/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.ifoduconfig_u2kv1r5global;

import com.huawei.nglct.bscfg.equipment.TEEquipmentDescription;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.rtn.oppositeneauosearch.TERtnNeAutoLogin;
import com.huawei.nglct.nemgr.rtn.oppositeneauosearch.TERtnNeSlotPortStruct;
import com.huawei.nglct.nemgr.rtn.oppositeneauosearch.TERtnPeerNeDetailInfor;
import com.huawei.nglct.nemgr.rtn.oppositeneauosearch.TERtnPeerNeInforCache;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.List;

public class TEQueryOppositeTerminalBean
extends TENEExplorerBean {
    TENE currentNE;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        this.currentNE = TENEListMgr.getInstance().getNE(neid);
        int realNeId = this.currentNE.getRealNEID();
        String strSlotId = inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue();
        int slotid = Integer.parseInt(strSlotId);
        TERtnNeSlotPortStruct struct = new TERtnNeSlotPortStruct(realNeId, slotid, 0);
        if (slotid == -1) {
            this.queryApproximateLink(struct);
        } else {
            this.queryOppositeNe(struct);
        }
        return this.outputData;
    }

    private void queryApproximateLink(TERtnNeSlotPortStruct struct) {
        List<TERtnPeerNeDetailInfor> oppositeNeInforList = TERtnPeerNeInforCache.getInstance().getApproximateInfor(struct);
        for (TERtnPeerNeDetailInfor teRtnPeerNeDetailInfor : oppositeNeInforList) {
            RowParams rowParams = new RowParams();
            int phySnkSlot = teRtnPeerNeDetailInfor.getSnkStruct().getSlotID();
            int phySrcNeId = teRtnPeerNeDetailInfor.getSrcStruct().getPhyNeID();
            int phySrcSlot = teRtnPeerNeDetailInfor.getSrcStruct().getSlotID();
            rowParams.addParam(new Param("snkNeID", String.valueOf(this.currentNE.getNEID())));
            rowParams.addParam(new Param("snkNeName", this.currentNE.getNEName()));
            rowParams.addParam(new Param("snkSlotID", String.valueOf(phySnkSlot)));
            rowParams.addParam(new Param("snkBoardName", this.currentNE.getBoard(phySnkSlot).getBoardName()));
            rowParams.addParam(new Param("snkNeType", this.currentNE.getNEType() + ""));
            TENE oppositeNe = TENEListMgr.getInstance().getPhyNE(phySrcNeId);
            if (oppositeNe != null) {
                rowParams.addParam(new Param("srcNeID", String.valueOf(oppositeNe.getNEID())));
                rowParams.addParam(new Param("srcNeName", oppositeNe.getNEName()));
                rowParams.addParam(new Param("srcSlotID", String.valueOf(phySrcSlot)));
                TEBoard oppositeBoard = oppositeNe.getBoard(phySrcSlot);
                if (oppositeBoard != null) {
                    rowParams.addParam(new Param("srcBoardName", oppositeBoard.getBoardName()));
                }
                rowParams.addParam(new Param("srcNeType", oppositeNe.getNEType() + ""));
            }
            this.outputData.getBussinessParams().addRowParams(rowParams);
        }
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
    }

    private void queryOppositeNe(TERtnNeSlotPortStruct struct) {
        TERtnPeerNeDetailInfor oppositeNeInfor = TERtnPeerNeInforCache.getInstance().get(struct);
        if (oppositeNeInfor != null) {
            int peerNEID = oppositeNeInfor.getSrcStruct().getPhyNeID();
            int errCode = TERtnNeAutoLogin.autoAddNeAndLogin(this.currentNE, peerNEID);
            if (errCode != 0) {
                TELogFactory.getNormalLogger().debug("Failed to Login the Opposite Ne. ");
                this.convertLoginFailInforToOutputData(errCode);
            } else {
                TELogFactory.getNormalLogger().debug("Succeeded to Login the Opposite Ne. ");
                this.convertPeerNeInforToOutputData(oppositeNeInfor);
            }
        } else {
            TELogFactory.getNormalLogger().debug("No Appropriate Record Found in Cache. ");
            this.convertNullInforToOutputData();
        }
    }

    private void convertPeerNeInforToOutputData(TERtnPeerNeDetailInfor oppositeNeInfor) {
        TENE peerNe = TENEListMgr.getInstance().getPhyNE(oppositeNeInfor.getSrcStruct().getPhyNeID());
        RowParams rowParams = new RowParams();
        rowParams.addParam(new Param("peerNEID", String.valueOf(peerNe.getNEID())));
        rowParams.addParam(new Param("peerNEName", peerNe.getNEName()));
        rowParams.addParam(new Param("peerRealNEID", String.valueOf(peerNe.getRealNEID())));
        rowParams.addParam(new Param("peerNEType", String.valueOf(peerNe.getNEType())));
        rowParams.addParam(new Param("peerShelfType", String.valueOf(peerNe.getShelfType())));
        rowParams.addParam(new Param("peerNEVersion", peerNe.getHostVersion()));
        rowParams.addParam(new Param("peerIFSlotId", String.valueOf(oppositeNeInfor.getSrcStruct().getSlotID())));
        rowParams.addParam(new Param("peerIFBoardName", peerNe.getNEName()));
        int devType = TEGetNEDomainVersion.getInstance().getDevType(peerNe.getNEType());
        int oduSlotId = oppositeNeInfor.getSrcStruct().getSlotID() + TEEquipmentDescription.getInstance().getSlotRelation(devType);
        rowParams.addParam(new Param("peerODUSlotId", String.valueOf(oduSlotId)));
        String neIP = peerNe.getNeIp();
        if (neIP == null || neIP.equals("")) {
            neIP = peerNe.getNEGWAddress();
        }
        rowParams.addParam(new Param("peerGatewayIP", neIP));
        this.outputData.getBussinessParams().addRowParams(rowParams);
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
    }

    private void convertLoginFailInforToOutputData(int errCode) {
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)errCode));
    }

    private void convertNullInforToOutputData() {
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)38662));
    }
}

