/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.ifoduconfig_u2kv1r5global;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.jni.hop.TEHopNearFarSideService;
import com.huawei.nglct.jni.hop.TEJniHopResult;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.rtn.hopmgr.JudgeResult;
import com.huawei.nglct.nemgr.rtn.hopmgr.TEJudgeNEDistanceInLCT;
import com.huawei.nglct.nemgr.rtn.oppositeneauosearch.TERtnNeAutoLogin;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.string.TEErrorResourceUtil;

public class TEQueryNearFarEndFlagBean
extends TENEExplorerBean {
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        String localSideNeID = inputData.getBussinessParams().getRowParams(0).getParam("localNeID").getValue();
        String oppositeSideNeID = inputData.getBussinessParams().getRowParams(0).getParam("oppositeNeID").getValue();
        TELogFactory.getNormalLogger().info("LocalSideNeID = " + localSideNeID);
        TELogFactory.getNormalLogger().info("OppositeSideNeID = " + localSideNeID);
        int iLocalSideNeID = Integer.parseInt(localSideNeID);
        int iOppositeSideNeID = Integer.parseInt(oppositeSideNeID);
        if (TESysManagerConstants.SYS_SINGLE_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
            this.processSysSingleStatus(iLocalSideNeID, iOppositeSideNeID);
        } else {
            TEJniHopResult result = TEHopNearFarSideService.getFarNeID((int)iLocalSideNeID, (int)iOppositeSideNeID);
            if (result.isAllSuccess()) {
                this.generateOutputXML(result.getFarNeID(), 0);
            } else {
                this.generateOutputXML(iOppositeSideNeID, 0);
            }
        }
        return this.outputData;
    }

    private static boolean isGateWayNE(TENE ne) {
        return ne.getNEGateWay() == 1;
    }

    private void generateOutputXML(int _neid, int errorcode) {
        RowParams rowParams = new RowParams();
        rowParams.addParam(new Param("farneid", String.valueOf(_neid)));
        this.outputData.setBussinessParams(new BussinessParams());
        this.outputData.getBussinessParams().addRowParams(rowParams);
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)errorcode));
    }

    private void processSysSingleStatus(int localSideNeID, int oppositeSideNeID) {
        TENE localNE = TENEListMgr.getInstance().getNE(localSideNeID);
        TENE oppositeNE = TENEListMgr.getInstance().getNE(oppositeSideNeID);
        int errorcode = 0;
        int outputFarSideNeId = -1;
        if (TEQueryNearFarEndFlagBean.isGateWayNE(localNE) && TEQueryNearFarEndFlagBean.isGateWayNE(oppositeNE)) {
            TELogFactory.getNormalLogger().info("Both sides are gateway NEs");
            outputFarSideNeId = oppositeSideNeID;
        } else if (TEQueryNearFarEndFlagBean.isGateWayNE(localNE) && !TEQueryNearFarEndFlagBean.isGateWayNE(oppositeNE)) {
            TELogFactory.getNormalLogger().info("The local side is gateway NE and the opposite side is not.");
            outputFarSideNeId = oppositeSideNeID;
        } else if (!TEQueryNearFarEndFlagBean.isGateWayNE(localNE) && TEQueryNearFarEndFlagBean.isGateWayNE(oppositeNE)) {
            TELogFactory.getNormalLogger().info("The op[oiste side is gateway NE and the local side is not.");
            outputFarSideNeId = localSideNeID;
        } else {
            TELogFactory.getNormalLogger().info("Both sides are not gateway NEs.");
            String gatewayNEAddress = localNE.getNEGWAddress();
            TENE gatewayNE = TENEListMgr.getInstance().getGateWayNEByIP(gatewayNEAddress);
            if (gatewayNE == null) {
                TELogFactory.getNormalLogger().info("The gateway ip address of opposite side is null");
                errorcode = 1090615122;
            } else {
                TELogFactory.getNormalLogger().info("The gateway ip address of opposite side exists");
                try {
                    errorcode = TERtnNeAutoLogin.autoAddNeAndLogin(localNE, gatewayNE.getRealNEID());
                    if (errorcode == 0) {
                        TELogFactory.getNormalLogger().info("Successfully login on the opposite ne.");
                        JudgeResult jr = TEJudgeNEDistanceInLCT.getInstance().getDistanceNeid(localNE, oppositeNE, gatewayNE);
                        errorcode = jr.getResultCode();
                        if (errorcode == 0) {
                            TELogFactory.getNormalLogger().info("Successfully checked out the far end terminal.");
                            outputFarSideNeId = jr.getFarneid();
                        } else {
                            TELogFactory.getNormalLogger().info("Failed ot checked out the far end terminal.");
                        }
                    } else {
                        TELogFactory.getNormalLogger().info("Unfortunately login failed.");
                    }
                }
                catch (Exception e) {
                    TELogFactory.getNormalLogger().error("An exception occured in TEQueryNearFarEndFlagBean", (Throwable)e);
                    outputFarSideNeId = 1091043331;
                }
            }
        }
        this.generateOutputXML(outputFarSideNeId, errorcode);
    }
}

