/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.ifoduconfig_u2kv1r5global;

import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.rtn.ifoduconfig_u2kv1r5global.TEIFODUCommonBean;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TEQueryLinkStatus
extends TENEExplorerBean {
    private static List<String> IFCmdList = new ArrayList<String>();
    private static List<String> ODUCmdList = new ArrayList<String>();
    private static final String[] columnDividedByThousand = new String[]{"ethband", "ethbandHigh", "W32BRD_ATTR_TRANSMITFRE", "W32BRD_ATTR_ACTTRECEIVEFRE", "W32BRD_ATTR_TRINTERVAL", "LOWFRE", "W32BRD_ATTR_WORKRANGE"};
    private static final String[] columnDividedByTen = new String[]{"W32BRD_ATTR_TRANSMITPOWER", "W32BRD_ATTR_RECEIVEPOWER", "W32BRD_ATTR_ACTRECEIVEPOWER", "W32PORT_ATTR_ATPCUPPER", "W32PORT_ATTR_ATPCLOWER", "LOWPOWER", "W32BRD_ATTR_ACTRANGEOFPOWER"};
    private static Map<String, String> bandWidthRelationMap = new HashMap<String, String>();
    private static Map<String, String> modulationRelationMap = new HashMap<String, String>();

    public ArrayList<Operation> getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        ArrayList operList = super.getOperation(neid, subFunc, inputData, memeryData);
        TEIFODUCommonBean.filterOperationList(neid, operList, IFCmdList, ODUCmdList);
        return operList;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        String finalCapacityVal = this.getFinalCapacityValue();
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        if (this.outputData == null || this.outputData.getBussinessParams() == null) {
            return;
        }
        for (int i = 0; i < this.outputData.getBussinessParams().getRowParamsCount(); ++i) {
            int j;
            RowParams rowParams = this.outputData.getBussinessParams().getRowParams(i);
            for (j = 0; j < columnDividedByThousand.length; ++j) {
                TEIFODUCommonBean.dividedByThousand(rowParams, columnDividedByThousand[j]);
            }
            for (j = 0; j < columnDividedByTen.length; ++j) {
                TEIFODUCommonBean.dividedByTen(rowParams, columnDividedByTen[j]);
            }
            if (rowParams.getParam("capacity") == null || finalCapacityVal == null) continue;
            rowParams.getParam("capacity").setValue(finalCapacityVal);
        }
    }

    public ArrayList<Integer> getFilterErrorCodeList() {
        ArrayList<Integer> errorList = new ArrayList<Integer>();
        errorList.add(38737);
        errorList.add(37898);
        errorList.add(38664);
        errorList.add(new Integer(39185));
        errorList.add(38751);
        return errorList;
    }

    private Operation getOperationByName(List<Operation> operationList, String operationName) {
        Operation oper = null;
        for (Operation tmpOperation : operationList) {
            if (!operationName.equals(tmpOperation.getName())) continue;
            oper = tmpOperation;
            break;
        }
        return oper;
    }

    private String getItemValue(List<Operation> opList, String operationName, String partName) {
        String value = null;
        Operation oper = this.getOperationByName(opList, operationName);
        if (oper != null && oper.getOutputCount() > 0 && oper.getOutput(0).getFaultCount() > 0 && "0".equals(oper.getOutput(0).getFault(0).getCode())) {
            value = oper.getOutput(0).getPartValue(partName);
        }
        return value;
    }

    private String getFinalCapacityValue() {
        Output[] outputArray;
        String finalCapacityVal = null;
        String spaceChannelValue = this.getItemValue(this.operationList, "NSCMD_PTN_CFG_GET_IF_CHANNELSPACE", "W32PORT_ATTR_CHANNELSPACE");
        spaceChannelValue = bandWidthRelationMap.get(spaceChannelValue);
        String curModeValue = this.getItemValue(this.operationList, "NSCMD_PTN_CFG_GET_ACM_CURRMOD", "W32PORT_ATTR_SENDMODID");
        curModeValue = modulationRelationMap.get(curModeValue);
        if (spaceChannelValue == null || curModeValue == null) {
            return null;
        }
        Operation capacityOper = this.getOperationByName(this.operationList, "NSCMD_CFG_GET_ACM_ALLCAPACITY");
        if (capacityOper == null) {
            return null;
        }
        if (capacityOper.getOutputCount() == 0) {
            return null;
        }
        if (!"0".equals(capacityOper.getOutput(0).getFault(0).getCode())) {
            return null;
        }
        int rightChannelBandwidthIndex = -1;
        int length = capacityOper.getOutputCount();
        for (int i = 0; i < length; ++i) {
            String[] firstSplitArray;
            Output output = capacityOper.getOutput(i);
            String rawData = output.getPartValue("capacity");
            if ((rawData = IOStreamConvertor.replaceSpecialStr((String)rawData)) == null || "".equals(rawData) || !spaceChannelValue.equals((firstSplitArray = rawData.split(":"))[0].trim())) continue;
            rightChannelBandwidthIndex = i;
            String[] secondSplitArray = firstSplitArray[1].split("%");
            for (int j = 0; j < secondSplitArray.length; ++j) {
                String tmpString = secondSplitArray[j];
                String[] thirdSplitArray = (tmpString = tmpString.trim()).split(",");
                if (!curModeValue.equals(thirdSplitArray[1].trim())) continue;
                finalCapacityVal = thirdSplitArray[2];
            }
        }
        if (rightChannelBandwidthIndex != -1 && (outputArray = capacityOper.getOutput()).length >= 1) {
            outputArray[0] = outputArray[rightChannelBandwidthIndex];
            for (int i = 1; i < outputArray.length; ++i) {
                outputArray[i] = null;
            }
        }
        return finalCapacityVal;
    }

    static {
        IFCmdList.add("NSCMD_CFG_GET_RADIO_LINKID");
        IFCmdList.add("NSCMD_CFG_GET_RADIO_REALLINKID");
        IFCmdList.add("NSCMD_CFG_GET_RADIO_ALLIFMODE");
        IFCmdList.add("NSCMD_CFG_GET_RADIO_IFMODE");
        IFCmdList.add("NSCMD_CFG_GET_RADIO_SERVICETYPE_WBID");
        IFCmdList.add("NSCMD_PTN_CFG_GET_IF_CHANNELSPACE");
        IFCmdList.add("NSCMD_PTN_CFG_GET_ACM_PARAM");
        IFCmdList.add("NSCMD_RTN_CFG_GET_E1PARAM_DEFINED_BY_MYSELF_FORHOP");
        IFCmdList.add("NSCMD_CFG_GET_E1PRIENABLE_CFG");
        IFCmdList.add("NSCMD_CFG_GET_ATPC_ENABLE");
        IFCmdList.add("NSCMD_CFG_GET_ATPC_THRESHOLD");
        IFCmdList.add("NSCMD_CFG_GET_ACM_ALLCAPACITY");
        IFCmdList.add("NSCMD_PTN_CFG_GET_ACM_CURRMOD");
        ODUCmdList.add("NSCMD_CFG_GET_ODU_INFO");
        ODUCmdList.add("NSCMD_CFG_GET_ODU_TXFREQ");
        ODUCmdList.add("NSCMD_CFG_GET_ODU_RFREQ");
        ODUCmdList.add("NSCMD_CFG_GET_ODU_TRSPACING");
        ODUCmdList.add("NSCMD_CFG_GET_ODU_TXPOWER");
        ODUCmdList.add("NSCMD_CFG_GET_ODU_SRSL");
        ODUCmdList.add("NSCMD_CFG_GET_ODU_RPOWER");
        ODUCmdList.add("NSCMD_CFG_GET_ODU_WORK");
        ODUCmdList.add("NSCMD_CFG_GET_ODU_TXFREQ_RG");
        ODUCmdList.add("NSCMD_CFG_GET_ODU_TXPOWER_RG");
        bandWidthRelationMap.put("2", "7M");
        bandWidthRelationMap.put("3", "14M");
        bandWidthRelationMap.put("4", "28M");
        bandWidthRelationMap.put("5", "40M");
        bandWidthRelationMap.put("6", "56M");
        bandWidthRelationMap.put("7", "FCC30M");
        bandWidthRelationMap.put("8", "FCC40M");
        bandWidthRelationMap.put("9", "FCC50M");
        modulationRelationMap.put("1", "QPSK");
        modulationRelationMap.put("2", "16QAM");
        modulationRelationMap.put("3", "32QAM");
        modulationRelationMap.put("4", "64QAM");
        modulationRelationMap.put("5", "128QAM");
        modulationRelationMap.put("6", "256QAM");
    }
}

