/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.ifoduconfig_u2kv1r5global;

import com.huawei.nglct.bscfg.equipment.TEEquipmentDescription;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgAttribute;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nemgr.rtn.ifoduconfig_u2kv1r5global.TECommand;
import com.huawei.nglct.nemgr.rtn.ifoduconfig_u2kv1r5global.TEIFODUCommonBean;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TEQueryIFODUBean
extends TENEExplorerBean {
    private static Map<String, TECommand> IFODU_COMMAND_MAP = new HashMap<String, TECommand>();
    private static final int E1CAP_INVALID = 255;
    private static final String INVALID_LINKID_1 = "0";
    private static final String INVALID_LINKID_2 = "65535";
    private static final String ENABLE = "1";
    private static final String DISABLE = "0";
    private static final String STM1_ETH = "2";
    private static final String[] columnDividedByThousand = new String[]{"ethband", "ethbandHigh", "W32BRD_ATTR_TRANSMITFRE", "W32BRD_ATTR_ACTTRECEIVEFRE", "W32BRD_ATTR_TRINTERVAL", "LOWFRE", "W32BRD_ATTR_WORKRANGE"};
    private static final String[] columnDividedByTen = new String[]{"W32BRD_ATTR_TRANSMITPOWER", "W32BRD_ATTR_RECEIVEPOWER", "W32BRD_ATTR_ACTRECEIVEPOWER", "W32PORT_ATTR_ATPCUPPER", "W32PORT_ATTR_ATPCLOWER", "LOWPOWER", "W32BRD_ATTR_ACTRANGEOFPOWER", "W32BRD_ATTR_ACTTRANSMITPOWER"};
    private static final String[] columnConvertInvalidate = new String[]{"W32BRD_ATTR_ACTTRANSMITFRE", "W32BRD_ATTR_ACTTRECEIVEFRE", "W32BRD_ATTR_ACTTRANSMITPOWER", "W32BRD_ATTR_ACTRECEIVEPOWER"};

    public ArrayList<Operation> getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        String queryType;
        ArrayList operList = super.getOperation(neid, subFunc, inputData, memeryData);
        BussinessParams bs = inputData.getBussinessParams();
        this.filterOperationList(neid, operList, bs);
        if (bs.getRowParamsCount() > 0 && bs.getRowParams(0).getParam("queryType") != null && "queryEthBandwidth".equals(queryType = bs.getRowParams(0).getParam("queryType").getValue())) {
            ArrayList<String> queryEthBandwidthList = new ArrayList<String>();
            queryEthBandwidthList.add("NSCMD_PTN_CFG_GET_ACM_PARAM");
            queryEthBandwidthList.add("NSCMD_RTN_CFG_GET_E1PARAM_DEFINED_BY_MYSELF_FORHOP");
            queryEthBandwidthList.add("NSCMD_CFG_GET_E1PRIENABLE_CFG");
            queryEthBandwidthList.add("NSCMD_CFG_GET_RADIO_SERVICETYPE_WBID");
            ArrayList<String> queryOduPowerList = new ArrayList<String>();
            queryOduPowerList.add("NSCMD_CFG_GET_ODU_SRSL");
            queryOduPowerList.add("NSCMD_CFG_GET_ODU_RPOWER");
            TEIFODUCommonBean.filterOperationList(neid, operList, queryEthBandwidthList, queryOduPowerList);
        }
        return operList;
    }

    protected void filterOperationList(int neid, List<Operation> operList, BussinessParams bs) {
        boolean isRefresh = this.getInputRefreshFlag(bs);
        boolean isQueryIF = this.getInputParamFlag(bs, "isQueryIF");
        boolean isQueryRF = this.getInputParamFlag(bs, "isQueryRF");
        boolean isQueryEquip = this.getInputParamFlag(bs, "isQueryEquip");
        int neType = TEConfigurationDataMgr.getInstance().getNE(neid).getNEType();
        int relationOffset = TEEquipmentDescription.getInstance().getSlotRelation(TEGetNEDomainVersion.getInstance().getDevType(neType));
        Iterator<Operation> iterator = operList.iterator();
        while (iterator.hasNext()) {
            int cmdType;
            Operation oper = iterator.next();
            TEBoard board = TEIFODUCommonBean.getInputBoard(neid, oper);
            if (board == null) {
                iterator.remove();
                continue;
            }
            String cmdName = oper.getName();
            int bdType = board.getBoardType();
            int n = cmdType = TEConfigurationDataMgr.getInstance().isIFboard(bdType) ? 1 : 2;
            TECommand cmd = IFODU_COMMAND_MAP.get(cmdName);
            if (cmd == null) continue;
            if (isRefresh && !cmd.isSupportRefresh() || relationOffset != 0 && cmdType != cmd.getCmdType()) {
                iterator.remove();
                continue;
            }
            if (!(cmd.getCmdResideType() == 1 && !isQueryIF || cmd.getCmdResideType() == 2 && !isQueryRF) && (cmd.getCmdResideType() != 3 || isQueryEquip) || !cmd.isSupportFilter()) continue;
            iterator.remove();
        }
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        TENE currentNE = TENEListMgr.getInstance().getNE(neid);
        int neType = currentNE.getNEType();
        boolean isRtn600 = false;
        if (neType == 54 || neType == 55 || neType == 60 || TESpecialAttrMgr.getInstance().isNESupport(neid, "TE_FUNC_RTN_CFG_HOPMGR", "TE_ATTR_RTN_HOPMGR_IS_PACKETMICROWAVE_NE")) {
            isRtn600 = true;
        }
        this.addE1NumProcess(isRtn600);
        this.addRealLinkIdProcess();
        TEIFODUCommonBean.addServiceCapacityProcess(operationList);
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        if (this.outputData == null || this.outputData.getBussinessParams() == null) {
            return;
        }
        for (int i = 0; i < this.outputData.getBussinessParams().getRowParamsCount(); ++i) {
            int j;
            RowParams rowParams = this.outputData.getBussinessParams().getRowParams(i);
            for (j = 0; j < columnDividedByThousand.length; ++j) {
                TEIFODUCommonBean.dividedByThousand(rowParams, columnDividedByThousand[j]);
            }
            for (j = 0; j < columnDividedByTen.length; ++j) {
                TEIFODUCommonBean.dividedByTen(rowParams, columnDividedByTen[j]);
            }
            for (j = 0; j < columnConvertInvalidate.length; ++j) {
                TEIFODUCommonBean.setDataInValid(rowParams, columnConvertInvalidate[j]);
            }
            for (j = 0; j < rowParams.getParamCount(); ++j) {
                String receivedLinkid;
                Param receivedLinkidParam;
                Param allworkmodeParam = rowParams.getParam("W32PORT_ATTR_ALLWORKMODE");
                if (allworkmodeParam != null && !"".equals(allworkmodeParam.getValue())) {
                    String allworkmodeValue = allworkmodeParam.getValue();
                    allworkmodeParam.setValue(IOStreamConvertor.replaceSpecialStr((String)allworkmodeValue));
                }
                if (null == (receivedLinkidParam = rowParams.getParam("W32PORT_ATTR_RECRADIOLINKID")) || !"0".equals(receivedLinkid = receivedLinkidParam.getValue().trim()) && !INVALID_LINKID_2.equals(receivedLinkid)) continue;
                receivedLinkid = "/";
                receivedLinkidParam.setValue(receivedLinkid);
            }
            Param paraSlot = rowParams.getParam("slotid");
            if (null == paraSlot) continue;
            int slotid = Integer.valueOf(paraSlot.getValue());
            TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(neid, slotid);
            if (board == null) {
                TELogFactory.getNormalLogger().error("get board (neid = " + neid + " , slotid = " + slotid + ") fail!");
                continue;
            }
            ArrayList<TEBoard> boardlist = new ArrayList<TEBoard>();
            boardlist.add(board);
            TEGenCfgAttribute attribute = TEGenCfgDataMgr.getGenCfgMode((int)board.getBoardType()).getAttrFromId("SDHBD_ATTR_IFBANDWIDTH");
            if (null == attribute) continue;
            String bandwidthlist = TEGenCfgDataMgr.getAttrRangeJSON((int)neid, (String)"W32PORT_ATTR_CHANNELSPACE", boardlist);
            rowParams.addParam("bandwidthlist", bandwidthlist);
            String ensureModelist = TEGenCfgDataMgr.getAttrRangeJSON((int)neid, (String)"W32PORT_ATTR_ENSURECALMODE", boardlist);
            rowParams.addParam("ensuremodelist", ensureModelist);
            String allcalModelist = TEGenCfgDataMgr.getAttrRangeJSON((int)neid, (String)"W32PORT_ATTR_ALLCALMODE", boardlist);
            rowParams.addParam("allcalmodelist", allcalModelist);
            String manulModelist = TEGenCfgDataMgr.getAttrRangeJSON((int)neid, (String)"W32PORT_ATTR_MANUALMODE", boardlist);
            rowParams.addParam("manualmodelist", manulModelist);
            rowParams.addParam("issupportactmode", String.valueOf(TEGenCfgDataMgr.isSupportAttr((int)neid, (int)slotid, (String)"W32PORT_ATTR_RECEIVEMODID")));
        }
    }

    private void addE1NumProcess(boolean isRTN600) {
        if (isRTN600) {
            return;
        }
        TENE tene = TENEListMgr.getInstance().getNE(this.neid);
        String version = tene.getShowNEVersion();
        String[] args = version.split("\\.");
        String subVerHigh = args[2];
        String subVerLow = args[3];
        if (Integer.parseInt(subVerHigh) > 2 || Integer.parseInt(subVerHigh) == 2 && Integer.parseInt(subVerLow) >= 20 || TESpecialAttrMgr.getInstance().isNESupport(this.neid, "TE_FUNC_RTN_CFG_HOPMGR", "TE_ATTR_RTN_HOPMGR_IS_HYBRID_NEVERSION")) {
            this.processHybridMicrowave();
        } else {
            this.processPacketMicrowave();
        }
    }

    private void addRealLinkIdProcess() {
        for (Operation oper : this.operationList) {
            int errCode;
            if ("NSCMD_CFG_GET_RADIO_REALLINKID".equals(oper.getName())) {
                errCode = Integer.valueOf(oper.getOutput(0).getFault(0).getCode());
                String slotid = oper.getInput().getPartValue("slotid");
                String portid = oper.getInput().getPartValue("port");
                if (0 == errCode) continue;
                Part slotPart = oper.getOutput(0).getPart("slotID");
                Part portPart = oper.getOutput(0).getPart("port");
                if (slotPart != null) {
                    slotPart.setValue(slotid);
                }
                if (portPart == null) continue;
                portPart.setValue(portid);
                continue;
            }
            if ("NSCMD_CFG_GET_ODU_RPOWER".equals(oper.getName())) {
                errCode = Integer.valueOf(oper.getOutput(0).getFault(0).getCode());
                if (0 == errCode) continue;
                oper.getOutput(0).setPartValue("W32BRD_ATTR_ACTTRANSMITPOWER", "");
                oper.getOutput(0).setPartValue("W32BRD_ATTR_ACTRECEIVEPOWER", "");
                continue;
            }
            if (!"NSCMD_CFG_GET_ODU_RFREQ".equals(oper.getName()) || 0 == (errCode = Integer.valueOf(oper.getOutput(0).getFault(0).getCode()).intValue())) continue;
            oper.getOutput(0).setPartValue("W32BRD_ATTR_ACTTRANSMITFRE", "");
            oper.getOutput(0).setPartValue("W32BRD_ATTR_ACTTRECEIVEFRE", "");
        }
    }

    public ArrayList<Integer> getFilterErrorCodeList() {
        ArrayList<Integer> errorList = new ArrayList<Integer>();
        errorList.add(38737);
        errorList.add(37898);
        errorList.add(38722);
        errorList.add(38664);
        errorList.add(new Integer(39185));
        errorList.add(38751);
        errorList.add(new Integer(57383));
        errorList.add(1091634631);
        errorList.add(38662);
        errorList.add(1090777617);
        return errorList;
    }

    private void processPacketMicrowave() {
        for (Operation oper : this.operationList) {
            int errCode;
            if (!"NSCMD_RTN_CFG_GET_E1PARAM_DEFINED_BY_MYSELF_FORHOP".equals(oper.getName()) || 0 != (errCode = Integer.valueOf(oper.getOutput(0).getFault(0).getCode()).intValue())) continue;
            Output output = null;
            for (int i = oper.getOutputCount() - 1; i >= 0; --i) {
                output = oper.getOutput(i);
                int e1Cap = Integer.valueOf(output.getPartValue("IFPORT_ATTR_ENSUREE1NUM"));
                if (255 != e1Cap) continue;
                oper.removeOutput(i);
            }
        }
    }

    private List<Operation> getOperationByName(List<Operation> operationList, String operationName) {
        ArrayList<Operation> list = new ArrayList<Operation>();
        for (Operation tmpOperation : operationList) {
            if (!operationName.equals(tmpOperation.getName())) continue;
            list.add(tmpOperation);
        }
        return list;
    }

    private String getParamValueInOper(ArrayList opers, String operName, String param) {
        String res = null;
        int len = opers.size();
        for (int i = 0; i < len; ++i) {
            Operation oper = (Operation)opers.get(i);
            if (!operName.equals(oper.getName())) continue;
            Output output = oper.getOutput(0);
            res = output.getPartValue(param);
        }
        return res;
    }

    private void processHybridMicrowave() {
        String serviceType = this.getParamValueInOper(this.operationList, "NSCMD_CFG_GET_RADIO_SERVICETYPE_WBID", "IFPORT_ATTR_SERVICETYPE");
        List<Operation> operList = this.getOperationByName(this.operationList, "NSCMD_RTN_CFG_GET_E1PARAM_DEFINED_BY_MYSELF_FORHOP");
        for (Operation oper : operList) {
            int errCode = Integer.valueOf(oper.getOutput(0).getFault(0).getCode());
            if (0 != errCode) continue;
            Output output = null;
            for (int i = oper.getOutputCount() - 1; i >= 0; --i) {
                output = oper.getOutput(i);
                int e1Cap = Integer.valueOf(output.getPartValue("IFPORT_ATTR_ENSUREE1NUM"));
                if (255 != e1Cap && (serviceType == null || !STM1_ETH.equals(serviceType) || !this.isNeedFilter(output.getPartValue("mode"), this.operationList))) continue;
                oper.removeOutput(i);
            }
            if (oper.getOutputCount() < 1) continue;
            String bandWidthHigh = oper.getOutput(oper.getOutputCount() - 1).getPartValue("ethband");
            Part bandWdithHighPart = new Part();
            bandWdithHighPart.setName("ethbandHigh");
            bandWdithHighPart.setValue(bandWidthHigh);
            oper.getOutput(0).addPart(bandWdithHighPart);
            String fullE1Num = oper.getOutput(oper.getOutputCount() - 1).getPartValue("IFPORT_ATTR_ENSUREE1NUM");
            Part fullE1NumPart = new Part();
            fullE1NumPart.setName("IFPORT_ATTR_FULLE1NUM");
            fullE1NumPart.setValue(fullE1Num);
            oper.getOutput(0).addPart(fullE1NumPart);
            String fullE1NumRange = oper.getOutput(oper.getOutputCount() - 1).getPartValue("IFPORT_ATTR_ENSUREE1NUM_RANGE");
            Part fullE1NumRangePart = new Part();
            fullE1NumRangePart.setName("IFPORT_ATTR_FULLE1NUM_RANGE");
            fullE1NumRangePart.setValue(fullE1NumRange);
            oper.getOutput(0).addPart(fullE1NumRangePart);
            for (int i = oper.getOutputCount() - 1; i > 0; --i) {
                oper.removeOutput(i);
            }
        }
    }

    private boolean isNeedFilter(String mode, List opers) {
        int menualMode;
        String amStatus = this.getParamValueInOper(this.operationList, "NSCMD_PTN_CFG_GET_ACM_PARAM", "W32PORT_ATTR_ACMENABLESTATUS");
        int currentMode = Integer.parseInt(mode);
        if (amStatus == null) {
            return false;
        }
        if (ENABLE.equals(amStatus)) {
            int ensureMode = Integer.parseInt(this.getParamValueInOper(this.operationList, "NSCMD_PTN_CFG_GET_ACM_PARAM", "W32PORT_ATTR_ENSURECALMODE"));
            int fullMode = Integer.parseInt(this.getParamValueInOper(this.operationList, "NSCMD_PTN_CFG_GET_ACM_PARAM", "W32PORT_ATTR_ALLCALMODE"));
            if (ensureMode > currentMode || fullMode < currentMode) {
                return true;
            }
        } else if ("0".equals(amStatus) && (menualMode = Integer.parseInt(this.getParamValueInOper(this.operationList, "NSCMD_PTN_CFG_GET_ACM_PARAM", "W32PORT_ATTR_MANUALMODE"))) != currentMode) {
            return true;
        }
        return false;
    }

    public String getDetailStr(RowParams rowparams) {
        Param opDescParam;
        if (null != rowparams && (opDescParam = rowparams.getParam("slotid")) != null && !opDescParam.equals((Object)"")) {
            return opDescParam.getValue() + "-" + TEConfigurationDataMgr.getInstance().getBoardName(this.neid, Integer.parseInt(opDescParam.getValue()));
        }
        return this.subfunc.getSubFuncDes(this.neid);
    }

    private boolean getInputRefreshFlag(BussinessParams bs) {
        boolean isRefresh = false;
        if (bs.getRowParamsCount() > 0 && bs.getRowParams(0).getParam("isRefreshUnEditable") != null) {
            isRefresh = bs.getRowParams(0).getParam("isRefreshUnEditable").getValue().equals(ENABLE);
        }
        return isRefresh;
    }

    private boolean getInputParamFlag(BussinessParams bs, String paramName) {
        boolean paramFlag = false;
        if (bs.getRowParamsCount() > 0 && bs.getRowParams(0).getParam(paramName) != null) {
            paramFlag = bs.getRowParams(0).getParam(paramName).getValue().equals("true");
        }
        return paramFlag;
    }

    static {
        IFODU_COMMAND_MAP.put("NSCMD_CFG_GET_RADIO_LINKID", new TECommand(1, false, false));
        IFODU_COMMAND_MAP.put("NSCMD_CFG_GET_RADIO_REALLINKID", new TECommand(1, true, false));
        IFODU_COMMAND_MAP.put("NSCMD_CFG_GET_RADIO_ALLIFMODE", new TECommand(1, false, false));
        IFODU_COMMAND_MAP.put("NSCMD_CFG_GET_RADIO_IFMODE", new TECommand(1, false, false));
        IFODU_COMMAND_MAP.put("NSCMD_CFG_GET_RADIO_SERVICETYPE_WBID", new TECommand(1, true));
        IFODU_COMMAND_MAP.put("NSCMD_PTN_CFG_GET_IF_CHANNELSPACE", new TECommand(1));
        IFODU_COMMAND_MAP.put("NSCMD_PTN_CFG_GET_ACM_PARAM", new TECommand(1, true));
        IFODU_COMMAND_MAP.put("NSCMD_RTN_CFG_GET_E1PARAM_DEFINED_BY_MYSELF_FORHOP", new TECommand(1, true));
        IFODU_COMMAND_MAP.put("NSCMD_CFG_GET_HYBRID_CAPACITY_FORHOP", new TECommand(1, true));
        IFODU_COMMAND_MAP.put("NSCMD_CFG_GET_E1PRIENABLE_CFG", new TECommand(1));
        IFODU_COMMAND_MAP.put("NSCMD_CFG_GET_ATPC_ENABLE", new TECommand(1, 2));
        IFODU_COMMAND_MAP.put("NSCMD_CFG_GET_ATPC_THRESHOLD", new TECommand(1, 2));
        IFODU_COMMAND_MAP.put("NSCMD_CFG_GET_ACM_ALLCAPACITY", new TECommand(1));
        IFODU_COMMAND_MAP.put("NSCMD_CFG_GET_HYBRID_STM1CAPACITY_WBID", new TECommand(1));
        IFODU_COMMAND_MAP.put("NSCMD_CFG_GET_IF_RUNNINGMODE", new TECommand(1, true));
        IFODU_COMMAND_MAP.put("NSCMD_CFG_GET_ADJOIN_NEINFO", new TECommand(1, false, false));
        IFODU_COMMAND_MAP.put("NSCMD_CFG_GET_RADIO_ADJOIN_LINKID", new TECommand(1, false, false));
        IFODU_COMMAND_MAP.put("NSCMD_CFG_GET_RADIO_XPIC_ENABLE", new TECommand(1, false, false));
        IFODU_COMMAND_MAP.put("NSCMD_CFG_GET_XPIC_BDPOLAR_WBID", new TECommand(1, false, false));
        IFODU_COMMAND_MAP.put("NSCMD_RTN_CFG_GET_ANTENNA_POLAR_WBID ", new TECommand(1, true, false));
        IFODU_COMMAND_MAP.put("NSCMD_PTN_CFG_GET_ACM_CURRMOD", new TECommand(1, true));
        IFODU_COMMAND_MAP.put("NSCMD_CFG_GET_ODU_INFO", new TECommand(2, 3, true));
        IFODU_COMMAND_MAP.put("NSCMD_CFG_GET_ODU_TXFREQ", new TECommand(2, true));
        IFODU_COMMAND_MAP.put("NSCMD_CFG_GET_ODU_RFREQ", new TECommand(2, true));
        IFODU_COMMAND_MAP.put("NSCMD_CFG_GET_ODU_TRSPACING", new TECommand(2, true));
        IFODU_COMMAND_MAP.put("NSCMD_CFG_GET_ODU_TXPOWER", new TECommand(2, true));
        IFODU_COMMAND_MAP.put("NSCMD_CFG_GET_ODU_SRSL", new TECommand(2, true));
        IFODU_COMMAND_MAP.put("NSCMD_CFG_GET_ODU_RPOWER", new TECommand(2, true, false));
        IFODU_COMMAND_MAP.put("NSCMD_CFG_GET_ODU_WORK", new TECommand(2));
        IFODU_COMMAND_MAP.put("NSCMD_CFG_GET_ODU_TXFREQ_RG", new TECommand(2));
        IFODU_COMMAND_MAP.put("NSCMD_CFG_GET_ODU_TXPOWER_RG", new TECommand(2));
    }
}

