/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.ifoduconfig_u2kv1r5global;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.neinterface.neadapter.TECommuNEMgr;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.string.TEStringUtils;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TEIFODUCommonBean {
    private static final String NSCMD_CFG_GET_ACM_ALLCAPACITY = "NSCMD_CFG_GET_ACM_ALLCAPACITY";
    private static Map<Integer, Integer> IFODU_SLOTID_OFFSET_MAP = new HashMap<Integer, Integer>();

    private TEIFODUCommonBean() {
    }

    public static TEBoard getInputBoard(int neID, Operation oper) {
        String slotId = oper.getInput().getPartValue("slotid");
        if (slotId.isEmpty()) {
            TELogFactory.getNormalLogger().error("the solt id is null !");
            return null;
        }
        int iSlotId = Integer.parseInt(slotId);
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(neID, iSlotId);
        if (board == null) {
            TELogFactory.getNormalLogger().error("can not get board: slotid = " + slotId);
        }
        return board;
    }

    protected static void filterOperationList(int neid, List<Operation> operList, List<String> ifCmdList, List<String> oduCmdList) {
        Iterator<Operation> iterator = operList.iterator();
        while (iterator.hasNext()) {
            Operation oper = iterator.next();
            TEBoard board = TEIFODUCommonBean.getInputBoard(neid, oper);
            if (board == null) {
                iterator.remove();
                continue;
            }
            String cmdName = oper.getName();
            int bdType = board.getBoardType();
            boolean isIFBoard = TEConfigurationDataMgr.getInstance().isIFboard(bdType);
            if (isIFBoard) {
                if (TEIFODUCommonBean.containsString(ifCmdList, cmdName)) continue;
                iterator.remove();
                continue;
            }
            if (TEIFODUCommonBean.containsString(oduCmdList, cmdName)) continue;
            iterator.remove();
        }
    }

    protected static boolean containsString(List<String> operList, String operName) {
        boolean result = false;
        for (int i = 0; i < operList.size(); ++i) {
            String tmpOperName = operList.get(i);
            if (!tmpOperName.equals(operName)) continue;
            result = true;
            break;
        }
        return result;
    }

    protected static void removeIndalidParam(RowParams[] rowParams) {
        for (RowParams r : rowParams) {
            Param[] params = r.getParam();
            for (int pindex = params.length - 1; pindex >= 0; --pindex) {
                Param p = params[pindex];
                if (TEIFODUCommonBean.isDataValid(p.getValue())) continue;
                r.removeParam(p);
            }
        }
    }

    protected static boolean isDataValid(String val) {
        boolean ret = true;
        if (val == null || "".equals(val) || "undefined".equals(val)) {
            ret = false;
        }
        return ret;
    }

    protected static void dividedByTen(RowParams rowParams, String AttrName) {
        String val;
        Param param = rowParams.getParam(AttrName);
        if (param != null && TEIFODUCommonBean.isDataValid(val = param.getValue()) && !"-1".equals(val)) {
            short temp = (short)new BigInteger(val).intValue();
            param.setValue(String.valueOf((float)temp / 10.0f));
        }
    }

    protected static void setDataInValid(RowParams rowParams, String AttrName) {
        String val;
        Param param = rowParams.getParam(AttrName);
        if (param != null && (!TEIFODUCommonBean.isDataValid(val = param.getValue()) || "-1".equals(val))) {
            param.setValue("/");
        }
    }

    protected static void dividedByThousand(RowParams rowParams, String AttrName) {
        String val;
        Param param = rowParams.getParam(AttrName);
        if (param != null && TEIFODUCommonBean.isDataValid(val = param.getValue()) && !"-1".equals(val)) {
            long temp = Long.parseLong(val);
            param.setValue(String.valueOf((double)temp / 1000.0));
        }
    }

    public static void addServiceCapacityProcess(List<Operation> opers) {
        Operation oper = null;
        Output output = null;
        Output firstOutput = null;
        Part part = null;
        Iterator<Operation> iterator = opers.iterator();
        while (iterator.hasNext()) {
            oper = iterator.next();
            if (!oper.getName().startsWith(NSCMD_CFG_GET_ACM_ALLCAPACITY) || !String.valueOf(0).equals(oper.getOutput(0).getFault(0).getCode())) continue;
            try {
                if (oper.getOutputCount() > 1) {
                    firstOutput = oper.getOutput(0);
                    for (int n = oper.getOutputCount() - 1; n > 0; --n) {
                        output = oper.getOutput(n);
                        part = firstOutput.getPart(firstOutput.getPartCount() - 1);
                        part.setValue(IOStreamConvertor.replaceSpecialStr((String)part.getValue()) + ";" + IOStreamConvertor.replaceSpecialStr((String)output.getPart(output.getPartCount() - 1).getValue()));
                        oper.removeOutput(output);
                    }
                    continue;
                }
                output = oper.getOutput(0);
                part = output.getPart(output.getPartCount() - 1);
                part.setValue(TEStringUtils.ascStrToStr((String)TEStringUtils.delInvalidSeq((String)part.getValue())));
            }
            catch (Exception e) {
                iterator.remove();
                TELogFactory.getNormalLogger().error("parse all capacity failed", (Throwable)e);
                return;
            }
        }
    }

    public static void processRef(int neid, List<String> operNames, Datainterface inputData) {
        ArrayList<Operation> opers = new ArrayList<Operation>();
        int iLen = operNames.size();
        for (int i = 0; i < iLen; ++i) {
            Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)operNames.get(i));
            if (oper == null) continue;
            int jLen = inputData.getBussinessParams().getRowParamsCount();
            for (int j = 0; j < jLen; ++j) {
                Param port;
                RowParams rowParam = inputData.getBussinessParams().getRowParams(j);
                Param slotID = rowParam.getParam("ifslotid");
                if (slotID == null) {
                    slotID = rowParam.getParam("slotid");
                }
                if ((port = rowParam.getParam("port")) == null) {
                    port = rowParam.getParam("portid");
                }
                if (slotID == null || port == null) continue;
                Operation tmpOper = (Operation)oper.clone();
                Input input = tmpOper.getInput();
                input.getPart(0).setValue(slotID.getValue());
                input.getPart(input.getPartCount() - 1).setValue(port.getValue());
                opers.add(tmpOper);
            }
        }
        if (opers.size() > 0) {
            int timeOut = 5;
            TECommuNEMgr.getInstance().sendCommand(neid, opers, 5, null);
        }
    }

    public static int getRelativeODUSlotID(int neid, int ifSlotID) {
        int oduSlotID = ifSlotID + TEIFODUCommonBean.getIFODUSlotIDOffset(neid);
        return oduSlotID;
    }

    public static int getIFODUSlotIDOffset(int neid) {
        int confVal = TESpecialAttrMgr.getInstance().getNEAttrIntValue(neid, "TE_FUNC_RTN_CFG_HOPMGR", "TE_ATTR_RTN_HOPMGR_RELATIVE_ODUSLOT_OFFSET");
        if (confVal != -1) {
            return confVal;
        }
        TENE currentNE = TENEListMgr.getInstance().getNE(neid);
        int neType = currentNE.getNEType();
        Integer offsetInteger = IFODU_SLOTID_OFFSET_MAP.get(neType);
        int finalOffset = 0;
        if (offsetInteger != null) {
            finalOffset = offsetInteger;
        }
        return finalOffset;
    }

    static {
        IFODU_SLOTID_OFFSET_MAP.put(54, 10);
        IFODU_SLOTID_OFFSET_MAP.put(55, 10);
        IFODU_SLOTID_OFFSET_MAP.put(60, 10);
        IFODU_SLOTID_OFFSET_MAP.put(76, 20);
        IFODU_SLOTID_OFFSET_MAP.put(77, 20);
        IFODU_SLOTID_OFFSET_MAP.put(83, 50);
        IFODU_SLOTID_OFFSET_MAP.put(89, 20);
        IFODU_SLOTID_OFFSET_MAP.put(90, 20);
        IFODU_SLOTID_OFFSET_MAP.put(92, 0);
        IFODU_SLOTID_OFFSET_MAP.put(95, 20);
        IFODU_SLOTID_OFFSET_MAP.put(114, 20);
        IFODU_SLOTID_OFFSET_MAP.put(115, 0);
    }
}

