/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.ifoduconfig_u2kv1r5c01;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.neinterface.neadapter.TECommuNEMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TEQueryIFODUGroup
extends com.huawei.nglct.nemgr.rtn.ifoduconfig_v2r8c01.TEQueryIFODUGroup {
    private static final String NSCMD_CFG_GET_NJ1_PG = "NSCMD_CFG_GET_NJ1_PG";
    private static final String NSCMD_CFG_GET_NJ1_BDMAP = "NSCMD_CFG_GET_NJ1_BDMAP";
    private static final String NSCMD_CFG_GET_PLA_GROUP = "NSCMD_CFG_GET_PLA_GROUP";
    private static final String WORK_UNIT = "1";
    private static final String PROTECT_UNIT = "0";
    private static final int RTN980 = 83;
    private static final int SLAVE_INFO_LENGTH = 8;
    private static final String P1J1 = "10";
    private static final String PLA = "11";

    @Override
    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        int confValue = TESpecialAttrMgr.getInstance().getNEAttrIntValue(neid, "TE_FUNC_RTN_CFG_HOPMGR", "TE_ATTR_RTN_HOPMGR_RELATIVE_ODUSLOT_OFFSET");
        if (confValue != -1) {
            this.IFODUSLOTVALUE = confValue;
        }
        if (TEConfigurationDataMgr.getInstance().getNE(neid).getNEType() == 83) {
            this.IFODUSLOTVALUE = 50;
        }
        super.handleMessage(neid, operationList, subfunc, filterErrorCodeList);
        this.queryGroup();
        this.sortResultByBoard();
    }

    private void queryGroup() {
        Operation nj1Oper = TECreateObjectFactory.getOperation((int)this.neid, (String)NSCMD_CFG_GET_NJ1_PG);
        Operation plaOper = TECreateObjectFactory.getOperation((int)this.neid, (String)NSCMD_CFG_GET_PLA_GROUP);
        ArrayList<Operation> tmp = new ArrayList<Operation>();
        tmp.add(nj1Oper);
        tmp.add(plaOper);
        int result = TECommuNEMgr.getInstance().sendCommand((int)this.neid, tmp, (int)this.getTimeOut(), null).retCode;
        if (result == 0) {
            this.addNj1Data(nj1Oper);
            this.addPlaData(plaOper);
        }
        tmp.clear();
    }

    private void addNj1Data(Operation nj1Oper) {
        Operation tmpOper;
        ArrayList<String> groupIds = new ArrayList<String>();
        int len = nj1Oper.getOutputCount();
        for (int i = 0; i < len; ++i) {
            Output output = nj1Oper.getOutput(i);
            if (!output.getFault(0).getCode().equals(String.valueOf(0))) continue;
            groupIds.add(output.getPart(0).getValue());
        }
        if (groupIds.isEmpty()) {
            return;
        }
        Operation nj1MapOper = TECreateObjectFactory.getOperation((int)this.neid, (String)NSCMD_CFG_GET_NJ1_BDMAP);
        ArrayList<Operation> tmp = new ArrayList<Operation>();
        int len2 = groupIds.size();
        for (int i = 0; i < len2; ++i) {
            tmpOper = (Operation)nj1MapOper.clone();
            Input input = tmpOper.getInput();
            input.getPart(0).setValue((String)groupIds.get(i));
            tmp.add(tmpOper);
        }
        if (tmp.isEmpty()) {
            return;
        }
        int result = TECommuNEMgr.getInstance().sendCommand((int)this.neid, tmp, (int)this.getTimeOut(), null).retCode;
        if (result == 0) {
            ArrayList<Map<String, List<String>>> data = new ArrayList<Map<String, List<String>>>();
            int len3 = tmp.size();
            for (int i = 0; i < len3; ++i) {
                tmpOper = (Operation)tmp.get(i);
                if (!tmpOper.getOutput(0).getFault(0).getCode().equals(String.valueOf(0))) continue;
                HashMap<String, List<String>> obj = new HashMap<String, List<String>>();
                int jlen = tmpOper.getOutputCount();
                for (int j = 0; j < jlen; ++j) {
                    this.fillAttr(tmpOper.getOutput(j), obj);
                }
                data.add(obj);
            }
            if (!data.isEmpty()) {
                this.addNj1StatusIntoOutputdata(data);
            }
        }
    }

    private void fillAttr(Output output, Map<String, List<String>> obj) {
        List<String> slots;
        if (PROTECT_UNIT.equals(output.getPart(1).getValue())) {
            slots = obj.get(PROTECT_UNIT);
            if (slots == null) {
                slots = new ArrayList<String>();
                obj.put(PROTECT_UNIT, slots);
            }
        } else {
            slots = obj.get(WORK_UNIT);
            if (slots == null) {
                slots = new ArrayList<String>();
                obj.put(WORK_UNIT, slots);
            }
        }
        slots.add(output.getPart(2).getValue());
    }

    private void addNj1StatusIntoOutputdata(List<Map<String, List<String>>> datas) {
        int len = datas.size();
        for (int i = 0; i < len; ++i) {
            Param param;
            RowParams rowParams;
            String tmpSlot;
            int j;
            Map<String, List<String>> tmpMap = datas.get(i);
            List<String> workSlotids = tmpMap.get(WORK_UNIT);
            List<String> protectSlotids = tmpMap.get(PROTECT_UNIT);
            int jlen = workSlotids.size();
            for (j = 0; j < jlen; ++j) {
                tmpSlot = workSlotids.get(j);
                rowParams = this.getRowpaParamsBySlotid(tmpSlot);
                if (rowParams == null) continue;
                param = new Param("wMode", P1J1);
                rowParams.addParam(param);
                param = new Param("isWork", WORK_UNIT);
                rowParams.addParam(param);
            }
            jlen = protectSlotids.size();
            for (j = 0; j < jlen; ++j) {
                tmpSlot = protectSlotids.get(j);
                rowParams = this.getRowpaParamsBySlotid(tmpSlot);
                if (rowParams == null) continue;
                param = new Param("wMode", P1J1);
                rowParams.addParam(param);
                param = new Param("isWork", PROTECT_UNIT);
                rowParams.addParam(param);
            }
        }
    }

    private RowParams getRowpaParamsBySlotid(String slotid) {
        BussinessParams bus = this.outputData.getBussinessParams();
        int len = bus.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            String workSlotid;
            RowParams rowParams = bus.getRowParams(i);
            if (rowParams.getParam("protectionSlotId") != null || !slotid.equals(workSlotid = rowParams.getParam("workingSlotId").getValue())) continue;
            return rowParams;
        }
        return null;
    }

    private void addPlaData(Operation oper) {
        Param param;
        if (!oper.getOutput(0).getFault(0).getCode().equals(PROTECT_UNIT)) {
            return;
        }
        ArrayList<String> workSlotidList = new ArrayList<String>();
        ArrayList<String> slaveSlotidList = new ArrayList<String>();
        int len = oper.getOutputCount();
        for (int i = 0; i < len; ++i) {
            Output output = oper.getOutput(0);
            String workSlotid = output.getPartValue("mainslotid");
            workSlotidList.add(workSlotid);
            int slavePortNum = Integer.valueOf(output.getPartValue("slaveportnum"));
            String slaveSlotids = output.getPartValue("slaveslotids");
            for (int j = 0; j < slavePortNum; ++j) {
                String eatchData = slaveSlotids.substring(j * 8, (j + 1) * 8);
                slaveSlotidList.add(Integer.valueOf(eatchData.substring(0, 4), 16).toString());
            }
        }
        for (String tmpSlot : workSlotidList) {
            RowParams rowParams = this.getRowpaParamsBySlotid(tmpSlot);
            if (rowParams == null) continue;
            param = new Param("wMode", PLA);
            rowParams.addParam(param);
            param = new Param("isWork", WORK_UNIT);
            rowParams.addParam(param);
        }
        for (String tmpSlot : slaveSlotidList) {
            RowParams rowParams = this.getRowpaParamsBySlotid(tmpSlot);
            if (rowParams == null) continue;
            param = new Param("wMode", PLA);
            rowParams.addParam(param);
            param = new Param("isWork", PROTECT_UNIT);
            rowParams.addParam(param);
        }
    }
}

