/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.ifoduconfig;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.necommon.TEOperationLogUtility;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.io.File;
import java.util.ArrayList;

public class TESetODUInfo
extends TENEExplorerBean {
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String BASE_PATH = "rtn" + File.separator + "res" + File.separator;
    private static final String STRING_SOURCE = BASE_PATH + File.separator + "ifoduconfig" + File.separator + "odures_" + LANGUAGE + ".ini";
    private TEResourceUtil resourceUtil = null;
    private static final String NSCMD_CFG_SET_ODU_WORK = "NSCMD_CFG_SET_ODU_WORK";
    private static final String W32BRD_ATTR_WORKSTATUS = "W32BRD_ATTR_WORKSTATUS";

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        this.resourceUtil = TEGetFilePath.getResource((int)neid, (String)STRING_SOURCE);
        TEOperationLogUtility.setOperaStr((String)this.getOperaStr());
        TEOperationLogUtility.writeAllLog((int)neid, (SubFunc)subfunc, (Datainterface)inputData, (String)user, (String)ipAddress, (Datainterface)outputData);
    }

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        int row;
        ArrayList operations = super.getOperation(neid, subFunc, inputData, memeryData);
        BussinessParams businessparams = inputData.getBussinessParams();
        RowParams rowparams = null;
        Param tempParam = null;
        int rowlen = businessparams.getRowParamsCount();
        for (row = 0; row < rowlen; ++row) {
            rowparams = businessparams.getRowParams(row);
            tempParam = rowparams.getParam(W32BRD_ATTR_WORKSTATUS);
        }
        if (null == tempParam) {
            for (row = 0; row < operations.size(); ++row) {
                if (!NSCMD_CFG_SET_ODU_WORK.equals(((Operation)operations.get(row)).getName())) continue;
                operations.remove(row);
                break;
            }
        }
        return operations;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList);
        this.distinctErrorCodeItemFilter(this.outputData);
    }

    public void distinctErrorCodeItemFilter(Datainterface output) {
        int Paramscount = output.getBussinessParams().getRowParamsCount();
        if (Paramscount <= 0) {
            return;
        }
        RowParams rowParams = output.getBussinessParams().getRowParams()[Paramscount - 1];
        RowErrors[] rowErrors = rowParams.getRowErrors();
        int len = rowErrors.length;
        RowErrors tmp_rowerrors = null;
        RowErrors tmp_rowerrors_1 = null;
        for (int i = 0; i < len; ++i) {
            tmp_rowerrors = rowErrors[i];
            for (int j = len - 1; j > i; --j) {
                tmp_rowerrors_1 = rowErrors[j];
                if (!tmp_rowerrors.getErrorMessage().getErrorcode().equals(tmp_rowerrors_1.getErrorMessage().getErrorcode())) continue;
                rowParams.removeRowErrors(rowErrors[j]);
                --len;
            }
        }
    }

    private String getOperaStr() {
        String des = "";
        try {
            RowParams rowParams = null;
            rowParams = this.inputData.getBussinessParams().getRowParams(0);
            int slotid = Integer.parseInt(rowParams.getParam("slotid").getValue());
            long W32BRD_ATTR_TRANSMITFRE = Long.parseLong(rowParams.getParam("W32BRD_ATTR_TRANSMITFRE").getValue());
            long W32BRD_ATTR_TRINTERVAL = Long.parseLong(rowParams.getParam("W32BRD_ATTR_TRINTERVAL").getValue());
            int W32BRD_ATTR_TRANSMITPOWER = Integer.parseInt(rowParams.getParam("W32BRD_ATTR_TRANSMITPOWER").getValue());
            int W32BRD_ATTR_WORKSTATUS = Integer.parseInt(rowParams.getParam(W32BRD_ATTR_WORKSTATUS).getValue());
            des = String.valueOf(slotid) + this.resourceUtil.getString("sep") + this.getBoardName(slotid) + " , ";
            des = des + this.resourceUtil.getString("W32BRD_ATTR_TRANSMITFRE") + ":" + String.valueOf(W32BRD_ATTR_TRANSMITFRE / 1000L) + " , ";
            des = des + this.resourceUtil.getString("W32BRD_ATTR_TRINTERVAL") + ":" + String.valueOf(W32BRD_ATTR_TRINTERVAL / 1000L) + " , ";
            des = des + this.resourceUtil.getString("W32BRD_ATTR_TRANSMITPOWER") + ":" + String.valueOf(W32BRD_ATTR_TRANSMITPOWER / 10) + " , ";
            if (0 == W32BRD_ATTR_WORKSTATUS) {
                des = des + this.resourceUtil.getString("WORKSTATUS") + ":" + this.resourceUtil.getString("closed") + ";";
            } else if (1 == W32BRD_ATTR_WORKSTATUS) {
                des = des + this.resourceUtil.getString("WORKSTATUS") + ":" + this.resourceUtil.getString("opened") + ";";
            }
            if (rowParams.getParam("W32BRD_ATTR_TXTHRESHOLDHIGH") != null && rowParams.getParam("W32BRD_ATTR_TXTHRESHOLDHIGH").getValue() != null) {
                int W32BRD_ATTR_TXTHRESHOLDHIGH = Integer.parseInt(rowParams.getParam("W32BRD_ATTR_TXTHRESHOLDHIGH").getValue());
                des = des + this.resourceUtil.getString("txthresholdhightx") + ":" + (float)W32BRD_ATTR_TXTHRESHOLDHIGH / 10.0f + " ,";
            }
            if (rowParams.getParam("W32BRD_ATTR_TXTHRESHOLDLOW") != null && rowParams.getParam("W32BRD_ATTR_TXTHRESHOLDLOW").getValue() != null) {
                int W32BRD_ATTR_TXTHRESHOLDLOW = Integer.parseInt(rowParams.getParam("W32BRD_ATTR_TXTHRESHOLDLOW").getValue());
                des = des + this.resourceUtil.getString("txthresholdlowtx") + ":" + (float)W32BRD_ATTR_TXTHRESHOLDLOW / 10.0f + " ,";
            }
            if (rowParams.getParam("W32BRD_ATTR_RXTHRESHOLDHIGH") != null && rowParams.getParam("W32BRD_ATTR_RXTHRESHOLDHIGH").getValue() != null) {
                int W32BRD_ATTR_RXTHRESHOLDHIGH = Integer.parseInt(rowParams.getParam("W32BRD_ATTR_RXTHRESHOLDHIGH").getValue());
                des = des + this.resourceUtil.getString("rxthresholdhightx") + ":" + (float)W32BRD_ATTR_RXTHRESHOLDHIGH / 10.0f + " ,";
            }
            if (rowParams.getParam("W32BRD_ATTR_RXTHRESHOLDLOW") != null && rowParams.getParam("W32BRD_ATTR_RXTHRESHOLDLOW").getValue() != null) {
                int W32BRD_ATTR_RXTHRESHOLDLOW = Integer.parseInt(rowParams.getParam("W32BRD_ATTR_RXTHRESHOLDLOW").getValue());
                des = des + this.resourceUtil.getString("rxthresholdlowtx") + ":" + (float)W32BRD_ATTR_RXTHRESHOLDLOW / 10.0f + " ,";
            }
        }
        catch (NumberFormatException e) {
            TELogFactory.getNormalLogger().error(e.getMessage());
        }
        catch (IndexOutOfBoundsException e) {
            TELogFactory.getNormalLogger().error(e.getMessage());
        }
        return des;
    }

    private String getBoardName(int slotid) {
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(this.neid, slotid);
        if (board == null) {
            return "";
        }
        int boardtype = board.getBoardType();
        String boardname = TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, boardtype);
        return boardname;
    }
}

