/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.ifoduconfig;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.necommon.TEOperationLogUtility;
import com.huawei.nglct.nemgr.rtn.ifoduconfig_u2kv1r5global.TEIFODUCommonBean;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TESetIFInfo
extends TENEExplorerBean {
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String BASE_PATH = "rtn" + File.separator + "res" + File.separator;
    private static final String STRING_SOURCE = BASE_PATH + "ifoduconfig" + File.separator + "ifres_" + LANGUAGE + ".ini";
    private static final List<String> RefCmdList = new ArrayList<String>();
    private TEResourceUtil resourceUtil = null;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.modifyInputParams();
            this.outputData = new Datainterface();
            this.operationList = this.getOperation(neid, subFunc, inputData, memeryData);
            for (Object opObj : this.operationList) {
                TENE ne;
                int boardType;
                Operation opSpec = (Operation)opObj;
                if (opSpec.getCmdid() != 35418 || !"5".equals(opSpec.getInput().getPartValue("bandwidth")) || (boardType = (ne = TENEListMgr.getInstance().getNE(neid)).getBoard(Integer.parseInt(opSpec.getInput().getPartValue("ifslotid"))).getBoardType()) != 1548) continue;
                Operation opClone = (Operation)opSpec.clone();
                this.operationList.remove(opObj);
                this.operationList.add(opClone);
                break;
            }
            if (null == this.operationList || this.operationList.size() == 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            int result = this.sendMessage(neid);
            if (result == 0) {
                this.handleMessage(neid, this.operationList, subFunc);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            this.encryptParamForOutputData();
            this.modifyOutputParams();
            Param isLogFlagParam = inputData.getBussinessParams().getRowParams(0).getParam("isLogFlag");
            if (isLogFlagParam != null && isLogFlagParam.getValue().equals("0")) {
                this.isLogFlag = false;
            }
            if (this.isLogFlag && this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        this.setNeIdParams();
        return this.outputData;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errorList = new ArrayList<Integer>();
        errorList.add(38737);
        return errorList;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        this.resourceUtil = TEGetFilePath.getResource((int)neid, (String)STRING_SOURCE);
        TEOperationLogUtility.setOperaStr((String)this.getOperaStr());
        TEOperationLogUtility.writeAllLog((int)neid, (SubFunc)subfunc, (Datainterface)inputData, (String)user, (String)ipAddress, (Datainterface)outputData);
    }

    private String getOperaStr() {
        String des = "";
        RowParams rowParams = null;
        rowParams = this.inputData.getBussinessParams().getRowParams(0);
        int slotid = 0;
        if (rowParams.getParam("ifslotid") != null) {
            slotid = Integer.parseInt(rowParams.getParam("ifslotid").getValue());
            des = String.valueOf(slotid) + this.resourceUtil.getString("sep") + this.getBoardName(slotid) + " , ";
            des = des + this.getParamString(rowParams, "W32PORT_ATTR_RADIOWORKMODE", 0);
            des = des + this.getParamString(rowParams, "W32PORT_ATTR_RADIOLINKID", 0);
            des = des + this.getParamString(rowParams, "W32PORT_ATTR_ATPCENABLE", 0);
            des = des + this.getParamString(rowParams, "W32PORT_ATTR_ATPCUPPER", 0);
            des = des + this.getParamString(rowParams, "W32PORT_ATTR_ATPCLOWER", 0);
            des = des + this.getParamString(rowParams, "W32PORT_ATTR_ATPCADJUSTMENT", 0);
            des = des + this.getParamString(rowParams, "serviceType", 0);
            des = des + this.getParamString(rowParams, "bandwidth", 0);
            des = des + this.getParamString(rowParams, "ammode", 0);
            des = des + this.getParamString(rowParams, "amstate", 0);
            des = des + this.getParamString(rowParams, "manualmode", 0);
            des = des + this.getParamString(rowParams, "ensuremode", 0);
            des = des + this.getParamString(rowParams, "fullmode", 0);
            des = des + this.getParamString(rowParams, "e1enable", 0);
            des = des + this.getParamString(rowParams, "guaranteenum", 0);
            des = des + this.getParamString(rowParams, "fullnum", 0);
            des = des + this.getParamString(rowParams, "ethband", 0);
            des = des + this.getParamString(rowParams, "stm1num", 0);
        }
        if (rowParams.getParam("slotid") != null) {
            slotid = Integer.parseInt(rowParams.getParam("slotid").getValue());
            des = des + String.valueOf(slotid) + this.resourceUtil.getString("sep") + this.getBoardName(slotid) + " , ";
            des = des + this.getParamString(rowParams, "W32BRD_ATTR_TRANSMITFRE", 1000);
            des = des + this.getParamString(rowParams, "W32BRD_ATTR_TRINTERVAL", 1000);
            des = des + this.getParamString(rowParams, "W32BRD_ATTR_TRANSMITPOWER", 10);
            des = des + this.getParamString(rowParams, "W32BRD_ATTR_RECEIVEPOWER", 0);
            des = des + this.getParamString(rowParams, "W32BRD_ATTR_WORKSTATUS", 0);
            des = des + this.getParamString(rowParams, "W32BRD_ATTR_ACTTRINTERVAL", 0);
            des = des + this.getParamString(rowParams, "W32BRD_ATTR_ACTTRANSMITPOWER", 0);
            des = des + this.getParamString(rowParams, "W32BRD_ATTR_SWITCHSTATUS", 0);
            des = des + this.getParamString(rowParams, "W32BRD_ATTR_REMARK", 0);
        }
        if (!des.isEmpty() && des.endsWith(", ")) {
            des = des.substring(0, des.length() - 2);
        }
        return des;
    }

    private String getParamString(RowParams rowParams, String name, int digit) {
        StringBuffer sb = new StringBuffer();
        String value = "";
        if (rowParams.getParam(name) != null) {
            String resValue;
            value = rowParams.getParam(name).getValue();
            sb.append(this.resourceUtil.getString(name)).append(":");
            if (0 != digit) {
                long ivalue = Long.parseLong(value);
                value = Float.toString((float)ivalue / (float)digit);
            }
            if (null != (resValue = this.resourceUtil.getString(name + "_" + value)) && !(name + "_" + value).equals(resValue)) {
                value = resValue;
            }
            sb.append(value).append(" , ");
        }
        return sb.toString();
    }

    private String getBoardName(int slotid) {
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(this.neid, slotid);
        if (board == null) {
            return "";
        }
        int boardtype = board.getBoardType();
        String boardname = TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, boardtype);
        return boardname;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        super.handleMessage(neid, operationList, subfunc);
        TEIFODUCommonBean.processRef(neid, RefCmdList, this.inputData);
    }

    static {
        RefCmdList.add("NSCMD_RTN_CFG_GET_EVERYMOD_E1NUM_CFG");
        RefCmdList.add("NSCMD_CFG_GET_AM_CURRCAPACITY");
    }
}

