/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.ifoduconfig;

import com.huawei.nglct.bscfg.equipment.TEEquipmentDescription;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class TEQueryIFODUGroup
extends TENEExplorerBean {
    protected Set boardlist = new HashSet();
    protected Set phyboardlist = new HashSet();
    protected TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
    protected int slotRelation = 0;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        int neType = TEConfigurationDataMgr.getInstance().getNE(neid).getNEType();
        this.slotRelation = TEEquipmentDescription.getInstance().getSlotRelation(TEGetNEDomainVersion.getInstance().getDevType(neType));
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        this.getBoardList();
        Operation operation = (Operation)operationList.get(0);
        Output output = operation.getOutput(0);
        int faultCode = Integer.parseInt(output.getFault(0).getCode());
        if (0 == faultCode) {
            if (this.outputData.getBussinessParams().getRowParamsCount() > 0) {
                this.handle1J1Data(this.outputData);
            }
        } else {
            this.outputData = new Datainterface();
            this.outputData.setBussinessParams(new BussinessParams());
        }
        this.handleIFODU();
    }

    private void getBoardList() {
        TEBoard board;
        int i;
        TENE ne = TENEListMgr.getInstance().getNE(this.neid);
        Vector bdList = ne.getClonedBoardList();
        Vector phybdList = ne.getClonedPhyBoardList();
        int len = bdList.size();
        for (i = 0; i < len; ++i) {
            board = (TEBoard)bdList.get(i);
            this.boardlist.add(board.getSlotID());
        }
        len = phybdList.size();
        for (i = 0; i < len; ++i) {
            int logicBoardType;
            board = (TEBoard)phybdList.get(i);
            int slotId = board.getSlotID();
            int boardType = board.getBoardType();
            if (boardType != (logicBoardType = this.mgr.getBoardType(this.neid, slotId))) continue;
            this.phyboardlist.add(board.getSlotID());
        }
    }

    protected void handle1J1Data(Datainterface outputData) {
        RowParams[] rowdatas = outputData.getBussinessParams().getRowParams();
        int len = rowdatas.length;
        for (int i = 0; i < len; ++i) {
            int workifid = 0;
            int workiftype = 0;
            int protectifid = 0;
            int protectiftype = 0;
            Param para = rowdatas[i].getParam("workingSlotId");
            if (para != null && !"".equals(para.getValue())) {
                workifid = Integer.parseInt(para.getValue());
                workiftype = this.mgr.getBoardType(this.neid, workifid);
                rowdatas[i].addParam("workingbdname", this.mgr.getBoardTypeName(this.neid, workiftype));
                rowdatas[i].addParam("workingbdtype", String.valueOf(workiftype));
                if (this.phyboardlist.contains(new Integer(workifid))) {
                    rowdatas[i].addParam("workifphy", "1");
                }
                this.boardlist.remove(new Integer(workifid));
            }
            if ((para = rowdatas[i].getParam("protectionSlotId")) == null || "".equals(para.getValue())) continue;
            protectifid = Integer.parseInt(para.getValue());
            protectiftype = this.mgr.getBoardType(this.neid, protectifid);
            rowdatas[i].addParam("protectbdname", this.mgr.getBoardTypeName(this.neid, protectiftype));
            rowdatas[i].addParam("protectbdtype", String.valueOf(protectiftype));
            if (this.phyboardlist.contains(new Integer(protectifid))) {
                rowdatas[i].addParam("protectifphy", "1");
            }
            this.boardlist.remove(new Integer(protectifid));
            rowdatas[i].addParam("workoduid", workifid + this.slotRelation + "");
            rowdatas[i].addParam("protectoduid", protectifid + this.slotRelation + "");
            this.boardlist.remove(new Integer(workifid + this.slotRelation));
            this.boardlist.remove(new Integer(protectifid + this.slotRelation));
            if (this.phyboardlist.contains(new Integer(workifid + this.slotRelation))) {
                rowdatas[i].addParam("workoduphy", "1");
            }
            if (!this.phyboardlist.contains(new Integer(protectifid + this.slotRelation))) continue;
            rowdatas[i].addParam("protectoduphy", "1");
        }
    }

    protected void handleIFODU() {
        Iterator ib = this.boardlist.iterator();
        while (ib.hasNext()) {
            int oduboardid;
            int boardid = (Integer)ib.next();
            int boardtype = this.mgr.getBoardType(this.neid, boardid);
            if (!this.mgr.isIFboard(boardtype) || !this.boardlist.contains(new Integer(oduboardid = boardid + this.slotRelation))) continue;
            RowParams rowparm = new RowParams();
            rowparm.addParam("workingSlotId", boardid + "");
            if (this.phyboardlist.contains(new Integer(boardid))) {
                rowparm.addParam("workifphy", "1");
            }
            rowparm.addParam("workingbdname", this.mgr.getBoardTypeName(this.neid, boardtype));
            rowparm.addParam("workingbdtype", String.valueOf(boardtype));
            rowparm.addParam("workoduid", oduboardid + "");
            if (this.phyboardlist.contains(new Integer(oduboardid))) {
                rowparm.addParam("workoduphy", "1");
            }
            this.outputData.getBussinessParams().addRowParams(rowparm);
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(38662);
        list.add(41674);
        return list;
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

