/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.if1plus1performance;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.performance.TEPfmBsEvent;
import com.huawei.nglct.nelist.model.performance.TEPfmEventsDataLoader;
import com.huawei.nglct.nemgr.rtn.if1plus1performance.TEIF1Plus1ProtectionHisPerformanceStruct;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;
import java.util.List;

public class TEQueryIF1Plus1ProtectionHisPerformance
extends TENEExplorerBean {
    private String grpIdVal = "";

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        BussinessParams businessParams = inputData.getBussinessParams();
        RowParams[] rowParamsArray = businessParams.getRowParams();
        this.grpIdVal = rowParamsArray[0].getParam("groupid").getValue();
        String operName = "NSCMD_PER_GET_HISDATA_NEW";
        Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)operName);
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Operation operClone = null;
        String periodVal = rowParamsArray[0].getParam("period").getValue();
        operClone = (Operation)oper.clone();
        Input input = operClone.getInput();
        input.setPartValue("peid", "0");
        input.setPartValue("period", periodVal);
        input.setPartValue("reserve", "255");
        input.setPartValue("objtype", "114");
        input.setPartValue("paralen", "1");
        input.setPartValue("objpara", "00");
        if (operClone.getInput().getPart("beginTime") != null) {
            Param starttimeParam = rowParamsArray[0].getParam("beginTime");
            input.setPartValue("beginTime", TEDateUtils.dateStrToByteStr((String)starttimeParam.getValue()));
        }
        if (operClone.getInput().getPart("endTime") != null) {
            Param endtimeParam = rowParamsArray[0].getParam("endTime");
            input.setPartValue("endTime", TEDateUtils.dateStrToByteStr((String)endtimeParam.getValue()));
        }
        operationList.add(operClone);
        return operationList;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        super.handleMessage(neid, operationList, subfunc);
        List<TEIF1Plus1ProtectionHisPerformanceStruct> structList = this.convertNeDataToNMStructList();
        this.convertPfmDataToOutputData(structList);
    }

    private List<TEIF1Plus1ProtectionHisPerformanceStruct> convertNeDataToNMStructList() {
        BussinessParams bussinessParams = this.outputData.getBussinessParams();
        TENE currentNE = TENEListMgr.getInstance().getNE(this.neid);
        ArrayList<TEIF1Plus1ProtectionHisPerformanceStruct> itemList = new ArrayList<TEIF1Plus1ProtectionHisPerformanceStruct>();
        for (int i = 0; i < bussinessParams.getRowParamsCount(); ++i) {
            RowParams rowParams = bussinessParams.getRowParams(i);
            if (rowParams.getRowErrorsCount() > 0) continue;
            Param startTimeParam = rowParams.getParam("startTime");
            String starTimeValue = TEDateUtils.byteStrToDateStr((String)startTimeParam.getValue());
            startTimeParam.setValue(starTimeValue);
            Param objparaParam = rowParams.getParam("objpara");
            String groupidParamValue = objparaParam.getValue().substring(0, 2);
            if (!"".equals(this.grpIdVal) && !"0".equals(this.grpIdVal) && Integer.parseInt(groupidParamValue, 16) != Integer.parseInt(this.grpIdVal)) continue;
            String remanentStr = objparaParam.getValue().substring(4);
            String itemNumValue = objparaParam.getValue().substring(0, 2);
            int itemNum = Integer.parseInt(itemNumValue);
            String temp = "";
            for (int j = 0; j < itemNum; ++j) {
                temp = remanentStr.substring(j * 22, (j + 1) * 22);
                String peId = temp.substring(0, 4);
                String peVal = temp.substring(4, 20);
                String valid = temp.substring(20, 22);
                TEIF1Plus1ProtectionHisPerformanceStruct peStruct = new TEIF1Plus1ProtectionHisPerformanceStruct();
                peStruct.setPeriod(rowParams.getParam("period").getValue());
                peStruct.setStartTime(rowParams.getParam("startTime").getValue());
                peStruct.setReserve(rowParams.getParam("reserve").getValue());
                peStruct.setObjtype(rowParams.getParam("objtype").getValue());
                peStruct.setParalen(rowParams.getParam("paralen").getValue());
                long hexPeId = Long.parseLong(peId, 16);
                peStruct.setPeid(String.valueOf(hexPeId));
                long hexPeVal = Long.parseLong(peVal, 16);
                peStruct.setPeValue(String.valueOf(hexPeVal));
                long hexValidFlag = Long.parseLong(valid, 16);
                peStruct.setValidFlag(String.valueOf(hexValidFlag));
                String contentShowed = currentNE.getNEName() + "-Protection Group ID:" + Long.parseLong(groupidParamValue, 16);
                peStruct.setPfmMonObj(contentShowed);
                itemList.add(peStruct);
            }
        }
        return itemList;
    }

    private void convertPfmDataToOutputData(List<TEIF1Plus1ProtectionHisPerformanceStruct> eventList) {
        boolean succ = true;
        if (!"0".equals(this.outputData.getErrorMessage().getErrorcode())) {
            succ = false;
        }
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        RowParams[] rowparams = new RowParams[eventList.size()];
        for (int i = 0; i < eventList.size(); ++i) {
            TEIF1Plus1ProtectionHisPerformanceStruct record = eventList.get(i);
            rowparams[i] = new RowParams();
            rowparams[i].addParam("peid", record.getPeid());
            TEPfmBsEvent pfmBsEvent = TEPfmEventsDataLoader.getInstance().getPfmBsEvent(this.neid, Integer.parseInt(record.getPeid()));
            String peName = pfmBsEvent.getPeName();
            rowparams[i].addParam("peName", peName);
            rowparams[i].addParam("period", String.valueOf(record.getPeriod()));
            rowparams[i].addParam("startTime", record.getStartTime());
            String peVal = record.getPeValue();
            rowparams[i].addParam("peValue", peVal);
            rowparams[i].addParam("validFlag", record.getValidFlag());
            rowparams[i].addParam("pfmMonObj", record.getPfmMonObj());
            this.outputData.getBussinessParams().addRowParams(rowparams[i]);
        }
        this.outputData.setErrorMessage(new ErrorMessage());
        if (succ) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
            TENE currentNE = TENEListMgr.getInstance().getNE(this.neid);
            String neName = currentNE.getNEName();
            RowErrors vRowErrors = new RowErrors();
            vRowErrors.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)38410));
            vRowErrors.addParam(new Param("nename", neName));
            RowParams vRowParams = new RowParams();
            vRowParams.addRowErrors(vRowErrors);
            this.outputData.getBussinessParams().addRowParams(vRowParams);
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList list = super.getFilterErrorCodeList();
        return list;
    }
}

