/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.if1plus1_v2r8c01;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;

public class TEQueryRadioInfo
extends TENEExplorerBean {
    public static final int RADIOACTIVESTATE = 3;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        Operation operation = (Operation)operationList.get(0);
        Output output = operation.getOutput(0);
        int faultCode = Integer.parseInt(output.getFault(0).getCode());
        if (faultCode == 0 && this.outputData.getBussinessParams().getRowParamsCount() > 0) {
            this.handleData(this.outputData);
        }
    }

    private void handleData(Datainterface outputData) {
        RowParams[] rowdatas = outputData.getBussinessParams().getRowParams();
        for (int len = rowdatas.length - 1; len >= 0; --len) {
            int activeflag;
            Param para = rowdatas[len].getParam("activeFlag");
            if (para == null || (activeflag = Integer.parseInt(para.getValue())) == 3) continue;
            outputData.getBussinessParams().removeRowParams(len);
        }
        rowdatas = outputData.getBussinessParams().getRowParams();
        int len = rowdatas.length;
        for (int i = 0; i < len; ++i) {
            Param para = rowdatas[i].getParam("workingSlotId");
            int workingSlotID = 0;
            if (para == null || "".equals(para.getValue())) continue;
            workingSlotID = Integer.parseInt(para.getValue());
            rowdatas[i].addParam("workingbdname", this.getBoardName(workingSlotID));
            para = rowdatas[i].getParam("workingPortId");
            if (para == null || "".equals(para.getValue())) continue;
            int workingPortID = Integer.parseInt(para.getValue());
            rowdatas[i].addParam("workingPortName", this.getPortName(workingSlotID, workingPortID));
            para = rowdatas[i].getParam("protectionSlotId");
            int protectionSlotID = 0;
            if (para == null || "".equals(para.getValue())) continue;
            protectionSlotID = Integer.parseInt(para.getValue());
            rowdatas[i].addParam("protectbdname", this.getBoardName(protectionSlotID));
            para = rowdatas[i].getParam("protectionPortId");
            if (para == null || "".equals(para.getValue())) continue;
            int protectionPortID = Integer.parseInt(para.getValue());
            rowdatas[i].addParam("protectionPortName", this.getPortName(protectionSlotID, protectionPortID));
            int result = this.querySwitchState(rowdatas[i]);
            if (0 != result) continue;
            para = rowdatas[i].getParam("equipSlotId");
            int equipSlotID = 0;
            if (para != null && !"".equals(para.getValue())) {
                equipSlotID = Integer.parseInt(para.getValue());
                if (equipSlotID == -1) {
                    para.setValue("");
                }
                rowdatas[i].addParam("equipbdname", this.getBoardName(equipSlotID));
            }
            if ((para = rowdatas[i].getParam("equipPortId")) == null || "".equals(para.getValue())) continue;
            int equipPortID = Integer.parseInt(para.getValue());
            if (equipPortID == -1) {
                para.setValue("");
            }
            rowdatas[i].addParam("equipPortName", this.getPortName(equipSlotID, equipPortID));
        }
    }

    private String getBoardName(int slotid) {
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(this.neid, slotid);
        if (board == null) {
            return "";
        }
        int boardtype = board.getBoardType();
        String boardname = TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, boardtype);
        return boardname;
    }

    private String getPortName(int slotID, int portID) {
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(this.neid, slotID);
        if (board == null) {
            return "";
        }
        int boardType = board.getBoardType();
        String portName = TEConfigurationDataMgr.getInstance().getPortName(this.neid, slotID, boardType, portID);
        return portName;
    }

    private int querySwitchState(RowParams rowdata) {
        ArrayList<Operation> operList = new ArrayList<Operation>();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_CFG_GET_RADIO_1J1PG_STATE");
        Input input = oper.getInput();
        input.setPartValue("groupId", rowdata.getParam("groupId").getValue());
        operList.add(oper);
        OperationResult result = TENECommMgr.getInstance().sendCommand(this.neid, operList, this.TIME_OUT);
        if (result.retCode != 0) {
            return result.retCode;
        }
        Operation tmpOper = (Operation)operList.get(0);
        for (Output output : tmpOper.getOutput()) {
            for (Fault fault : output.getFault()) {
                String code = fault.getCode();
                if (null != code && Integer.parseInt(code) == 0) continue;
                return Integer.parseInt(code);
            }
            String equipSlotId = output.getPart("equipSlotId").getValue();
            rowdata.getParam("equipSlotId").setValue(equipSlotId);
            String equipPortId = output.getPart("equipPortId").getValue();
            rowdata.getParam("equipPortId").setValue(equipPortId);
            String equipWBoardState = output.getPart("equipWBoardState").getValue();
            rowdata.getParam("equipWBoardState").setValue(equipWBoardState);
            String equipPBoardState = output.getPart("equipPBoardState").getValue();
            rowdata.getParam("equipPBoardState").setValue(equipPBoardState);
            String equipSwitchRequest = output.getPart("equipSwitchRequest").getValue();
            rowdata.getParam("equipSwitchRequest").setValue(equipSwitchRequest);
        }
        operList.clear();
        return 0;
    }
}

