/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.if1plus1_v2r8c01;

import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEPort;
import com.huawei.nglct.nelist.model.TESubBoard;
import com.huawei.nglct.nemgr.rtn.if1plus1_v2r8c01.TEAvailableRes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class TEGetAvailableRes
implements TENEMgrInterface {
    private TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
    private TENEListMgr neListMgr = TENEListMgr.getInstance();
    private ArrayList availablePortResList = new ArrayList();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        return this.getAllResource(neid);
    }

    private Datainterface getAllResource(int neid) {
        TENE ne = this.neListMgr.getNE(neid);
        Vector boardList = ne.getClonedBoardList();
        Collections.sort(boardList);
        TEPort port = null;
        TEBoard board = null;
        TESubBoard subBoard = null;
        ArrayList portList = null;
        int boardLen = boardList.size();
        for (int i = 0; i < boardLen; ++i) {
            int j;
            board = (TEBoard)boardList.get(i);
            int boardType = board.getBoardType();
            if (!this.mgr.isIFboard(boardType)) continue;
            TEAvailableRes availablePortRes = null;
            List subBoardList = board.getSubBoardList();
            if (subBoardList.size() > 0) {
                Collections.sort(subBoardList);
                int size = subBoardList.size();
                for (j = 0; j < size; ++j) {
                    subBoard = (TESubBoard)subBoardList.get(j);
                    portList = this.mgr.getBoardPortList(neid, subBoard.getSubBoardType(), board.getSlotID());
                    int portLen = portList.size();
                    for (int k = 0; k < portLen; ++k) {
                        int portID = (Integer)portList.get(k);
                        port = board.getPort(portID);
                        availablePortRes = new TEAvailableRes(ne, board, subBoard, port);
                    }
                }
            } else {
                portList = this.mgr.getBoardPortList(neid, boardType, board.getSlotID());
                int portLen = portList.size();
                for (j = 0; j < portLen; ++j) {
                    int portID = (Integer)portList.get(j);
                    port = this.mgr.getPort(neid, board.getSlotID(), portID);
                    port.setPortName(this.mgr.getPortName(neid, board.getSlotID(), boardType, portID));
                    subBoard = new TESubBoard(board.getNEID(), board.getSlotID(), 255);
                    availablePortRes = new TEAvailableRes(ne, board, subBoard, port);
                }
            }
            if (null == availablePortRes) continue;
            this.availablePortResList.add(availablePortRes);
        }
        return this.constructPtnData();
    }

    private Datainterface constructPtnData() {
        Datainterface datainterface = new Datainterface();
        BussinessParams bParams = new BussinessParams();
        int size = this.availablePortResList.size();
        for (int i = 0; i < size; ++i) {
            TEAvailableRes portRes = (TEAvailableRes)this.availablePortResList.get(i);
            RowParams rParams = new RowParams();
            Param param = null;
            param = new Param("neId", String.valueOf(portRes.getNe().getNEID()));
            rParams.addParam(param);
            param = new Param("neName", portRes.getNe().getNEName());
            rParams.addParam(param);
            param = new Param("slotId", String.valueOf(portRes.getBoard().getSlotID()));
            rParams.addParam(param);
            param = new Param("boardType", String.valueOf(portRes.getBoard().getBoardType()));
            rParams.addParam(param);
            param = new Param("boardName", portRes.getBoard().getBoardName());
            rParams.addParam(param);
            param = new Param("subSlotId", String.valueOf(portRes.getSubBoard().getSubSlotID()));
            rParams.addParam(param);
            param = new Param("subBoardType", String.valueOf(portRes.getSubBoard().getSubBoardType()));
            rParams.addParam(param);
            if (portRes.getSubBoard().getSubBoardName() != null) {
                param = new Param("subBoardName", portRes.getSubBoard().getSubBoardName());
                rParams.addParam(param);
            }
            param = new Param("portID", String.valueOf(portRes.getPort().getPortNo()));
            rParams.addParam(param);
            param = new Param("portType", String.valueOf(portRes.getPort().getPortType()));
            rParams.addParam(param);
            if (portRes.getPort().getPortName() != null) {
                param = new Param("portName", portRes.getPort().getPortName());
                rParams.addParam(param);
            }
            bParams.addRowParams(rParams);
        }
        datainterface.setBussinessParams(bParams);
        return datainterface;
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

