/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.if1plus1;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.neinterface.neadapter.TECommuNEMgr;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.necommon.TEOperationLogUtility;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;

public class TEQueryRadioInfo
extends TENEExplorerBean {
    public static final int RADIOACTIVESTATE = 3;

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        TEOperationLogUtility.setOperaStr((String)subfunc.getSubFuncDes(neid));
        TEOperationLogUtility.writeLog((int)neid, (SubFunc)subfunc, (Datainterface)inputData, (String)user, (String)ipAddress, (Datainterface)outputData);
    }

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        int[] proid = this.handlePPID(neid);
        if (proid.length == 0) {
            this.outputData = new Datainterface();
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
            Param isLogFlagParam = inputData.getBussinessParams().getRowParams(0).getParam("isLogFlag");
            if (isLogFlagParam != null && isLogFlagParam.getValue().equals("0")) {
                this.isLogFlag = false;
            }
            if (this.isLogFlag && this.isNeedOperationlog()) {
                this.writeLog(neid, subFunc, inputData, user, ipAddress, this.outputData);
            }
            return this.outputData;
        }
        Datainterface newinput = new Datainterface();
        BussinessParams businessParam = new BussinessParams();
        for (int i = 0; i < proid.length; ++i) {
            RowParams rtnRowParams = new RowParams();
            rtnRowParams.addParam("groupId", proid[i] + "");
            businessParam.addRowParams(rtnRowParams);
        }
        newinput.setBussinessParams(businessParam);
        return super.performBussinessProcess(neid, subFunc, newinput, memeryData, user, ipAddress);
    }

    private int[] handlePPID(int neid) {
        ArrayList<String> l = new ArrayList<String>();
        ArrayList<Object> operationList = new ArrayList<Object>();
        Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_RADIO_1J1PG");
        operationList.add(oper.clone());
        OperationResult result = TECommuNEMgr.getInstance().sendCommand(neid, operationList, 15, this.subfunc);
        if (result.retCode != 0) {
            return new int[0];
        }
        int size = operationList.size();
        for (int i = 0; i < size; ++i) {
            Operation operation = (Operation)operationList.get(i);
            for (Output output : operation.getOutput()) {
                int retCode = new Integer(output.getFault()[0].getCode());
                if (retCode != 0) continue;
                String value = output.getPartValue("groupId");
                l.add(value);
            }
        }
        int[] a = new int[l.size()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = Integer.parseInt((String)l.get(i));
        }
        return a;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        Operation operation = (Operation)operationList.get(0);
        Output output = operation.getOutput(0);
        int faultCode = Integer.parseInt(output.getFault(0).getCode());
        if (faultCode == 0 && this.outputData.getBussinessParams().getRowParamsCount() > 0) {
            this.handleData(this.outputData);
        }
    }

    public void handleData(Datainterface outputData) {
        RowParams[] rowdatas = outputData.getBussinessParams().getRowParams();
        int activeflag = Integer.parseInt(rowdatas[0].getParam("activeFlag").getValue());
        if (activeflag != 3) {
            outputData.getBussinessParams().removeRowParams(0);
            return;
        }
        int len = rowdatas.length;
        for (int i = 0; i < len; ++i) {
            int id;
            Param para = rowdatas[i].getParam("workingSlotId");
            if (para != null && !"".equals(para.getValue())) {
                id = Integer.parseInt(para.getValue());
                rowdatas[i].addParam("workingbdname", this.getBoardName(id));
            }
            if ((para = rowdatas[i].getParam("protectionSlotId")) != null && !"".equals(para.getValue())) {
                id = Integer.parseInt(para.getValue());
                rowdatas[i].addParam("protectbdname", this.getBoardName(id));
            }
            if ((para = rowdatas[i].getParam("equipSlotId")) != null && !"".equals(para.getValue())) {
                id = Integer.parseInt(para.getValue());
                if (id == -1) {
                    para.setValue("");
                }
                rowdatas[i].addParam("equipbdname", this.getBoardName(id));
            }
            if ((para = rowdatas[i].getParam("waveSlotId")) == null || "".equals(para.getValue())) continue;
            id = Integer.parseInt(para.getValue());
            if (id == -1) {
                para.setValue("");
            }
            rowdatas[i].addParam("wavebdname", this.getBoardName(id));
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(new Integer(38662));
        list.add(new Integer(41674));
        list.add(37898);
        list.add(1091634631);
        list.add(1090777617);
        return list;
    }

    private String getBoardName(int slotid) {
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(this.neid, slotid);
        if (board == null) {
            return "";
        }
        int boardtype = board.getBoardType();
        String boardname = TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, boardtype);
        return boardname;
    }
}

