/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.hopmgr;

import com.huawei.nglct.bscfg.equipment.TEEquipmentDescription;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TEQueryRemoteNeInfor
extends TENEExplorerBean {
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        RowParams rowParams = inputData.getBussinessParams().getRowParams(0);
        String pLogicNeID = rowParams.getParam("peerNEID").getValue();
        String pPhyNeID = rowParams.getParam("peerRealNEID").getValue();
        String pIFSloID = rowParams.getParam("peerIFSlotId").getValue();
        int peerNEID = Integer.parseInt(pPhyNeID);
        int peerSlotId = Integer.parseInt(pIFSloID);
        TENE ne = TENEListMgr.getInstance().getNE(Integer.parseInt(pLogicNeID));
        if (null == ne && TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090615159));
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            return this.outputData;
        }
        if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts() && null != ne && 1 != ne.getLogStatus() && !TEHandleSbiInfo.getInstance().handleSBIConnectOnInter(ne.getNEID())) {
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            return this.outputData;
        }
        Param funIdParam = rowParams.getParam("funid");
        this.queryPeerBoard(peerNEID, peerSlotId, funIdParam);
        this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        return this.outputData;
    }

    private void queryPeerBoard(int peerNEID, int peerSlotId, Param funIdParam) {
        TENE ne = TENEListMgr.getInstance().getPhyNE(peerNEID);
        RowParams rowParams_rtn = new RowParams();
        rowParams_rtn.addParam(new Param("peerNEID", String.valueOf(ne.getNEID())));
        rowParams_rtn.addParam(new Param("peerNEName", ne.getNEName()));
        rowParams_rtn.addParam(new Param("peerRealNEID", String.valueOf(ne.getRealNEID())));
        String peerNEIP = ne.getNeIp();
        if (peerNEIP == null || peerNEIP.equals("")) {
            peerNEIP = ne.getNEGWAddress();
        }
        rowParams_rtn.addParam(new Param("peerNEIP", peerNEIP));
        int neType = ne.getNEType();
        int shelfType = ne.getShelfType();
        int devType = TEGetNEDomainVersion.getInstance().getDevType(neType);
        int slotRealation = TEEquipmentDescription.getInstance().getSlotRelation(devType);
        rowParams_rtn.addParam(new Param("peerNEType", String.valueOf(neType)));
        rowParams_rtn.addParam(new Param("peerShelfType", String.valueOf(shelfType)));
        rowParams_rtn.addParam(new Param("peerNEVersion", ne.getHostVersion()));
        String curUser = ne.getCurUser();
        String neState = ne.getNEState();
        curUser = curUser == null ? "" : curUser;
        neState = neState == null ? "" : neState;
        rowParams_rtn.addParam(new Param("peerNEUser", curUser));
        rowParams_rtn.addParam(new Param("peerNEState", neState));
        rowParams_rtn.addParam(new Param("peerIFSlotId", String.valueOf(peerSlotId)));
        rowParams_rtn.addParam(new Param("peerIFBoardName", TEConfigurationDataMgr.getInstance().getBoard(ne.getNEID(), peerSlotId).getBoardName()));
        rowParams_rtn.addParam(new Param("peerODUSlotId", String.valueOf(peerSlotId + slotRealation)));
        rowParams_rtn.addParam(new Param("peerSupported", String.valueOf(this.isSupportFunction(ne, funIdParam))));
        this.outputData.getBussinessParams().addRowParams(rowParams_rtn);
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
    }

    private boolean isSupportFunction(TENE neObj, Param funIdParam) {
        if (null == funIdParam || "".equals(funIdParam.getValue()) || "0".equals(funIdParam.getValue())) {
            return true;
        }
        int neType = neObj.getNEType();
        String NE_FUNC_TREE_FILE_NAME = "nefunctiontree_" + neType + "_" + TESysManagerBean.getInstance().getlanguage() + ".xml";
        String path = TEResourceManager.getPath() + File.separator + TEGetFilePath.getFilePath((int)neType, null, (String)(TEPathManager.CONFIG_PROFILE_PATH + NE_FUNC_TREE_FILE_NAME));
        String bundlename = TEGetFilePath.getNEBundleName((int)neType);
        Document doc = null;
        try {
            doc = TEParseXMLFile.parseFile((String)bundlename, (String)path);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("GetIsSupportFunction() fail!", (Throwable)e);
        }
        if (null == doc) {
            TELogFactory.getNormalLogger().error("Parse file fail\u00a3\u00a1");
            return true;
        }
        return this.isSupportFunction(neObj, doc, funIdParam.getValue());
    }

    private boolean isSupportFunction(TENE neObj, Document doc, String funId) {
        NodeList leaf_list = null;
        NodeList itemList = null;
        Element noleaf = null;
        Element element = null;
        Element itemElement = null;
        boolean isSupport = false;
        NodeList nodeList = doc.getElementsByTagName("nonleaf");
        int size = nodeList.getLength();
        block0: for (int i = 0; i < size; ++i) {
            noleaf = (Element)nodeList.item(i);
            leaf_list = noleaf.getElementsByTagName("leaf");
            for (int j = leaf_list.getLength() - 1; j >= 0; --j) {
                element = (Element)leaf_list.item(j);
                if (!element.getAttribute("defaultFunID").equals(funId)) continue;
                itemList = element.getElementsByTagName("functionItem");
                if (null == itemList || itemList.getLength() <= 0) continue block0;
                int kSize = itemList.getLength();
                for (int k = 0; k < kSize; ++k) {
                    itemElement = (Element)itemList.item(k);
                    if (itemElement.hasAttribute("neversion")) {
                        if (!this.checkNeVersion(neObj.getHostVersion(), itemElement.getAttribute("neversion"))) continue;
                        isSupport = true;
                        continue block0;
                    }
                    isSupport = true;
                }
                continue block0;
            }
        }
        return isSupport;
    }

    private boolean checkNeVersion(String neVersion, String suppVersions) {
        if (suppVersions == null || suppVersions.equals("")) {
            return true;
        }
        String[] spaceVersions = suppVersions.substring(1, suppVersions.length() - 1).split(",");
        int m = spaceVersions.length;
        for (int i = 0; i < m; ++i) {
            String[] versions = spaceVersions[i].split("-");
            if (neVersion.compareToIgnoreCase(versions[0]) < 0 || neVersion.compareToIgnoreCase(versions[1]) > 0) continue;
            return true;
        }
        return false;
    }
}

