/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.hopmgr;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nelist.ITENEInfo;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEInfoImpl;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.rtn.hopmgr.JudgeResult;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class TEJudgeNEDistanceInLCT {
    private static TEJudgeNEDistanceInLCT instance;
    Set set = new HashSet();
    private ITENEInfo neInfo = new TENEInfoImpl();

    public void setNeInfo(ITENEInfo neInfo) {
        this.neInfo = neInfo;
    }

    private TEJudgeNEDistanceInLCT() {
    }

    public static synchronized TEJudgeNEDistanceInLCT getInstance() {
        if (instance == null) {
            instance = new TEJudgeNEDistanceInLCT();
        }
        return instance;
    }

    public JudgeResult judgeNeDistance(int neid1, int neid2) {
        JudgeResult judgeResult = new JudgeResult();
        if (this.isGateWayNEAndNONGateWayNE(neid1, neid2)) {
            judgeResult.setResultCode(0);
            if (this.neInfo.isGateWayNE(neid1)) {
                judgeResult.setFarneid(neid2);
            } else {
                judgeResult.setFarneid(neid1);
            }
        } else if (this.is2GateWayNE(neid1, neid2)) {
            judgeResult.setResultCode(1090615123);
        } else {
            judgeResult.setResultCode(2);
        }
        return judgeResult;
    }

    public JudgeResult judgeNonGateWayNeDistance(int firstNeid, int secondNeid) {
        TENE firstNE = TENEListMgr.getInstance().getNE(firstNeid);
        TENE secondNE = TENEListMgr.getInstance().getNE(secondNeid);
        if (firstNE.getNeIp() != secondNE.getNeIp()) {
            JudgeResult result = new JudgeResult();
            result.setResultCode(1090615124);
            return result;
        }
        TENE gatewayNE = TENEListMgr.getInstance().getGateWayNEByIP(firstNE.getNeIp());
        if (gatewayNE != null) {
            if (gatewayNE.getLogStatus() == 1) {
                return this.getDistanceNeid(firstNE, secondNE, gatewayNE);
            }
            JudgeResult result = new JudgeResult();
            result.setResultCode(1090615120);
            return result;
        }
        JudgeResult result = new JudgeResult();
        result.setResultCode(1090615122);
        return result;
    }

    public JudgeResult getDistanceNeid(TENE firstNE, TENE secondNE, TENE gatewayNE) {
        JudgeResult result;
        Map<String, String> distanceNe = this.getDistanceInGateWayByECC(gatewayNE.getNEID());
        Set<String> keys = distanceNe.keySet();
        Iterator<String> realNEIDit = keys.iterator();
        String firstNEDistance = null;
        String secondNEDistance = null;
        while (realNEIDit.hasNext()) {
            String realID = realNEIDit.next();
            String firstNERealID = String.valueOf(firstNE.getRealNEID());
            String secondNERealID = String.valueOf(secondNE.getRealNEID());
            if (firstNERealID.equalsIgnoreCase(realID)) {
                firstNEDistance = distanceNe.get(firstNERealID);
                continue;
            }
            if (!secondNERealID.equalsIgnoreCase(realID)) continue;
            secondNEDistance = distanceNe.get(secondNERealID);
        }
        if (firstNEDistance != null && secondNEDistance != null) {
            int firstNEDis = -1;
            int secondNEDis = -1;
            try {
                firstNEDis = Integer.parseInt(firstNEDistance);
                secondNEDis = Integer.parseInt(secondNEDistance);
            }
            catch (NumberFormatException ex) {
                TELogFactory.getNormalLogger().error("Judge ne distance failed!", (Throwable)ex);
            }
            if (firstNEDis != -1 && secondNEDis != -1) {
                result = new JudgeResult();
                result.setFarneid(firstNEDis >= secondNEDis ? firstNE.getNEID() : secondNE.getNEID());
                result.setResultCode(0);
            } else {
                result = new JudgeResult();
                result.setResultCode(1090615121);
            }
        } else {
            result = new JudgeResult();
            result.setResultCode(1090615121);
        }
        return result;
    }

    public Map<String, String> getDistanceInGateWayByECC(int gateWayNeid) {
        HashMap<String, String> neDistanceMap = new HashMap<String, String>();
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Operation oper = TECreateObjectFactory.getOperation((int)gateWayNeid, (String)"NSCMD_ECC_GET_COREROUTE");
        operationList.add(oper);
        OperationResult result = TENECommMgr.getInstance().sendCommand(gateWayNeid, operationList, null, 10);
        if (result.retCode == 0) {
            Output[] outputs = ((Operation)operationList.get(0)).getOutput();
            int len = outputs.length;
            for (int i = 0; i < len; ++i) {
                if (!outputs[i].getFault(0).getCode().equals(String.valueOf(0))) continue;
                String hexDestNEID = outputs[i].getPartValue("destaddress");
                neDistanceMap.put("" + Integer.parseInt(hexDestNEID, 16), outputs[i].getPartValue("distance"));
            }
        }
        TELogFactory.getNormalLogger().info("Get distance in gateWay(" + gateWayNeid + ") :" + ((Object)neDistanceMap).toString());
        return neDistanceMap;
    }

    public boolean is2NONGateWayNE(int firstNE, int secondNE) {
        return !this.neInfo.isGateWayNE(firstNE) && !this.neInfo.isGateWayNE(secondNE);
    }

    public boolean is2GateWayNE(int firstNE, int secondNE) {
        return this.neInfo.isGateWayNE(firstNE) && this.neInfo.isGateWayNE(secondNE);
    }

    public boolean isGateWayNEAndNONGateWayNE(int firstNE, int secondNE) {
        return this.neInfo.isGateWayNE(firstNE) && !this.neInfo.isGateWayNE(secondNE) || !this.neInfo.isGateWayNE(firstNE) && this.neInfo.isGateWayNE(secondNE);
    }
}

