/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.hopmgr;

import com.huawei.nglct.bscfg.equipment.TEEquipmentDescription;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.jni.nelist.TEGetLogicNEIDService;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.rtn.hopmgr.TEAutoAddNEBean;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;

public class TEHopBean
extends TENEExplorerBean {
    private String gwAddress = "";
    private int peerNEID = -1;
    private int peerSlotId = -1;
    private int neGWType = 1;
    private static final long WAIT_TIME = 3000L;
    private static final int FORCE_LOGIN_TAG = 1;
    private String slotId = "";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        int result;
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        this.slotId = inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue();
        TENE localNe = TEConfigurationDataMgr.getInstance().getNE(neid);
        TELogFactory.getNormalLogger().info("localNe neid = " + this.neid + ", phyNeid = " + localNe.getRealNEID());
        this.gwAddress = localNe.getNEGWAddress();
        this.neGWType = localNe.getNEGWType();
        if (!this.startFiberSearch()) {
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            return this.outputData;
        }
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            TELogFactory.getNormalLogger().error("TEHopBean.performBussinessProcess() fail!", (Throwable)e);
        }
        if (!this.searchPeerNE()) {
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            return this.outputData;
        }
        TENE ne = TENEListMgr.getInstance().getPhyNE(this.peerNEID);
        if (null == ne) {
            if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
                int logicNEID = TEGetLogicNEIDService.getLogicNEID((int)this.peerNEID);
                if (logicNEID != -1) {
                    RowParams rowParams = this.createLocalNEParam(neid);
                    rowParams.addParam("peerNEID", String.valueOf(logicNEID));
                    rowParams.addParam("peerRealNEID", String.valueOf(this.peerNEID));
                    rowParams.addParam("peerIFSlotId", String.valueOf(this.peerSlotId));
                    String[] procArr = TEGetLogicNEIDService.getProcInfo((int)logicNEID);
                    if (procArr != null && procArr.length > 1) {
                        rowParams.addParam("procID", procArr[0]);
                        rowParams.addParam("procHandle", procArr[1]);
                    }
                    this.outputData.getBussinessParams().addRowParams(rowParams);
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                } else {
                    TELogFactory.getNormalLogger().error("the opposite ne is null");
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090615159));
                }
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
                return this.outputData;
            }
            result = TEAutoAddNEBean.addNE(this.peerNEID, this.gwAddress, this.neGWType, localNe.getCurUser(), localNe.getCurUserPassword(), 1);
            if (0 != result) {
                TELogFactory.getNormalLogger().warn("TEAutoAddNEBean.addNE fail! errorCode = " + result);
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
                return this.outputData;
            }
            ne = TENEListMgr.getInstance().getPhyNE(this.peerNEID);
        }
        if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
            TELogFactory.getNormalLogger().info("peerNe neid = " + ne.getNEID() + ", phyNeid = " + ne.getRealNEID());
            if (1 != ne.getLogStatus() && (result = (int)(TEHandleSbiInfo.getInstance().handleSBIConnectOnInter(ne.getNEID()) ? 1 : 0)) == 0) {
                TELogFactory.getNormalLogger().error("connect sbi of peerNe failed!");
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
                return this.outputData;
            }
        } else if (!this.isPeerNeLogin(ne) && !this.login(ne)) {
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            return this.outputData;
        }
        this.queryPeerBoard();
        this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        return this.outputData;
    }

    public String getDetailStr(RowParams rowparams) {
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        String boardName = mgr.getBoardTypeName(this.neid, mgr.getBoardType(this.neid, Integer.parseInt(this.slotId)));
        StringBuffer sb = new StringBuffer();
        sb.append(this.slotId).append('-').append(boardName);
        return sb.toString();
    }

    private boolean startFiberSearch() {
        this.operationList = new ArrayList();
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_SET_FIBERSEARCH");
        operation.getInput().getPart("slotid").setValue(this.slotId);
        this.operationList.add(operation);
        int result = this.sendMessage(this.neid);
        if (0 == result) {
            operation = (Operation)this.operationList.get(0);
            int errorCode = Integer.parseInt(operation.getOutput(0).getFault(0).getCode());
            if (0 == errorCode) {
                return true;
            }
            TELogFactory.getNormalLogger().warn("Fibersearch Start fail! errorCode = " + errorCode);
            this.setErrorMessage(errorCode);
            return false;
        }
        TELogFactory.getNormalLogger().warn("Fibersearch Start sendMessage fail! errorCode = " + result);
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        return false;
    }

    private boolean searchPeerNE() {
        Operation operation = null;
        this.operationList = new ArrayList();
        TENE ne = TENEListMgr.getInstance().getNE(this.neid);
        operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_FIBERSEARCH");
        operation.getInput().getPart("neid").setValue(String.valueOf(ne.getRealNEID()));
        operation.getInput().getPart("slotid").setValue(this.slotId);
        this.operationList.add(operation);
        int result = this.sendMessage(this.neid);
        if (0 == result) {
            operation = (Operation)this.operationList.get(0);
            int errorCode = Integer.parseInt(operation.getOutput(0).getFault(0).getCode());
            if (0 == errorCode) {
                int peerNEID_RS = Integer.parseInt(operation.getOutput(0).getPartValue("srcneid"));
                if (ne.getRealNEID() == peerNEID_RS) {
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090596385));
                    return false;
                }
                this.peerNEID = peerNEID_RS;
                this.peerSlotId = Integer.parseInt(operation.getOutput(0).getPartValue("srcslotid"));
                return true;
            }
            TELogFactory.getNormalLogger().warn("Fibersearch get result fail! errorCode = " + errorCode);
            this.setErrorMessage(errorCode);
            return false;
        }
        TELogFactory.getNormalLogger().warn("Fibersearch get result sendMessage fail! errorCode = " + result);
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        return false;
    }

    private void setErrorMessage(int errorCode) {
        RowParams rowParams = new RowParams();
        RowErrors rowErrors = new RowErrors();
        Param param = new Param();
        param.setName("neid");
        param.setValue(String.valueOf(this.neid));
        rowErrors.addParam(param);
        param = new Param();
        param.setName("nename");
        param.setValue(TEConfigurationDataMgr.getInstance().getNE(this.neid).getNEName());
        rowErrors.addParam(param);
        rowErrors.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)errorCode));
        rowParams.addRowErrors(rowErrors);
        this.outputData.getBussinessParams().addRowParams(rowParams);
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
    }

    private RowParams createLocalNEParam(int neID) {
        TENE localNe = TEConfigurationDataMgr.getInstance().getNE(neID);
        RowParams rowParams = new RowParams();
        String localNEIP = localNe.getNeIp();
        if (localNEIP == null || localNEIP.equals("")) {
            localNEIP = localNe.getNEGWAddress();
        }
        rowParams.addParam(new Param("localNEIP", localNEIP));
        rowParams.addParam(new Param("localNEName", localNe.getNEName()));
        rowParams.addParam(new Param("localNEID", String.valueOf(localNe.getRealNEID())));
        return rowParams;
    }

    private void queryPeerBoard() {
        TENE ne = TENEListMgr.getInstance().getPhyNE(this.peerNEID);
        RowParams rowParams = this.createLocalNEParam(this.neid);
        rowParams.addParam(new Param("peerNEID", String.valueOf(ne.getNEID())));
        rowParams.addParam(new Param("peerNEName", ne.getNEName()));
        rowParams.addParam(new Param("peerRealNEID", String.valueOf(ne.getRealNEID())));
        String peerNEIP = ne.getNeIp();
        if (peerNEIP == null || peerNEIP.equals("")) {
            peerNEIP = ne.getNEGWAddress();
        }
        rowParams.addParam(new Param("peerNEIP", peerNEIP));
        int neType = ne.getNEType();
        int shelfType = ne.getShelfType();
        int devType = TEGetNEDomainVersion.getInstance().getDevType(neType);
        int slotRealation = TEEquipmentDescription.getInstance().getSlotRelation(devType);
        rowParams.addParam(new Param("peerNEType", String.valueOf(neType)));
        rowParams.addParam(new Param("peerShelfType", String.valueOf(shelfType)));
        rowParams.addParam(new Param("peerNEVersion", ne.getHostVersion()));
        String curUser = ne.getCurUser();
        String neState = ne.getNEState();
        curUser = curUser == null ? "" : curUser;
        neState = neState == null ? "" : neState;
        rowParams.addParam(new Param("peerNEUser", curUser));
        rowParams.addParam(new Param("peerNEState", neState));
        rowParams.addParam(new Param("peerIFSlotId", String.valueOf(this.peerSlotId)));
        rowParams.addParam(new Param("peerIFBoardName", TEConfigurationDataMgr.getInstance().getBoard(ne.getNEID(), this.peerSlotId).getBoardName()));
        rowParams.addParam(new Param("peerODUSlotId", String.valueOf(this.peerSlotId + slotRealation)));
        this.outputData.getBussinessParams().addRowParams(rowParams);
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
    }

    private boolean isPeerNeLogin(TENE ne) {
        int logStatus = ne.getLogStatus();
        return 1 == logStatus;
    }

    private boolean login(TENE ne) {
        int result = TEAutoAddNEBean.login(ne.getNEID(), ne.getNEGWAddress(), ne.getCurUser(), ne.getCurUserPassword(), 1);
        if (0 != result) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            return false;
        }
        return true;
    }
}

