/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.graphanalyse.binfile;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.gencfg.TimeZoneDateBean;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.rtn.graphanalyse.binfile.BinfileUtil;
import com.huawei.nglct.nemgr.rtn.graphanalyse.binfile.TEODULctGraphBean;
import com.huawei.nglct.util.hfcpfiledata.TEHFCPFileAdapter;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;

public class TEODULctGraphPreBean
extends TENEExplorerBean {
    private static final String BIN_FILE_TYPE = "1";
    private static final int SAVE_TIME_OUT = 40;
    private String keyNeID = "";
    private String keySoltID = "";
    private String keySdate = "";
    private String keyeDate = "";
    private String keyPowerType = "";
    private String keyeCounterType = "";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        RowParams rowParams = inputData.getBussinessParams().getRowParams()[0];
        Param sdate = rowParams.getParam("sdate");
        Param edate = rowParams.getParam("edate");
        this.keyNeID = this.getParamValue(rowParams, "neid");
        this.keySoltID = this.getParamValue(rowParams, "slotid");
        this.keySdate = this.getParamValue(rowParams, "sdate");
        this.keyeDate = this.getParamValue(rowParams, "edate");
        this.keyPowerType = this.getParamValue(rowParams, "powertype");
        this.keyeCounterType = this.getParamValue(rowParams, "countertype");
        TimeZoneDateBean timeBean = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neid);
        sdate.setValue(timeBean.strToUTC(sdate.getValue()));
        edate.setValue(timeBean.strToUTC(edate.getValue()));
        rowParams.addParam("filetype", BIN_FILE_TYPE);
        this.sendSaveCommandBeforeQuery(rowParams.getParam("countertype").getValue());
        this.TIME_OUT = 120;
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    private boolean sendSaveCommandBeforeQuery(String counttype) {
        boolean bResult = false;
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PER_SET_HIS_DATA_BU");
        if (operation != null) {
            operation.getInput().getPart("type").setValue(counttype);
            ArrayList<Operation> operationList = new ArrayList<Operation>();
            operationList.add(operation);
            OperationResult result = TENECommMgr.getInstance().sendCommand(this.neid, operationList, 40);
            if (result.retCode == 0 && (operation = (Operation)operationList.get(0)).getOutput(0).getFault(0).getCode().equals(String.valueOf(0))) {
                bResult = true;
            }
        } else {
            bResult = true;
        }
        return bResult;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        String key = TEODULctGraphBean.getKey(this.keyNeID, this.keySoltID, this.keySdate, this.keyeDate, this.keyPowerType, this.keyeCounterType);
        Object[] fileName = this.getFileNames(operationList, "fileNameList");
        super.handleMessage(neid, operationList, subfunc, filterErrorCodeList);
        if (this.outputData.getErrorMessage().getErrorcode().equals(String.valueOf(0))) {
            ArrayList<byte[]> files = new ArrayList<byte[]>();
            int len = fileName.length;
            for (int i = 0; i < len; ++i) {
                String fileStr = (String)fileName[i];
                byte[] tmpB = TEHFCPFileAdapter.getFile((String)fileStr.substring(0, fileStr.lastIndexOf(47)), null, (String)fileStr.substring(fileStr.lastIndexOf(47) + 1).toUpperCase(), (int)TENEListMgr.getInstance().getNE(neid).getRealNEID());
                if (tmpB == null) continue;
                TELogFactory.getNormalLogger().info("get file[" + fileStr + "] sucess!");
                tmpB = TEODULctGraphPreBean.distillFromZipFile(tmpB);
                TELogFactory.getNormalLogger().info("unzip file[" + fileStr + "] sucess!");
                files.add(tmpB);
                TELogFactory.getNormalLogger().info("add byte:\n" + BinfileUtil.getStringFromByteArray(tmpB));
            }
            if (files.size() == 0) {
                this.reHandleMsg();
            } else {
                TEODULctGraphBean.getFileSourceList().put((Object)key, files);
            }
        } else {
            RowParams rowParam = this.outputData.getBussinessParams().getRowParams(0);
            if (rowParam.getRowErrorsCount() == 0) {
                rowParam = this.outputData.getBussinessParams().getRowParams(1);
            }
            Param sdate = rowParam.getRowErrors(rowParam.getRowErrorsCount() - 1).getParam("sdate");
            Param edate = rowParam.getRowErrors(rowParam.getRowErrorsCount() - 1).getParam("edate");
            if (sdate != null) {
                TimeZoneDateBean timeBean = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neid);
                sdate.setValue(timeBean.UTCToTime(sdate.getValue()));
                edate.setValue(timeBean.UTCToTime(edate.getValue()));
            }
        }
    }

    private Object[] getFileNames(List<Operation> operationList, String name) {
        Part part = null;
        Object[] fileNameArr = new String[]{};
        ArrayList files = new ArrayList();
        int operLen = operationList.size();
        block0: for (int i = 0; i < operLen; ++i) {
            Operation oper = operationList.get(i);
            int outLen = oper.getOutputCount();
            for (int j = 0; j < outLen; ++j) {
                Output outPut = oper.getOutput(j);
                Part tmp = outPut.getPart(name);
                if (tmp == null || tmp.getValue() == null) continue;
                part = tmp;
                int fileNums = Integer.parseInt(outPut.getPart("filenum").getValue());
                TEODULctGraphPreBean.addFile(files, part, fileNums);
                continue block0;
            }
        }
        if (files.size() > 0) {
            fileNameArr = files.toArray();
        }
        TELogFactory.getNormalLogger().debug("Ne history data file size=" + fileNameArr.length);
        return fileNameArr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] distillFromZipFile(byte[] data) {
        byte[] res = new byte[]{};
        GZIPInputStream zipStream = null;
        try {
            byte[] old;
            zipStream = new GZIPInputStream(new ByteArrayInputStream(data));
            byte[] tmp = new byte[500];
            int eof = 0;
            while (-1 != (eof = zipStream.read(tmp, 0, tmp.length))) {
                old = res;
                res = new byte[old.length + eof];
                System.arraycopy(old, 0, res, 0, old.length);
                System.arraycopy(tmp, 0, res, old.length, eof);
            }
            tmp = "\n".getBytes();
            old = res;
            res = new byte[old.length + tmp.length];
            System.arraycopy(old, 0, res, 0, old.length);
            System.arraycopy(tmp, 0, res, old.length, tmp.length);
            zipStream.close();
        }
        catch (IOException e) {
            TELogFactory.getNormalLogger().error("distillFromZipFile fail!");
            TELogFactory.getNormalLogger().error(e.getMessage());
            try {
                if (null != zipStream) {
                    zipStream.close();
                }
            }
            catch (IOException e1) {
                TELogFactory.getNormalLogger().error(e1.getMessage());
            }
            finally {
                zipStream = null;
            }
        }
        return res;
    }

    public static void addFile(List files, Part part, int len) {
        String value = part.getValue();
        int fileNameLen = 0;
        int index = 0;
        String fileName = "";
        for (int i = 0; i < len; ++i) {
            if (i == 0) {
                fileNameLen = Integer.parseInt(value.substring(index, index + 4), 16);
                index += 4;
            } else {
                fileNameLen = Integer.parseInt(value.substring(index, index + 6), 16);
                index += 6;
            }
            fileName = TEODULctGraphPreBean.convert(value.substring(index, index + fileNameLen * 2));
            index += fileNameLen * 2;
            if (files.contains(fileName)) continue;
            files.add(fileName);
        }
    }

    public static String convert(String hexStr) {
        byte[] retByte = new byte[hexStr.length() / 2];
        int j = retByte.length;
        for (int i = 0; i < j; ++i) {
            retByte[i] = (byte)Integer.parseInt(hexStr.substring(i * 2, i * 2 + 2), 16);
        }
        return new String(retByte);
    }

    private void reHandleMsg() {
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
        BussinessParams bus = new BussinessParams();
        RowParams rowparam = new RowParams();
        RowErrors rowError = new RowErrors();
        ErrorMessage errorMessage = new ErrorMessage();
        errorMessage.setErrorcode("1090646029");
        errorMessage.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot((int)Integer.valueOf("1090646029")));
        Param par = new Param();
        par.setName("nename");
        par.setValue(TENEListMgr.getInstance().getNE(this.neid).getNEName());
        rowError.setErrorMessage(errorMessage);
        rowError.addParam(par);
        rowparam.addRowErrors(rowError);
        bus.addRowParams(rowparam);
        this.outputData.setBussinessParams(bus);
    }

    private String getParamValue(RowParams rowParams, String paramName) {
        Param parm = rowParams.getParam(paramName);
        if (parm != null) {
            return parm.getValue();
        }
        return "";
    }
}

