/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.graphanalyse.binfile;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.nemgr.rtn.graphanalyse.PerformSNRData;
import com.huawei.nglct.nemgr.rtn.graphanalyse.TELctDrawing_SNR;
import com.huawei.nglct.nemgr.rtn.graphanalyse.binfile.HistoryDataParaInterface;
import com.huawei.nglct.nemgr.rtn.graphanalyse.binfile.HistoryEvent;
import com.huawei.nglct.nemgr.rtn.graphanalyse.binfile.PeriodHistoryData;
import com.huawei.nglct.nemgr.rtn.graphanalyse.binfile.QxHistoryDataPara;
import com.huawei.nglct.nemgr.rtn.graphanalyse.binfile.RtnEventFilter;
import com.huawei.nglct.nemgr.rtn.graphanalyse.binfile.RtnHistoryData;
import com.huawei.nglct.nemgr.rtn.graphanalyse.binfile.RtnObjectTypeFilter;
import com.huawei.nglct.nemgr.rtn.graphanalyse.binfile.TEODULctGraphBean;
import com.huawei.nglct.util.datetime.TEDateUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TEODULctGraphBean_SNR
extends TEODULctGraphBean {
    private static final int IF_SNR_MAX = 15375;
    private static final int IF_SNR_MIN = 15376;
    private static final int IF_SNR_AVG = 15377;
    private static final int IFPORT_OBJ = 110;
    public static final String SNR_AVG = "avg";
    public static final String SNR_MAX = "max";
    public static final String SNR_MIN = "min";
    public static final String SNR_ALL = "all";
    private String snrType = "all";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performBussinessProcess(HttpServletRequest request, HttpServletResponse response) {
        try {
            String edate_rtn;
            String sdate_rtn;
            String counterType;
            this.neid = Integer.parseInt(request.getParameter("neid"));
            this.slotId = request.getParameter("slotid");
            this.keySdate = request.getParameter("sdate");
            this.keyeDate = request.getParameter("edate");
            this.powerType_rtn = request.getParameter("powertype");
            this.counterType = request.getParameter("counterType");
            String key = TEODULctGraphBean.getKey(String.valueOf(this.neid), this.slotId, this.keySdate, this.keyeDate, this.powerType_rtn, this.counterType);
            TELctDrawing_SNR lctDrawing = new TELctDrawing_SNR();
            lctDrawing.setNeid(this.neid);
            this.timeBean = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)this.neid);
            if (request.getParameter("downFlg") != null) {
                lctDrawing.setDownFlg(true);
            }
            if ("1".equals(counterType = request.getParameter("counterType"))) {
                lctDrawing.setCuTp("count1");
                this.counterPermType = 1;
            } else if ("2".equals(counterType)) {
                lctDrawing.setCuTp("count2");
                this.counterPermType = 2;
            }
            if (request.getParameter("snrtype") != null) {
                String tempSnrType = request.getParameter("snrtype");
                if (tempSnrType.equalsIgnoreCase(SNR_AVG)) {
                    this.snrType = "SNRAVG";
                } else if (tempSnrType.equalsIgnoreCase(SNR_MAX)) {
                    this.snrType = "SNRMAX";
                } else if (tempSnrType.equalsIgnoreCase(SNR_MIN)) {
                    this.snrType = "SNRMIN";
                }
            }
            lctDrawing.setSnrType(this.snrType);
            int imgX_RTN = Integer.parseInt(request.getParameter("imgX").trim());
            int imgY_RTN = Integer.parseInt(request.getParameter("imgY").trim());
            lctDrawing.setImgX(imgX_RTN);
            lctDrawing.setImgY(imgY_RTN);
            if ("".equals(request.getParameter("sdate").trim()) || "".equals(request.getParameter("edate").trim())) {
                sdate_rtn = null;
                edate_rtn = null;
            } else {
                sdate_rtn = request.getParameter("sdate").trim().substring(0, 16);
                edate_rtn = request.getParameter("edate").trim().substring(0, 16);
                this.startD_rtn = TEDateUtils.strToCalendar((String)sdate_rtn, (String)"yyyy-MM-dd HH:mm");
                this.endD_rtn = TEDateUtils.strToCalendar((String)edate_rtn, (String)"yyyy-MM-dd HH:mm");
                lctDrawing.setDataList(this.geDataFromBinFile(key));
            }
            lctDrawing.setSdate(sdate_rtn);
            lctDrawing.setEdate(edate_rtn);
            BufferedImage spectWaveimage_rtn = lctDrawing.createImg();
            response.setContentType("image/jpeg");
            response.setHeader("Expires", "0");
            response.setHeader("Pragma", "public");
            response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
            response.setHeader("Cache-Control", "public");
            if (request.getParameter("downFlg") != null) {
                response.setHeader("Content-disposition", "attachment;filename=PerformanceGraph.jpg");
            }
            ServletOutputStream out = response.getOutputStream();
            ImageIO.write((RenderedImage)spectWaveimage_rtn, "jpg", (OutputStream)out);
            out.close();
        }
        catch (ParseException e) {
            TELogFactory.getNormalLogger().error("TEODULctGraphBean_SNR", (Throwable)e);
        }
        catch (IOException e) {
            TELogFactory.getNormalLogger().error("TEODULctGraphBean_SNR", (Throwable)e);
        }
        finally {
            try {
                response.getOutputStream().close();
            }
            catch (IOException e1) {
                TELogFactory.getNormalLogger().error("TEODULctGraphBean_SNR", (Throwable)e1);
            }
        }
    }

    private List<PerformSNRData> geDataFromBinFile(String key) throws IOException, ParseException {
        RtnEventFilter eventFilter = new RtnEventFilter();
        if (this.snrType.equalsIgnoreCase(SNR_MAX) || this.snrType.equalsIgnoreCase("SNRMAX") || this.snrType.equalsIgnoreCase(SNR_ALL)) {
            eventFilter.addFilterEventID(15375);
        }
        if (this.snrType.equalsIgnoreCase(SNR_MIN) || this.snrType.equalsIgnoreCase("SNRMIN") || this.snrType.equalsIgnoreCase(SNR_ALL)) {
            eventFilter.addFilterEventID(15376);
        }
        if (this.snrType.equalsIgnoreCase(SNR_AVG) || this.snrType.equalsIgnoreCase("SNRAVG") || this.snrType.equalsIgnoreCase(SNR_ALL)) {
            eventFilter.addFilterEventID(15377);
        }
        RtnObjectTypeFilter objectFilter = new RtnObjectTypeFilter();
        objectFilter.addFilterObjectType(110);
        ArrayList<PerformSNRData> list = new ArrayList<PerformSNRData>();
        List fileByteList = (List)fileSourceList.getDataNotRefresh((Object)key);
        if (fileByteList != null) {
            for (int i = 0; i < fileByteList.size(); ++i) {
                byte[] file1 = (byte[])fileByteList.get(i);
                list.addAll(this.processOneFiledata(eventFilter, objectFilter, file1));
            }
        }
        return list;
    }

    protected List<PerformSNRData> processOneFiledata(RtnEventFilter eventFilter, RtnObjectTypeFilter objectFilter, byte[] filedata) {
        ArrayList<PerformSNRData> list = new ArrayList<PerformSNRData>();
        RtnHistoryData dataPara_rtn = RtnHistoryData.buildRtnHistoryData(filedata, eventFilter, objectFilter);
        if (dataPara_rtn.getHead().getPeriodType() != this.counterPermType) {
            return list;
        }
        List<PeriodHistoryData> body_rtn = dataPara_rtn.getBody();
        for (int j = 0; j < body_rtn.size(); ++j) {
            Calendar eventDate;
            if (body_rtn.get(j) == null || (eventDate = this.getNMTimeFromEventData(this.startD_rtn, this.endD_rtn, body_rtn.get(j).getStartTime())) == null) continue;
            for (int hisPos = 0; hisPos < body_rtn.get(j).getHistoryDataPara().size(); ++hisPos) {
                HistoryEvent hisEventAvg;
                HistoryEvent hisEventMin;
                HistoryDataParaInterface hisPara_rtn = body_rtn.get(j).getHistoryDataPara().get(hisPos);
                if (hisPara_rtn == null || !(hisPara_rtn instanceof QxHistoryDataPara) || !objectFilter.getSupportObjectType().contains(((QxHistoryDataPara)hisPara_rtn).getObjectType())) continue;
                Map objectInfo = TEODULctGraphBean_SNR.parseOduPortObj(((QxHistoryDataPara)hisPara_rtn).getPara());
                TELogFactory.getNormalLogger().debug("RTN dat slotID=" + objectInfo.get("slotid").toString());
                TELogFactory.getNormalLogger().debug("Input slotID=" + this.slotId);
                if (!objectInfo.get("slotid").toString().equals(this.slotId)) continue;
                PerformSNRData data = new PerformSNRData();
                data.setDate(eventDate.getTime());
                HistoryEvent hisEventMax = ((QxHistoryDataPara)hisPara_rtn).getEventByID(15375);
                boolean isContinue = false;
                if (hisEventMax != null) {
                    data.setSnrMAX((int)hisEventMax.getValue() / 10);
                    isContinue = true;
                }
                if ((hisEventMin = ((QxHistoryDataPara)hisPara_rtn).getEventByID(15376)) != null) {
                    data.setSnrMIN((int)hisEventMin.getValue() / 10);
                    isContinue = true;
                }
                if ((hisEventAvg = ((QxHistoryDataPara)hisPara_rtn).getEventByID(15377)) != null) {
                    data.setSnrAVG((int)hisEventAvg.getValue() / 10);
                    isContinue = true;
                }
                if (!isContinue) continue;
                TELogFactory.getNormalLogger().debug("Add SNR data=" + data.toString());
                list.add(data);
            }
        }
        return list;
    }
}

