/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.graphanalyse.binfile;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TESpecialAppInterface;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.gencfg.TimeZoneDateBean;
import com.huawei.nglct.nemgr.rtn.graphanalyse.PwData;
import com.huawei.nglct.nemgr.rtn.graphanalyse.TELctDrawing;
import com.huawei.nglct.nemgr.rtn.graphanalyse.binfile.BinfileUtil;
import com.huawei.nglct.nemgr.rtn.graphanalyse.binfile.HistoryDataParaInterface;
import com.huawei.nglct.nemgr.rtn.graphanalyse.binfile.HistoryEvent;
import com.huawei.nglct.nemgr.rtn.graphanalyse.binfile.PeriodHistoryData;
import com.huawei.nglct.nemgr.rtn.graphanalyse.binfile.QxHistoryDataPara;
import com.huawei.nglct.nemgr.rtn.graphanalyse.binfile.RtnEventFilter;
import com.huawei.nglct.nemgr.rtn.graphanalyse.binfile.RtnHistoryData;
import com.huawei.nglct.nemgr.rtn.graphanalyse.binfile.RtnObjectTypeFilter;
import com.huawei.nglct.nemgr.rtn.graphanalyse.binfile.TEODULctGraphBean_MSE;
import com.huawei.nglct.nemgr.rtn.graphanalyse.binfile.TEODULctGraphBean_SNR;
import com.huawei.nglct.util.buffer.TETimeBuffer;
import com.huawei.nglct.util.datetime.TEDateUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TEODULctGraphBean
implements TESpecialAppInterface {
    protected int neid;
    protected String slotId;
    protected String keySdate = "";
    protected String keyeDate = "";
    protected String powerType_rtn;
    protected String counterType = "";
    protected Calendar startD_rtn;
    protected Calendar endD_rtn;
    protected static final String C_15M = "1";
    protected static final String C_24H = "2";
    protected static final int COUNTTYPE_15M = 1;
    protected static final int COUNTTYPE_24H = 2;
    private static final String RS = "rs";
    private static final String TS = "ts";
    private static final String SNR = "snr";
    private static final String MSE = "mse";
    private static final int RSL_MAX = 8606;
    private static final int RSL_MIN = 8607;
    private static final int TSL_MAX = 8609;
    private static final int TSL_MIN = 8610;
    private static final int ODUPORT_OBJ = 111;
    protected static TETimeBuffer<String, List<byte[]>> fileSourceList = new TETimeBuffer(50);
    TimeZoneDateBean timeBean;
    int maxEventID;
    int minEventID;
    String eventType;
    protected int counterPermType = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performBussinessProcess(HttpServletRequest request, HttpServletResponse response) {
        try {
            String edate_rtn;
            String sdate_rtn;
            this.neid = Integer.parseInt(request.getParameter("neid"));
            this.slotId = request.getParameter("slotid");
            this.keySdate = request.getParameter("sdate");
            this.keyeDate = request.getParameter("edate");
            this.powerType_rtn = request.getParameter("powertype");
            this.counterType = request.getParameter("counterType");
            String key = TEODULctGraphBean.getKey(String.valueOf(this.neid), this.slotId, this.keySdate, this.keyeDate, this.powerType_rtn, this.counterType);
            if (this.powerType_rtn != null && this.powerType_rtn.equalsIgnoreCase(SNR)) {
                TEODULctGraphBean_SNR snrGraphBean = new TEODULctGraphBean_SNR();
                snrGraphBean.performBussinessProcess(request, response);
                return;
            }
            if (this.powerType_rtn != null && this.powerType_rtn.equalsIgnoreCase(MSE)) {
                TEODULctGraphBean_MSE mseGraphBean = new TEODULctGraphBean_MSE();
                mseGraphBean.performBussinessProcess(request, response);
                return;
            }
            TELctDrawing lctDrawing = new TELctDrawing();
            lctDrawing.setNeid(this.neid);
            this.timeBean = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)this.neid);
            if (request.getParameter("downFlg") != null) {
                lctDrawing.setDownFlg(true);
            }
            if (C_15M.equals(this.counterType)) {
                lctDrawing.setCuTp("count1");
                this.counterPermType = 1;
            } else if (C_24H.equals(this.counterType)) {
                lctDrawing.setCuTp("count2");
                this.counterPermType = 2;
            }
            if (this.powerType_rtn != null) {
                if (this.powerType_rtn.equals(RS)) {
                    lctDrawing.setPowerType("RS");
                } else if (TS.equals(this.powerType_rtn)) {
                    lctDrawing.setPowerType("TX");
                }
            }
            int imgX_rtn = Integer.parseInt(request.getParameter("imgX").trim());
            int imgY_rtn = Integer.parseInt(request.getParameter("imgY").trim());
            lctDrawing.setImgX(imgX_rtn);
            lctDrawing.setImgY(imgY_rtn);
            if ("".equals(request.getParameter("sdate").trim()) || "".equals(request.getParameter("edate").trim())) {
                sdate_rtn = null;
                edate_rtn = null;
            } else {
                sdate_rtn = request.getParameter("sdate").trim().substring(0, 16);
                edate_rtn = request.getParameter("edate").trim().substring(0, 16);
                this.startD_rtn = TEDateUtils.strToCalendar((String)sdate_rtn, (String)"yyyy-MM-dd HH:mm");
                this.endD_rtn = TEDateUtils.strToCalendar((String)edate_rtn, (String)"yyyy-MM-dd HH:mm");
                lctDrawing.setDataList(this.geDataFromBinFile(key));
            }
            lctDrawing.setSdate(sdate_rtn);
            lctDrawing.setEdate(edate_rtn);
            BufferedImage spectWaveimage = lctDrawing.createImg();
            response.setContentType("image/jpeg");
            response.setHeader("Expires", "0");
            response.setHeader("Pragma", "public");
            response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
            response.setHeader("Cache-Control", "public");
            if (request.getParameter("downFlg") != null) {
                response.setHeader("Content-disposition", "attachment;filename=ODUGraph.jpg");
            }
            ServletOutputStream out = response.getOutputStream();
            ImageIO.write((RenderedImage)spectWaveimage, "jpg", (OutputStream)out);
            out.close();
        }
        catch (ParseException e) {
            TELogFactory.getNormalLogger().error("TEODULctGraphBean", (Throwable)e);
        }
        catch (IOException e) {
            TELogFactory.getNormalLogger().error("TEODULctGraphBean", (Throwable)e);
        }
        finally {
            try {
                response.getOutputStream().close();
            }
            catch (IOException e1) {
                TELogFactory.getNormalLogger().error("TEODULctGraphBean", (Throwable)e1);
            }
        }
    }

    private List<PwData> geDataFromBinFile(String key) throws IOException, ParseException {
        RtnEventFilter eventFilter = new RtnEventFilter();
        if (RS.equals(this.powerType_rtn)) {
            eventFilter.addFilterEventID(8606);
            eventFilter.addFilterEventID(8607);
            this.maxEventID = 8606;
            this.minEventID = 8607;
            this.eventType = "rsl";
        } else {
            eventFilter.addFilterEventID(8609);
            eventFilter.addFilterEventID(8610);
            this.maxEventID = 8609;
            this.minEventID = 8610;
            this.eventType = "tsl";
        }
        RtnObjectTypeFilter objectFilter = new RtnObjectTypeFilter();
        objectFilter.addFilterObjectType(111);
        ArrayList<PwData> list = new ArrayList<PwData>();
        List fileByteList = (List)fileSourceList.getDataNotRefresh((Object)key);
        if (fileByteList != null) {
            for (int i = 0; i < fileByteList.size(); ++i) {
                byte[] file1 = (byte[])fileByteList.get(i);
                list.addAll(this.processOneFiledata(eventFilter, objectFilter, file1));
            }
        }
        return list;
    }

    private List<PwData> processOneFiledata(RtnEventFilter eventFilter, RtnObjectTypeFilter objectFilter, byte[] filedata) {
        ArrayList<PwData> list = new ArrayList<PwData>();
        RtnHistoryData dataPara = RtnHistoryData.buildRtnHistoryData(filedata, eventFilter, objectFilter);
        if (null == dataPara || dataPara.getHead().getPeriodType() != this.counterPermType) {
            return list;
        }
        List<PeriodHistoryData> body = dataPara.getBody();
        for (int j = 0; j < body.size(); ++j) {
            Calendar eventDate;
            if (body.get(j) == null || (eventDate = this.getNMTimeFromEventData(this.startD_rtn, this.endD_rtn, body.get(j).getStartTime())) == null) continue;
            for (int hisPos = 0; hisPos < body.get(j).getHistoryDataPara().size(); ++hisPos) {
                HistoryDataParaInterface hisPara = body.get(j).getHistoryDataPara().get(hisPos);
                if (hisPara == null || !(hisPara instanceof QxHistoryDataPara) || !objectFilter.getSupportObjectType().contains(((QxHistoryDataPara)hisPara).getObjectType())) continue;
                Map objectInfo = TEODULctGraphBean.parseOduPortObj(((QxHistoryDataPara)hisPara).getPara());
                TELogFactory.getNormalLogger().debug("RTN dat slotID=" + objectInfo.get("slotid").toString());
                TELogFactory.getNormalLogger().debug("Input slotID=" + this.slotId);
                if (!objectInfo.get("slotid").toString().equals(this.slotId)) continue;
                PwData data = new PwData();
                data.setDate(eventDate.getTime());
                HistoryEvent hisEventMax = ((QxHistoryDataPara)hisPara).getEventByID(this.maxEventID);
                HistoryEvent hisEventMin = ((QxHistoryDataPara)hisPara).getEventByID(this.minEventID);
                if (hisEventMax == null || hisEventMin == null) continue;
                data.setPwH((int)hisEventMax.getValue() / 10);
                data.setPwL((int)hisEventMin.getValue() / 10);
                data.setEvType(this.eventType);
                list.add(data);
            }
        }
        return list;
    }

    protected Calendar getNMTimeFromEventData(Calendar startD, Calendar endD, Calendar eventDate) {
        String timstr = this.timeBean.calendarToTime(eventDate);
        Calendar myCald = TEDateUtils.strToCalendar((String)(timstr = TEODULctGraphBean.convertTimeAccordingToSysStauts(timstr)), (String)"yyyy-MM-dd HH:mm");
        if (startD.compareTo(myCald) > 0 || endD.compareTo(myCald) < 0) {
            return null;
        }
        return myCald;
    }

    protected static Map parseOduPortObj(byte[] para) {
        HashMap<String, Integer> objectInfo = new HashMap<String, Integer>();
        objectInfo.put("slotid", BinfileUtil.getLongFromByteArray(para, 0, 2).intValue());
        objectInfo.put("subcardid", BinfileUtil.getLongFromByteArray(para, 2, 1).intValue());
        objectInfo.put("portid", BinfileUtil.getLongFromByteArray(para, 3, 2).intValue());
        return objectInfo;
    }

    public static TETimeBuffer<String, List<byte[]>> getFileSourceList() {
        return fileSourceList;
    }

    public static String convertTimeAccordingToSysStauts(String time) {
        SimpleDateFormat frm = new SimpleDateFormat(TimeZoneDateBean.getTimeConvertFormat());
        SimpleDateFormat frm2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String returnTimeString = time;
        try {
            Date date = frm.parse(time);
            returnTimeString = frm2.format(date);
        }
        catch (ParseException e) {
            TELogFactory.getNormalLogger().error("TEODULctGraphBean", (Throwable)e);
        }
        return returnTimeString;
    }

    public static String getKey(String neID, String slotID, String sdate, String edate, String powerType, String counterType) {
        StringBuffer result = new StringBuffer();
        result.append(neID).append(";");
        result.append(slotID).append(";");
        result.append(sdate).append(";");
        result.append(edate).append(";");
        result.append(powerType).append(";");
        result.append(counterType);
        return result.toString();
    }
}

