/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.graphanalyse.binfile;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nemgr.rtn.graphanalyse.binfile.EventFilter;
import com.huawei.nglct.nemgr.rtn.graphanalyse.binfile.HistoryDataHead;
import com.huawei.nglct.nemgr.rtn.graphanalyse.binfile.ObjectFilter;
import com.huawei.nglct.nemgr.rtn.graphanalyse.binfile.PeriodHistoryData;
import java.util.ArrayList;
import java.util.List;

public class RtnHistoryData {
    private HistoryDataHead head;
    private static EventFilter eventFilter;
    private static ObjectFilter objectFilter;
    private List<PeriodHistoryData> body;

    private RtnHistoryData() {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(50);
        sb.append("HistoryData Head:\n").append(this.head.toString());
        sb.append("\nHistoryData body:");
        for (int i = 0; i < this.body.size(); ++i) {
            sb.append(this.body.get(i).toString());
        }
        return sb.toString();
    }

    public List<PeriodHistoryData> getBody() {
        return this.body;
    }

    public void setBody(List<PeriodHistoryData> body) {
        this.body = body;
    }

    public HistoryDataHead getHead() {
        return this.head;
    }

    public void setHead(HistoryDataHead head) {
        this.head = head;
    }

    public static synchronized RtnHistoryData buildRtnHistoryData(byte[] data, EventFilter filter, ObjectFilter objectFilter) {
        eventFilter = filter;
        RtnHistoryData.objectFilter = objectFilter;
        RtnHistoryData rtnHisData = new RtnHistoryData();
        rtnHisData.head = HistoryDataHead.buildHistoryDataHead(data);
        if (null == rtnHisData.head) {
            return null;
        }
        rtnHisData.body = new ArrayList<PeriodHistoryData>();
        int pos = 0;
        for (int i = 0; i < rtnHisData.head.getPeriodNum(); ++i) {
            byte[] tempBytes = new byte[data.length - rtnHisData.head.getHeadLength() - pos];
            System.arraycopy(data, rtnHisData.head.getHeadLength() + pos, tempBytes, 0, tempBytes.length);
            PeriodHistoryData hisData = PeriodHistoryData.buildPeriodHistoryData(tempBytes, rtnHisData.getHead().getProtolFlg());
            if (hisData == null) break;
            pos += hisData.getPeriodHistoryDataLength();
            if (rtnHisData == null) continue;
            rtnHisData.body.add(hisData);
        }
        TELogFactory.getNormalLogger().info(rtnHisData.toString());
        return rtnHisData;
    }

    public static EventFilter getEventFilter() {
        return eventFilter;
    }

    public static ObjectFilter getObjectFilter() {
        return objectFilter;
    }
}

