/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.graphanalyse.binfile;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nemgr.rtn.graphanalyse.binfile.BinfileUtil;
import com.huawei.nglct.nemgr.rtn.graphanalyse.binfile.HistoryDataParaInterface;
import com.huawei.nglct.nemgr.rtn.graphanalyse.binfile.HistoryEvent;
import com.huawei.nglct.util.io.IOStreamConvertor;
import java.util.ArrayList;
import java.util.List;

public class QxHistoryDataPara
implements HistoryDataParaInterface {
    private byte respara;
    private int objectType;
    private int paraLength;
    private byte[] para;
    private int eventNum;
    List<HistoryEvent> event;
    private static final int FAILED = -1;
    private static final int SUCCESS = 0;
    private static final int HISTORY_EVENT_LENGTH = 11;
    private static final int RES_PARA_LENGTH = 1;
    private static final int OBJ_TYPE_LENGTH = 2;
    private static final int PARALENGTH_FIELD_LENGTH = 2;
    private static final int EVENT_NUM_FIELD_LENGTH = 2;

    @Override
    public int buildHistoryDataPara(byte[] bytes) {
        byte[] newLocalCopyBytes = bytes;
        this.respara = newLocalCopyBytes[0];
        this.objectType = (int)BinfileUtil.getLongFromByteArray(newLocalCopyBytes, 1, 2).longValue();
        this.paraLength = (int)BinfileUtil.getLongFromByteArray(newLocalCopyBytes, 3, 2).longValue();
        String byeStr = IOStreamConvertor.getStringFromByteArray((byte[])newLocalCopyBytes);
        if (newLocalCopyBytes.length < 5 + this.paraLength) {
            TELogFactory.getNormalLogger().error("Parse QxHistoryDataPara failed:\n" + byeStr);
            return -1;
        }
        this.para = new byte[this.paraLength];
        System.arraycopy(newLocalCopyBytes, 5, this.para, 0, this.paraLength);
        this.eventNum = (int)BinfileUtil.getLongFromByteArray(newLocalCopyBytes, 5 + this.paraLength, 2).longValue();
        if (newLocalCopyBytes.length < 7 + this.paraLength + this.eventNum * 11) {
            TELogFactory.getNormalLogger().error("Parse QxHistoryDataPara failed:\n" + byeStr);
            return -1;
        }
        this.event = new ArrayList<HistoryEvent>();
        for (int i = 0; i < this.eventNum; ++i) {
            byte[] tempBytes = new byte[11];
            System.arraycopy(newLocalCopyBytes, 7 + this.paraLength + i * 11, tempBytes, 0, 11);
            HistoryEvent hevent = HistoryEvent.buildHistoryEvent(tempBytes);
            if (hevent == null) continue;
            this.event.add(hevent);
        }
        return 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("respara=").append(this.respara);
        sb.append("\nobjectType=").append(this.objectType);
        sb.append("\nparaLength=").append(this.paraLength);
        sb.append("\npara=[").append(BinfileUtil.getStringFromByteArray(this.para)).append("]\neventNum=");
        sb.append(this.eventNum);
        for (int i = 0; i < this.event.size(); ++i) {
            sb.append("\nHistoryEvent=[");
            sb.append(this.event.get(i).toString()).append(']');
        }
        return sb.toString();
    }

    public List<HistoryEvent> getEvent() {
        return this.event;
    }

    public HistoryEvent getEventByID(int eventID) {
        for (int i = 0; i < this.event.size(); ++i) {
            if (this.event.get((int)i).eventID != eventID) continue;
            return this.event.get(i);
        }
        return null;
    }

    public int getObjectType() {
        return this.objectType;
    }

    public byte[] getPara() {
        return (byte[])this.para.clone();
    }

    public byte getRespara() {
        return this.respara;
    }

    public int getParaLength() {
        return this.paraLength;
    }

    public int getEventNum() {
        return this.eventNum;
    }

    @Override
    public int getHistoryDataByteLength() {
        return this.eventNum * 11 + 1 + 2 + 2 + 2 + this.paraLength;
    }
}

