/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.graphanalyse.binfile;

import com.huawei.nglct.nemgr.rtn.graphanalyse.binfile.BinfileUtil;
import com.huawei.nglct.nemgr.rtn.graphanalyse.binfile.HistoryDataParaInterface;
import com.huawei.nglct.nemgr.rtn.graphanalyse.binfile.QxHistoryDataPara;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class PeriodHistoryData {
    Calendar startTime;
    int length;
    private List<HistoryDataParaInterface> historyDataPara = new ArrayList<HistoryDataParaInterface>();
    private static final int TL1_PROTOL = 1;
    private static final int QX_PROTOL = 2;

    public int getPeriodHistoryDataLength() {
        return this.length + 10;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(200);
        sb.append("\n==================History Data start==================");
        sb.append("\nstartTime:").append(this.startTime.getTime().toString());
        sb.append("\nlength:").append(this.length);
        if (this.historyDataPara != null) {
            for (int i = 0; i < this.historyDataPara.size(); ++i) {
                sb.append("\n").append(this.historyDataPara.get(i).toString());
            }
        }
        sb.append("\n==================History Data end==================");
        return sb.toString();
    }

    public List<HistoryDataParaInterface> getHistoryDataPara() {
        return this.historyDataPara;
    }

    public void addHistoryDataPara(HistoryDataParaInterface hisDataPara) {
        this.historyDataPara.add(hisDataPara);
    }

    public static PeriodHistoryData buildPeriodHistoryData(byte[] bytes, byte protolType) {
        PeriodHistoryData periodData = new PeriodHistoryData();
        periodData.startTime = Calendar.getInstance();
        periodData.startTime.set(bytes[0] + 1990, bytes[1] - 1, bytes[2], bytes[3], bytes[4], bytes[5]);
        periodData.length = (int)BinfileUtil.getLongFromByteArray(bytes, 6, 4).longValue();
        if (bytes.length < periodData.length + 10) {
            return null;
        }
        byte[] tempBytes = new byte[periodData.length];
        QxHistoryDataPara hisData = null;
        int buildResult = 0;
        for (int hasBuildLength = 0; hasBuildLength < periodData.length; hasBuildLength += hisData.getHistoryDataByteLength()) {
            System.arraycopy(bytes, 10 + hasBuildLength, tempBytes, 0, periodData.length - hasBuildLength);
            switch (protolType) {
                case 2: {
                    hisData = new QxHistoryDataPara();
                    buildResult = hisData.buildHistoryDataPara(tempBytes);
                    break;
                }
                case 1: {
                    break;
                }
            }
            if (hisData != null && buildResult == 0) {
                periodData.addHistoryDataPara(hisData);
                continue;
            }
            return null;
        }
        return periodData;
    }

    public Calendar getStartTime() {
        return this.startTime;
    }
}

