/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.graphanalyse.binfile;

import com.huawei.nglct.nemgr.rtn.graphanalyse.binfile.BinfileUtil;

public class HistoryDataHead {
    private int checkSum;
    private byte protolFlg;
    private byte version;
    private byte periodType;
    private int periodNum;
    private int historyDataLength;

    public int getHeadLength() {
        return 32;
    }

    private HistoryDataHead() {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("checkSum:").append(this.checkSum);
        sb.append("\nprotolFlg:").append(this.protolFlg);
        sb.append("\nversion:").append(this.version);
        sb.append("\nperiodType:").append(this.periodType);
        sb.append("\nperiodNum:").append(this.periodNum);
        sb.append("\nhistoryDataLength:").append(this.historyDataLength);
        return sb.toString();
    }

    public static HistoryDataHead buildHistoryDataHead(byte[] bytes) {
        HistoryDataHead head = new HistoryDataHead();
        Long check = BinfileUtil.getLongFromByteArray(bytes, 0, 4);
        if (null == check) {
            return null;
        }
        head.checkSum = check.intValue();
        head.protolFlg = bytes[4];
        head.version = bytes[5];
        head.periodType = bytes[6];
        head.periodNum = BinfileUtil.getLongFromByteArray(bytes, 26, 2).intValue();
        head.historyDataLength = BinfileUtil.getLongFromByteArray(bytes, 28, 4).intValue();
        return head;
    }

    public int getCheckSum() {
        return this.checkSum;
    }

    public void setCheckSum(int checkSum) {
        this.checkSum = checkSum;
    }

    public byte getProtolFlg() {
        return this.protolFlg;
    }

    public void setProtolFlg(byte protolFlg) {
        this.protolFlg = protolFlg;
    }

    public byte getVersion() {
        return this.version;
    }

    public void setVersion(byte version) {
        this.version = version;
    }

    public byte getPeriodType() {
        return this.periodType;
    }

    public void setPeriodType(byte periodType) {
        this.periodType = periodType;
    }

    public int getPeriodNum() {
        return this.periodNum;
    }

    public void setPeriodNum(int periodNum) {
        this.periodNum = periodNum;
    }

    public int getHistoryDataLength() {
        return this.historyDataLength;
    }

    public void setHistoryDataLength(int historyDataLength) {
        this.historyDataLength = historyDataLength;
    }
}

