/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.graphanalyse.binfile;

import com.huawei.nglct.cbb.log.TELogFactory;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.zip.GZIPInputStream;

public class BinfileUtil {
    public static final String DATA_SEPARATOR = " ";
    public static final String BLANK_DATA = "  ";
    public static final String DASH_LINE = " ---  ";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final int BUFFER_SIZE_3K = 30000;
    public static final int BUFFER_SIZE_500 = 500;
    public static final int LONG_BYTE_SIZE = 8;

    private BinfileUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getByteFromFile(String fileName) {
        ByteBuffer allData = ByteBuffer.allocate(30000);
        BufferedInputStream bufferIS = null;
        FileInputStream fileIS = null;
        GZIPInputStream dataIS = null;
        try {
            fileIS = new FileInputStream(fileName);
            dataIS = new GZIPInputStream(fileIS);
            bufferIS = new BufferedInputStream(dataIS);
            byte[] buffer = new byte[500];
            while (bufferIS.read(buffer) != -1) {
                if (allData.remaining() < 500) {
                    ByteBuffer temp = ByteBuffer.allocate(allData.capacity() + buffer.length);
                    temp.put(allData);
                    allData = temp;
                }
                allData.put(buffer);
            }
        }
        catch (IOException e1) {
            try {
                TELogFactory.getNormalLogger().error(e1.getMessage());
            }
            catch (Throwable throwable) {
                BinfileUtil.safeCloseInputStream(bufferIS);
                BinfileUtil.safeCloseInputStream(dataIS);
                BinfileUtil.safeCloseInputStream(fileIS);
                throw throwable;
            }
            BinfileUtil.safeCloseInputStream(bufferIS);
            BinfileUtil.safeCloseInputStream(dataIS);
            BinfileUtil.safeCloseInputStream(fileIS);
        }
        BinfileUtil.safeCloseInputStream(bufferIS);
        BinfileUtil.safeCloseInputStream(dataIS);
        BinfileUtil.safeCloseInputStream(fileIS);
        byte[] bytes = new byte[allData.position() + 1];
        byte[] allDatabytes = allData.array();
        System.arraycopy(allDatabytes, 0, bytes, 0, bytes.length);
        return bytes;
    }

    private static void safeCloseInputStream(InputStream fileStream) {
        if (fileStream != null) {
            try {
                fileStream.close();
            }
            catch (IOException ex) {
                TELogFactory.getNormalLogger().info("close file stream failed!", (Throwable)ex);
            }
        }
    }

    public static Long getLongFromByteArray(byte[] bytes, int startPos, int length) {
        if (length <= 8 && length <= bytes.length - startPos) {
            if (bytes[startPos] >= 0) {
                int temp = 0;
                for (int i = startPos; i < startPos + length; ++i) {
                    temp = (temp << 8) + (bytes[i] & 0xFF);
                }
                return temp;
            }
            return BinfileUtil.getPatchCode(bytes, startPos, length);
        }
        TELogFactory.getNormalLogger().error("NE Data Error! Data:" + new String(bytes));
        return null;
    }

    public static final String getStringFromByteArray(byte[] data) {
        StringBuffer sb = new StringBuffer();
        int counter = 0;
        for (int i = 0; i < data.length; ++i) {
            int temp = data[i] >= 0 ? data[i] : data[i] + 256;
            String t = Integer.toString(temp, 16);
            if (t.length() < 2) {
                t = "0" + t;
            }
            sb.append(t).append(DATA_SEPARATOR);
            if ((counter + 1) % 32 == 0) {
                sb.append(LINE_SEPARATOR);
                counter = 0;
                continue;
            }
            ++counter;
        }
        return sb.toString();
    }

    public static Long getPatchCode(byte[] bytes, int startPos, int length) {
        int temp = 0;
        for (int i = startPos; i < startPos + length; ++i) {
            temp = (temp << 8) + (~bytes[i] & 0xFF);
        }
        return -1 * (temp + 1);
    }

    public static Long getLongFromByteArray(byte[] bytes) {
        return BinfileUtil.getLongFromByteArray(bytes, 0, bytes.length);
    }
}

