/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.graphanalyse;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.gencfg.TimeZoneDateBean;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.rtn.graphanalyse.TEODULctGraphBean;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.hfcpfiledata.TEHFCPFileAdapter;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class TEODULctGraphPreBean
extends TENEExplorerBean {
    private Calendar startD;
    private Calendar endD;
    private String slotId;
    private String powerType;
    private String keyNeID = "";
    private String keySoltID = "";
    private String keySdate = "";
    private String keyeDate = "";
    private String keyPowerType = "";
    private String keyeCounterType = "";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        RowParams rowParams = inputData.getBussinessParams().getRowParams()[0];
        this.keyNeID = this.getParamValue(rowParams, "neid");
        this.keySoltID = this.getParamValue(rowParams, "slotid");
        this.keySdate = this.getParamValue(rowParams, "sdate");
        this.keyeDate = this.getParamValue(rowParams, "edate");
        this.keyPowerType = this.getParamValue(rowParams, "powertype");
        this.keyeCounterType = this.getParamValue(rowParams, "countertype");
        Param sdate = rowParams.getParam("sdate");
        Param edate = rowParams.getParam("edate");
        this.powerType = rowParams.getParam("powertype").getValue();
        this.slotId = rowParams.getParam("slotid").getValue();
        this.startD = TEDateUtils.strToCalendar((String)sdate.getValue());
        this.endD = TEDateUtils.strToCalendar((String)edate.getValue());
        TimeZoneDateBean timeBean = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neid);
        sdate.setValue(timeBean.strToUTC(sdate.getValue()));
        edate.setValue(timeBean.strToUTC(edate.getValue()));
        this.TIME_OUT = 30;
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        String key = TEODULctGraphBean.getKey(this.keyNeID, this.keySoltID, this.keySdate, this.keyeDate, this.keyPowerType, this.keyeCounterType);
        Object[] fileName = this.getFileNames(operationList, "fileNameList");
        super.handleMessage(neid, operationList, subfunc, filterErrorCodeList);
        if (this.outputData.getErrorMessage().getErrorcode().equals(String.valueOf(0))) {
            ArrayList<byte[]> files = new ArrayList<byte[]>();
            files.clear();
            int len = fileName.length;
            for (int i = 0; i < len; ++i) {
                String fileStr = (String)fileName[i];
                byte[] tmpB = TEHFCPFileAdapter.getFile((String)fileStr.substring(0, fileStr.lastIndexOf(47)), null, (String)fileStr.substring(fileStr.lastIndexOf(47) + 1).toUpperCase(), (int)TENEListMgr.getInstance().getNE(neid).getRealNEID());
                if (tmpB == null) continue;
                tmpB = com.huawei.nglct.nemgr.rtn.graphanalyse.binfile.TEODULctGraphPreBean.distillFromZipFile(tmpB);
                files.add(tmpB);
            }
            if (files.size() == 0 || !this.isHasLegalData(files)) {
                this.reHandleMsg();
            } else {
                TEODULctGraphBean.getFileSourceList().put((Object)key, files);
            }
        } else {
            RowParams rowParam = this.outputData.getBussinessParams().getRowParams(0);
            if (rowParam.getRowErrorsCount() == 0) {
                rowParam = this.outputData.getBussinessParams().getRowParams(1);
            }
            Param sdate = rowParam.getRowErrors(rowParam.getRowErrorsCount() - 1).getParam("sdate");
            Param edate = rowParam.getRowErrors(rowParam.getRowErrorsCount() - 1).getParam("edate");
            if (sdate != null && !sdate.getValue().equals("")) {
                TimeZoneDateBean timeBean = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neid);
                sdate.setValue(timeBean.UTCToTime(sdate.getValue()));
                edate.setValue(timeBean.UTCToTime(edate.getValue()));
            }
        }
    }

    private Object[] getFileNames(List<Operation> operationList, String name) {
        Part part = null;
        Object[] fileNameArr = new String[]{};
        ArrayList files = new ArrayList();
        int operLen = operationList.size();
        block0: for (int i = 0; i < operLen; ++i) {
            Operation oper = operationList.get(i);
            int outLen = oper.getOutputCount();
            for (int j = 0; j < outLen; ++j) {
                Output outPut = oper.getOutput(j);
                Part tmp = outPut.getPart(name);
                if (tmp == null || tmp.getValue() == null) continue;
                part = tmp;
                int fileNums = Integer.parseInt(outPut.getPart("filenum").getValue());
                com.huawei.nglct.nemgr.rtn.graphanalyse.binfile.TEODULctGraphPreBean.addFile(files, part, fileNums);
                continue block0;
            }
        }
        if (files.size() > 0) {
            fileNameArr = files.toArray();
        }
        return fileNameArr;
    }

    private boolean isHasLegalData(List files) {
        String min;
        String max;
        boolean flg = false;
        if ("rs".equals(this.powerType)) {
            max = "rsl_max";
            min = "rsl_min";
        } else {
            max = "tsl_max";
            min = "tsl_min";
        }
        try {
            if (files.isEmpty()) {
                return false;
            }
            Iterator iter = files.iterator();
            while (iter.hasNext()) {
                String line;
                byte[] file = (byte[])iter.next();
                BufferedReader reader = new BufferedReader(new CharArrayReader(new String(file).toCharArray()));
                while ((line = reader.readLine()) != null) {
                    String cellSlotId;
                    String[] board;
                    String celTime;
                    String cellEid;
                    String[] cells;
                    if ("".equals(line.trim()) || line.toLowerCase(Locale.US).indexOf("start") != -1) continue;
                    if (line.indexOf("\"") > -1) {
                        cells = line.split("\",");
                        cellEid = cells[1].split(",")[0];
                        celTime = cells[0].split(",")[1].trim();
                        board = line.split("\"")[1].split(",");
                        cellSlotId = board[0].substring(board[0].indexOf("=") + 1);
                    } else {
                        cells = line.split(",");
                        cellEid = cells[3];
                        celTime = cells[1].trim();
                        board = line.split("board=");
                        cellSlotId = board[1].split(",")[0];
                    }
                    if (!cellSlotId.equals(this.slotId) || !max.equalsIgnoreCase(cellEid) && !min.equalsIgnoreCase(cellEid)) continue;
                    TimeZoneDateBean timeBean = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)this.neid);
                    Calendar myCald = TEDateUtils.strToCalendar((String)celTime, (String)"yyyy-MM-dd HH:mm");
                    String timstr = timeBean.calendarToTime(myCald);
                    myCald = TEDateUtils.strToCalendar((String)(timstr = TEODULctGraphBean.convertTimeAccordingToSysStauts(timstr)), (String)"yyyy-MM-dd HH:mm");
                    if (this.startD.compareTo(myCald) >= 0 || this.endD.compareTo(myCald) <= 0) continue;
                    flg = true;
                    break;
                }
                reader.close();
                if (!flg) {
                    iter.remove();
                    continue;
                }
                return true;
            }
        }
        catch (IOException e) {
            TELogFactory.getNormalLogger().error("InputStream red Fault:\n", (Throwable)e);
            return false;
        }
        return false;
    }

    private void reHandleMsg() {
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
        BussinessParams bus = new BussinessParams();
        RowParams rowparam = new RowParams();
        RowErrors rowError = new RowErrors();
        ErrorMessage errorMessage = new ErrorMessage();
        errorMessage.setErrorcode("38410");
        errorMessage.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot((int)Integer.valueOf("38410")));
        Param par = new Param();
        par.setName("nename");
        par.setValue(TENEListMgr.getInstance().getNE(this.neid).getNEName());
        rowError.setErrorMessage(errorMessage);
        rowError.addParam(par);
        rowparam.addRowErrors(rowError);
        bus.addRowParams(rowparam);
        this.outputData.setBussinessParams(bus);
    }

    private String getParamValue(RowParams rowParams, String paramName) {
        Param parm = rowParams.getParam(paramName);
        if (parm != null) {
            return parm.getValue();
        }
        return "";
    }
}

