/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.graphanalyse;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TESpecialAppInterface;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.gencfg.TimeZoneDateBean;
import com.huawei.nglct.nemgr.rtn.graphanalyse.PwData;
import com.huawei.nglct.nemgr.rtn.graphanalyse.TELctDrawing;
import com.huawei.nglct.util.buffer.TETimeBuffer;
import com.huawei.nglct.util.datetime.TEDateUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TEODULctGraphBean
implements TESpecialAppInterface {
    private int neid;
    private String slotId;
    private String keySdate = "";
    private String keyeDate = "";
    private String powerType = "";
    private String counterType = "";
    private Calendar startD;
    private Calendar endD;
    private static final String C_15M = "1";
    private static final String C_24H = "2";
    private static final String RS = "rs";
    private static final String TS = "ts";
    protected static TETimeBuffer<String, List<byte[]>> fileSourceList = new TETimeBuffer(50);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performBussinessProcess(HttpServletRequest request, HttpServletResponse response) {
        try {
            String edate;
            String sdate;
            this.neid = Integer.parseInt(request.getParameter("neid"));
            this.slotId = request.getParameter("slotid");
            this.keySdate = request.getParameter("sdate");
            this.keyeDate = request.getParameter("edate");
            this.powerType = request.getParameter("powertype");
            this.counterType = request.getParameter("counterType");
            String key = TEODULctGraphBean.getKey(String.valueOf(this.neid), this.slotId, this.keySdate, this.keyeDate, this.powerType, this.counterType);
            TELctDrawing lctDrawing = new TELctDrawing();
            lctDrawing.setNeid(this.neid);
            if (request.getParameter("downFlg") != null) {
                lctDrawing.setDownFlg(true);
                String counterType = request.getParameter("counterType");
                if (C_15M.equals(counterType)) {
                    lctDrawing.setCuTp("count1");
                } else if (C_24H.equals(counterType)) {
                    lctDrawing.setCuTp("count2");
                }
                if (this.powerType.equals(RS)) {
                    lctDrawing.setPowerType("RS");
                } else if (TS.equals(this.powerType)) {
                    lctDrawing.setPowerType("TX");
                }
            }
            int imgX = Integer.parseInt(request.getParameter("imgX").trim());
            int imgY = Integer.parseInt(request.getParameter("imgY").trim());
            lctDrawing.setImgX(imgX);
            lctDrawing.setImgY(imgY);
            if ("".equals(request.getParameter("sdate").trim()) || "".equals(request.getParameter("edate").trim())) {
                sdate = null;
                edate = null;
            } else {
                sdate = request.getParameter("sdate").trim().substring(0, 16);
                edate = request.getParameter("edate").trim().substring(0, 16);
                this.startD = TEDateUtils.strToCalendar((String)sdate, (String)"yyyy-MM-dd HH:mm");
                this.endD = TEDateUtils.strToCalendar((String)edate, (String)"yyyy-MM-dd HH:mm");
                lctDrawing.setDataList(this.geDataFromFile(key));
            }
            lctDrawing.setSdate(sdate);
            lctDrawing.setEdate(edate);
            BufferedImage spectWaveimage = lctDrawing.createImg();
            response.setContentType("image/jpeg");
            response.setHeader("Expires", "0");
            response.setHeader("Pragma", "public");
            response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
            response.setHeader("Cache-Control", "public");
            if (request.getParameter("downFlg") != null) {
                response.setHeader("Content-disposition", "attachment;filename=ODUGraph.jpg");
            }
            ServletOutputStream out = response.getOutputStream();
            ImageIO.write((RenderedImage)spectWaveimage, "jpg", (OutputStream)out);
            out.close();
        }
        catch (IOException e) {
            TELogFactory.getNormalLogger().error("TEODULctGraphBean", (Throwable)e);
        }
        catch (ParseException e) {
            TELogFactory.getNormalLogger().error("TEODULctGraphBean", (Throwable)e);
        }
        finally {
            try {
                response.getOutputStream().close();
            }
            catch (IOException e1) {
                TELogFactory.getNormalLogger().error("TEODULctGraphBean", (Throwable)e1);
            }
        }
    }

    private List<PwData> geDataFromFile(String mapKey) throws IOException, ParseException {
        String min;
        String max;
        HashMap<String, PwData> tmpMap = new HashMap<String, PwData>();
        SimpleDateFormat frm = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        TimeZoneDateBean timeBean = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)this.neid);
        if (RS.equals(this.powerType)) {
            max = "rsl_max";
            min = "rsl_min";
        } else {
            max = "tsl_max";
            min = "tsl_min";
        }
        List fileByteList = (List)fileSourceList.getDataNotRefresh((Object)mapKey);
        for (int i = 0; fileByteList != null && i < fileByteList.size(); ++i) {
            String line;
            byte[] file1 = (byte[])fileByteList.get(i);
            BufferedReader reader = new BufferedReader(new CharArrayReader(new String(file1).toCharArray()));
            while ((line = reader.readLine()) != null) {
                String cellSlotId;
                String[] board;
                int celPw;
                String celTime;
                String cellEid;
                String[] cells;
                if ("".equals(line.trim()) || line.toLowerCase(Locale.US).indexOf("start") != -1) continue;
                if (line.indexOf("\"") > -1) {
                    cells = line.split("\",");
                    cellEid = cells[1].split(",")[0];
                    celTime = cells[0].split(",")[1].trim();
                    celPw = Integer.parseInt(cells[1].split(",")[1]);
                    board = line.split("\"")[1].split(",");
                    cellSlotId = board[0].substring(board[0].indexOf("=") + 1);
                } else {
                    cells = line.split(",");
                    cellEid = cells[3];
                    celTime = cells[1].trim();
                    celPw = Integer.parseInt(cells[4].trim());
                    board = line.split("board=");
                    cellSlotId = board[1].split(",")[0];
                }
                celPw /= 10;
                if (!cellSlotId.equals(this.slotId) || !max.equalsIgnoreCase(cellEid) && !min.equalsIgnoreCase(cellEid)) continue;
                Calendar myCald = TEDateUtils.strToCalendar((String)celTime, (String)"yyyy-MM-dd HH:mm");
                String timstr = timeBean.calendarToTime(myCald);
                myCald = TEDateUtils.strToCalendar((String)(timstr = TEODULctGraphBean.convertTimeAccordingToSysStauts(timstr)), (String)"yyyy-MM-dd HH:mm");
                if (this.startD.compareTo(myCald) > 0 || this.endD.compareTo(myCald) < 0) continue;
                String key = cellEid.split("_")[0] + "_" + celTime.split(":")[0] + ":" + celTime.split(":")[1];
                if (tmpMap.containsKey(key)) {
                    ((PwData)tmpMap.get(key)).setValue(celPw);
                    continue;
                }
                PwData data = new PwData();
                data.setDate(frm.parse(timstr));
                frm.format(data.getDate());
                data.setValue(celPw);
                data.setEvType(cellEid.split("_")[0]);
                tmpMap.put(key, data);
            }
            reader.close();
        }
        ArrayList<PwData> list = new ArrayList<PwData>(tmpMap.values());
        Collections.sort(list, new PwData());
        return list;
    }

    public static TETimeBuffer<String, List<byte[]>> getFileSourceList() {
        return fileSourceList;
    }

    public static String convertTimeAccordingToSysStauts(String time) {
        SimpleDateFormat frm = new SimpleDateFormat(TimeZoneDateBean.getTimeConvertFormat());
        SimpleDateFormat frm2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String returnTimeString = time;
        try {
            Date date = frm.parse(time);
            returnTimeString = frm2.format(date);
        }
        catch (ParseException e) {
            TELogFactory.getNormalLogger().error(e.getMessage());
        }
        return returnTimeString;
    }

    public static String getKey(String neID, String slotID, String sdate, String edate, String powerType, String counterType) {
        StringBuffer result = new StringBuffer();
        result.append(neID).append(";");
        result.append(slotID).append(";");
        result.append(sdate).append(";");
        result.append(edate).append(";");
        result.append(powerType).append(";");
        result.append(counterType);
        return result.toString();
    }
}

