/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.graphanalyse;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nemgr.rtn.graphanalyse.PwData;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TELctDrawing {
    public static String TX = "TX";
    public static String RX = "RX";
    public static String Legend = "Legend";
    public static String TxMin = "TxMin";
    public static String RxMin = "RxMin";
    public static String TxMax = "TxMax";
    public static String RxMax = "RxMax";
    public static String Unit = "Unit";
    public static String SNRMAX = "SNRMAX";
    public static String SNRMIN = "SNRMIN";
    public static String SNRAVG = "SNRAVG";
    public static String SNRCUR = "SNRCUR";
    private int imgW;
    private int imgH;
    protected String cuTp = "count1";
    private String sdate;
    private String edate;
    protected int topX = 0;
    protected int topY = 10;
    protected int scaleY;
    protected int startY;
    protected int scaleX;
    protected int startX;
    protected long scaleTime;
    private int scalePower = 5;
    private String powerType = "RS";
    protected List dataList = new ArrayList();
    private SimpleDateFormat normalFrm = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private DateFormat frm2 = new SimpleDateFormat("MM/dd HH:mm");
    protected boolean downFlg = false;
    protected int neid;
    protected static final String RS = "rtn" + File.separator + "res" + File.separator + "graphanalyse" + File.separator + "odugraphres_" + TESysManagerBean.getInstance().getlanguage() + ".ini";

    public void setNeid(int neid) {
        this.neid = neid;
    }

    public void setDownFlg(boolean downFlg) {
        this.downFlg = downFlg;
    }

    public BufferedImage createImg() {
        BufferedImage img = new BufferedImage(this.imgW, this.imgH, 1);
        Graphics2D paintBrush = (Graphics2D)img.getGraphics();
        this.paintFixedEelement(paintBrush);
        if (this.sdate != null || this.edate != null) {
            this.paintTrendLine(paintBrush);
        }
        return img;
    }

    private void paintFixedEelement(Graphics2D paintBrush) {
        try {
            this.initres(this.neid);
            FontMetrics fontmetri = paintBrush.getFontMetrics();
            this.computeScale();
            paintBrush.setColor(new Color(239, 239, 239));
            paintBrush.fillRect(0, 0, this.imgW, this.imgH);
            paintBrush.setColor(Color.black);
            paintBrush.fillRect(this.startX + 5, this.startY, 2, this.scaleY * 26);
            paintBrush.setColor(Color.gray);
            int tempX = this.startX + this.scaleX + 5;
            for (int i = 0; i < 10; ++i) {
                paintBrush.drawLine(tempX, this.startY, tempX, this.startY + this.scaleY * 26);
                tempX += this.scaleX;
            }
            tempX = this.drawYScale(paintBrush);
            paintBrush.setColor(Color.black);
            paintBrush.setFont(new Font("Serif", 1, 13));
            this.drawUpText(paintBrush, fontmetri);
            this.drawYTextScale(paintBrush, tempX);
            if (this.sdate != null) {
                long tmpDateTime = this.normalFrm.parse(this.sdate).getTime();
                paintBrush.drawString(this.frm2.format(new Date(tmpDateTime)), this.startX - 10, this.startY + this.scaleY * 26 + 15);
                for (int i = 1; i < 10; ++i) {
                    paintBrush.drawString(this.frm2.format(new Date(tmpDateTime += this.scaleTime)), this.startX + this.scaleX * i - 10, this.startY + this.scaleY * 26 + 15);
                }
            }
            this.drawLegendColorLine(paintBrush);
        }
        catch (ParseException e) {
            TELogFactory.getNormalLogger().error("TELctDrawing.paintFixedEelement() fail!", (Throwable)e);
        }
    }

    protected void drawYTextScale(Graphics2D paintBrush, int tempX) {
        paintBrush.setColor(Color.black);
        int tempY = this.startY + 5;
        for (int temp = 30; temp >= -100; temp -= 10) {
            if (temp == 0) {
                tempX = this.topX + 13;
            }
            if (temp > 0) {
                tempX = this.topX + 8;
            }
            if (temp < 0) {
                tempX = this.topX + 5;
            }
            if (temp == -100) {
                tempX = this.topX + 3;
                tempY -= 2;
            }
            paintBrush.drawString(String.valueOf(temp), tempX, tempY);
            tempY += this.scaleY * 2;
        }
    }

    protected int drawYScale(Graphics2D paintBrush) {
        int tempX = this.startX + 5;
        int tempY = this.startY;
        for (int i = 0; i < 27; ++i) {
            if (i % 2 == 0) {
                tempX -= 5;
            }
            paintBrush.drawLine(tempX, tempY, this.startX + 5 + this.scaleX * 10, tempY);
            if (i % 2 == 0) {
                tempX += 5;
            }
            tempY += this.scaleY;
        }
        return tempX;
    }

    protected void drawLegendColorLine(Graphics2D paintBrush) {
        if ("en".equals(TESysManagerBean.getInstance().getlanguage())) {
            paintBrush.setColor(Color.blue);
            paintBrush.fillRect(this.topX + 195, this.topY - 5, 20, 3);
            paintBrush.fillRect(this.topX + 425, this.topY - 5, 20, 3);
            paintBrush.setColor(Color.red);
            paintBrush.fillRect(this.topX + 290, this.topY - 5, 20, 3);
            paintBrush.fillRect(this.topX + 520, this.topY - 5, 20, 3);
        } else {
            paintBrush.setColor(Color.blue);
            paintBrush.fillRect(this.topX + 205, this.topY - 4, 20, 3);
            paintBrush.fillRect(this.topX + 515, this.topY - 4, 20, 3);
            paintBrush.setColor(Color.red);
            paintBrush.fillRect(this.topX + 350, this.topY - 4, 20, 3);
            paintBrush.fillRect(this.topX + 660, this.topY - 4, 20, 3);
        }
    }

    protected void drawUpText(Graphics2D paintBrush, FontMetrics fontmetri) {
        if ("en".equals(TESysManagerBean.getInstance().getlanguage())) {
            paintBrush.drawString(Legend, this.topX + 80, this.topY);
            paintBrush.drawString(RxMin, this.topX + 375, this.topY);
            paintBrush.drawString(RxMax, this.topX + 465, this.topY);
            paintBrush.drawString(TxMin, this.topX + 145, this.topY);
            paintBrush.drawString(TxMax, this.topX + 235, this.topY);
            paintBrush.drawString(Unit, this.topX + 13, this.topY + 5);
            if (this.downFlg) {
                paintBrush.setFont(new Font("Serif", 0, 13));
                paintBrush.drawString(TEGetFilePath.getResource((int)this.neid, (String)RS).getString(this.cuTp), this.topX + 730, this.topY + 3);
                paintBrush.drawString(TEGetFilePath.getResource((int)this.neid, (String)RS).getString(this.powerType), this.topX + 750 + fontmetri.stringWidth(TEGetFilePath.getResource((int)this.neid, (String)RS).getString(this.cuTp)), this.topY + 3);
                paintBrush.setFont(new Font("", 1, 13));
            }
        } else {
            paintBrush.drawString(Legend, this.topX + 60, this.topY + 2);
            paintBrush.drawString(RxMin, this.topX + 410, this.topY + 2);
            paintBrush.drawString(RxMax, this.topX + 555, this.topY + 2);
            paintBrush.drawString(TxMin, this.topX + 100, this.topY + 2);
            paintBrush.drawString(TxMax, this.topX + 245, this.topY + 2);
            paintBrush.drawString(Unit, this.topX + 13, this.topY + 5);
            if (this.downFlg) {
                paintBrush.setFont(new Font("Serif", 0, 13));
                paintBrush.drawString(TEGetFilePath.getResource((int)this.neid, (String)RS).getString(this.cuTp), this.topX + 800, this.topY + 3);
                paintBrush.drawString(TEGetFilePath.getResource((int)this.neid, (String)RS).getString(this.powerType), this.topX + 820 + fontmetri.stringWidth(TEGetFilePath.getResource((int)this.neid, (String)RS).getString(this.cuTp)), this.topY + 2);
                paintBrush.setFont(new Font("Serif", 1, 13));
            }
        }
    }

    protected void paintTrendLine(Graphics2D paintBrush) {
        int len = this.dataList.size();
        int[] Min_X = new int[len];
        int[] Min_Y = new int[len];
        int[] Max_X = new int[len];
        int[] Max_Y = new int[len];
        int index = 0;
        for (int i = 0; i < len; ++i) {
            PwData data = (PwData)this.dataList.get(i);
            int x = this.computeX(data.getDate());
            int y1 = this.computeY(data.getPwH());
            int y2 = this.computeY(data.getPwL());
            Min_X[index] = x;
            Max_X[index] = x;
            Min_Y[index] = y2;
            Max_Y[index] = y1;
            ++index;
        }
        paintBrush.setColor(Color.red);
        paintBrush.drawPolyline(Max_X, Max_Y, len);
        paintBrush.setColor(Color.blue);
        paintBrush.drawPolyline(Min_X, Min_Y, len);
    }

    private void computeScale() {
        try {
            int temp = this.imgH - 40;
            this.scaleY = temp / 26;
            this.startY = this.topY + 15;
            temp = this.imgW - 2 * this.topX - 46;
            int residue = temp % 10;
            this.scaleX = temp / 10;
            this.topX += residue / 2;
            this.startX = this.topX + 25;
            if (this.sdate != null && this.edate != null) {
                long timeLeg = this.normalFrm.parse(this.edate).getTime() - this.normalFrm.parse(this.sdate).getTime();
                this.scaleTime = timeLeg / 10L + 60000L;
            }
        }
        catch (ParseException e) {
            TELogFactory.getNormalLogger().error("TELctDrawing.computeScale() fail!", (Throwable)e);
        }
    }

    protected int computeX(Date timePoint) {
        try {
            BigDecimal scX = new BigDecimal(this.scaleX);
            BigDecimal scT = new BigDecimal(this.scaleTime);
            long timeLeg = timePoint.getTime() - this.normalFrm.parse(this.sdate).getTime();
            int num = Long.valueOf(timeLeg / this.scaleTime).intValue();
            long residue = timeLeg % this.scaleTime;
            BigDecimal a = new BigDecimal(residue);
            BigDecimal rs = a.multiply(scX).divide(scT, 0, 5);
            return this.startX + num * this.scaleX + rs.intValue();
        }
        catch (ParseException e) {
            TELogFactory.getNormalLogger().error("TELctDrawing.computeX() fail!", (Throwable)e);
            return this.startX;
        }
    }

    protected int computeY(int pw) {
        BigDecimal scY = new BigDecimal(this.scaleY);
        BigDecimal scP = new BigDecimal(this.scalePower);
        int num = pw / this.scalePower;
        int residue = pw % this.scalePower;
        BigDecimal a = new BigDecimal(residue);
        BigDecimal rs = a.multiply(scY).divide(scP, 0, 5);
        return this.startY + 6 * this.scaleY - num * this.scaleY - rs.intValue();
    }

    public void setCuTp(String cuTp) {
        this.cuTp = cuTp;
    }

    public void setEdate(String edate) {
        this.edate = edate;
    }

    public void setImgX(int imgX) {
        this.imgW = imgX;
    }

    public void setImgY(int imgY) {
        this.imgH = imgY;
    }

    public void setSdate(String sdate) {
        this.sdate = sdate;
    }

    public void setDataList(List dataList) {
        this.dataList.addAll(dataList);
    }

    protected String getResourceName(String rname) {
        return TEGetFilePath.getResource((int)this.neid, (String)RS).getString(rname);
    }

    protected void initres(int neid) {
        TX = this.getResourceName("TX");
        RX = this.getResourceName("RX");
        Legend = this.getResourceName("Legend");
        TxMin = this.getResourceName("TxMin");
        RxMin = this.getResourceName("RxMin");
        TxMax = this.getResourceName("TxMax");
        RxMax = this.getResourceName("RxMax");
        Unit = this.getResourceName("Unit");
        SNRMAX = this.getResourceName("SNRMAX");
        SNRMIN = this.getResourceName("SNRMIN");
        SNRAVG = this.getResourceName("SNRAVG");
    }

    public void setPowerType(String powerType) {
        this.powerType = powerType;
    }
}

