/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.gencfg;

import com.huawei.nglct.consts.TEInteMacroCodeConstant;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import java.math.BigInteger;
import java.util.LinkedHashSet;
import java.util.Vector;

public class TEGenCfgToolkit {
    public static int PARAMTYPE_STRING = 1;
    public static int PARAMTYPE_INTEGER = 2;
    public static int PARAMTYPE_DOUBLE = 3;

    public static String getAttributeName(int attrID) {
        String attrName = (String)TEInteMacroCodeConstant.getAttributeMap().get(attrID);
        return attrName;
    }

    public static LinkedHashSet<Integer> getIFBoardList(int neID) {
        TENE currentNE = TENEListMgr.getInstance().getNE(neID);
        TEConfigurationDataMgr instance = TEConfigurationDataMgr.getInstance();
        Vector boardList = currentNE.getClonedBoardList();
        LinkedHashSet<Integer> ifBoardList = new LinkedHashSet<Integer>();
        int len = boardList.size();
        for (int i = 0; i < len; ++i) {
            TEBoard board = (TEBoard)boardList.get(i);
            int slotId = board.getSlotID();
            int boardType = board.getBoardType();
            if (!instance.isIFboard(boardType)) continue;
            ifBoardList.add(slotId);
        }
        return ifBoardList;
    }

    public static LinkedHashSet<Integer> getIFBoardList(int neID, int tBoardType) {
        TENE currentNE = TENEListMgr.getInstance().getNE(neID);
        Vector boardList = currentNE.getClonedBoardList();
        LinkedHashSet<Integer> ifBoardList = new LinkedHashSet<Integer>();
        int len = boardList.size();
        for (int i = 0; i < len; ++i) {
            TEBoard board = (TEBoard)boardList.get(i);
            int slotId = board.getSlotID();
            int boardType = board.getBoardType();
            if (tBoardType != boardType) continue;
            ifBoardList.add(slotId);
        }
        return ifBoardList;
    }

    public static LinkedHashSet<Integer> getODUBoardList(int neID) {
        TENE currentNE = TENEListMgr.getInstance().getNE(neID);
        TEConfigurationDataMgr instance = TEConfigurationDataMgr.getInstance();
        Vector boardList = currentNE.getClonedBoardList();
        LinkedHashSet<Integer> oduBoardList = new LinkedHashSet<Integer>();
        int len = boardList.size();
        for (int i = 0; i < len; ++i) {
            TEBoard board = (TEBoard)boardList.get(i);
            int slotId = board.getSlotID();
            String boardName = instance.getBoardName(neID, slotId);
            if (!"ODU".equals(boardName)) continue;
            oduBoardList.add(slotId);
        }
        return oduBoardList;
    }

    public static String dividedByTen(String value) {
        if (null == value || "-1".equals(value)) {
            return value;
        }
        short temp = (short)new BigInteger(value).intValue();
        return String.valueOf((float)temp / 10.0f);
    }

    public static String dividedByThousand(String value) {
        if (null == value || "-1".equals(value)) {
            return value;
        }
        long temp = Long.parseLong(value);
        return String.valueOf((double)temp / 1000.0);
    }

    public static String getRangeValue(String min, String max) {
        return "[" + min + "," + max + "]";
    }

    public static String splitRangeValue(String value) {
        String[] ethBands;
        value = !TEGenCfgToolkit.isValidate(value) ? "/" : ((ethBands = value.split("-")).length == 1 ? TEGenCfgToolkit.dividedByThousand(ethBands[0]) : TEGenCfgToolkit.dividedByThousand(ethBands[0]) + "-" + TEGenCfgToolkit.dividedByThousand(ethBands[1]));
        return value;
    }

    public static String mutiplyByTen(String value) {
        if (!TEGenCfgToolkit.isValidate(value)) {
            return value;
        }
        float temp = Float.parseFloat(value);
        return String.valueOf((int)(temp * 10.0f));
    }

    public static boolean isValidate(String value) {
        boolean isvalidate = true;
        if (value == null || value.isEmpty()) {
            isvalidate = false;
            return isvalidate;
        }
        if ("-1".equals(value) || "/".equals(value)) {
            isvalidate = false;
            return isvalidate;
        }
        return isvalidate;
    }
}

