/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.gencfg;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.consts.TEInteMacroCodeConstant;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nemgr.dbmgr.TEGenCfgScriptUtil;
import com.huawei.nglct.nemgr.dbmgr.TEWebLCTDBGenCfgUtil;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenAttrObjectValue;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenObjectID;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenOperationResult;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenValue;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenValueResult;
import com.huawei.nglct.nemgr.rtn.gencfg.TEGenCfgToolkit;
import com.huawei.nglct.po.embeddednemgrmo.gencfg.TEWebLCTBoardGenCfgMOPO;
import com.huawei.nglct.util.io.IOStreamConvertor;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public class TEGenAttrToolkit {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();
    private static Set<String> attrNeedMutiplyBy10 = new HashSet<String>();
    private static final Map<String, String> cfgAttr2QxparamMap = new HashMap<String, String>();
    private static final Map<String, String> errorQxparamMap = new HashMap<String, String>();
    String[] attrNeedDevidedBy1000 = new String[]{"W32BRD_ATTR_TRANSMITFRE", "W32BRD_ATTR_TRINTERVAL", "W32BRD_ATTR_ACTTRANSMITFRE", "W32BRD_ATTR_ACTTRECEIVEFRE", "W32BRD_ATTR_ACTTRINTERVAL", "W32BRD_ATTR_TRINTERVALP"};

    public TEGenOperationResult queryAttrbutesFromDB(TEGenAttrObjectValue attr) {
        TEGenOperationResult operResult = new TEGenOperationResult();
        int neID = attr.getNEID();
        List genValueList = attr.getAttrIDList();
        TEWebLCTDBGenCfgUtil dbUtil = new TEWebLCTDBGenCfgUtil(neID);
        TEGenObjectID objectID = attr.getObjectID();
        int slotID = objectID.containSlotID() ? objectID.getSlotIDInInt() : 0;
        List<TEDaoNameValuePair> criteriaList = this.getCriteriaList(objectID);
        boolean containsError = false;
        for (TEGenValue teGenValue : genValueList) {
            int attrID = teGenValue.getAttrID();
            String attrName = TEGenCfgToolkit.getAttributeName(attrID);
            TEWebLCTBoardGenCfgMOPO mopo = dbUtil.queryAttrFromBoardDB(criteriaList, slotID, attrName);
            String attrValue = mopo == null ? null : mopo.getAttrValue();
            String finalValue = this.convertAttrValue(dbUtil, slotID, attrName, attrValue);
            TEGenValueResult genValResult = new TEGenValueResult();
            genValResult.attrID = attrID;
            genValResult.attrValue = finalValue;
            genValResult.errorCode = finalValue == null ? 1090595329 : 0;
            genValResult.errorInfo = "";
            containsError = finalValue == null ? true : containsError;
            operResult.getGenResultList().add(genValResult);
        }
        operResult.setWholeErrorCode(0);
        operResult.setErrorInfo("");
        return operResult;
    }

    private List<TEDaoNameValuePair> getCriteriaList(TEGenObjectID objectID) {
        int portID;
        ArrayList<TEDaoNameValuePair> criteriaList = new ArrayList<TEDaoNameValuePair>();
        int n = portID = objectID.containPortID() ? objectID.getPortIDInInt() : 0;
        if (objectID.containPortID()) {
            TEDaoNameValuePair valPair = new TEDaoNameValuePair();
            valPair.setName("Port");
            valPair.setValue(String.valueOf(portID));
            criteriaList.add(valPair);
        }
        return criteriaList.isEmpty() ? null : criteriaList;
    }

    protected String convertAttrValue(TEWebLCTDBGenCfgUtil dbUtil, int slotID, String attrName, String attrValue) {
        TEWebLCTBoardGenCfgMOPO mopo_low;
        if ("W32BRD_ATTR_PRODUCESN".equals(attrName)) {
            TEWebLCTBoardGenCfgMOPO mopo = dbUtil.queryAttrFromBoardDB(null, slotID, "W32BRD_ATTR_FACTORYCODE");
            String tmpFactoryCodeValue = mopo == null ? null : mopo.getAttrValue();
            attrValue = attrValue + "-" + tmpFactoryCodeValue;
        }
        if ("W32BRD_ATTR_PRODUCETIME".equals(attrName)) {
            TEWebLCTBoardGenCfgMOPO mopo_year = dbUtil.queryAttrFromBoardDB(null, slotID, "W32BRD_ATTR_ODUINFO_YEAR");
            TEWebLCTBoardGenCfgMOPO mopo_month = dbUtil.queryAttrFromBoardDB(null, slotID, "W32BRD_ATTR_ODUINFO_MONTH");
            if (mopo_year != null && mopo_month != null) {
                attrValue = mopo_year.getAttrValue() + "-" + mopo_month.getAttrValue();
            }
        }
        if ("W32BRD_ATTR_WORKRANGE".equals(attrName) && (mopo_low = dbUtil.queryAttrFromBoardDB(null, slotID, "W32BRD_ATTR_LOWFRE")) != null) {
            DecimalFormat format = new DecimalFormat("0.000");
            String finalLowVal = format.format(Double.parseDouble(TEGenCfgToolkit.dividedByThousand(mopo_low.getAttrValue())));
            String finalHighVal = format.format(Double.parseDouble(TEGenCfgToolkit.dividedByThousand(attrValue)));
            attrValue = "[" + finalLowVal + "," + finalHighVal + "]";
        }
        if ("W32BRD_ATTR_ACTRANGEOFPOWER".equals(attrName) && (mopo_low = dbUtil.queryAttrFromBoardDB(null, slotID, "W32BRD_ATTR_LOWPOWER")) != null) {
            attrValue = "[" + TEGenCfgToolkit.dividedByTen(mopo_low.getAttrValue()) + "," + TEGenCfgToolkit.dividedByTen(attrValue) + "]";
        }
        if (Arrays.asList(this.attrNeedDevidedBy1000).contains(attrName)) {
            return TEGenCfgToolkit.dividedByThousand(attrValue);
        }
        String finalValue = attrValue == null ? null : IOStreamConvertor.replaceSpecialStr((String)attrValue).trim();
        return finalValue;
    }

    public TEGenOperationResult queryAttrbutesFromNE(TEGenAttrObjectValue attr) {
        TEGenOperationResult operResult = new TEGenOperationResult();
        List genValueList = attr.getAttrIDList();
        this.fillGenValueName(genValueList);
        int neID = attr.getNEID();
        TEGenObjectID objectID = attr.getObjectID();
        int slotID = objectID.containSlotID() ? objectID.getSlotIDInInt() : 0;
        TENE neObj = TENEListMgr.getInstance().getNE(neID);
        TEBoard board = neObj.getBoard(slotID);
        if (board == null) {
            e2eLogger.info("query Attrbutes From NE failed! the board is null:" + objectID.toString());
            return operResult;
        }
        e2eLogger.info("query Attrbutes From NE, board\u00a3\u00ba" + board.getBoardTypeName());
        int boardType = board.getBoardType();
        ArrayList<TEGenValue> ifattrlist = new ArrayList<TEGenValue>();
        ArrayList<TEGenValue> oduattrlist = new ArrayList<TEGenValue>();
        this.splitGenValueList(neID, boardType, genValueList, ifattrlist, oduattrlist);
        Datainterface inputData = null;
        Datainterface outputData = null;
        if (!ifattrlist.isEmpty()) {
            inputData = TEGenCfgScriptUtil.createInputData((int)neID, (int)slotID, ifattrlist);
            outputData = TEGenCfgScriptUtil.performSubFunc((int)neID, (int)2105971, (Datainterface)inputData);
            this.parseOutputData(neID, outputData, ifattrlist, operResult);
        }
        if (!oduattrlist.isEmpty()) {
            inputData = TEGenCfgScriptUtil.createInputData((int)neID, (int)slotID, oduattrlist);
            outputData = TEGenCfgScriptUtil.performSubFunc((int)neID, (int)0x202272, (Datainterface)inputData);
            this.parseOutputData(neID, outputData, oduattrlist, operResult);
        }
        ifattrlist.clear();
        oduattrlist.clear();
        operResult.setWholeErrorCode(0);
        operResult.setErrorInfo("");
        return operResult;
    }

    private void fillGenValueName(List<TEGenValue> genValueList) {
        for (TEGenValue teGenValue : genValueList) {
            int attrID = teGenValue.getAttrID();
            String attrName = TEGenCfgToolkit.getAttributeName(attrID);
            teGenValue.setAttrName(attrName);
        }
    }

    private void splitGenValueList(int neid, int boardType, List<TEGenValue> genValueList, List<TEGenValue> ifattrlist, List<TEGenValue> oduattrlist) {
        boolean isSupportIF = false;
        boolean isSupportODU = false;
        if (TEGenCfgDataMgr.isBoardSupportAttr((int)neid, (int)boardType, (String)"W32PORT_ATTR_RADIOLINKID")) {
            isSupportIF = true;
        }
        if (TEGenCfgDataMgr.isBoardSupportAttr((int)neid, (int)boardType, (String)"W32BRD_ATTR_TRANSMITFRE")) {
            isSupportODU = true;
        }
        for (TEGenValue teGenValue : genValueList) {
            int attrID = teGenValue.getAttrID();
            if (isSupportIF && TEInteMacroCodeConstant.isIFAttr((int)attrID)) {
                ifattrlist.add(teGenValue);
            }
            if (!isSupportODU || !TEInteMacroCodeConstant.isODUAttr((int)attrID)) continue;
            oduattrlist.add(teGenValue);
        }
        this.specialAttrhanle(ifattrlist);
    }

    private void specialAttrhanle(List<TEGenValue> genValueList) {
        TEGenValue bandWideth;
        boolean isNeedCapacity = false;
        boolean isNeedBandWideth = false;
        boolean isNeedServiceType = false;
        boolean isNeedIFRuningMode = false;
        boolean isNeedE1NUM = false;
        boolean isNeedAmStatus = false;
        for (TEGenValue teGenValue : genValueList) {
            if ("W32PORT_ATTR_AMWORKMODE_RANGE_MIN".equals(teGenValue.getAttrName())) {
                isNeedCapacity = true;
                if (!this.isContainAtrr(genValueList, "W32PORT_ATTR_CHANNELSPACE")) {
                    isNeedBandWideth = true;
                }
                if (!this.isContainAtrr(genValueList, "IFPORT_ATTR_SERVICETYPE")) {
                    isNeedServiceType = true;
                }
                if (!this.isContainAtrr(genValueList, "W32PORT_ATTR_IFRUNNINGMODE")) {
                    isNeedIFRuningMode = true;
                }
                if (!this.isContainAtrr(genValueList, "W32PORT_ATTR_ACMENABLESTATUS")) {
                    isNeedAmStatus = true;
                }
            }
            if (!"ethband".equals(teGenValue.getAttrName()) && !"IFPORT_ATTR_FULLE1NUM".equals(teGenValue.getAttrName())) continue;
            if (!this.isContainAtrr(genValueList, "IFPORT_ATTR_SERVICETYPE")) {
                isNeedServiceType = true;
            }
            if (!this.isContainAtrr(genValueList, "IFPORT_ATTR_ENSUREE1NUM")) {
                isNeedE1NUM = true;
            }
            if (this.isContainAtrr(genValueList, "W32PORT_ATTR_ACMENABLESTATUS")) continue;
            isNeedAmStatus = true;
        }
        if (isNeedCapacity) {
            TEGenValue caption = new TEGenValue();
            caption.setAttrName("capacity");
            genValueList.add(caption);
        }
        if (isNeedBandWideth) {
            bandWideth = new TEGenValue();
            bandWideth.setAttrName("W32PORT_ATTR_CHANNELSPACE");
            genValueList.add(bandWideth);
        }
        if (isNeedE1NUM) {
            bandWideth = new TEGenValue();
            bandWideth.setAttrName("IFPORT_ATTR_ENSUREE1NUM");
            genValueList.add(bandWideth);
        }
        if (isNeedAmStatus) {
            TEGenValue amStatus = new TEGenValue();
            amStatus.setAttrName("W32PORT_ATTR_ACMENABLESTATUS");
            genValueList.add(amStatus);
        }
        if (isNeedServiceType) {
            TEGenValue serviceType = new TEGenValue();
            serviceType.setAttrName("IFPORT_ATTR_SERVICETYPE");
            genValueList.add(serviceType);
        }
        if (isNeedIFRuningMode) {
            TEGenValue ifRunningMode = new TEGenValue();
            ifRunningMode.setAttrName("W32PORT_ATTR_IFRUNNINGMODE");
            genValueList.add(ifRunningMode);
        }
    }

    private boolean isContainAtrr(List<TEGenValue> genValueList, String attrName) {
        boolean isExist = false;
        for (TEGenValue teGenValue : genValueList) {
            if (!attrName.equals(teGenValue.getAttrName())) continue;
            return true;
        }
        return isExist;
    }

    protected void parseOutputData(int neID, Datainterface outputData, List<TEGenValue> genValueList, TEGenOperationResult operResult) {
        if (null == outputData || null == outputData.getErrorMessage()) {
            operResult.setWholeErrorCode(1090650122);
            return;
        }
        int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != errorCode && 1 != errorCode && 2 != errorCode) {
            this.fillTEGenValueResultErr(errorCode, genValueList, operResult);
            return;
        }
        for (TEGenValue teGenValue : genValueList) {
            if (teGenValue.getAttrID() == 0) continue;
            TEGenValueResult genValResult = new TEGenValueResult();
            this.fillTEGenValueResult(outputData.getBussinessParams(), teGenValue, genValResult);
            operResult.getGenResultList().add(genValResult);
        }
    }

    private void fillTEGenValueResultErr(int errCode, List<TEGenValue> genValueList, TEGenOperationResult operResult) {
        operResult.setWholeErrorCode(errCode);
        for (TEGenValue teGenValue : genValueList) {
            int attrID = teGenValue.getAttrID();
            TEGenValueResult genValResult = new TEGenValueResult();
            genValResult.attrID = attrID;
            genValResult.errorCode = errCode;
            operResult.getGenResultList().add(genValResult);
        }
    }

    private void fillTEGenValueResult(BussinessParams bussiness, TEGenValue teGenValue, TEGenValueResult genValResult) {
        int attrID = teGenValue.getAttrID();
        String attrName = teGenValue.getAttrName();
        genValResult.attrID = attrID;
        String attrValue = null;
        int errCodeFromNE = 0;
        for (int i = bussiness.getRowParamsCount() - 1; i >= 0; --i) {
            RowParams row = bussiness.getRowParams(i);
            Param param = row.getParam(this.convertAttrName(attrName));
            if (param != null && param.getValue() != null) {
                attrValue = this.convertNEAttrValue(row, param, attrName);
                break;
            }
            if (row.getRowErrorsCount() == 0) continue;
            int errLen = row.getRowErrorsCount();
            for (int j = 0; j < errLen; ++j) {
                String tempAttrID;
                int retCode = Integer.parseInt(row.getRowErrors(j).getErrorMessage().getErrorcode());
                if (row.getRowErrors(j).getParam("attrId") == null || !(tempAttrID = row.getRowErrors(j).getParam("attrId").getValue()).equals(this.getErrorAttrName(attrName))) continue;
                errCodeFromNE = retCode;
            }
        }
        genValResult.attrValue = attrValue;
        int n = genValResult.errorCode = attrValue == null || "".equals(attrValue) || "/".equals(attrValue) || "-".equals(attrValue) ? this.getTEGenValueResulErrorCode(errCodeFromNE) : 0;
        if (genValResult.errorCode == 1090596479) {
            genValResult.errorCode = 37898;
        }
    }

    private int getTEGenValueResulErrorCode(int errCodeFromNE) {
        return errCodeFromNE == 0 ? 1090595329 : errCodeFromNE;
    }

    private String convertAttrName(String name) {
        if (cfgAttr2QxparamMap.get(name) != null) {
            return cfgAttr2QxparamMap.get(name);
        }
        return name;
    }

    private String getErrorAttrName(String name) {
        if (cfgAttr2QxparamMap.get(name) != null) {
            return cfgAttr2QxparamMap.get(name);
        }
        if (errorQxparamMap.get(name) != null) {
            return errorQxparamMap.get(name);
        }
        return name;
    }

    private String convertNEAttrValue(RowParams row, Param param, String attrName) {
        Param lowparam;
        String attrValue = null;
        if ("W32BRD_ATTR_PRODUCESN".equals(attrName)) {
            Param tempparam = row.getParam("W32BRD_ATTR_FACTORYCODE");
            if (tempparam != null && !tempparam.getValue().isEmpty()) {
                String tmpFactoryCodeValue = tempparam.getValue();
                attrValue = param.getValue() + "-" + tmpFactoryCodeValue;
            }
        } else if ("W32BRD_ATTR_PRODUCETIME".equals(attrName)) {
            Param yearparam = row.getParam("YEAR");
            Param monthparam = row.getParam("MONTH");
            if (yearparam != null && monthparam != null) {
                attrValue = yearparam.getValue() + "-" + monthparam.getValue();
            }
        } else if ("W32BRD_ATTR_WORKRANGE".equals(attrName)) {
            lowparam = row.getParam("LOWFRE");
            if (lowparam != null && TEGenCfgToolkit.isValidate(lowparam.getValue())) {
                String finalLowVal = lowparam.getValue();
                String finalHighVal = param.getValue();
                attrValue = TEGenCfgToolkit.getRangeValue(finalLowVal, finalHighVal);
            } else {
                attrValue = param.getValue();
            }
        } else if ("W32BRD_ATTR_ACTRANGEOFPOWER".equals(attrName)) {
            lowparam = row.getParam("LOWPOWER");
            attrValue = lowparam != null && TEGenCfgToolkit.isValidate(lowparam.getValue()) ? TEGenCfgToolkit.getRangeValue(lowparam.getValue(), param.getValue()) : param.getValue();
        } else if ("W32BRD_ATTR_CONFIGTRANSMITPOWER".equals(attrName)) {
            Param sendPowerparam = row.getParam("sendpower");
            if (sendPowerparam != null && TEGenCfgToolkit.isValidate(sendPowerparam.getValue())) {
                attrValue = sendPowerparam.getValue();
            }
        } else {
            attrValue = "W32BRD_ATTR_TRINTERVALP".equals(attrName) ? TEGenCfgToolkit.dividedByThousand(param.getValue()) : ("ethband".equals(attrName) ? TEGenCfgToolkit.splitRangeValue(param.getValue()) : (attrNeedMutiplyBy10.contains(attrName) ? TEGenCfgToolkit.mutiplyByTen(param.getValue()) : param.getValue()));
        }
        String finalValue = attrValue == null ? null : IOStreamConvertor.replaceSpecialStr(attrValue).trim();
        return finalValue;
    }

    static {
        attrNeedMutiplyBy10.add("W32BRD_ATTR_MAXTRANSMITPOWER");
        attrNeedMutiplyBy10.add("W32BRD_ATTR_TRANSMITPOWER");
        attrNeedMutiplyBy10.add("W32BRD_ATTR_RECEIVEPOWER");
        attrNeedMutiplyBy10.add("W32BRD_ATTR_TXTHRESHOLDHIGH");
        attrNeedMutiplyBy10.add("W32BRD_ATTR_TXTHRESHOLDLOW");
        attrNeedMutiplyBy10.add("W32BRD_ATTR_RXTHRESHOLDHIGH");
        attrNeedMutiplyBy10.add("W32BRD_ATTR_RXTHRESHOLDLOW");
        attrNeedMutiplyBy10.add("W32BRD_ATTR_ACTTRANSMITPOWER");
        attrNeedMutiplyBy10.add("W32BRD_ATTR_ACTRECEIVEPOWER");
        attrNeedMutiplyBy10.add("W32BRD_ATTR_ACTRANGEOFPOWER");
        cfgAttr2QxparamMap.put("W32BRD_ATTR_CONFIGTRANSMITPOWER", "sendpower");
        cfgAttr2QxparamMap.put("W32BRD_ATTR_PRODUCETIME", "YEAR");
        errorQxparamMap.put("W32PORT_ATTR_AMWORKMODE_RANGE_MIN", "capacity");
        errorQxparamMap.put("W32PORT_ATTR_AMWORKMODE_RANGE_MAX", "capacity");
    }
}

