/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.fastconfig;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class TEAddBoardFilter
extends TENEExplorerBean {
    private List logInfoList = new ArrayList();
    private TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String BASE_PATH = "res" + File.separator;
    private static final String FUNC_DES_RES = BASE_PATH + "funcdesres_" + LANGUAGE + ".ini";
    private static final String SLOT_ID_PARAM = "slotID";
    private static final String BOARD_TYPE_PARAM = "boardType";
    private static final int BOARD_EXIST_ERROR = 38665;
    public int slotid;
    private int boardType;

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> l = new ArrayList<Integer>();
        l.add(new Integer(38664));
        l.add(new Integer(38665));
        return l;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList l) {
        for (int i = operationList.size() - 1; i >= 0; i -= 2) {
            Operation addBoardOperation = (Operation)operationList.get(i - 1);
            Operation verfityOperation = (Operation)operationList.get(i);
            if (!verfityOperation.getOutput(0).getFault(0).getCode().equals("0")) {
                verfityOperation.setInput(addBoardOperation.getInput());
                operationList.remove(i - 1);
                continue;
            }
            operationList.remove(i);
        }
        ArrayList operationl = (ArrayList)operationList.clone();
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)l);
        for (int i = operationl.size() - 1; i >= 0; --i) {
            Operation operation = (Operation)operationl.get(i);
            Part part = Definitions.getParam((Part[])operation.getInput().getPart(), (String)SLOT_ID_PARAM);
            this.slotid = Integer.parseInt(part.getValue());
            part = Definitions.getParam((Part[])operation.getInput().getPart(), (String)BOARD_TYPE_PARAM);
            this.boardType = Integer.parseInt(part.getValue());
            if (!operation.getOutput(0).getFault(0).getCode().equals(String.valueOf(0)) && !operation.getOutput(0).getFault(0).getCode().equals(String.valueOf(38665))) continue;
            this.addBoard();
        }
    }

    private void addBoard() {
        try {
            Vector boardList = TENEListMgr.getInstance().getNE(this.neid).getBoardList();
            TEBoard board = new TEBoard(this.neid, this.slotid, this.boardType);
            if (!boardList.contains(board)) {
                boardList.add(board);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Add memery Board Fault!", (Throwable)e);
            return;
        }
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            if (outputData.getErrorMessage().getErrorcode().equals(String.valueOf(1090646019))) {
                return;
            }
            TENE neObj = this.cfgDataMgr.getNE(neid);
            String operateObject = "";
            operateObject = null == neObj ? String.valueOf(neid) : neObj.getNEName();
            String operateName = TEGetFilePath.getResource((int)neid, (String)FUNC_DES_RES).getString(subfunc.getDes());
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            switch (errorCode) {
                case 1090646019: {
                    break;
                }
                case 0: {
                    this.logSuccess(user, ipAddress, operateObject, operateName, errorCode);
                    break;
                }
                case 1: {
                    this.logSuccess(user, ipAddress, operateObject, operateName, errorCode);
                    this.logFail(user, ipAddress, operateObject, operateName);
                    break;
                }
                case 2: {
                    this.logFail(user, ipAddress, operateObject, operateName);
                    break;
                }
                default: {
                    this.logOther(user, ipAddress, operateObject, operateName, errorCode);
                }
            }
            int size = this.logInfoList.size();
            for (int i = 0; i < size; ++i) {
                TELogMgr.writeLog((TELogInfo)((TELogInfo)this.logInfoList.get(i)));
            }
        }
        catch (Exception e) {
            return;
        }
    }

    private void logSuccess(String user, String ipAddress, String operateObject, String operateName, int errorCode) {
        RowParams rowParams = null;
        int rowCount = this.inputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < rowCount; ++i) {
            String desc = "";
            TELogInfo loginfo = new TELogInfo();
            loginfo.setCmdID(this.subfunc.getCode());
            loginfo.setLocation(ipAddress);
            loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
            loginfo.setOperateObject(operateObject);
            loginfo.setOperateName(operateName);
            rowParams = this.inputData.getBussinessParams().getRowParams(i);
            int slotId = Integer.parseInt(rowParams.getParam(SLOT_ID_PARAM).getValue());
            int bdType = Integer.parseInt(rowParams.getParam(BOARD_TYPE_PARAM).getValue());
            String boardName = this.cfgDataMgr.getBoardTypeName(this.neid, bdType);
            desc = desc + operateName + ":" + slotId + "-" + boardName;
            loginfo.setOperateDesc(desc);
            loginfo.setResult(0);
            loginfo.setErrCode(0);
            loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
            this.logInfoList.add(loginfo);
        }
    }

    private void logFail(String user, String ipAddress, String operateObject, String operateName) {
        int len = this.outputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            RowErrors[] rowErrors = this.outputData.getBussinessParams().getRowParams(i).getRowErrors();
            int size = rowErrors.length;
            for (int j = 0; j < size; ++j) {
                String desc = "";
                int slotId = Integer.parseInt(rowErrors[j].getParam(SLOT_ID_PARAM).getValue());
                int bdType = Integer.parseInt(rowErrors[j].getParam(BOARD_TYPE_PARAM).getValue());
                String boardName = this.cfgDataMgr.getBoardTypeName(this.neid, bdType);
                desc = desc + operateName + ":" + slotId + "-" + boardName;
                for (int k = this.logInfoList.size() - 1; k >= 0; --k) {
                    TELogInfo loginfo = (TELogInfo)this.logInfoList.get(k);
                    if (!loginfo.getOperateDesc().equalsIgnoreCase(desc)) continue;
                    this.logInfoList.remove(k);
                }
                TELogInfo loginfo = new TELogInfo();
                loginfo.setCmdID(this.subfunc.getCode());
                loginfo.setLocation(ipAddress);
                loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
                loginfo.setOperateObject(operateObject);
                loginfo.setOperateName(operateName);
                loginfo.setOperateDesc(desc);
                loginfo.setResult(2);
                loginfo.setErrCode(Integer.parseInt(rowErrors[j].getErrorMessage().getErrorcode()));
                loginfo.setErrInfo(rowErrors[i].getErrorMessage().getErrorinfo());
                this.logInfoList.add(loginfo);
            }
        }
    }

    private void logOther(String user, String ipAddress, String operateObject, String operateName, int errorCode) {
        RowParams rowParams = null;
        int rowCount = this.inputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < rowCount; ++i) {
            String desc = "";
            TELogInfo loginfo = new TELogInfo();
            loginfo.setCmdID(this.subfunc.getCode());
            loginfo.setLocation(ipAddress);
            loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
            loginfo.setOperateObject(operateObject);
            loginfo.setOperateName(operateName);
            rowParams = this.inputData.getBussinessParams().getRowParams(i);
            int slotId = Integer.parseInt(rowParams.getParam(SLOT_ID_PARAM).getValue());
            int bdType = Integer.parseInt(rowParams.getParam(BOARD_TYPE_PARAM).getValue());
            String boardName = this.cfgDataMgr.getBoardTypeName(this.neid, bdType);
            desc = desc + operateName + ":" + slotId + "-" + boardName;
            loginfo.setOperateDesc(desc);
            loginfo.setResult(2);
            loginfo.setErrCode(errorCode);
            loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
            this.logInfoList.add(loginfo);
        }
    }
}

