/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.fagemargin;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.gencfg.TEGenCfgDataConvertor;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.rtn.fagemargin.TENESystemParamsData;
import com.huawei.nglct.nemgr.rtn.fagemargin.TENESystemParamsUtils;
import java.util.ArrayList;

public class TERTNQuerySystemParamBean
extends TENEExplorerBean {
    private static final String RXMSET = "rxmset";
    private static final String RXSENSITIVITY = "rxsensitivity";
    private static final String RXMAXPOWER = "rxmaxpower";
    private static final String MRXSLOTID = "1";
    private static final String PRXSLOTID = "0";
    private static final String SLOTFLAG = "slotFlag";
    private static final int INVALID_SYSTEMPARAM = -1;
    private static double mRxFreqBand = -1.0;
    private static int mRxSlotid = -1;
    private static double pRxFreqBand = -1.0;
    private static int pRxSlotid = -1;

    private static void clearFreqBand() {
        mRxFreqBand = -1.0;
        mRxSlotid = -1;
        pRxFreqBand = -1.0;
        pRxSlotid = -1;
    }

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        BussinessParams bussinessParamsinputData = inputData.getBussinessParams();
        int len = bussinessParamsinputData.getRowParamsCount();
        RowParams rowparams = null;
        for (int i = 0; i < len; ++i) {
            rowparams = bussinessParamsinputData.getRowParams(i);
            if (null != rowparams.getParam("mRxFreqBand")) {
                mRxFreqBand = Double.valueOf(rowparams.getParam("mRxFreqBand").getValue());
                mRxSlotid = Integer.valueOf(rowparams.getParam("slotid").getValue());
            }
            if (null == rowparams.getParam("pRxFreqBand")) continue;
            pRxFreqBand = Double.valueOf(rowparams.getParam("pRxFreqBand").getValue());
            pRxSlotid = Integer.valueOf(rowparams.getParam("slotid").getValue());
        }
        return super.getOperation(neid, subFunc, inputData, memeryData);
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList errList = super.getFilterErrorCodeList();
        errList.add(38737);
        return errList;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = TEGenCfgDataConvertor.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        if (null == this.outputData || null == this.outputData.getBussinessParams() || this.outputData.getBussinessParams().getRowParamsCount() == 0) {
            TELogFactory.getNormalLogger().error("<--FADEMARGIN--> : outputData == null or the length of outputData is 0!");
            return;
        }
        RowParams rowparams = null;
        int len = this.outputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            rowparams = this.outputData.getBussinessParams().getRowParams(i);
            if (rowparams.getParamCount() == 0) continue;
            int slotid = Integer.valueOf(rowparams.getParam("slotid").getValue());
            int boardtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
            Param tempBandwidth = rowparams.getParam("bandwidth");
            int bandwidth = this.isDataValid(tempBandwidth) ? 0 : this.resetParamValue(tempBandwidth.getValue());
            Param tempSendmode = rowparams.getParam("sendmode");
            int sendmode = -1;
            if (tempSendmode != null) {
                sendmode = this.isDataValid(tempSendmode) ? 0 : this.resetParamValue(tempSendmode.getValue());
            }
            Param tempReceivemode = rowparams.getParam("receivemode");
            int receivemode = -1;
            if (tempReceivemode != null) {
                receivemode = this.isDataValid(tempReceivemode) ? 0 : this.resetParamValue(tempReceivemode.getValue());
            }
            TELogFactory.getNormalLogger().info("<--FADEMARGIN--> : bandwidth = " + bandwidth + " sendmode = " + sendmode + " receivemode = " + receivemode);
            String[] systemParamValue = this.getSystemParamValue(boardtype, bandwidth, sendmode, receivemode, mRxFreqBand);
            TELogFactory.getNormalLogger().info("<--FADEMARGIN--> : rxmaxpower = " + systemParamValue[0] + " rxmset = " + systemParamValue[1] + " rxsensitivity = " + systemParamValue[2]);
            if (-1.0 != pRxFreqBand && pRxSlotid == slotid) {
                rowparams.addParam(new Param(SLOTFLAG, PRXSLOTID));
                rowparams.addParam(new Param(PRXSLOTID, String.valueOf(slotid)));
            } else {
                rowparams.addParam(new Param(SLOTFLAG, MRXSLOTID));
                rowparams.addParam(new Param(MRXSLOTID, String.valueOf(slotid)));
            }
            rowparams.addParam(new Param(RXMAXPOWER, systemParamValue[0]));
            rowparams.addParam(new Param(RXMSET, systemParamValue[1]));
            rowparams.addParam(new Param(RXSENSITIVITY, systemParamValue[2]));
        }
        TERTNQuerySystemParamBean.clearFreqBand();
    }

    private String[] getSystemParamValue(int boardtype, int bandwith, int sendmode, int receivemode, double freqband) {
        String[] defaultValue = new String[]{PRXSLOTID, PRXSLOTID, PRXSLOTID};
        defaultValue[0] = TENESystemParamsUtils.getInstance().getSystemParamMset().get(receivemode);
        if (defaultValue[0] == null) {
            defaultValue[0] = PRXSLOTID;
        }
        TENESystemParamsData data = new TENESystemParamsData(boardtype, bandwith, receivemode, freqband);
        data = TENESystemParamsUtils.getInstance().getSystemParamsData(data);
        if (null != data) {
            defaultValue[1] = String.valueOf(data.getMset());
            defaultValue[2] = String.valueOf(data.getSensitivity());
        }
        return defaultValue;
    }

    private int resetParamValue(String value) {
        if (!"/".equals(value) && !"-".equals(value)) {
            return Integer.valueOf(value);
        }
        return -1;
    }

    private boolean isDataValid(Param param) {
        if (null == param) {
            return false;
        }
        return param.getValue() != null && param.getValue() != "" && param.getValue() != "undefined";
    }
}

