/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.fagemargin;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.rtn.fagemargin.TENEPoint;
import com.huawei.nglct.nemgr.rtn.fagemargin.TENESystemParamsUtils;

public class TERTNQueryFadeMarginBean
extends TENEExplorerBean {
    private static final String SLOTFLAG = "slotFlag";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.outputData = super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
        BussinessParams bussinessParam = new BussinessParams();
        this.outputData.setBussinessParams(bussinessParam);
        BussinessParams bussinessParamsinputData = inputData.getBussinessParams();
        int len = bussinessParamsinputData.getRowParamsCount();
        RowParams irowparams = null;
        RowParams orowparams = null;
        for (int i = 0; i < len; ++i) {
            irowparams = bussinessParamsinputData.getRowParams(i);
            String slotid = irowparams.getParam("slotid").getValue();
            String num = irowparams.getParam("num").getValue();
            String rslmse = irowparams.getParam("rslmse").getValue();
            String slotflag = irowparams.getParam(SLOTFLAG).getValue();
            TELogFactory.getNormalLogger().info("<--FADEMARGIN--> : SLOTFLAG = " + slotflag + SLOTFLAG + " slotid = " + slotid);
            double rxPower = Double.valueOf(irowparams.getParam("rxPower").getValue());
            double systemParam_mset = Double.valueOf(irowparams.getParam("mset").getValue());
            double systemParam_sensitivity = Double.valueOf(irowparams.getParam("sensitivity").getValue());
            double[] fadematginValue = this.getFademarginValues(rxPower, systemParam_mset, systemParam_sensitivity, num, rslmse);
            orowparams = new RowParams();
            orowparams.addParam("neid", irowparams.getParam("neid").getValue());
            orowparams.addParam("slotid", slotid);
            orowparams.addParam(SLOTFLAG, slotflag);
            orowparams.addParam("deltamse", String.valueOf(fadematginValue[0]));
            orowparams.addParam("fademargin", String.valueOf(fadematginValue[1]));
            this.outputData.getBussinessParams().addRowParams(orowparams);
        }
        return this.outputData;
    }

    private double[] getFademarginValues(double RSL0, double systemParam_mset, double systemParam_sensitivity, String num, String rslmse) {
        double[] defaultValue = new double[]{0.0, 0.0};
        try {
            TENEPoint[] points = TENESystemParamsUtils.getValidPointsFromData(num, rslmse);
            TELogFactory.getNormalLogger().info("<--FADEMARGIN--> : rslmse = " + rslmse);
            TELogFactory.getNormalLogger().info("<--FADEMARGIN--> : rxPower0 = " + RSL0 + " systemParam_mset = " + systemParam_mset + " systemParam_sensitivity = " + systemParam_sensitivity);
            TELogFactory.getNormalLogger().info("<--FADEMARGIN--> : the 2 points = " + points[0].toString() + "" + points[1].toString());
            double MSE1 = points[0].getCoordinate_y();
            double MSE2 = points[1].getCoordinate_y();
            double RSL_c = TENESystemParamsUtils.CalculateDeltaRSLValue(points[1], points[0], systemParam_mset);
            TELogFactory.getNormalLogger().info("<--FADEMARGIN--> : RSL_c = " + RSL_c);
            double fademargin = RSL0 - Math.max(RSL_c, systemParam_sensitivity);
            defaultValue[0] = 0.0 == points[0].getCoordinate_x() && 0.0 == points[0].getCoordinate_y() ? 0.0 : Math.abs(MSE1 - MSE2);
            defaultValue[1] = fademargin;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("<--FADEMARGIN--> Err", (Throwable)e);
            defaultValue[0] = 0.0;
            defaultValue[1] = 0.0;
        }
        return defaultValue;
    }
}

