/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.fagemargin;

import com.huawei.nglct.bscfg.equipment.TEEquipmentDescription;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public class TERTNQueryBoardGroupBean
extends TENEExplorerBean {
    protected Set<Integer> boardlist = new HashSet<Integer>();
    protected Set<BoardKey> phyboardlist = new HashSet<BoardKey>();
    protected int slotRelation = 0;
    protected TEConfigurationDataMgr configureMgr = TEConfigurationDataMgr.getInstance();
    protected TENE currentNeObject = null;
    protected static final int QX_NUMBER = 3;
    protected static final int QUERY_XPIC_INDEX = 0;
    protected static final int QUERY_1J1_INDEX = 1;
    protected static final int QUERY_1J1_STATE_INDEX = 2;
    private int slotId = 0;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        Param querytypeParam;
        this.currentNeObject = TENEListMgr.getInstance().getNE(neid);
        this.neid = neid;
        Param slot = inputData.getBussinessParams().getRowParams(0).getParam("slotid");
        if (null != slot) {
            try {
                this.slotId = Integer.parseInt(slot.getValue());
            }
            catch (NumberFormatException ex) {
                TELogFactory.getNormalLogger().warn("Input param slotid is not number!");
                this.slotId = 0;
            }
        }
        if (null != (querytypeParam = inputData.getBussinessParams().getRowParams(0).getParam("querytype")) && querytypeParam.getValue().equals("getallIFODUBoard")) {
            this.handleMessage(neid, new ArrayList(), subFunc, this.getFilterErrorCodeList());
            return this.outputData;
        }
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.boardlist = this.getBoardList();
        this.phyboardlist = this.getPhyBoardList();
        int neType = this.currentNeObject.getNEType();
        this.slotRelation = TEEquipmentDescription.getInstance().getSlotRelation(TEGetNEDomainVersion.getInstance().getDevType(neType));
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        if (operationList.size() == 3) {
            this.handleXPICData((Operation)operationList.get(0));
            this.handle1J1Data((Operation)operationList.get(1), (Operation)operationList.get(2));
        }
        if (0 == this.slotId) {
            this.handleIFODU();
        }
    }

    protected void handleXPICData(Operation operation) {
        Output out = null;
        int mSlotId = 0;
        int pSlotId = 0;
        int m = operation.getOutputCount();
        for (int i = 0; i < m; ++i) {
            out = operation.getOutput(i);
            if (!this.isOutputSuccess(out) || out.getPart("hPolarBdid") == null || out.getPart("vPolarBdid") == null) continue;
            RowParams rowparm = new RowParams();
            mSlotId = Integer.parseInt(out.getPartValue("hPolarBdid"));
            if (this.isEqualInputSlot(mSlotId, pSlotId = Integer.parseInt(out.getPartValue("vPolarBdid")))) continue;
            rowparm.addParam("neversion", this.currentNeObject.getHostVersion());
            rowparm.addParam("mSlotId", String.valueOf(mSlotId));
            rowparm.addParam("mBoardName", this.configureMgr.getBoardTypeName(this.neid, this.configureMgr.getBoardType(this.neid, mSlotId)));
            this.setPhyState(rowparm, mSlotId, "mIfPhy");
            this.boardlist.remove(mSlotId);
            rowparm.addParam("mOduSlotId", String.valueOf(mSlotId + this.slotRelation));
            this.setPhyState(rowparm, mSlotId + this.slotRelation, "mOduPhy");
            this.boardlist.remove(mSlotId + this.slotRelation);
            rowparm.addParam("mOduBoardName", this.configureMgr.getBoardName(this.neid, mSlotId + this.slotRelation));
            rowparm.addParam("mPortId", out.getPartValue("hPolarPortid"));
            rowparm.addParam("pSlotId", String.valueOf(pSlotId));
            rowparm.addParam("pBoardName", this.configureMgr.getBoardTypeName(this.neid, this.configureMgr.getBoardType(this.neid, pSlotId)));
            this.setPhyState(rowparm, pSlotId, "pIfPhy");
            this.boardlist.remove(pSlotId);
            rowparm.addParam("pOduSlotId", String.valueOf(pSlotId + this.slotRelation));
            this.setPhyState(rowparm, pSlotId + this.slotRelation, "pOduPhy");
            rowparm.addParam("pOduBoardName", this.configureMgr.getBoardName(this.neid, mSlotId + this.slotRelation));
            this.boardlist.remove(pSlotId + this.slotRelation);
            rowparm.addParam("pPortId", out.getPartValue("vPolarPortid"));
            rowparm.addParam("protectType", "-1");
            this.outputData.getBussinessParams().addRowParams(rowparm);
        }
    }

    private void setPhyState(RowParams row, int slotid, String name) {
        int boardType = this.configureMgr.getBoardType(this.neid, slotid);
        if (this.phyboardlist.contains(new BoardKey(slotid, boardType))) {
            row.addParam(name, "1");
        }
    }

    protected void handle1J1Data(Operation operationGroup, Operation operationGroupState) {
        int i;
        Output out = null;
        String protectId = "";
        int pSlotId = 0;
        int mSlotId = 0;
        String stateSlot = "";
        HashMap<String, String> groupIDAndWorkSlotIdMap = new HashMap<String, String>();
        int m = operationGroupState.getOutputCount();
        for (i = 0; i < m; ++i) {
            out = operationGroupState.getOutput(i);
            if (!this.isOutputSuccess(out)) continue;
            groupIDAndWorkSlotIdMap.put(out.getPartValue("groupId"), out.getPartValue("equipSlotId"));
        }
        m = operationGroup.getOutputCount();
        for (i = 0; i < m; ++i) {
            out = operationGroup.getOutput(i);
            if (!this.isOutputSuccess(out) || out.getPart("workingSlotId") == null || out.getPart("protectionSlotId") == null || this.isEqualInputSlot(mSlotId = Integer.parseInt(out.getPartValue("workingSlotId")), pSlotId = Integer.parseInt(out.getPartValue("protectionSlotId")))) continue;
            protectId = out.getPartValue("groupId");
            if (groupIDAndWorkSlotIdMap.containsKey(protectId)) {
                stateSlot = (String)groupIDAndWorkSlotIdMap.get(protectId);
            }
            RowParams rowparm = new RowParams();
            boolean isConvertWork = String.valueOf(pSlotId).equals(stateSlot);
            this.set1J1RowParam(rowparm, out, isConvertWork);
            this.outputData.getBussinessParams().addRowParams(rowparm);
        }
    }

    private void set1J1RowParam(RowParams rowparm, Output out, boolean convert) {
        if (rowparm != null && out != null) {
            String mname = "m";
            String pname = "p";
            rowparm.addParam("neversion", this.currentNeObject.getHostVersion());
            int mSlotId = Integer.parseInt(out.getPartValue("workingSlotId"));
            String mPortId = out.getPartValue("workingport");
            int pSlotId = Integer.parseInt(out.getPartValue("protectionSlotId"));
            String pPortId = out.getPartValue("protectionport");
            rowparm.addParam(pname + "SlotId", String.valueOf(pSlotId));
            rowparm.addParam(pname + "BoardName", this.configureMgr.getBoardTypeName(this.neid, this.configureMgr.getBoardType(this.neid, pSlotId)));
            this.setPhyState(rowparm, pSlotId, pname + "IfPhy");
            this.boardlist.remove(pSlotId);
            rowparm.addParam(pname + "OduSlotId", String.valueOf(pSlotId + this.slotRelation));
            this.setPhyState(rowparm, pSlotId + this.slotRelation, pname + "OduPhy");
            rowparm.addParam(pname + "OduBoardName", this.configureMgr.getBoardName(this.neid, mSlotId + this.slotRelation));
            this.boardlist.remove(pSlotId + this.slotRelation);
            rowparm.addParam(pname + "PortId", pPortId);
            rowparm.addParam(mname + "SlotId", String.valueOf(mSlotId));
            rowparm.addParam(mname + "BoardName", this.configureMgr.getBoardTypeName(this.neid, this.configureMgr.getBoardType(this.neid, mSlotId)));
            this.setPhyState(rowparm, mSlotId, mname + "IfPhy");
            this.boardlist.remove(mSlotId);
            rowparm.addParam(mname + "OduSlotId", String.valueOf(mSlotId + this.slotRelation));
            this.setPhyState(rowparm, mSlotId + this.slotRelation, mname + "OduPhy");
            rowparm.addParam(mname + "OduBoardName", this.configureMgr.getBoardName(this.neid, mSlotId + this.slotRelation));
            this.boardlist.remove(mSlotId + this.slotRelation);
            rowparm.addParam(mname + "PortId", mPortId);
            if (convert) {
                rowparm.addParam("convert", String.valueOf(convert));
            }
            rowparm.addParam("protectType", out.getPartValue("wMode"));
        }
    }

    protected void handleIFODU() {
        for (int boardid : this.boardlist) {
            int oduboardid;
            int boardtype = this.configureMgr.getBoardType(this.neid, boardid);
            if (!this.configureMgr.isIFboard(boardtype) || !this.boardlist.contains(oduboardid = boardid + this.slotRelation)) continue;
            RowParams rowparm = new RowParams();
            rowparm.addParam("mSlotId", boardid + "");
            rowparm.addParam("mBoardName", this.configureMgr.getBoardTypeName(this.neid, boardtype));
            this.setPhyState(rowparm, boardid, "mIfPhy");
            rowparm.addParam("mOduSlotId", oduboardid + "");
            rowparm.addParam("mOduBoardName", this.configureMgr.getBoardName(this.neid, oduboardid));
            this.setPhyState(rowparm, oduboardid, "mOduPhy");
            rowparm.addParam("neversion", this.currentNeObject.getHostVersion());
            this.outputData.getBussinessParams().addRowParams(rowparm);
        }
    }

    private Set<Integer> getBoardList() {
        HashSet<Integer> result = new HashSet<Integer>();
        Vector bdList = this.currentNeObject.getClonedBoardList();
        int len = bdList.size();
        for (int i = 0; i < len; ++i) {
            TEBoard board = (TEBoard)bdList.get(i);
            result.add(board.getSlotID());
        }
        return result;
    }

    private Set<BoardKey> getPhyBoardList() {
        HashSet<BoardKey> result = new HashSet<BoardKey>();
        Vector phybdList = this.currentNeObject.getClonedPhyBoardList();
        int len = phybdList.size();
        for (int i = 0; i < len; ++i) {
            int logicBoardType;
            TEBoard board = (TEBoard)phybdList.get(i);
            int slotId = board.getSlotID();
            int boardType = board.getBoardType();
            if (boardType != (logicBoardType = this.configureMgr.getBoardType(this.neid, slotId))) continue;
            result.add(new BoardKey(board.getSlotID(), boardType));
        }
        return result;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(38662);
        list.add(41674);
        return list;
    }

    private boolean isEqualInputSlot(int mSlotId, int pSlotId) {
        return 0 != this.slotId && this.slotId != mSlotId && this.slotId != pSlotId;
    }

    class BoardKey {
        private int slotID = 0;
        private int boardType = 0;

        public BoardKey(int boardType, int slotID) {
            this.boardType = boardType;
            this.slotID = slotID;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.boardType;
            result = 31 * result + this.slotID;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BoardKey other = (BoardKey)obj;
            if (this.boardType != other.boardType) {
                return false;
            }
            return this.slotID == other.slotID;
        }
    }
}

