/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.fagemargin;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nemgr.rtn.fagemargin.TENEPoint;
import com.huawei.nglct.nemgr.rtn.fagemargin.TENESystemParamsData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class TENESystemParamsUtils {
    private static final int INT_INVALID = 65536;
    private static final int DELTAMSEHOLD = 5;
    private static final int BDTYPE_SL91ISU2 = 2266;
    private static final int BDTYPE_SL91ISX2 = 2267;
    private static final int BDTYPE_SL91IFU2 = 2079;
    private static final int BDTYPE_SL91IFX2 = 2080;
    public static final int IFB_MODULATION_QPSK = 1;
    public static final int IFB_MODULATION_16QAM = 2;
    public static final int IFB_MODULATION_32QAM = 3;
    public static final int IFB_MODULATION_64QAM = 4;
    public static final int IFB_MODULATION_128QAM = 5;
    public static final int IFB_MODULATION_256QAM = 6;
    public static final int IFB_MODULATION_2048QAM = 13;
    public static final int IFB_BANDWIDTH_7M = 2;
    public static final int IFB_BANDWIDTH_14M = 3;
    public static final int IFB_BANDWIDTH_28M = 4;
    public static final int IFB_BANDWIDTH_40M = 5;
    public static final int IFB_BANDWIDTH_56M = 6;
    public static final double IFB_FREQBAND_6G = 6.0;
    public static final double IFB_FREQBAND_7G = 7.0;
    public static final double IFB_FREQBAND_8G = 8.0;
    public static final double IFB_FREQBAND_10G = 10.0;
    public static final double IFB_FREQBAND_10p5G = 10.5;
    public static final double IFB_FREQBAND_11G = 11.0;
    public static final double IFB_FREQBAND_13G = 13.0;
    public static final double IFB_FREQBAND_15G = 15.0;
    public static final double IFB_FREQBAND_18G = 18.0;
    public static final double IFB_FREQBAND_23G = 23.0;
    public static final double IFB_FREQBAND_26G = 26.0;
    public static final double IFB_FREQBAND_28G = 28.0;
    public static final double IFB_FREQBAND_32G = 32.0;
    public static final double IFB_FREQBAND_38G = 38.0;
    private static final double MIN_SST = -32768.0;
    private static boolean inited = false;
    private static TENESystemParamsUtils instance = new TENESystemParamsUtils();
    private static List<TENESystemParamsData> systemParams;
    private static Map<Integer, String> maxRxPower;

    public static TENESystemParamsUtils getInstance() {
        return instance;
    }

    public Map<Integer, String> getSystemParamMset() {
        return maxRxPower;
    }

    public TENESystemParamsData getSystemParamsData(TENESystemParamsData data) {
        if (null == data) {
            return null;
        }
        TENESystemParamsData tempdata = null;
        int len = systemParams.size();
        for (int i = 0; i < len; ++i) {
            tempdata = systemParams.get(i);
            if (!data.equals(tempdata)) continue;
            return tempdata;
        }
        return null;
    }

    private TENESystemParamsUtils() {
        if (!inited) {
            inited = true;
            this.loadSystemParamsData();
            this.loadExtSystemParamsData();
        }
    }

    /*
     * Opcode count of 39043 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private void loadSystemParamsData() {
        systemParams = new ArrayList<TENESystemParamsData>();
        maxRxPower = new HashMap<Integer, String>();
        if (maxRxPower.isEmpty()) {
            maxRxPower.put(-1, "0");
            maxRxPower.put(1, "-20");
            maxRxPower.put(2, "-20");
            maxRxPower.put(3, "-20");
            maxRxPower.put(4, "-20");
            maxRxPower.put(5, "-20");
            maxRxPower.put(6, "-25");
            maxRxPower.put(13, "-20");
        }
        double[][] systemParamsTable = new double[][]{{2266.0, 2.0, 1.0, 6.0, -92.5, 9.2}, {2266.0, 2.0, 1.0, 7.0, -92.5, 9.2}, {2266.0, 2.0, 1.0, 8.0, -92.5, 9.2}, {2266.0, 2.0, 1.0, 10.0, -92.0, 9.2}, {2266.0, 2.0, 1.0, 10.5, -90.0, 9.2}, {2266.0, 2.0, 1.0, 11.0, -92.0, 9.2}, {2266.0, 2.0, 1.0, 13.0, -92.0, 9.2}, {2266.0, 2.0, 1.0, 15.0, -92.0, 9.2}, {2266.0, 2.0, 1.0, 18.0, -92.0, 9.2}, {2266.0, 2.0, 1.0, 23.0, -91.5, 9.2}, {2266.0, 2.0, 1.0, 26.0, -91.0, 9.2}, {2266.0, 2.0, 1.0, 28.0, -90.5, 9.2}, {2266.0, 2.0, 1.0, 32.0, -90.0, 9.2}, {2266.0, 2.0, 1.0, 38.0, -89.5, 9.2}, {2266.0, 2.0, 2.0, 6.0, -86.5, 15.2}, {2266.0, 2.0, 2.0, 7.0, -86.5, 15.2}, {2266.0, 2.0, 2.0, 8.0, -86.5, 15.2}, {2266.0, 2.0, 2.0, 10.0, -86.0, 15.2}, {2266.0, 2.0, 2.0, 10.5, -84.0, 15.2}, {2266.0, 2.0, 2.0, 11.0, -86.0, 15.2}, {2266.0, 2.0, 2.0, 13.0, -86.0, 15.2}, {2266.0, 2.0, 2.0, 15.0, -86.0, 15.2}, {2266.0, 2.0, 2.0, 18.0, -86.0, 15.2}, {2266.0, 2.0, 2.0, 23.0, -85.5, 15.2}, {2266.0, 2.0, 2.0, 26.0, -85.0, 15.2}, {2266.0, 2.0, 2.0, 28.0, -84.5, 15.2}, {2266.0, 2.0, 2.0, 32.0, -84.0, 15.2}, {2266.0, 2.0, 2.0, 38.0, -83.5, 15.2}, {2266.0, 2.0, 3.0, 6.0, -82.5, 17.5}, {2266.0, 2.0, 3.0, 7.0, -82.5, 17.5}, {2266.0, 2.0, 3.0, 8.0, -82.5, 17.5}, {2266.0, 2.0, 3.0, 10.0, -82.0, 17.5}, {2266.0, 2.0, 3.0, 10.5, -80.0, 17.5}, {2266.0, 2.0, 3.0, 11.0, -82.0, 17.5}, {2266.0, 2.0, 3.0, 13.0, -82.0, 17.5}, {2266.0, 2.0, 3.0, 15.0, -82.0, 17.5}, {2266.0, 2.0, 3.0, 18.0, -82.0, 17.5}, {2266.0, 2.0, 3.0, 23.0, -81.5, 17.5}, {2266.0, 2.0, 3.0, 26.0, -81.0, 17.5}, {2266.0, 2.0, 3.0, 28.0, -80.5, 17.5}, {2266.0, 2.0, 3.0, 32.0, -80.0, 17.5}, {2266.0, 2.0, 3.0, 38.0, -79.5, 17.5}, {2266.0, 2.0, 4.0, 6.0, -80.0, 20.8}, {2266.0, 2.0, 4.0, 7.0, -80.0, 20.8}, {2266.0, 2.0, 4.0, 8.0, -80.0, 20.8}, {2266.0, 2.0, 4.0, 10.0, -79.5, 20.8}, {2266.0, 2.0, 4.0, 10.5, -77.5, 20.8}, {2266.0, 2.0, 4.0, 11.0, -79.5, 20.8}, {2266.0, 2.0, 4.0, 13.0, -79.5, 20.8}, {2266.0, 2.0, 4.0, 15.0, -79.5, 20.8}, {2266.0, 2.0, 4.0, 18.0, -79.5, 20.8}, {2266.0, 2.0, 4.0, 23.0, -79.0, 20.8}, {2266.0, 2.0, 4.0, 26.0, -78.5, 20.8}, {2266.0, 2.0, 4.0, 28.0, -78.0, 20.8}, {2266.0, 2.0, 4.0, 32.0, -77.5, 20.8}, {2266.0, 2.0, 4.0, 38.0, -77.0, 20.8}, {2266.0, 2.0, 5.0, 6.0, -77.0, 23.7}, {2266.0, 2.0, 5.0, 7.0, -77.0, 23.7}, {2266.0, 2.0, 5.0, 8.0, -77.0, 23.7}, {2266.0, 2.0, 5.0, 10.0, -76.5, 23.7}, {2266.0, 2.0, 5.0, 10.5, -74.5, 23.7}, {2266.0, 2.0, 5.0, 11.0, -76.5, 23.7}, {2266.0, 2.0, 5.0, 13.0, -76.5, 23.7}, {2266.0, 2.0, 5.0, 15.0, -76.5, 23.7}, {2266.0, 2.0, 5.0, 18.0, -76.5, 23.7}, {2266.0, 2.0, 5.0, 23.0, -76.0, 23.7}, {2266.0, 2.0, 5.0, 26.0, -75.5, 23.7}, {2266.0, 2.0, 5.0, 28.0, -75.0, 23.7}, {2266.0, 2.0, 5.0, 32.0, -74.5, 23.7}, {2266.0, 2.0, 5.0, 38.0, -74.0, 23.7}, {2266.0, 2.0, 6.0, 6.0, -74.0, 26.8}, {2266.0, 2.0, 6.0, 7.0, -74.0, 26.8}, {2266.0, 2.0, 6.0, 8.0, -74.0, 26.8}, {2266.0, 2.0, 6.0, 10.0, -73.5, 26.8}, {2266.0, 2.0, 6.0, 10.5, -71.5, 26.8}, {2266.0, 2.0, 6.0, 11.0, -73.5, 26.8}, {2266.0, 2.0, 6.0, 13.0, -73.5, 26.8}, {2266.0, 2.0, 6.0, 15.0, -73.5, 26.8}, {2266.0, 2.0, 6.0, 18.0, -73.5, 26.8}, {2266.0, 2.0, 6.0, 23.0, -73.0, 26.8}, {2266.0, 2.0, 6.0, 26.0, -72.5, 26.8}, {2266.0, 2.0, 6.0, 28.0, -72.0, 26.8}, {2266.0, 2.0, 6.0, 32.0, -71.5, 26.8}, {2266.0, 2.0, 6.0, 38.0, -71.0, 26.8}, {2266.0, 3.0, 1.0, 6.0, -90.5, 8.0}, {2266.0, 3.0, 1.0, 7.0, -90.5, 8.0}, {2266.0, 3.0, 1.0, 8.0, -90.5, 8.0}, {2266.0, 3.0, 1.0, 10.0, -90.0, 8.0}, {2266.0, 3.0, 1.0, 10.5, -88.0, 8.0}, {2266.0, 3.0, 1.0, 11.0, -90.0, 8.0}, {2266.0, 3.0, 1.0, 13.0, -90.0, 8.0}, {2266.0, 3.0, 1.0, 15.0, -90.0, 8.0}, {2266.0, 3.0, 1.0, 18.0, -90.0, 8.0}, {2266.0, 3.0, 1.0, 23.0, -89.5, 8.0}, {2266.0, 3.0, 1.0, 26.0, -89.0, 8.0}, {2266.0, 3.0, 1.0, 28.0, -88.5, 8.0}, {2266.0, 3.0, 1.0, 32.0, -88.0, 8.0}, {2266.0, 3.0, 1.0, 38.0, -87.5, 8.0}, {2266.0, 3.0, 2.0, 6.0, -83.5, 14.5}, {2266.0, 3.0, 2.0, 7.0, -83.5, 14.5}, {2266.0, 3.0, 2.0, 8.0, -83.5, 14.5}, {2266.0, 3.0, 2.0, 10.0, -83.0, 14.5}, {2266.0, 3.0, 2.0, 10.5, -81.0, 14.5}, {2266.0, 3.0, 2.0, 11.0, -83.0, 14.5}, {2266.0, 3.0, 2.0, 13.0, -83.0, 14.5}, {2266.0, 3.0, 2.0, 15.0, -83.0, 14.5}, {2266.0, 3.0, 2.0, 18.0, -83.0, 14.5}, {2266.0, 3.0, 2.0, 23.0, -82.5, 14.5}, {2266.0, 3.0, 2.0, 26.0, -82.0, 14.5}, {2266.0, 3.0, 2.0, 28.0, -81.5, 14.5}, {2266.0, 3.0, 2.0, 32.0, -81.0, 14.5}, {2266.0, 3.0, 2.0, 38.0, -80.5, 14.5}, {2266.0, 3.0, 3.0, 6.0, -79.5, 17.5}, {2266.0, 3.0, 3.0, 7.0, -79.5, 17.5}, {2266.0, 3.0, 3.0, 8.0, -79.5, 17.5}, {2266.0, 3.0, 3.0, 10.0, -79.0, 17.5}, {2266.0, 3.0, 3.0, 10.5, -77.0, 17.5}, {2266.0, 3.0, 3.0, 11.0, -79.0, 17.5}, {2266.0, 3.0, 3.0, 13.0, -79.0, 17.5}, {2266.0, 3.0, 3.0, 15.0, -79.0, 17.5}, {2266.0, 3.0, 3.0, 18.0, -79.0, 17.5}, {2266.0, 3.0, 3.0, 23.0, -78.5, 17.5}, {2266.0, 3.0, 3.0, 26.0, -78.0, 17.5}, {2266.0, 3.0, 3.0, 28.0, -77.5, 17.5}, {2266.0, 3.0, 3.0, 32.0, -77.0, 17.5}, {2266.0, 3.0, 3.0, 38.0, -76.5, 17.5}, {2266.0, 3.0, 4.0, 6.0, -77.0, 20.8}, {2266.0, 3.0, 4.0, 7.0, -77.0, 20.8}, {2266.0, 3.0, 4.0, 8.0, -77.0, 20.8}, {2266.0, 3.0, 4.0, 10.0, -76.5, 20.8}, {2266.0, 3.0, 4.0, 10.5, -74.5, 20.8}, {2266.0, 3.0, 4.0, 11.0, -76.5, 20.8}, {2266.0, 3.0, 4.0, 13.0, -76.5, 20.8}, {2266.0, 3.0, 4.0, 15.0, -76.5, 20.8}, {2266.0, 3.0, 4.0, 18.0, -76.5, 20.8}, {2266.0, 3.0, 4.0, 23.0, -76.0, 20.8}, {2266.0, 3.0, 4.0, 26.0, -75.5, 20.8}, {2266.0, 3.0, 4.0, 28.0, -75.0, 20.8}, {2266.0, 3.0, 4.0, 32.0, -74.5, 20.8}, {2266.0, 3.0, 4.0, 38.0, -74.0, 20.8}, {2266.0, 3.0, 5.0, 6.0, -74.0, 23.7}, {2266.0, 3.0, 5.0, 7.0, -74.0, 23.7}, {2266.0, 3.0, 5.0, 8.0, -74.0, 23.7}, {2266.0, 3.0, 5.0, 10.0, -73.5, 23.7}, {2266.0, 3.0, 5.0, 10.5, -71.5, 23.7}, {2266.0, 3.0, 5.0, 11.0, -73.5, 23.7}, {2266.0, 3.0, 5.0, 13.0, -73.5, 23.7}, {2266.0, 3.0, 5.0, 15.0, -73.5, 23.7}, {2266.0, 3.0, 5.0, 18.0, -73.5, 23.7}, {2266.0, 3.0, 5.0, 23.0, -73.0, 23.7}, {2266.0, 3.0, 5.0, 26.0, -72.5, 23.7}, {2266.0, 3.0, 5.0, 28.0, -72.0, 23.7}, {2266.0, 3.0, 5.0, 32.0, -71.5, 23.7}, {2266.0, 3.0, 5.0, 38.0, -71.0, 23.7}, {2266.0, 3.0, 6.0, 6.0, -71.0, 26.8}, {2266.0, 3.0, 6.0, 7.0, -71.0, 26.8}, {2266.0, 3.0, 6.0, 8.0, -71.0, 26.8}, {2266.0, 3.0, 6.0, 10.0, -70.5, 26.8}, {2266.0, 3.0, 6.0, 10.5, -68.5, 26.8}, {2266.0, 3.0, 6.0, 11.0, -70.5, 26.8}, {2266.0, 3.0, 6.0, 13.0, -70.5, 26.8}, {2266.0, 3.0, 6.0, 15.0, -70.5, 26.8}, {2266.0, 3.0, 6.0, 18.0, -70.5, 26.8}, {2266.0, 3.0, 6.0, 23.0, -70.0, 26.8}, {2266.0, 3.0, 6.0, 26.0, -69.5, 26.8}, {2266.0, 3.0, 6.0, 28.0, -69.0, 26.8}, {2266.0, 3.0, 6.0, 32.0, -68.5, 26.8}, {2266.0, 3.0, 6.0, 38.0, -68.0, 26.8}, {2266.0, 4.0, 1.0, 6.0, -87.5, 7.8}, {2266.0, 4.0, 1.0, 7.0, -87.5, 7.8}, {2266.0, 4.0, 1.0, 8.0, -87.5, 7.8}, {2266.0, 4.0, 1.0, 10.0, -87.0, 7.8}, {2266.0, 4.0, 1.0, 10.5, -85.0, 7.8}, {2266.0, 4.0, 1.0, 11.0, -87.0, 7.8}, {2266.0, 4.0, 1.0, 13.0, -87.0, 7.8}, {2266.0, 4.0, 1.0, 15.0, -87.0, 7.8}, {2266.0, 4.0, 1.0, 18.0, -87.0, 7.8}, {2266.0, 4.0, 1.0, 23.0, -86.5, 7.8}, {2266.0, 4.0, 1.0, 26.0, -86.0, 7.8}, {2266.0, 4.0, 1.0, 28.0, -85.5, 7.8}, {2266.0, 4.0, 1.0, 32.0, -85.0, 7.8}, {2266.0, 4.0, 1.0, 38.0, -84.5, 7.8}, {2266.0, 4.0, 2.0, 6.0, -80.5, 14.5}, {2266.0, 4.0, 2.0, 7.0, -80.5, 14.5}, {2266.0, 4.0, 2.0, 8.0, -80.5, 14.5}, {2266.0, 4.0, 2.0, 10.0, -80.0, 14.5}, {2266.0, 4.0, 2.0, 10.5, -78.0, 14.5}, {2266.0, 4.0, 2.0, 11.0, -80.0, 14.5}, {2266.0, 4.0, 2.0, 13.0, -80.0, 14.5}, {2266.0, 4.0, 2.0, 15.0, -80.0, 14.5}, {2266.0, 4.0, 2.0, 18.0, -80.0, 14.5}, {2266.0, 4.0, 2.0, 23.0, -79.5, 14.5}, {2266.0, 4.0, 2.0, 26.0, -79.0, 14.5}, {2266.0, 4.0, 2.0, 28.0, -78.5, 14.5}, {2266.0, 4.0, 2.0, 32.0, -78.0, 14.5}, {2266.0, 4.0, 2.0, 38.0, -77.5, 14.5}, {2266.0, 4.0, 3.0, 6.0, -71.0, 18.0}, {2266.0, 4.0, 3.0, 7.0, -71.0, 18.0}, {2266.0, 4.0, 3.0, 8.0, -71.0, 18.0}, {2266.0, 4.0, 3.0, 10.0, -70.5, 18.0}, {2266.0, 4.0, 3.0, 10.5, -68.5, 18.0}, {2266.0, 4.0, 3.0, 11.0, -70.5, 18.0}, {2266.0, 4.0, 3.0, 13.0, -70.5, 18.0}, {2266.0, 4.0, 3.0, 15.0, -70.5, 18.0}, {2266.0, 4.0, 3.0, 18.0, -70.5, 18.0}, {2266.0, 4.0, 3.0, 23.0, -70.0, 18.0}, {2266.0, 4.0, 3.0, 26.0, -69.5, 18.0}, {2266.0, 4.0, 3.0, 28.0, -69.0, 18.0}, {2266.0, 4.0, 3.0, 32.0, -68.5, 18.0}, {2266.0, 4.0, 3.0, 38.0, -68.0, 18.0}, {2266.0, 4.0, 4.0, 6.0, -74.0, 20.8}, {2266.0, 4.0, 4.0, 7.0, -74.0, 20.8}, {2266.0, 4.0, 4.0, 8.0, -74.0, 20.8}, {2266.0, 4.0, 4.0, 10.0, -73.5, 20.8}, {2266.0, 4.0, 4.0, 10.5, -71.5, 20.8}, {2266.0, 4.0, 4.0, 11.0, -73.5, 20.8}, {2266.0, 4.0, 4.0, 13.0, -73.5, 20.8}, {2266.0, 4.0, 4.0, 15.0, -73.5, 20.8}, {2266.0, 4.0, 4.0, 18.0, -73.5, 20.8}, {2266.0, 4.0, 4.0, 23.0, -73.0, 20.8}, {2266.0, 4.0, 4.0, 26.0, -72.5, 20.8}, {2266.0, 4.0, 4.0, 28.0, -72.0, 20.8}, {2266.0, 4.0, 4.0, 32.0, -71.5, 20.8}, {2266.0, 4.0, 4.0, 38.0, -71.0, 20.8}, {2266.0, 4.0, 5.0, 6.0, -71.0, 23.7}, {2266.0, 4.0, 5.0, 7.0, -71.0, 23.7}, {2266.0, 4.0, 5.0, 8.0, -71.0, 23.7}, {2266.0, 4.0, 5.0, 10.0, -70.5, 23.7}, {2266.0, 4.0, 5.0, 10.5, -68.5, 23.7}, {2266.0, 4.0, 5.0, 11.0, -70.5, 23.7}, {2266.0, 4.0, 5.0, 13.0, -70.5, 23.7}, {2266.0, 4.0, 5.0, 15.0, -70.5, 23.7}, {2266.0, 4.0, 5.0, 18.0, -70.5, 23.7}, {2266.0, 4.0, 5.0, 23.0, -70.0, 23.7}, {2266.0, 4.0, 5.0, 26.0, -69.5, 23.7}, {2266.0, 4.0, 5.0, 28.0, -69.0, 23.7}, {2266.0, 4.0, 5.0, 32.0, -68.5, 23.7}, {2266.0, 4.0, 5.0, 38.0, -68.0, 23.7}, {2266.0, 4.0, 6.0, 6.0, -68.0, 27.1}, {2266.0, 4.0, 6.0, 7.0, -68.0, 27.1}, {2266.0, 4.0, 6.0, 8.0, -68.0, 27.1}, {2266.0, 4.0, 6.0, 10.0, -67.5, 27.1}, {2266.0, 4.0, 6.0, 10.5, -65.5, 27.1}, {2266.0, 4.0, 6.0, 11.0, -67.5, 27.1}, {2266.0, 4.0, 6.0, 13.0, -67.5, 27.1}, {2266.0, 4.0, 6.0, 15.0, -67.5, 27.1}, {2266.0, 4.0, 6.0, 18.0, -67.5, 27.1}, {2266.0, 4.0, 6.0, 23.0, -67.0, 27.1}, {2266.0, 4.0, 6.0, 26.0, -66.5, 27.1}, {2266.0, 4.0, 6.0, 28.0, -66.0, 27.1}, {2266.0, 4.0, 6.0, 32.0, -65.5, 27.1}, {2266.0, 4.0, 6.0, 38.0, -65.0, 27.1}, {2266.0, 6.0, 1.0, 6.0, -84.5, 7.8}, {2266.0, 6.0, 1.0, 7.0, -84.5, 7.8}, {2266.0, 6.0, 1.0, 8.0, -84.5, 7.8}, {2266.0, 6.0, 1.0, 10.0, -84.0, 7.8}, {2266.0, 6.0, 1.0, 10.5, -32768.0, 7.8}, {2266.0, 6.0, 1.0, 11.0, -84.0, 7.8}, {2266.0, 6.0, 1.0, 13.0, -84.0, 7.8}, {2266.0, 6.0, 1.0, 15.0, -84.0, 7.8}, {2266.0, 6.0, 1.0, 18.0, -84.0, 7.8}, {2266.0, 6.0, 1.0, 23.0, -83.5, 7.8}, {2266.0, 6.0, 1.0, 26.0, -83.0, 7.8}, {2266.0, 6.0, 1.0, 28.0, -82.5, 7.8}, {2266.0, 6.0, 1.0, 32.0, -82.0, 7.8}, {2266.0, 6.0, 1.0, 38.0, -81.5, 7.8}, {2266.0, 6.0, 2.0, 6.0, -77.5, 14.5}, {2266.0, 6.0, 2.0, 7.0, -77.5, 14.5}, {2266.0, 6.0, 2.0, 8.0, -77.5, 14.5}, {2266.0, 6.0, 2.0, 10.0, -77.0, 14.5}, {2266.0, 6.0, 2.0, 10.5, -32768.0, 14.5}, {2266.0, 6.0, 2.0, 11.0, -77.0, 14.5}, {2266.0, 6.0, 2.0, 13.0, -77.0, 14.5}, {2266.0, 6.0, 2.0, 15.0, -77.0, 14.5}, {2266.0, 6.0, 2.0, 18.0, -77.0, 14.5}, {2266.0, 6.0, 2.0, 23.0, -76.5, 14.5}, {2266.0, 6.0, 2.0, 26.0, -76.0, 14.5}, {2266.0, 6.0, 2.0, 28.0, -75.5, 14.5}, {2266.0, 6.0, 2.0, 32.0, -75.0, 14.5}, {2266.0, 6.0, 2.0, 38.0, -74.5, 14.5}, {2266.0, 6.0, 3.0, 6.0, -73.5, 17.5}, {2266.0, 6.0, 3.0, 7.0, -73.5, 17.5}, {2266.0, 6.0, 3.0, 8.0, -73.5, 17.5}, {2266.0, 6.0, 3.0, 10.0, -73.0, 17.5}, {2266.0, 6.0, 3.0, 10.5, -32768.0, 17.5}, {2266.0, 6.0, 3.0, 11.0, -73.0, 17.5}, {2266.0, 6.0, 3.0, 13.0, -73.0, 17.5}, {2266.0, 6.0, 3.0, 15.0, -73.0, 17.5}, {2266.0, 6.0, 3.0, 18.0, -73.0, 17.5}, {2266.0, 6.0, 3.0, 23.0, -72.5, 17.5}, {2266.0, 6.0, 3.0, 26.0, -72.0, 17.5}, {2266.0, 6.0, 3.0, 28.0, -71.5, 17.5}, {2266.0, 6.0, 3.0, 32.0, -71.0, 17.5}, {2266.0, 6.0, 3.0, 38.0, -70.5, 17.5}, {2266.0, 6.0, 4.0, 6.0, -71.0, 20.8}, {2266.0, 6.0, 4.0, 7.0, -71.0, 20.8}, {2266.0, 6.0, 4.0, 8.0, -71.0, 20.8}, {2266.0, 6.0, 4.0, 10.0, -70.5, 20.8}, {2266.0, 6.0, 4.0, 10.5, -32768.0, 20.8}, {2266.0, 6.0, 4.0, 11.0, -70.5, 20.8}, {2266.0, 6.0, 4.0, 13.0, -70.5, 20.8}, {2266.0, 6.0, 4.0, 15.0, -70.5, 20.8}, {2266.0, 6.0, 4.0, 18.0, -70.5, 20.8}, {2266.0, 6.0, 4.0, 23.0, -70.0, 20.8}, {2266.0, 6.0, 4.0, 26.0, -69.5, 20.8}, {2266.0, 6.0, 4.0, 28.0, -69.0, 20.8}, {2266.0, 6.0, 4.0, 32.0, -68.5, 20.8}, {2266.0, 6.0, 4.0, 38.0, -68.0, 20.8}, {2266.0, 6.0, 5.0, 6.0, -68.0, 23.7}, {2266.0, 6.0, 5.0, 7.0, -68.0, 23.7}, {2266.0, 6.0, 5.0, 8.0, -68.0, 23.7}, {2266.0, 6.0, 5.0, 10.0, -67.5, 23.7}, {2266.0, 6.0, 5.0, 10.5, -32768.0, 23.7}, {2266.0, 6.0, 5.0, 11.0, -67.5, 23.7}, {2266.0, 6.0, 5.0, 13.0, -67.5, 23.7}, {2266.0, 6.0, 5.0, 15.0, -67.5, 23.7}, {2266.0, 6.0, 5.0, 18.0, -67.5, 23.7}, {2266.0, 6.0, 5.0, 23.0, -67.0, 23.7}, {2266.0, 6.0, 5.0, 26.0, -66.5, 23.7}, {2266.0, 6.0, 5.0, 28.0, -66.0, 23.7}, {2266.0, 6.0, 5.0, 32.0, -65.5, 23.7}, {2266.0, 6.0, 5.0, 38.0, -65.0, 23.7}, {2266.0, 6.0, 6.0, 6.0, -65.0, 26.8}, {2266.0, 6.0, 6.0, 7.0, -65.0, 26.8}, {2266.0, 6.0, 6.0, 8.0, -65.0, 26.8}, {2266.0, 6.0, 6.0, 10.0, -64.5, 26.8}, {2266.0, 6.0, 6.0, 10.5, -32768.0, 26.8}, {2266.0, 6.0, 6.0, 11.0, -64.5, 26.8}, {2266.0, 6.0, 6.0, 13.0, -64.5, 26.8}, {2266.0, 6.0, 6.0, 15.0, -64.5, 26.8}, {2266.0, 6.0, 6.0, 18.0, -64.5, 26.8}, {2266.0, 6.0, 6.0, 23.0, -64.0, 26.8}, {2266.0, 6.0, 6.0, 26.0, -63.5, 26.8}, {2266.0, 6.0, 6.0, 28.0, -63.0, 26.8}, {2266.0, 6.0, 6.0, 32.0, -62.5, 26.8}, {2266.0, 6.0, 6.0, 38.0, -62.0, 26.8}, {2266.0, 5.0, 1.0, 6.0, -86.0, 7.8}, {2266.0, 5.0, 1.0, 7.0, -86.0, 7.8}, {2266.0, 5.0, 1.0, 8.0, -86.0, 7.8}, {2266.0, 5.0, 1.0, 10.0, -85.5, 7.8}, {2266.0, 5.0, 1.0, 10.5, -32768.0, 7.8}, {2266.0, 5.0, 1.0, 11.0, -85.5, 7.8}, {2266.0, 5.0, 1.0, 13.0, -85.5, 7.8}, {2266.0, 5.0, 1.0, 15.0, -85.5, 7.8}, {2266.0, 5.0, 1.0, 18.0, -85.5, 7.8}, {2266.0, 5.0, 1.0, 23.0, -85.0, 7.8}, {2266.0, 5.0, 1.0, 26.0, -84.5, 7.8}, {2266.0, 5.0, 1.0, 28.0, -84.0, 7.8}, {2266.0, 5.0, 1.0, 32.0, -83.5, 7.8}, {2266.0, 5.0, 1.0, 38.0, -83.0, 7.8}, {2266.0, 5.0, 2.0, 6.0, -79.0, 14.5}, {2266.0, 5.0, 2.0, 7.0, -79.0, 14.5}, {2266.0, 5.0, 2.0, 8.0, -79.0, 14.5}, {2266.0, 5.0, 2.0, 10.0, -78.5, 14.5}, {2266.0, 5.0, 2.0, 10.5, -32768.0, 14.5}, {2266.0, 5.0, 2.0, 11.0, -78.5, 14.5}, {2266.0, 5.0, 2.0, 13.0, -78.5, 14.5}, {2266.0, 5.0, 2.0, 15.0, -78.5, 14.5}, {2266.0, 5.0, 2.0, 18.0, -78.5, 14.5}, {2266.0, 5.0, 2.0, 23.0, -78.0, 14.5}, {2266.0, 5.0, 2.0, 26.0, -77.5, 14.5}, {2266.0, 5.0, 2.0, 28.0, -77.0, 14.5}, {2266.0, 5.0, 2.0, 32.0, -76.5, 14.5}, {2266.0, 5.0, 2.0, 38.0, -76.0, 14.5}, {2266.0, 5.0, 3.0, 6.0, -75.0, 18.0}, {2266.0, 5.0, 3.0, 7.0, -75.0, 18.0}, {2266.0, 5.0, 3.0, 8.0, -75.0, 18.0}, {2266.0, 5.0, 3.0, 10.0, -74.5, 18.0}, {2266.0, 5.0, 3.0, 10.5, -32768.0, 18.0}, {2266.0, 5.0, 3.0, 11.0, -74.5, 18.0}, {2266.0, 5.0, 3.0, 13.0, -74.5, 18.0}, {2266.0, 5.0, 3.0, 15.0, -74.5, 18.0}, {2266.0, 5.0, 3.0, 18.0, -74.5, 18.0}, {2266.0, 5.0, 3.0, 23.0, -74.0, 18.0}, {2266.0, 5.0, 3.0, 26.0, -73.5, 18.0}, {2266.0, 5.0, 3.0, 28.0, -73.0, 18.0}, {2266.0, 5.0, 3.0, 32.0, -72.5, 18.0}, {2266.0, 5.0, 3.0, 38.0, -72.0, 18.0}, {2266.0, 5.0, 4.0, 6.0, -72.5, 20.8}, {2266.0, 5.0, 4.0, 7.0, -72.5, 20.8}, {2266.0, 5.0, 4.0, 8.0, -72.5, 20.8}, {2266.0, 5.0, 4.0, 10.0, -72.0, 20.8}, {2266.0, 5.0, 4.0, 10.5, -32768.0, 20.8}, {2266.0, 5.0, 4.0, 11.0, -72.0, 20.8}, {2266.0, 5.0, 4.0, 13.0, -72.0, 20.8}, {2266.0, 5.0, 4.0, 15.0, -72.0, 20.8}, {2266.0, 5.0, 4.0, 18.0, -72.0, 20.8}, {2266.0, 5.0, 4.0, 23.0, -71.5, 20.8}, {2266.0, 5.0, 4.0, 26.0, -71.0, 20.8}, {2266.0, 5.0, 4.0, 28.0, -70.5, 20.8}, {2266.0, 5.0, 4.0, 32.0, -70.0, 20.8}, {2266.0, 5.0, 4.0, 38.0, -69.5, 20.8}, {2266.0, 5.0, 5.0, 6.0, -69.5, 24.0}, {2266.0, 5.0, 5.0, 7.0, -69.5, 24.0}, {2266.0, 5.0, 5.0, 8.0, -69.5, 24.0}, {2266.0, 5.0, 5.0, 10.0, -69.0, 24.0}, {2266.0, 5.0, 5.0, 10.5, -32768.0, 24.0}, {2266.0, 5.0, 5.0, 11.0, -69.0, 24.0}, {2266.0, 5.0, 5.0, 13.0, -69.0, 24.0}, {2266.0, 5.0, 5.0, 15.0, -69.0, 24.0}, {2266.0, 5.0, 5.0, 18.0, -69.0, 24.0}, {2266.0, 5.0, 5.0, 23.0, -68.5, 24.0}, {2266.0, 5.0, 5.0, 26.0, -68.0, 24.0}, {2266.0, 5.0, 5.0, 28.0, -67.5, 24.0}, {2266.0, 5.0, 5.0, 32.0, -67.0, 24.0}, {2266.0, 5.0, 5.0, 38.0, -66.5, 24.0}, {2266.0, 5.0, 6.0, 6.0, -66.5, 27.1}, {2266.0, 5.0, 6.0, 7.0, -66.5, 27.1}, {2266.0, 5.0, 6.0, 8.0, -66.5, 27.1}, {2266.0, 5.0, 6.0, 10.0, -66.0, 27.1}, {2266.0, 5.0, 6.0, 10.5, -32768.0, 27.1}, {2266.0, 5.0, 6.0, 11.0, -66.0, 27.1}, {2266.0, 5.0, 6.0, 13.0, -66.0, 27.1}, {2266.0, 5.0, 6.0, 15.0, -66.0, 27.1}, {2266.0, 5.0, 6.0, 18.0, -66.0, 27.1}, {2266.0, 5.0, 6.0, 23.0, -65.5, 27.1}, {2266.0, 5.0, 6.0, 26.0, -65.0, 27.1}, {2266.0, 5.0, 6.0, 28.0, -64.5, 27.1}, {2266.0, 5.0, 6.0, 32.0, -64.0, 27.1}, {2266.0, 5.0, 6.0, 38.0, -63.5, 27.1}, {2267.0, 2.0, 1.0, 6.0, -92.5, 9.2}, {2267.0, 2.0, 1.0, 7.0, -92.5, 9.2}, {2267.0, 2.0, 1.0, 8.0, -92.5, 9.2}, {2267.0, 2.0, 1.0, 10.0, -92.0, 9.2}, {2267.0, 2.0, 1.0, 10.5, -90.0, 9.2}, {2267.0, 2.0, 1.0, 11.0, -92.0, 9.2}, {2267.0, 2.0, 1.0, 13.0, -92.0, 9.2}, {2267.0, 2.0, 1.0, 15.0, -92.0, 9.2}, {2267.0, 2.0, 1.0, 18.0, -92.0, 9.2}, {2267.0, 2.0, 1.0, 23.0, -91.5, 9.2}, {2267.0, 2.0, 1.0, 26.0, -91.0, 9.2}, {2267.0, 2.0, 1.0, 28.0, -90.5, 9.2}, {2267.0, 2.0, 1.0, 32.0, -90.0, 9.2}, {2267.0, 2.0, 1.0, 38.0, -89.5, 9.2}, {2267.0, 2.0, 2.0, 6.0, -86.5, 15.2}, {2267.0, 2.0, 2.0, 7.0, -86.5, 15.2}, {2267.0, 2.0, 2.0, 8.0, -86.5, 15.2}, {2267.0, 2.0, 2.0, 10.0, -86.0, 15.2}, {2267.0, 2.0, 2.0, 10.5, -84.0, 15.2}, {2267.0, 2.0, 2.0, 11.0, -86.0, 15.2}, {2267.0, 2.0, 2.0, 13.0, -86.0, 15.2}, {2267.0, 2.0, 2.0, 15.0, -86.0, 15.2}, {2267.0, 2.0, 2.0, 18.0, -86.0, 15.2}, {2267.0, 2.0, 2.0, 23.0, -85.5, 15.2}, {2267.0, 2.0, 2.0, 26.0, -85.0, 15.2}, {2267.0, 2.0, 2.0, 28.0, -84.5, 15.2}, {2267.0, 2.0, 2.0, 32.0, -84.0, 15.2}, {2267.0, 2.0, 2.0, 38.0, -83.5, 15.2}, {2267.0, 2.0, 3.0, 6.0, -82.5, 17.5}, {2267.0, 2.0, 3.0, 7.0, -82.5, 17.5}, {2267.0, 2.0, 3.0, 8.0, -82.5, 17.5}, {2267.0, 2.0, 3.0, 10.0, -82.0, 17.5}, {2267.0, 2.0, 3.0, 10.5, -80.0, 17.5}, {2267.0, 2.0, 3.0, 11.0, -82.0, 17.5}, {2267.0, 2.0, 3.0, 13.0, -82.0, 17.5}, {2267.0, 2.0, 3.0, 15.0, -82.0, 17.5}, {2267.0, 2.0, 3.0, 18.0, -82.0, 17.5}, {2267.0, 2.0, 3.0, 23.0, -81.5, 17.5}, {2267.0, 2.0, 3.0, 26.0, -81.0, 17.5}, {2267.0, 2.0, 3.0, 28.0, -80.5, 17.5}, {2267.0, 2.0, 3.0, 32.0, -80.0, 17.5}, {2267.0, 2.0, 3.0, 38.0, -79.5, 17.5}, {2267.0, 2.0, 4.0, 6.0, -80.0, 20.8}, {2267.0, 2.0, 4.0, 7.0, -80.0, 20.8}, {2267.0, 2.0, 4.0, 8.0, -80.0, 20.8}, {2267.0, 2.0, 4.0, 10.0, -79.5, 20.8}, {2267.0, 2.0, 4.0, 10.5, -77.5, 20.8}, {2267.0, 2.0, 4.0, 11.0, -79.5, 20.8}, {2267.0, 2.0, 4.0, 13.0, -79.5, 20.8}, {2267.0, 2.0, 4.0, 15.0, -79.5, 20.8}, {2267.0, 2.0, 4.0, 18.0, -79.5, 20.8}, {2267.0, 2.0, 4.0, 23.0, -79.0, 20.8}, {2267.0, 2.0, 4.0, 26.0, -78.5, 20.8}, {2267.0, 2.0, 4.0, 28.0, -78.0, 20.8}, {2267.0, 2.0, 4.0, 32.0, -77.5, 20.8}, {2267.0, 2.0, 4.0, 38.0, -77.0, 20.8}, {2267.0, 2.0, 5.0, 6.0, -77.0, 23.7}, {2267.0, 2.0, 5.0, 7.0, -77.0, 23.7}, {2267.0, 2.0, 5.0, 8.0, -77.0, 23.7}, {2267.0, 2.0, 5.0, 10.0, -76.5, 23.7}, {2267.0, 2.0, 5.0, 10.5, -74.5, 23.7}, {2267.0, 2.0, 5.0, 11.0, -76.5, 23.7}, {2267.0, 2.0, 5.0, 13.0, -76.5, 23.7}, {2267.0, 2.0, 5.0, 15.0, -76.5, 23.7}, {2267.0, 2.0, 5.0, 18.0, -76.5, 23.7}, {2267.0, 2.0, 5.0, 23.0, -76.0, 23.7}, {2267.0, 2.0, 5.0, 26.0, -75.5, 23.7}, {2267.0, 2.0, 5.0, 28.0, -75.0, 23.7}, {2267.0, 2.0, 5.0, 32.0, -74.5, 23.7}, {2267.0, 2.0, 5.0, 38.0, -74.0, 23.7}, {2267.0, 2.0, 6.0, 6.0, -74.0, 26.8}, {2267.0, 2.0, 6.0, 7.0, -74.0, 26.8}, {2267.0, 2.0, 6.0, 8.0, -74.0, 26.8}, {2267.0, 2.0, 6.0, 10.0, -73.5, 26.8}, {2267.0, 2.0, 6.0, 10.5, -71.5, 26.8}, {2267.0, 2.0, 6.0, 11.0, -73.5, 26.8}, {2267.0, 2.0, 6.0, 13.0, -73.5, 26.8}, {2267.0, 2.0, 6.0, 15.0, -73.5, 26.8}, {2267.0, 2.0, 6.0, 18.0, -73.5, 26.8}, {2267.0, 2.0, 6.0, 23.0, -73.0, 26.8}, {2267.0, 2.0, 6.0, 26.0, -72.5, 26.8}, {2267.0, 2.0, 6.0, 28.0, -72.0, 26.8}, {2267.0, 2.0, 6.0, 32.0, -71.5, 26.8}, {2267.0, 2.0, 6.0, 38.0, -71.0, 26.8}, {2267.0, 3.0, 1.0, 6.0, -90.5, 8.0}, {2267.0, 3.0, 1.0, 7.0, -90.5, 8.0}, {2267.0, 3.0, 1.0, 8.0, -90.5, 8.0}, {2267.0, 3.0, 1.0, 10.0, -90.0, 8.0}, {2267.0, 3.0, 1.0, 10.5, -88.0, 8.0}, {2267.0, 3.0, 1.0, 11.0, -90.0, 8.0}, {2267.0, 3.0, 1.0, 13.0, -90.0, 8.0}, {2267.0, 3.0, 1.0, 15.0, -90.0, 8.0}, {2267.0, 3.0, 1.0, 18.0, -90.0, 8.0}, {2267.0, 3.0, 1.0, 23.0, -89.5, 8.0}, {2267.0, 3.0, 1.0, 26.0, -89.0, 8.0}, {2267.0, 3.0, 1.0, 28.0, -88.5, 8.0}, {2267.0, 3.0, 1.0, 32.0, -88.0, 8.0}, {2267.0, 3.0, 1.0, 38.0, -87.5, 8.0}, {2267.0, 3.0, 2.0, 6.0, -83.5, 14.5}, {2267.0, 3.0, 2.0, 7.0, -83.5, 14.5}, {2267.0, 3.0, 2.0, 8.0, -83.5, 14.5}, {2267.0, 3.0, 2.0, 10.0, -83.0, 14.5}, {2267.0, 3.0, 2.0, 10.5, -81.0, 14.5}, {2267.0, 3.0, 2.0, 11.0, -83.0, 14.5}, {2267.0, 3.0, 2.0, 13.0, -83.0, 14.5}, {2267.0, 3.0, 2.0, 15.0, -83.0, 14.5}, {2267.0, 3.0, 2.0, 18.0, -83.0, 14.5}, {2267.0, 3.0, 2.0, 23.0, -82.5, 14.5}, {2267.0, 3.0, 2.0, 26.0, -82.0, 14.5}, {2267.0, 3.0, 2.0, 28.0, -81.5, 14.5}, {2267.0, 3.0, 2.0, 32.0, -81.0, 14.5}, {2267.0, 3.0, 2.0, 38.0, -80.5, 14.5}, {2267.0, 3.0, 3.0, 6.0, -79.5, 17.5}, {2267.0, 3.0, 3.0, 7.0, -79.5, 17.5}, {2267.0, 3.0, 3.0, 8.0, -79.5, 17.5}, {2267.0, 3.0, 3.0, 10.0, -79.0, 17.5}, {2267.0, 3.0, 3.0, 10.5, -77.0, 17.5}, {2267.0, 3.0, 3.0, 11.0, -79.0, 17.5}, {2267.0, 3.0, 3.0, 13.0, -79.0, 17.5}, {2267.0, 3.0, 3.0, 15.0, -79.0, 17.5}, {2267.0, 3.0, 3.0, 18.0, -79.0, 17.5}, {2267.0, 3.0, 3.0, 23.0, -78.5, 17.5}, {2267.0, 3.0, 3.0, 26.0, -78.0, 17.5}, {2267.0, 3.0, 3.0, 28.0, -77.5, 17.5}, {2267.0, 3.0, 3.0, 32.0, -77.0, 17.5}, {2267.0, 3.0, 3.0, 38.0, -76.5, 17.5}, {2267.0, 3.0, 4.0, 6.0, -77.0, 20.8}, {2267.0, 3.0, 4.0, 7.0, -77.0, 20.8}, {2267.0, 3.0, 4.0, 8.0, -77.0, 20.8}, {2267.0, 3.0, 4.0, 10.0, -76.5, 20.8}, {2267.0, 3.0, 4.0, 10.5, -74.5, 20.8}, {2267.0, 3.0, 4.0, 11.0, -76.5, 20.8}, {2267.0, 3.0, 4.0, 13.0, -76.5, 20.8}, {2267.0, 3.0, 4.0, 15.0, -76.5, 20.8}, {2267.0, 3.0, 4.0, 18.0, -76.5, 20.8}, {2267.0, 3.0, 4.0, 23.0, -76.0, 20.8}, {2267.0, 3.0, 4.0, 26.0, -75.5, 20.8}, {2267.0, 3.0, 4.0, 28.0, -75.0, 20.8}, {2267.0, 3.0, 4.0, 32.0, -74.5, 20.8}, {2267.0, 3.0, 4.0, 38.0, -74.0, 20.8}, {2267.0, 3.0, 5.0, 6.0, -74.0, 23.7}, {2267.0, 3.0, 5.0, 7.0, -74.0, 23.7}, {2267.0, 3.0, 5.0, 8.0, -74.0, 23.7}, {2267.0, 3.0, 5.0, 10.0, -73.5, 23.7}, {2267.0, 3.0, 5.0, 10.5, -71.5, 23.7}, {2267.0, 3.0, 5.0, 11.0, -73.5, 23.7}, {2267.0, 3.0, 5.0, 13.0, -73.5, 23.7}, {2267.0, 3.0, 5.0, 15.0, -73.5, 23.7}, {2267.0, 3.0, 5.0, 18.0, -73.5, 23.7}, {2267.0, 3.0, 5.0, 23.0, -73.0, 23.7}, {2267.0, 3.0, 5.0, 26.0, -72.5, 23.7}, {2267.0, 3.0, 5.0, 28.0, -72.0, 23.7}, {2267.0, 3.0, 5.0, 32.0, -71.5, 23.7}, {2267.0, 3.0, 5.0, 38.0, -71.0, 23.7}, {2267.0, 3.0, 6.0, 6.0, -71.0, 26.8}, {2267.0, 3.0, 6.0, 7.0, -71.0, 26.8}, {2267.0, 3.0, 6.0, 8.0, -71.0, 26.8}, {2267.0, 3.0, 6.0, 10.0, -70.5, 26.8}, {2267.0, 3.0, 6.0, 10.5, -68.5, 26.8}, {2267.0, 3.0, 6.0, 11.0, -70.5, 26.8}, {2267.0, 3.0, 6.0, 13.0, -70.5, 26.8}, {2267.0, 3.0, 6.0, 15.0, -70.5, 26.8}, {2267.0, 3.0, 6.0, 18.0, -70.5, 26.8}, {2267.0, 3.0, 6.0, 23.0, -70.0, 26.8}, {2267.0, 3.0, 6.0, 26.0, -69.5, 26.8}, {2267.0, 3.0, 6.0, 28.0, -69.0, 26.8}, {2267.0, 3.0, 6.0, 32.0, -68.5, 26.8}, {2267.0, 3.0, 6.0, 38.0, -68.0, 26.8}, {2267.0, 4.0, 1.0, 6.0, -87.5, 7.8}, {2267.0, 4.0, 1.0, 7.0, -87.5, 7.8}, {2267.0, 4.0, 1.0, 8.0, -87.5, 7.8}, {2267.0, 4.0, 1.0, 10.0, -87.0, 7.8}, {2267.0, 4.0, 1.0, 10.5, -85.0, 7.8}, {2267.0, 4.0, 1.0, 11.0, -87.0, 7.8}, {2267.0, 4.0, 1.0, 13.0, -87.0, 7.8}, {2267.0, 4.0, 1.0, 15.0, -87.0, 7.8}, {2267.0, 4.0, 1.0, 18.0, -87.0, 7.8}, {2267.0, 4.0, 1.0, 23.0, -86.5, 7.8}, {2267.0, 4.0, 1.0, 26.0, -86.0, 7.8}, {2267.0, 4.0, 1.0, 28.0, -85.5, 7.8}, {2267.0, 4.0, 1.0, 32.0, -85.0, 7.8}, {2267.0, 4.0, 1.0, 38.0, -84.5, 7.8}, {2267.0, 4.0, 2.0, 6.0, -80.5, 14.5}, {2267.0, 4.0, 2.0, 7.0, -80.5, 14.5}, {2267.0, 4.0, 2.0, 8.0, -80.5, 14.5}, {2267.0, 4.0, 2.0, 10.0, -80.0, 14.5}, {2267.0, 4.0, 2.0, 10.5, -78.0, 14.5}, {2267.0, 4.0, 2.0, 11.0, -80.0, 14.5}, {2267.0, 4.0, 2.0, 13.0, -80.0, 14.5}, {2267.0, 4.0, 2.0, 15.0, -80.0, 14.5}, {2267.0, 4.0, 2.0, 18.0, -80.0, 14.5}, {2267.0, 4.0, 2.0, 23.0, -79.5, 14.5}, {2267.0, 4.0, 2.0, 26.0, -79.0, 14.5}, {2267.0, 4.0, 2.0, 28.0, -78.5, 14.5}, {2267.0, 4.0, 2.0, 32.0, -78.0, 14.5}, {2267.0, 4.0, 2.0, 38.0, -77.5, 14.5}, {2267.0, 4.0, 3.0, 6.0, -71.0, 18.0}, {2267.0, 4.0, 3.0, 7.0, -71.0, 18.0}, {2267.0, 4.0, 3.0, 8.0, -71.0, 18.0}, {2267.0, 4.0, 3.0, 10.0, -70.5, 18.0}, {2267.0, 4.0, 3.0, 10.5, -68.5, 18.0}, {2267.0, 4.0, 3.0, 11.0, -70.5, 18.0}, {2267.0, 4.0, 3.0, 13.0, -70.5, 18.0}, {2267.0, 4.0, 3.0, 15.0, -70.5, 18.0}, {2267.0, 4.0, 3.0, 18.0, -70.5, 18.0}, {2267.0, 4.0, 3.0, 23.0, -70.0, 18.0}, {2267.0, 4.0, 3.0, 26.0, -69.5, 18.0}, {2267.0, 4.0, 3.0, 28.0, -69.0, 18.0}, {2267.0, 4.0, 3.0, 32.0, -68.5, 18.0}, {2267.0, 4.0, 3.0, 38.0, -68.0, 18.0}, {2267.0, 4.0, 4.0, 6.0, -74.0, 20.8}, {2267.0, 4.0, 4.0, 7.0, -74.0, 20.8}, {2267.0, 4.0, 4.0, 8.0, -74.0, 20.8}, {2267.0, 4.0, 4.0, 10.0, -73.5, 20.8}, {2267.0, 4.0, 4.0, 10.5, -71.5, 20.8}, {2267.0, 4.0, 4.0, 11.0, -73.5, 20.8}, {2267.0, 4.0, 4.0, 13.0, -73.5, 20.8}, {2267.0, 4.0, 4.0, 15.0, -73.5, 20.8}, {2267.0, 4.0, 4.0, 18.0, -73.5, 20.8}, {2267.0, 4.0, 4.0, 23.0, -73.0, 20.8}, {2267.0, 4.0, 4.0, 26.0, -72.5, 20.8}, {2267.0, 4.0, 4.0, 28.0, -72.0, 20.8}, {2267.0, 4.0, 4.0, 32.0, -71.5, 20.8}, {2267.0, 4.0, 4.0, 38.0, -71.0, 20.8}, {2267.0, 4.0, 5.0, 6.0, -71.0, 23.7}, {2267.0, 4.0, 5.0, 7.0, -71.0, 23.7}, {2267.0, 4.0, 5.0, 8.0, -71.0, 23.7}, {2267.0, 4.0, 5.0, 10.0, -70.5, 23.7}, {2267.0, 4.0, 5.0, 10.5, -68.5, 23.7}, {2267.0, 4.0, 5.0, 11.0, -70.5, 23.7}, {2267.0, 4.0, 5.0, 13.0, -70.5, 23.7}, {2267.0, 4.0, 5.0, 15.0, -70.5, 23.7}, {2267.0, 4.0, 5.0, 18.0, -70.5, 23.7}, {2267.0, 4.0, 5.0, 23.0, -70.0, 23.7}, {2267.0, 4.0, 5.0, 26.0, -69.5, 23.7}, {2267.0, 4.0, 5.0, 28.0, -69.0, 23.7}, {2267.0, 4.0, 5.0, 32.0, -68.5, 23.7}, {2267.0, 4.0, 5.0, 38.0, -68.0, 23.7}, {2267.0, 4.0, 6.0, 6.0, -68.0, 27.1}, {2267.0, 4.0, 6.0, 7.0, -68.0, 27.1}, {2267.0, 4.0, 6.0, 8.0, -68.0, 27.1}, {2267.0, 4.0, 6.0, 10.0, -67.5, 27.1}, {2267.0, 4.0, 6.0, 10.5, -65.5, 27.1}, {2267.0, 4.0, 6.0, 11.0, -67.5, 27.1}, {2267.0, 4.0, 6.0, 13.0, -67.5, 27.1}, {2267.0, 4.0, 6.0, 15.0, -67.5, 27.1}, {2267.0, 4.0, 6.0, 18.0, -67.5, 27.1}, {2267.0, 4.0, 6.0, 23.0, -67.0, 27.1}, {2267.0, 4.0, 6.0, 26.0, -66.5, 27.1}, {2267.0, 4.0, 6.0, 28.0, -66.0, 27.1}, {2267.0, 4.0, 6.0, 32.0, -65.5, 27.1}, {2267.0, 4.0, 6.0, 38.0, -65.0, 27.1}, {2267.0, 6.0, 1.0, 6.0, -84.5, 7.8}, {2267.0, 6.0, 1.0, 7.0, -84.5, 7.8}, {2267.0, 6.0, 1.0, 8.0, -84.5, 7.8}, {2267.0, 6.0, 1.0, 10.0, -84.0, 7.8}, {2267.0, 6.0, 1.0, 10.5, -32768.0, 7.8}, {2267.0, 6.0, 1.0, 11.0, -84.0, 7.8}, {2267.0, 6.0, 1.0, 13.0, -84.0, 7.8}, {2267.0, 6.0, 1.0, 15.0, -84.0, 7.8}, {2267.0, 6.0, 1.0, 18.0, -84.0, 7.8}, {2267.0, 6.0, 1.0, 23.0, -83.5, 7.8}, {2267.0, 6.0, 1.0, 26.0, -83.0, 7.8}, {2267.0, 6.0, 1.0, 28.0, -82.5, 7.8}, {2267.0, 6.0, 1.0, 32.0, -82.0, 7.8}, {2267.0, 6.0, 1.0, 38.0, -81.5, 7.8}, {2267.0, 6.0, 2.0, 6.0, -77.5, 14.5}, {2267.0, 6.0, 2.0, 7.0, -77.5, 14.5}, {2267.0, 6.0, 2.0, 8.0, -77.5, 14.5}, {2267.0, 6.0, 2.0, 10.0, -77.0, 14.5}, {2267.0, 6.0, 2.0, 10.5, -32768.0, 14.5}, {2267.0, 6.0, 2.0, 11.0, -77.0, 14.5}, {2267.0, 6.0, 2.0, 13.0, -77.0, 14.5}, {2267.0, 6.0, 2.0, 15.0, -77.0, 14.5}, {2267.0, 6.0, 2.0, 18.0, -77.0, 14.5}, {2267.0, 6.0, 2.0, 23.0, -76.5, 14.5}, {2267.0, 6.0, 2.0, 26.0, -76.0, 14.5}, {2267.0, 6.0, 2.0, 28.0, -75.5, 14.5}, {2267.0, 6.0, 2.0, 32.0, -75.0, 14.5}, {2267.0, 6.0, 2.0, 38.0, -74.5, 14.5}, {2267.0, 6.0, 3.0, 6.0, -73.5, 17.5}, {2267.0, 6.0, 3.0, 7.0, -73.5, 17.5}, {2267.0, 6.0, 3.0, 8.0, -73.5, 17.5}, {2267.0, 6.0, 3.0, 10.0, -73.0, 17.5}, {2267.0, 6.0, 3.0, 10.5, -32768.0, 17.5}, {2267.0, 6.0, 3.0, 11.0, -73.0, 17.5}, {2267.0, 6.0, 3.0, 13.0, -73.0, 17.5}, {2267.0, 6.0, 3.0, 15.0, -73.0, 17.5}, {2267.0, 6.0, 3.0, 18.0, -73.0, 17.5}, {2267.0, 6.0, 3.0, 23.0, -72.5, 17.5}, {2267.0, 6.0, 3.0, 26.0, -72.0, 17.5}, {2267.0, 6.0, 3.0, 28.0, -71.5, 17.5}, {2267.0, 6.0, 3.0, 32.0, -71.0, 17.5}, {2267.0, 6.0, 3.0, 38.0, -70.5, 17.5}, {2267.0, 6.0, 4.0, 6.0, -71.0, 20.8}, {2267.0, 6.0, 4.0, 7.0, -71.0, 20.8}, {2267.0, 6.0, 4.0, 8.0, -71.0, 20.8}, {2267.0, 6.0, 4.0, 10.0, -70.5, 20.8}, {2267.0, 6.0, 4.0, 10.5, -32768.0, 20.8}, {2267.0, 6.0, 4.0, 11.0, -70.5, 20.8}, {2267.0, 6.0, 4.0, 13.0, -70.5, 20.8}, {2267.0, 6.0, 4.0, 15.0, -70.5, 20.8}, {2267.0, 6.0, 4.0, 18.0, -70.5, 20.8}, {2267.0, 6.0, 4.0, 23.0, -70.0, 20.8}, {2267.0, 6.0, 4.0, 26.0, -69.5, 20.8}, {2267.0, 6.0, 4.0, 28.0, -69.0, 20.8}, {2267.0, 6.0, 4.0, 32.0, -68.5, 20.8}, {2267.0, 6.0, 4.0, 38.0, -68.0, 20.8}, {2267.0, 6.0, 5.0, 6.0, -68.0, 23.7}, {2267.0, 6.0, 5.0, 7.0, -68.0, 23.7}, {2267.0, 6.0, 5.0, 8.0, -68.0, 23.7}, {2267.0, 6.0, 5.0, 10.0, -67.5, 23.7}, {2267.0, 6.0, 5.0, 10.5, -32768.0, 23.7}, {2267.0, 6.0, 5.0, 11.0, -67.5, 23.7}, {2267.0, 6.0, 5.0, 13.0, -67.5, 23.7}, {2267.0, 6.0, 5.0, 15.0, -67.5, 23.7}, {2267.0, 6.0, 5.0, 18.0, -67.5, 23.7}, {2267.0, 6.0, 5.0, 23.0, -67.0, 23.7}, {2267.0, 6.0, 5.0, 26.0, -66.5, 23.7}, {2267.0, 6.0, 5.0, 28.0, -66.0, 23.7}, {2267.0, 6.0, 5.0, 32.0, -65.5, 23.7}, {2267.0, 6.0, 5.0, 38.0, -65.0, 23.7}, {2267.0, 6.0, 6.0, 6.0, -65.0, 26.8}, {2267.0, 6.0, 6.0, 7.0, -65.0, 26.8}, {2267.0, 6.0, 6.0, 8.0, -65.0, 26.8}, {2267.0, 6.0, 6.0, 10.0, -64.5, 26.8}, {2267.0, 6.0, 6.0, 10.5, -32768.0, 26.8}, {2267.0, 6.0, 6.0, 11.0, -64.5, 26.8}, {2267.0, 6.0, 6.0, 13.0, -64.5, 26.8}, {2267.0, 6.0, 6.0, 15.0, -64.5, 26.8}, {2267.0, 6.0, 6.0, 18.0, -64.5, 26.8}, {2267.0, 6.0, 6.0, 23.0, -64.0, 26.8}, {2267.0, 6.0, 6.0, 26.0, -63.5, 26.8}, {2267.0, 6.0, 6.0, 28.0, -63.0, 26.8}, {2267.0, 6.0, 6.0, 32.0, -62.5, 26.8}, {2267.0, 6.0, 6.0, 38.0, -62.0, 26.8}, {2267.0, 5.0, 1.0, 6.0, -86.0, 7.8}, {2267.0, 5.0, 1.0, 7.0, -86.0, 7.8}, {2267.0, 5.0, 1.0, 8.0, -86.0, 7.8}, {2267.0, 5.0, 1.0, 10.0, -85.5, 7.8}, {2267.0, 5.0, 1.0, 10.5, -32768.0, 7.8}, {2267.0, 5.0, 1.0, 11.0, -85.5, 7.8}, {2267.0, 5.0, 1.0, 13.0, -85.5, 7.8}, {2267.0, 5.0, 1.0, 15.0, -85.5, 7.8}, {2267.0, 5.0, 1.0, 18.0, -85.5, 7.8}, {2267.0, 5.0, 1.0, 23.0, -85.0, 7.8}, {2267.0, 5.0, 1.0, 26.0, -84.5, 7.8}, {2267.0, 5.0, 1.0, 28.0, -84.0, 7.8}, {2267.0, 5.0, 1.0, 32.0, -83.5, 7.8}, {2267.0, 5.0, 1.0, 38.0, -83.0, 7.8}, {2267.0, 5.0, 2.0, 6.0, -79.0, 14.5}, {2267.0, 5.0, 2.0, 7.0, -79.0, 14.5}, {2267.0, 5.0, 2.0, 8.0, -79.0, 14.5}, {2267.0, 5.0, 2.0, 10.0, -78.5, 14.5}, {2267.0, 5.0, 2.0, 10.5, -32768.0, 14.5}, {2267.0, 5.0, 2.0, 11.0, -78.5, 14.5}, {2267.0, 5.0, 2.0, 13.0, -78.5, 14.5}, {2267.0, 5.0, 2.0, 15.0, -78.5, 14.5}, {2267.0, 5.0, 2.0, 18.0, -78.5, 14.5}, {2267.0, 5.0, 2.0, 23.0, -78.0, 14.5}, {2267.0, 5.0, 2.0, 26.0, -77.5, 14.5}, {2267.0, 5.0, 2.0, 28.0, -77.0, 14.5}, {2267.0, 5.0, 2.0, 32.0, -76.5, 14.5}, {2267.0, 5.0, 2.0, 38.0, -76.0, 14.5}, {2267.0, 5.0, 3.0, 6.0, -75.0, 18.0}, {2267.0, 5.0, 3.0, 7.0, -75.0, 18.0}, {2267.0, 5.0, 3.0, 8.0, -75.0, 18.0}, {2267.0, 5.0, 3.0, 10.0, -74.5, 18.0}, {2267.0, 5.0, 3.0, 10.5, -32768.0, 18.0}, {2267.0, 5.0, 3.0, 11.0, -74.5, 18.0}, {2267.0, 5.0, 3.0, 13.0, -74.5, 18.0}, {2267.0, 5.0, 3.0, 15.0, -74.5, 18.0}, {2267.0, 5.0, 3.0, 18.0, -74.5, 18.0}, {2267.0, 5.0, 3.0, 23.0, -74.0, 18.0}, {2267.0, 5.0, 3.0, 26.0, -73.5, 18.0}, {2267.0, 5.0, 3.0, 28.0, -73.0, 18.0}, {2267.0, 5.0, 3.0, 32.0, -72.5, 18.0}, {2267.0, 5.0, 3.0, 38.0, -72.0, 18.0}, {2267.0, 5.0, 4.0, 6.0, -72.5, 20.8}, {2267.0, 5.0, 4.0, 7.0, -72.5, 20.8}, {2267.0, 5.0, 4.0, 8.0, -72.5, 20.8}, {2267.0, 5.0, 4.0, 10.0, -72.0, 20.8}, {2267.0, 5.0, 4.0, 10.5, -32768.0, 20.8}, {2267.0, 5.0, 4.0, 11.0, -72.0, 20.8}, {2267.0, 5.0, 4.0, 13.0, -72.0, 20.8}, {2267.0, 5.0, 4.0, 15.0, -72.0, 20.8}, {2267.0, 5.0, 4.0, 18.0, -72.0, 20.8}, {2267.0, 5.0, 4.0, 23.0, -71.5, 20.8}, {2267.0, 5.0, 4.0, 26.0, -71.0, 20.8}, {2267.0, 5.0, 4.0, 28.0, -70.5, 20.8}, {2267.0, 5.0, 4.0, 32.0, -70.0, 20.8}, {2267.0, 5.0, 4.0, 38.0, -69.5, 20.8}, {2267.0, 5.0, 5.0, 6.0, -69.5, 24.0}, {2267.0, 5.0, 5.0, 7.0, -69.5, 24.0}, {2267.0, 5.0, 5.0, 8.0, -69.5, 24.0}, {2267.0, 5.0, 5.0, 10.0, -69.0, 24.0}, {2267.0, 5.0, 5.0, 10.5, -32768.0, 24.0}, {2267.0, 5.0, 5.0, 11.0, -69.0, 24.0}, {2267.0, 5.0, 5.0, 13.0, -69.0, 24.0}, {2267.0, 5.0, 5.0, 15.0, -69.0, 24.0}, {2267.0, 5.0, 5.0, 18.0, -69.0, 24.0}, {2267.0, 5.0, 5.0, 23.0, -68.5, 24.0}, {2267.0, 5.0, 5.0, 26.0, -68.0, 24.0}, {2267.0, 5.0, 5.0, 28.0, -67.5, 24.0}, {2267.0, 5.0, 5.0, 32.0, -67.0, 24.0}, {2267.0, 5.0, 5.0, 38.0, -66.5, 24.0}, {2267.0, 5.0, 6.0, 6.0, -66.5, 27.1}, {2267.0, 5.0, 6.0, 7.0, -66.5, 27.1}, {2267.0, 5.0, 6.0, 8.0, -66.5, 27.1}, {2267.0, 5.0, 6.0, 10.0, -66.0, 27.1}, {2267.0, 5.0, 6.0, 10.5, -32768.0, 27.1}, {2267.0, 5.0, 6.0, 11.0, -66.0, 27.1}, {2267.0, 5.0, 6.0, 13.0, -66.0, 27.1}, {2267.0, 5.0, 6.0, 15.0, -66.0, 27.1}, {2267.0, 5.0, 6.0, 18.0, -66.0, 27.1}, {2267.0, 5.0, 6.0, 23.0, -65.5, 27.1}, {2267.0, 5.0, 6.0, 26.0, -65.0, 27.1}, {2267.0, 5.0, 6.0, 28.0, -64.5, 27.1}, {2267.0, 5.0, 6.0, 32.0, -64.0, 27.1}, {2267.0, 5.0, 6.0, 38.0, -63.5, 27.1}, {2079.0, 2.0, 1.0, 6.0, -92.5, 9.0}, {2079.0, 2.0, 1.0, 7.0, -92.5, 9.0}, {2079.0, 2.0, 1.0, 8.0, -92.5, 9.0}, {2079.0, 2.0, 1.0, 10.0, -92.0, 9.0}, {2079.0, 2.0, 1.0, 10.5, -90.0, 9.0}, {2079.0, 2.0, 1.0, 11.0, -92.0, 9.0}, {2079.0, 2.0, 1.0, 13.0, -92.0, 9.0}, {2079.0, 2.0, 1.0, 15.0, -92.0, 9.0}, {2079.0, 2.0, 1.0, 18.0, -92.0, 9.0}, {2079.0, 2.0, 1.0, 23.0, -91.5, 9.0}, {2079.0, 2.0, 1.0, 26.0, -91.0, 9.0}, {2079.0, 2.0, 1.0, 28.0, -90.5, 9.0}, {2079.0, 2.0, 1.0, 32.0, -90.0, 9.0}, {2079.0, 2.0, 1.0, 38.0, -89.5, 9.0}, {2079.0, 2.0, 2.0, 6.0, -86.5, 14.8}, {2079.0, 2.0, 2.0, 7.0, -86.5, 14.8}, {2079.0, 2.0, 2.0, 8.0, -86.5, 14.8}, {2079.0, 2.0, 2.0, 10.0, -86.0, 14.8}, {2079.0, 2.0, 2.0, 10.5, -84.0, 14.8}, {2079.0, 2.0, 2.0, 11.0, -86.0, 14.8}, {2079.0, 2.0, 2.0, 13.0, -86.0, 14.8}, {2079.0, 2.0, 2.0, 15.0, -86.0, 14.8}, {2079.0, 2.0, 2.0, 18.0, -86.0, 14.8}, {2079.0, 2.0, 2.0, 23.0, -85.5, 14.8}, {2079.0, 2.0, 2.0, 26.0, -85.0, 14.8}, {2079.0, 2.0, 2.0, 28.0, -84.5, 14.8}, {2079.0, 2.0, 2.0, 32.0, -84.0, 14.8}, {2079.0, 2.0, 2.0, 38.0, -83.5, 14.8}, {2079.0, 2.0, 3.0, 6.0, -82.5, 18.6}, {2079.0, 2.0, 3.0, 7.0, -82.5, 18.6}, {2079.0, 2.0, 3.0, 8.0, -82.5, 18.6}, {2079.0, 2.0, 3.0, 10.0, -82.0, 18.6}, {2079.0, 2.0, 3.0, 10.5, -80.0, 18.6}, {2079.0, 2.0, 3.0, 11.0, -82.0, 18.6}, {2079.0, 2.0, 3.0, 13.0, -82.0, 18.6}, {2079.0, 2.0, 3.0, 15.0, -82.0, 18.6}, {2079.0, 2.0, 3.0, 18.0, -82.0, 18.6}, {2079.0, 2.0, 3.0, 23.0, -81.5, 18.6}, {2079.0, 2.0, 3.0, 26.0, -81.0, 18.6}, {2079.0, 2.0, 3.0, 28.0, -80.5, 18.6}, {2079.0, 2.0, 3.0, 32.0, -80.0, 18.6}, {2079.0, 2.0, 3.0, 38.0, -79.5, 18.6}, {2079.0, 2.0, 4.0, 6.0, -79.5, 22.1}, {2079.0, 2.0, 4.0, 7.0, -79.5, 22.1}, {2079.0, 2.0, 4.0, 8.0, -79.5, 22.1}, {2079.0, 2.0, 4.0, 10.0, -79.0, 22.1}, {2079.0, 2.0, 4.0, 10.5, -77.0, 22.1}, {2079.0, 2.0, 4.0, 11.0, -79.0, 22.1}, {2079.0, 2.0, 4.0, 13.0, -79.0, 22.1}, {2079.0, 2.0, 4.0, 15.0, -79.0, 22.1}, {2079.0, 2.0, 4.0, 18.0, -79.0, 22.1}, {2079.0, 2.0, 4.0, 23.0, -78.5, 22.1}, {2079.0, 2.0, 4.0, 26.0, -78.0, 22.1}, {2079.0, 2.0, 4.0, 28.0, -77.5, 22.1}, {2079.0, 2.0, 4.0, 32.0, -77.0, 22.1}, {2079.0, 2.0, 4.0, 38.0, -76.5, 22.1}, {2079.0, 2.0, 5.0, 6.0, -76.5, 25.7}, {2079.0, 2.0, 5.0, 7.0, -76.5, 25.7}, {2079.0, 2.0, 5.0, 8.0, -76.5, 25.7}, {2079.0, 2.0, 5.0, 10.0, -76.0, 25.7}, {2079.0, 2.0, 5.0, 10.5, -74.0, 25.7}, {2079.0, 2.0, 5.0, 11.0, -76.0, 25.7}, {2079.0, 2.0, 5.0, 13.0, -76.0, 25.7}, {2079.0, 2.0, 5.0, 15.0, -76.0, 25.7}, {2079.0, 2.0, 5.0, 18.0, -76.0, 25.7}, {2079.0, 2.0, 5.0, 23.0, -75.5, 25.7}, {2079.0, 2.0, 5.0, 26.0, -75.0, 25.7}, {2079.0, 2.0, 5.0, 28.0, -74.5, 25.7}, {2079.0, 2.0, 5.0, 32.0, -74.0, 25.7}, {2079.0, 2.0, 5.0, 38.0, -73.5, 25.7}, {2079.0, 2.0, 6.0, 6.0, -73.5, 27.3}, {2079.0, 2.0, 6.0, 7.0, -73.5, 27.3}, {2079.0, 2.0, 6.0, 8.0, -73.5, 27.3}, {2079.0, 2.0, 6.0, 10.0, -73.0, 27.3}, {2079.0, 2.0, 6.0, 10.5, -71.0, 27.3}, {2079.0, 2.0, 6.0, 11.0, -73.0, 27.3}, {2079.0, 2.0, 6.0, 13.0, -73.0, 27.3}, {2079.0, 2.0, 6.0, 15.0, -73.0, 27.3}, {2079.0, 2.0, 6.0, 18.0, -73.0, 27.3}, {2079.0, 2.0, 6.0, 23.0, -72.5, 27.3}, {2079.0, 2.0, 6.0, 26.0, -72.0, 27.3}, {2079.0, 2.0, 6.0, 28.0, -71.5, 27.3}, {2079.0, 2.0, 6.0, 32.0, -71.0, 27.3}, {2079.0, 2.0, 6.0, 38.0, -70.5, 27.3}, {2079.0, 3.0, 1.0, 6.0, -90.5, 9.0}, {2079.0, 3.0, 1.0, 7.0, -90.5, 9.0}, {2079.0, 3.0, 1.0, 8.0, -90.5, 9.0}, {2079.0, 3.0, 1.0, 10.0, -90.0, 9.0}, {2079.0, 3.0, 1.0, 10.5, -88.0, 9.0}, {2079.0, 3.0, 1.0, 11.0, -90.0, 9.0}, {2079.0, 3.0, 1.0, 13.0, -90.0, 9.0}, {2079.0, 3.0, 1.0, 15.0, -90.0, 9.0}, {2079.0, 3.0, 1.0, 18.0, -90.0, 9.0}, {2079.0, 3.0, 1.0, 23.0, -89.5, 9.0}, {2079.0, 3.0, 1.0, 26.0, -89.0, 9.0}, {2079.0, 3.0, 1.0, 28.0, -88.5, 9.0}, {2079.0, 3.0, 1.0, 32.0, -88.0, 9.0}, {2079.0, 3.0, 1.0, 38.0, -87.5, 9.0}, {2079.0, 3.0, 2.0, 6.0, -83.5, 14.6}, {2079.0, 3.0, 2.0, 7.0, -83.5, 14.6}, {2079.0, 3.0, 2.0, 8.0, -83.5, 14.6}, {2079.0, 3.0, 2.0, 10.0, -83.0, 14.6}, {2079.0, 3.0, 2.0, 10.5, -81.0, 14.6}, {2079.0, 3.0, 2.0, 11.0, -83.0, 14.6}, {2079.0, 3.0, 2.0, 13.0, -83.0, 14.6}, {2079.0, 3.0, 2.0, 15.0, -83.0, 14.6}, {2079.0, 3.0, 2.0, 18.0, -83.0, 14.6}, {2079.0, 3.0, 2.0, 23.0, -82.5, 14.6}, {2079.0, 3.0, 2.0, 26.0, -82.0, 14.6}, {2079.0, 3.0, 2.0, 28.0, -81.5, 14.6}, {2079.0, 3.0, 2.0, 32.0, -81.0, 14.6}, {2079.0, 3.0, 2.0, 38.0, -80.5, 14.6}, {2079.0, 3.0, 3.0, 6.0, -79.5, 18.0}, {2079.0, 3.0, 3.0, 7.0, -79.5, 18.0}, {2079.0, 3.0, 3.0, 8.0, -79.5, 18.0}, {2079.0, 3.0, 3.0, 10.0, -79.0, 18.0}, {2079.0, 3.0, 3.0, 10.5, -77.0, 18.0}, {2079.0, 3.0, 3.0, 11.0, -79.0, 18.0}, {2079.0, 3.0, 3.0, 13.0, -79.0, 18.0}, {2079.0, 3.0, 3.0, 15.0, -79.0, 18.0}, {2079.0, 3.0, 3.0, 18.0, -79.0, 18.0}, {2079.0, 3.0, 3.0, 23.0, -78.5, 18.0}, {2079.0, 3.0, 3.0, 26.0, -78.0, 18.0}, {2079.0, 3.0, 3.0, 28.0, -77.5, 18.0}, {2079.0, 3.0, 3.0, 32.0, -77.0, 18.0}, {2079.0, 3.0, 3.0, 38.0, -76.5, 18.0}, {2079.0, 3.0, 4.0, 6.0, -76.5, 21.0}, {2079.0, 3.0, 4.0, 7.0, -76.5, 21.0}, {2079.0, 3.0, 4.0, 8.0, -76.5, 21.0}, {2079.0, 3.0, 4.0, 10.0, -76.0, 21.0}, {2079.0, 3.0, 4.0, 10.5, -74.0, 21.0}, {2079.0, 3.0, 4.0, 11.0, -76.0, 21.0}, {2079.0, 3.0, 4.0, 13.0, -76.0, 21.0}, {2079.0, 3.0, 4.0, 15.0, -76.0, 21.0}, {2079.0, 3.0, 4.0, 18.0, -76.0, 21.0}, {2079.0, 3.0, 4.0, 23.0, -75.5, 21.0}, {2079.0, 3.0, 4.0, 26.0, -75.0, 21.0}, {2079.0, 3.0, 4.0, 28.0, -74.5, 21.0}, {2079.0, 3.0, 4.0, 32.0, -74.0, 21.0}, {2079.0, 3.0, 4.0, 38.0, -73.5, 21.0}, {2079.0, 3.0, 5.0, 6.0, -73.5, 24.2}, {2079.0, 3.0, 5.0, 7.0, -73.5, 24.2}, {2079.0, 3.0, 5.0, 8.0, -73.5, 24.2}, {2079.0, 3.0, 5.0, 10.0, -73.0, 24.2}, {2079.0, 3.0, 5.0, 10.5, -71.0, 24.2}, {2079.0, 3.0, 5.0, 11.0, -73.0, 24.2}, {2079.0, 3.0, 5.0, 13.0, -73.0, 24.2}, {2079.0, 3.0, 5.0, 15.0, -73.0, 24.2}, {2079.0, 3.0, 5.0, 18.0, -73.0, 24.2}, {2079.0, 3.0, 5.0, 23.0, -72.5, 24.2}, {2079.0, 3.0, 5.0, 26.0, -72.0, 24.2}, {2079.0, 3.0, 5.0, 28.0, -71.5, 24.2}, {2079.0, 3.0, 5.0, 32.0, -71.0, 24.2}, {2079.0, 3.0, 5.0, 38.0, -70.5, 24.2}, {2079.0, 3.0, 6.0, 6.0, -70.5, 26.9}, {2079.0, 3.0, 6.0, 7.0, -70.5, 26.9}, {2079.0, 3.0, 6.0, 8.0, -70.5, 26.9}, {2079.0, 3.0, 6.0, 10.0, -70.0, 26.9}, {2079.0, 3.0, 6.0, 10.5, -68.0, 26.9}, {2079.0, 3.0, 6.0, 11.0, -70.0, 26.9}, {2079.0, 3.0, 6.0, 13.0, -70.0, 26.9}, {2079.0, 3.0, 6.0, 15.0, -70.0, 26.9}, {2079.0, 3.0, 6.0, 18.0, -70.0, 26.9}, {2079.0, 3.0, 6.0, 23.0, -69.5, 26.9}, {2079.0, 3.0, 6.0, 26.0, -69.0, 26.9}, {2079.0, 3.0, 6.0, 28.0, -68.5, 26.9}, {2079.0, 3.0, 6.0, 32.0, -68.0, 26.9}, {2079.0, 3.0, 6.0, 38.0, -67.5, 26.9}, {2079.0, 4.0, 1.0, 6.0, -87.5, 9.0}, {2079.0, 4.0, 1.0, 7.0, -87.5, 9.0}, {2079.0, 4.0, 1.0, 8.0, -87.5, 9.0}, {2079.0, 4.0, 1.0, 10.0, -87.0, 9.0}, {2079.0, 4.0, 1.0, 10.5, -85.0, 9.0}, {2079.0, 4.0, 1.0, 11.0, -87.0, 9.0}, {2079.0, 4.0, 1.0, 13.0, -87.0, 9.0}, {2079.0, 4.0, 1.0, 15.0, -87.0, 9.0}, {2079.0, 4.0, 1.0, 18.0, -87.0, 9.0}, {2079.0, 4.0, 1.0, 23.0, -86.5, 9.0}, {2079.0, 4.0, 1.0, 26.0, -86.0, 9.0}, {2079.0, 4.0, 1.0, 28.0, -85.5, 9.0}, {2079.0, 4.0, 1.0, 32.0, -85.0, 9.0}, {2079.0, 4.0, 1.0, 38.0, -84.5, 9.0}, {2079.0, 4.0, 2.0, 6.0, -80.5, 14.6}, {2079.0, 4.0, 2.0, 7.0, -80.5, 14.6}, {2079.0, 4.0, 2.0, 8.0, -80.5, 14.6}, {2079.0, 4.0, 2.0, 10.0, -80.0, 14.6}, {2079.0, 4.0, 2.0, 10.5, -78.0, 14.6}, {2079.0, 4.0, 2.0, 11.0, -80.0, 14.6}, {2079.0, 4.0, 2.0, 13.0, -80.0, 14.6}, {2079.0, 4.0, 2.0, 15.0, -80.0, 14.6}, {2079.0, 4.0, 2.0, 18.0, -80.0, 14.6}, {2079.0, 4.0, 2.0, 23.0, -79.5, 14.6}, {2079.0, 4.0, 2.0, 26.0, -79.0, 14.6}, {2079.0, 4.0, 2.0, 28.0, -78.5, 14.6}, {2079.0, 4.0, 2.0, 32.0, -78.0, 14.6}, {2079.0, 4.0, 2.0, 38.0, -77.5, 14.6}, {2079.0, 4.0, 3.0, 6.0, -76.5, 18.4}, {2079.0, 4.0, 3.0, 7.0, -76.5, 18.4}, {2079.0, 4.0, 3.0, 8.0, -76.5, 18.4}, {2079.0, 4.0, 3.0, 10.0, -76.0, 18.4}, {2079.0, 4.0, 3.0, 10.5, -74.0, 18.4}, {2079.0, 4.0, 3.0, 11.0, -76.0, 18.4}, {2079.0, 4.0, 3.0, 13.0, -76.0, 18.4}, {2079.0, 4.0, 3.0, 15.0, -76.0, 18.4}, {2079.0, 4.0, 3.0, 18.0, -76.0, 18.4}, {2079.0, 4.0, 3.0, 23.0, -75.5, 18.4}, {2079.0, 4.0, 3.0, 26.0, -75.0, 18.4}, {2079.0, 4.0, 3.0, 28.0, -74.5, 18.4}, {2079.0, 4.0, 3.0, 32.0, -74.0, 18.4}, {2079.0, 4.0, 3.0, 38.0, -73.5, 18.4}, {2079.0, 4.0, 4.0, 6.0, -73.5, 21.1}, {2079.0, 4.0, 4.0, 7.0, -73.5, 21.1}, {2079.0, 4.0, 4.0, 8.0, -73.5, 21.1}, {2079.0, 4.0, 4.0, 10.0, -73.0, 21.1}, {2079.0, 4.0, 4.0, 10.5, -71.0, 21.1}, {2079.0, 4.0, 4.0, 11.0, -73.0, 21.1}, {2079.0, 4.0, 4.0, 13.0, -73.0, 21.1}, {2079.0, 4.0, 4.0, 15.0, -73.0, 21.1}, {2079.0, 4.0, 4.0, 18.0, -73.0, 21.1}, {2079.0, 4.0, 4.0, 23.0, -72.5, 21.1}, {2079.0, 4.0, 4.0, 26.0, -72.0, 21.1}, {2079.0, 4.0, 4.0, 28.0, -71.5, 21.1}, {2079.0, 4.0, 4.0, 32.0, -71.0, 21.1}, {2079.0, 4.0, 4.0, 38.0, -70.5, 21.1}, {2079.0, 4.0, 5.0, 6.0, -70.5, 24.3}, {2079.0, 4.0, 5.0, 7.0, -70.5, 24.3}, {2079.0, 4.0, 5.0, 8.0, -70.5, 24.3}, {2079.0, 4.0, 5.0, 10.0, -70.0, 24.3}, {2079.0, 4.0, 5.0, 10.5, -68.0, 24.3}, {2079.0, 4.0, 5.0, 11.0, -70.0, 24.3}, {2079.0, 4.0, 5.0, 13.0, -70.0, 24.3}, {2079.0, 4.0, 5.0, 15.0, -70.0, 24.3}, {2079.0, 4.0, 5.0, 18.0, -70.0, 24.3}, {2079.0, 4.0, 5.0, 23.0, -69.5, 24.3}, {2079.0, 4.0, 5.0, 26.0, -69.0, 24.3}, {2079.0, 4.0, 5.0, 28.0, -68.5, 24.3}, {2079.0, 4.0, 5.0, 32.0, -68.0, 24.3}, {2079.0, 4.0, 5.0, 38.0, -67.5, 24.3}, {2079.0, 4.0, 6.0, 6.0, -67.5, 27.1}, {2079.0, 4.0, 6.0, 7.0, -67.5, 27.1}, {2079.0, 4.0, 6.0, 8.0, -67.5, 27.1}, {2079.0, 4.0, 6.0, 10.0, -67.0, 27.1}, {2079.0, 4.0, 6.0, 10.5, -65.0, 27.1}, {2079.0, 4.0, 6.0, 11.0, -67.0, 27.1}, {2079.0, 4.0, 6.0, 13.0, -67.0, 27.1}, {2079.0, 4.0, 6.0, 15.0, -67.0, 27.1}, {2079.0, 4.0, 6.0, 18.0, -67.0, 27.1}, {2079.0, 4.0, 6.0, 23.0, -66.5, 27.1}, {2079.0, 4.0, 6.0, 26.0, -66.0, 27.1}, {2079.0, 4.0, 6.0, 28.0, -65.5, 27.1}, {2079.0, 4.0, 6.0, 32.0, -65.0, 27.1}, {2079.0, 4.0, 6.0, 38.0, -64.5, 27.1}, {2079.0, 6.0, 1.0, 6.0, -84.5, 9.0}, {2079.0, 6.0, 1.0, 7.0, -84.5, 9.0}, {2079.0, 6.0, 1.0, 8.0, -84.5, 9.0}, {2079.0, 6.0, 1.0, 10.0, -84.0, 9.0}, {2079.0, 6.0, 1.0, 10.5, -32768.0, 9.0}, {2079.0, 6.0, 1.0, 11.0, -84.0, 9.0}, {2079.0, 6.0, 1.0, 13.0, -84.0, 9.0}, {2079.0, 6.0, 1.0, 15.0, -84.0, 9.0}, {2079.0, 6.0, 1.0, 18.0, -84.0, 9.0}, {2079.0, 6.0, 1.0, 23.0, -83.5, 9.0}, {2079.0, 6.0, 1.0, 26.0, -83.0, 9.0}, {2079.0, 6.0, 1.0, 28.0, -82.5, 9.0}, {2079.0, 6.0, 1.0, 32.0, -82.0, 9.0}, {2079.0, 6.0, 1.0, 38.0, -81.5, 9.0}, {2079.0, 6.0, 2.0, 6.0, -77.5, 14.6}, {2079.0, 6.0, 2.0, 7.0, -77.5, 14.6}, {2079.0, 6.0, 2.0, 8.0, -77.5, 14.6}, {2079.0, 6.0, 2.0, 10.0, -77.0, 14.6}, {2079.0, 6.0, 2.0, 10.5, -32768.0, 14.6}, {2079.0, 6.0, 2.0, 11.0, -77.0, 14.6}, {2079.0, 6.0, 2.0, 13.0, -77.0, 14.6}, {2079.0, 6.0, 2.0, 15.0, -77.0, 14.6}, {2079.0, 6.0, 2.0, 18.0, -77.0, 14.6}, {2079.0, 6.0, 2.0, 23.0, -76.5, 14.6}, {2079.0, 6.0, 2.0, 26.0, -76.0, 14.6}, {2079.0, 6.0, 2.0, 28.0, -75.5, 14.6}, {2079.0, 6.0, 2.0, 32.0, -75.0, 14.6}, {2079.0, 6.0, 2.0, 38.0, -74.5, 14.6}, {2079.0, 6.0, 3.0, 6.0, -73.5, 18.0}, {2079.0, 6.0, 3.0, 7.0, -73.5, 18.0}, {2079.0, 6.0, 3.0, 8.0, -73.5, 18.0}, {2079.0, 6.0, 3.0, 10.0, -73.0, 18.0}, {2079.0, 6.0, 3.0, 10.5, -32768.0, 18.0}, {2079.0, 6.0, 3.0, 11.0, -73.0, 18.0}, {2079.0, 6.0, 3.0, 13.0, -73.0, 18.0}, {2079.0, 6.0, 3.0, 15.0, -73.0, 18.0}, {2079.0, 6.0, 3.0, 18.0, -73.0, 18.0}, {2079.0, 6.0, 3.0, 23.0, -72.5, 18.0}, {2079.0, 6.0, 3.0, 26.0, -72.0, 18.0}, {2079.0, 6.0, 3.0, 28.0, -71.5, 18.0}, {2079.0, 6.0, 3.0, 32.0, -71.0, 18.0}, {2079.0, 6.0, 3.0, 38.0, -70.5, 18.0}, {2079.0, 6.0, 4.0, 6.0, -70.5, 21.0}, {2079.0, 6.0, 4.0, 7.0, -70.5, 21.0}, {2079.0, 6.0, 4.0, 8.0, -70.5, 21.0}, {2079.0, 6.0, 4.0, 10.0, -70.0, 21.0}, {2079.0, 6.0, 4.0, 10.5, -32768.0, 21.0}, {2079.0, 6.0, 4.0, 11.0, -70.0, 21.0}, {2079.0, 6.0, 4.0, 13.0, -70.0, 21.0}, {2079.0, 6.0, 4.0, 15.0, -70.0, 21.0}, {2079.0, 6.0, 4.0, 18.0, -70.0, 21.0}, {2079.0, 6.0, 4.0, 23.0, -69.5, 21.0}, {2079.0, 6.0, 4.0, 26.0, -69.0, 21.0}, {2079.0, 6.0, 4.0, 28.0, -68.5, 21.0}, {2079.0, 6.0, 4.0, 32.0, -68.0, 21.0}, {2079.0, 6.0, 4.0, 38.0, -67.5, 21.0}, {2079.0, 6.0, 5.0, 6.0, -67.5, 24.0}, {2079.0, 6.0, 5.0, 7.0, -67.5, 24.0}, {2079.0, 6.0, 5.0, 8.0, -67.5, 24.0}, {2079.0, 6.0, 5.0, 10.0, -67.0, 24.0}, {2079.0, 6.0, 5.0, 10.5, -32768.0, 24.0}, {2079.0, 6.0, 5.0, 11.0, -67.0, 24.0}, {2079.0, 6.0, 5.0, 13.0, -67.0, 24.0}, {2079.0, 6.0, 5.0, 15.0, -67.0, 24.0}, {2079.0, 6.0, 5.0, 18.0, -67.0, 24.0}, {2079.0, 6.0, 5.0, 23.0, -66.5, 24.0}, {2079.0, 6.0, 5.0, 26.0, -66.0, 24.0}, {2079.0, 6.0, 5.0, 28.0, -65.5, 24.0}, {2079.0, 6.0, 5.0, 32.0, -65.0, 24.0}, {2079.0, 6.0, 5.0, 38.0, -64.5, 24.0}, {2079.0, 6.0, 6.0, 6.0, -64.5, 27.0}, {2079.0, 6.0, 6.0, 7.0, -64.5, 27.0}, {2079.0, 6.0, 6.0, 8.0, -64.5, 27.0}, {2079.0, 6.0, 6.0, 10.0, -64.0, 27.0}, {2079.0, 6.0, 6.0, 10.5, -32768.0, 27.0}, {2079.0, 6.0, 6.0, 11.0, -64.0, 27.0}, {2079.0, 6.0, 6.0, 13.0, -64.0, 27.0}, {2079.0, 6.0, 6.0, 15.0, -64.0, 27.0}, {2079.0, 6.0, 6.0, 18.0, -64.0, 27.0}, {2079.0, 6.0, 6.0, 23.0, -63.5, 27.0}, {2079.0, 6.0, 6.0, 26.0, -63.0, 27.0}, {2079.0, 6.0, 6.0, 28.0, -62.5, 27.0}, {2079.0, 6.0, 6.0, 32.0, -62.0, 27.0}, {2079.0, 6.0, 6.0, 38.0, -61.5, 27.0}, {2080.0, 4.0, 1.0, 6.0, -87.5, 9.0}, {2080.0, 4.0, 1.0, 7.0, -87.5, 9.0}, {2080.0, 4.0, 1.0, 8.0, -87.5, 9.0}, {2080.0, 4.0, 1.0, 10.0, -32768.0, 9.0}, {2080.0, 4.0, 1.0, 10.5, -32768.0, 9.0}, {2080.0, 4.0, 1.0, 11.0, -87.0, 9.0}, {2080.0, 4.0, 1.0, 13.0, -87.0, 9.0}, {2080.0, 4.0, 1.0, 15.0, -87.0, 9.0}, {2080.0, 4.0, 1.0, 18.0, -87.0, 9.0}, {2080.0, 4.0, 1.0, 23.0, -86.5, 9.0}, {2080.0, 4.0, 1.0, 26.0, -86.0, 9.0}, {2080.0, 4.0, 1.0, 28.0, -85.5, 9.0}, {2080.0, 4.0, 1.0, 32.0, -85.0, 9.0}, {2080.0, 4.0, 1.0, 38.0, -84.5, 9.0}, {2080.0, 4.0, 2.0, 6.0, -80.5, 14.6}, {2080.0, 4.0, 2.0, 7.0, -80.5, 14.6}, {2080.0, 4.0, 2.0, 8.0, -80.5, 14.6}, {2080.0, 4.0, 2.0, 10.0, -32768.0, 14.6}, {2080.0, 4.0, 2.0, 10.5, -32768.0, 14.6}, {2080.0, 4.0, 2.0, 11.0, -80.0, 14.6}, {2080.0, 4.0, 2.0, 13.0, -80.0, 14.6}, {2080.0, 4.0, 2.0, 15.0, -80.0, 14.6}, {2080.0, 4.0, 2.0, 18.0, -80.0, 14.6}, {2080.0, 4.0, 2.0, 23.0, -79.5, 14.6}, {2080.0, 4.0, 2.0, 26.0, -79.0, 14.6}, {2080.0, 4.0, 2.0, 28.0, -78.5, 14.6}, {2080.0, 4.0, 2.0, 32.0, -78.0, 14.6}, {2080.0, 4.0, 2.0, 38.0, -77.5, 14.6}, {2080.0, 4.0, 3.0, 6.0, -76.5, 18.4}, {2080.0, 4.0, 3.0, 7.0, -76.5, 18.4}, {2080.0, 4.0, 3.0, 8.0, -76.5, 18.4}, {2080.0, 4.0, 3.0, 10.0, -32768.0, 18.4}, {2080.0, 4.0, 3.0, 10.5, -32768.0, 18.4}, {2080.0, 4.0, 3.0, 11.0, -76.0, 18.4}, {2080.0, 4.0, 3.0, 13.0, -76.0, 18.4}, {2080.0, 4.0, 3.0, 15.0, -76.0, 18.4}, {2080.0, 4.0, 3.0, 18.0, -76.0, 18.4}, {2080.0, 4.0, 3.0, 23.0, -75.5, 18.4}, {2080.0, 4.0, 3.0, 26.0, -75.0, 18.4}, {2080.0, 4.0, 3.0, 28.0, -74.5, 18.4}, {2080.0, 4.0, 3.0, 32.0, -74.0, 18.4}, {2080.0, 4.0, 3.0, 38.0, -73.5, 18.4}, {2080.0, 4.0, 4.0, 6.0, -73.5, 21.1}, {2080.0, 4.0, 4.0, 7.0, -73.5, 21.1}, {2080.0, 4.0, 4.0, 8.0, -73.5, 21.1}, {2080.0, 4.0, 4.0, 10.0, -32768.0, 21.1}, {2080.0, 4.0, 4.0, 10.5, -32768.0, 21.1}, {2080.0, 4.0, 4.0, 11.0, -73.0, 21.1}, {2080.0, 4.0, 4.0, 13.0, -73.0, 21.1}, {2080.0, 4.0, 4.0, 15.0, -73.0, 21.1}, {2080.0, 4.0, 4.0, 18.0, -73.0, 21.1}, {2080.0, 4.0, 4.0, 23.0, -72.5, 21.1}, {2080.0, 4.0, 4.0, 26.0, -72.0, 21.1}, {2080.0, 4.0, 4.0, 28.0, -71.5, 21.1}, {2080.0, 4.0, 4.0, 32.0, -71.0, 21.1}, {2080.0, 4.0, 4.0, 38.0, -70.5, 21.1}, {2080.0, 4.0, 5.0, 6.0, -70.5, 24.3}, {2080.0, 4.0, 5.0, 7.0, -70.5, 24.3}, {2080.0, 4.0, 5.0, 8.0, -70.5, 24.3}, {2080.0, 4.0, 5.0, 10.0, -32768.0, 24.3}, {2080.0, 4.0, 5.0, 10.5, -32768.0, 24.3}, {2080.0, 4.0, 5.0, 11.0, -70.0, 24.3}, {2080.0, 4.0, 5.0, 13.0, -70.0, 24.3}, {2080.0, 4.0, 5.0, 15.0, -70.0, 24.3}, {2080.0, 4.0, 5.0, 18.0, -70.0, 24.3}, {2080.0, 4.0, 5.0, 23.0, -69.5, 24.3}, {2080.0, 4.0, 5.0, 26.0, -69.0, 24.3}, {2080.0, 4.0, 5.0, 28.0, -68.5, 24.3}, {2080.0, 4.0, 5.0, 32.0, -68.0, 24.3}, {2080.0, 4.0, 5.0, 38.0, -67.5, 24.3}, {2080.0, 4.0, 6.0, 6.0, -67.5, 27.1}, {2080.0, 4.0, 6.0, 7.0, -67.5, 27.1}, {2080.0, 4.0, 6.0, 8.0, -67.5, 27.1}, {2080.0, 4.0, 6.0, 10.0, -32768.0, 27.1}, {2080.0, 4.0, 6.0, 10.5, -32768.0, 27.1}, {2080.0, 4.0, 6.0, 11.0, -67.0, 27.1}, {2080.0, 4.0, 6.0, 13.0, -67.0, 27.1}, {2080.0, 4.0, 6.0, 15.0, -67.0, 27.1}, {2080.0, 4.0, 6.0, 18.0, -67.0, 27.1}, {2080.0, 4.0, 6.0, 23.0, -66.5, 27.1}, {2080.0, 4.0, 6.0, 26.0, -66.0, 27.1}, {2080.0, 4.0, 6.0, 28.0, -65.5, 27.1}, {2080.0, 4.0, 6.0, 32.0, -65.0, 27.1}, {2080.0, 4.0, 6.0, 38.0, -64.5, 27.1}, {2080.0, 6.0, 1.0, 6.0, -84.5, 9.0}, {2080.0, 6.0, 1.0, 7.0, -84.5, 9.0}, {2080.0, 6.0, 1.0, 8.0, -84.5, 9.0}, {2080.0, 6.0, 1.0, 10.0, -32768.0, 9.0}, {2080.0, 6.0, 1.0, 10.5, -32768.0, 9.0}, {2080.0, 6.0, 1.0, 11.0, -84.0, 9.0}, {2080.0, 6.0, 1.0, 13.0, -84.0, 9.0}, {2080.0, 6.0, 1.0, 15.0, -84.0, 9.0}, {2080.0, 6.0, 1.0, 18.0, -84.0, 9.0}, {2080.0, 6.0, 1.0, 23.0, -83.5, 9.0}, {2080.0, 6.0, 1.0, 26.0, -83.0, 9.0}, {2080.0, 6.0, 1.0, 28.0, -82.5, 9.0}, {2080.0, 6.0, 1.0, 32.0, -82.0, 9.0}, {2080.0, 6.0, 1.0, 38.0, -81.5, 9.0}, {2080.0, 6.0, 2.0, 6.0, -77.5, 14.6}, {2080.0, 6.0, 2.0, 7.0, -77.5, 14.6}, {2080.0, 6.0, 2.0, 8.0, -77.5, 14.6}, {2080.0, 6.0, 2.0, 10.0, -32768.0, 14.6}, {2080.0, 6.0, 2.0, 10.5, -32768.0, 14.6}, {2080.0, 6.0, 2.0, 11.0, -77.0, 14.6}, {2080.0, 6.0, 2.0, 13.0, -77.0, 14.6}, {2080.0, 6.0, 2.0, 15.0, -77.0, 14.6}, {2080.0, 6.0, 2.0, 18.0, -77.0, 14.6}, {2080.0, 6.0, 2.0, 23.0, -76.5, 14.6}, {2080.0, 6.0, 2.0, 26.0, -76.0, 14.6}, {2080.0, 6.0, 2.0, 28.0, -75.5, 14.6}, {2080.0, 6.0, 2.0, 32.0, -75.0, 14.6}, {2080.0, 6.0, 2.0, 38.0, -74.5, 14.6}, {2080.0, 6.0, 3.0, 6.0, -73.5, 18.0}, {2080.0, 6.0, 3.0, 7.0, -73.5, 18.0}, {2080.0, 6.0, 3.0, 8.0, -73.5, 18.0}, {2080.0, 6.0, 3.0, 10.0, -32768.0, 18.0}, {2080.0, 6.0, 3.0, 10.5, -32768.0, 18.0}, {2080.0, 6.0, 3.0, 11.0, -73.0, 18.0}, {2080.0, 6.0, 3.0, 13.0, -73.0, 18.0}, {2080.0, 6.0, 3.0, 15.0, -73.0, 18.0}, {2080.0, 6.0, 3.0, 18.0, -73.0, 18.0}, {2080.0, 6.0, 3.0, 23.0, -72.5, 18.0}, {2080.0, 6.0, 3.0, 26.0, -72.0, 18.0}, {2080.0, 6.0, 3.0, 28.0, -71.5, 18.0}, {2080.0, 6.0, 3.0, 32.0, -71.0, 18.0}, {2080.0, 6.0, 3.0, 38.0, -70.5, 18.0}, {2080.0, 6.0, 4.0, 6.0, -70.5, 21.0}, {2080.0, 6.0, 4.0, 7.0, -70.5, 21.0}, {2080.0, 6.0, 4.0, 8.0, -70.5, 21.0}, {2080.0, 6.0, 4.0, 10.0, -32768.0, 21.0}, {2080.0, 6.0, 4.0, 10.5, -32768.0, 21.0}, {2080.0, 6.0, 4.0, 11.0, -70.0, 21.0}, {2080.0, 6.0, 4.0, 13.0, -70.0, 21.0}, {2080.0, 6.0, 4.0, 15.0, -70.0, 21.0}, {2080.0, 6.0, 4.0, 18.0, -70.0, 21.0}, {2080.0, 6.0, 4.0, 23.0, -69.5, 21.0}, {2080.0, 6.0, 4.0, 26.0, -69.0, 21.0}, {2080.0, 6.0, 4.0, 28.0, -68.5, 21.0}, {2080.0, 6.0, 4.0, 32.0, -68.0, 21.0}, {2080.0, 6.0, 4.0, 38.0, -67.5, 21.0}, {2080.0, 6.0, 5.0, 6.0, -67.5, 24.0}, {2080.0, 6.0, 5.0, 7.0, -67.5, 24.0}, {2080.0, 6.0, 5.0, 8.0, -67.5, 24.0}, {2080.0, 6.0, 5.0, 10.0, -32768.0, 24.0}, {2080.0, 6.0, 5.0, 10.5, -32768.0, 24.0}, {2080.0, 6.0, 5.0, 11.0, -67.0, 24.0}, {2080.0, 6.0, 5.0, 13.0, -67.0, 24.0}, {2080.0, 6.0, 5.0, 15.0, -67.0, 24.0}, {2080.0, 6.0, 5.0, 18.0, -67.0, 24.0}, {2080.0, 6.0, 5.0, 23.0, -66.5, 24.0}, {2080.0, 6.0, 5.0, 26.0, -66.0, 24.0}, {2080.0, 6.0, 5.0, 28.0, -65.5, 24.0}, {2080.0, 6.0, 5.0, 32.0, -65.0, 24.0}, {2080.0, 6.0, 5.0, 38.0, -64.5, 24.0}, {2080.0, 6.0, 6.0, 6.0, -64.5, 27.0}, {2080.0, 6.0, 6.0, 7.0, -64.5, 27.0}, {2080.0, 6.0, 6.0, 8.0, -64.5, 27.0}, {2080.0, 6.0, 6.0, 10.0, -32768.0, 27.0}, {2080.0, 6.0, 6.0, 10.5, -32768.0, 27.0}, {2080.0, 6.0, 6.0, 11.0, -64.0, 27.0}, {2080.0, 6.0, 6.0, 13.0, -64.0, 27.0}, {2080.0, 6.0, 6.0, 15.0, -64.0, 27.0}, {2080.0, 6.0, 6.0, 18.0, -64.0, 27.0}, {2080.0, 6.0, 6.0, 23.0, -63.5, 27.0}, {2080.0, 6.0, 6.0, 26.0, -63.0, 27.0}, {2080.0, 6.0, 6.0, 28.0, -62.5, 27.0}, {2080.0, 6.0, 6.0, 32.0, -62.0, 27.0}, {2080.0, 6.0, 6.0, 38.0, -61.5, 27.0}};
        this.addSystemParam(systemParamsTable);
    }

    private void loadExtSystemParamsData() {
        double[][] extSystemParamsTable = new double[][]{{2080.0, 2.0, 1.0, 6.0, -92.5, 9.5}, {2080.0, 2.0, 1.0, 7.0, -92.5, 9.5}, {2080.0, 2.0, 1.0, 8.0, -92.5, 9.5}, {2080.0, 2.0, 1.0, 10.0, -32768.0, 9.5}, {2080.0, 2.0, 1.0, 10.5, -32768.0, 9.5}, {2080.0, 2.0, 1.0, 11.0, -92.0, 9.5}, {2080.0, 2.0, 1.0, 13.0, -92.0, 9.5}, {2080.0, 2.0, 1.0, 15.0, -92.0, 9.5}, {2080.0, 2.0, 1.0, 18.0, -92.0, 9.5}, {2080.0, 2.0, 1.0, 23.0, -91.5, 9.5}, {2080.0, 2.0, 1.0, 26.0, -91.0, 9.5}, {2080.0, 2.0, 1.0, 28.0, -90.5, 9.5}, {2080.0, 2.0, 1.0, 32.0, -90.0, 9.5}, {2080.0, 2.0, 1.0, 38.0, -89.5, 9.5}, {2080.0, 2.0, 2.0, 6.0, -86.5, 15.2}, {2080.0, 2.0, 2.0, 7.0, -86.5, 15.2}, {2080.0, 2.0, 2.0, 8.0, -86.5, 15.2}, {2080.0, 2.0, 2.0, 10.0, -32768.0, 15.2}, {2080.0, 2.0, 2.0, 10.5, -32768.0, 15.2}, {2080.0, 2.0, 2.0, 11.0, -86.0, 15.2}, {2080.0, 2.0, 2.0, 13.0, -86.0, 15.2}, {2080.0, 2.0, 2.0, 15.0, -86.0, 15.2}, {2080.0, 2.0, 2.0, 18.0, -86.0, 15.2}, {2080.0, 2.0, 2.0, 23.0, -85.5, 15.2}, {2080.0, 2.0, 2.0, 26.0, -85.0, 15.2}, {2080.0, 2.0, 2.0, 28.0, -84.5, 15.2}, {2080.0, 2.0, 2.0, 32.0, -84.0, 15.2}, {2080.0, 2.0, 2.0, 38.0, -83.5, 15.2}, {2080.0, 2.0, 3.0, 6.0, -82.5, 17.7}, {2080.0, 2.0, 3.0, 7.0, -82.5, 17.7}, {2080.0, 2.0, 3.0, 8.0, -82.5, 17.7}, {2080.0, 2.0, 3.0, 10.0, -32768.0, 17.7}, {2080.0, 2.0, 3.0, 10.5, -32768.0, 17.7}, {2080.0, 2.0, 3.0, 11.0, -82.0, 17.7}, {2080.0, 2.0, 3.0, 13.0, -82.0, 17.7}, {2080.0, 2.0, 3.0, 15.0, -82.0, 17.7}, {2080.0, 2.0, 3.0, 18.0, -82.0, 17.7}, {2080.0, 2.0, 3.0, 23.0, -81.5, 17.7}, {2080.0, 2.0, 3.0, 26.0, -81.0, 17.7}, {2080.0, 2.0, 3.0, 28.0, -80.5, 17.7}, {2080.0, 2.0, 3.0, 32.0, -80.0, 17.7}, {2080.0, 2.0, 3.0, 38.0, -79.5, 17.7}, {2080.0, 2.0, 4.0, 6.0, -79.5, 20.9}, {2080.0, 2.0, 4.0, 7.0, -79.5, 20.9}, {2080.0, 2.0, 4.0, 8.0, -79.5, 20.9}, {2080.0, 2.0, 4.0, 10.0, -32768.0, 20.9}, {2080.0, 2.0, 4.0, 10.5, -32768.0, 20.9}, {2080.0, 2.0, 4.0, 11.0, -79.0, 20.9}, {2080.0, 2.0, 4.0, 13.0, -79.0, 20.9}, {2080.0, 2.0, 4.0, 15.0, -79.0, 20.9}, {2080.0, 2.0, 4.0, 18.0, -79.0, 20.9}, {2080.0, 2.0, 4.0, 23.0, -78.5, 20.9}, {2080.0, 2.0, 4.0, 26.0, -32768.0, 20.9}, {2080.0, 2.0, 4.0, 28.0, -32768.0, 20.9}, {2080.0, 2.0, 4.0, 32.0, -32768.0, 20.9}, {2080.0, 2.0, 4.0, 38.0, -32768.0, 20.9}, {2080.0, 2.0, 5.0, 6.0, -32768.0, 23.7}, {2080.0, 2.0, 5.0, 7.0, -32768.0, 23.7}, {2080.0, 2.0, 5.0, 8.0, -32768.0, 23.7}, {2080.0, 2.0, 5.0, 10.0, -32768.0, 23.7}, {2080.0, 2.0, 5.0, 10.5, -32768.0, 23.7}, {2080.0, 2.0, 5.0, 11.0, -32768.0, 23.7}, {2080.0, 2.0, 5.0, 13.0, -32768.0, 23.7}, {2080.0, 2.0, 5.0, 15.0, -32768.0, 23.7}, {2080.0, 2.0, 5.0, 18.0, -32768.0, 23.7}, {2080.0, 2.0, 5.0, 23.0, -32768.0, 23.7}, {2080.0, 2.0, 5.0, 26.0, -32768.0, 23.7}, {2080.0, 2.0, 5.0, 28.0, -32768.0, 23.7}, {2080.0, 2.0, 5.0, 32.0, -32768.0, 23.7}, {2080.0, 2.0, 5.0, 38.0, -32768.0, 23.7}, {2080.0, 2.0, 6.0, 6.0, -32768.0, 26.4}, {2080.0, 2.0, 6.0, 7.0, -32768.0, 26.4}, {2080.0, 2.0, 6.0, 8.0, -32768.0, 26.4}, {2080.0, 2.0, 6.0, 10.0, -32768.0, 26.4}, {2080.0, 2.0, 6.0, 10.5, -32768.0, 26.4}, {2080.0, 2.0, 6.0, 11.0, -32768.0, 26.4}, {2080.0, 2.0, 6.0, 13.0, -32768.0, 26.4}, {2080.0, 2.0, 6.0, 15.0, -32768.0, 26.4}, {2080.0, 2.0, 6.0, 18.0, -32768.0, 26.4}, {2080.0, 2.0, 6.0, 23.0, -32768.0, 26.4}, {2080.0, 2.0, 6.0, 26.0, -32768.0, 26.4}, {2080.0, 2.0, 6.0, 28.0, -32768.0, 26.4}, {2080.0, 2.0, 6.0, 32.0, -32768.0, 26.4}, {2080.0, 2.0, 6.0, 38.0, -32768.0, 26.4}, {2080.0, 3.0, 1.0, 6.0, -90.5, 8.0}, {2080.0, 3.0, 1.0, 7.0, -90.5, 8.0}, {2080.0, 3.0, 1.0, 8.0, -90.5, 8.0}, {2080.0, 3.0, 1.0, 10.0, -32768.0, 8.0}, {2080.0, 3.0, 1.0, 10.5, -32768.0, 8.0}, {2080.0, 3.0, 1.0, 11.0, -90.0, 8.0}, {2080.0, 3.0, 1.0, 13.0, -90.0, 8.0}, {2080.0, 3.0, 1.0, 15.0, -90.0, 8.0}, {2080.0, 3.0, 1.0, 18.0, -90.0, 8.0}, {2080.0, 3.0, 1.0, 23.0, -89.5, 8.0}, {2080.0, 3.0, 1.0, 26.0, -89.0, 8.0}, {2080.0, 3.0, 1.0, 28.0, -88.5, 8.0}, {2080.0, 3.0, 1.0, 32.0, -88.0, 8.0}, {2080.0, 3.0, 1.0, 38.0, -87.5, 8.0}, {2080.0, 3.0, 2.0, 6.0, -83.5, 14.2}, {2080.0, 3.0, 2.0, 7.0, -83.5, 14.2}, {2080.0, 3.0, 2.0, 8.0, -83.5, 14.2}, {2080.0, 3.0, 2.0, 10.0, -32768.0, 14.2}, {2080.0, 3.0, 2.0, 10.5, -32768.0, 14.2}, {2080.0, 3.0, 2.0, 11.0, -83.0, 14.2}, {2080.0, 3.0, 2.0, 13.0, -83.0, 14.2}, {2080.0, 3.0, 2.0, 15.0, -83.0, 14.2}, {2080.0, 3.0, 2.0, 18.0, -83.0, 14.2}, {2080.0, 3.0, 2.0, 23.0, -82.5, 14.2}, {2080.0, 3.0, 2.0, 26.0, -82.0, 14.2}, {2080.0, 3.0, 2.0, 28.0, -81.5, 14.2}, {2080.0, 3.0, 2.0, 32.0, -81.0, 14.2}, {2080.0, 3.0, 2.0, 38.0, -80.5, 14.2}, {2080.0, 3.0, 3.0, 6.0, -79.5, 17.4}, {2080.0, 3.0, 3.0, 7.0, -79.5, 17.4}, {2080.0, 3.0, 3.0, 8.0, -79.5, 17.4}, {2080.0, 3.0, 3.0, 10.0, -32768.0, 17.4}, {2080.0, 3.0, 3.0, 10.5, -32768.0, 17.4}, {2080.0, 3.0, 3.0, 11.0, -79.0, 17.4}, {2080.0, 3.0, 3.0, 13.0, -79.0, 17.4}, {2080.0, 3.0, 3.0, 15.0, -79.0, 17.4}, {2080.0, 3.0, 3.0, 18.0, -79.0, 17.4}, {2080.0, 3.0, 3.0, 23.0, -78.5, 17.4}, {2080.0, 3.0, 3.0, 26.0, -78.0, 17.4}, {2080.0, 3.0, 3.0, 28.0, -77.5, 17.4}, {2080.0, 3.0, 3.0, 32.0, -77.0, 17.4}, {2080.0, 3.0, 3.0, 38.0, -76.5, 17.4}, {2080.0, 3.0, 4.0, 6.0, -76.5, 20.5}, {2080.0, 3.0, 4.0, 7.0, -76.5, 20.5}, {2080.0, 3.0, 4.0, 8.0, -76.5, 20.5}, {2080.0, 3.0, 4.0, 10.0, -32768.0, 20.5}, {2080.0, 3.0, 4.0, 10.5, -32768.0, 20.5}, {2080.0, 3.0, 4.0, 11.0, -76.0, 20.5}, {2080.0, 3.0, 4.0, 13.0, -76.0, 20.5}, {2080.0, 3.0, 4.0, 15.0, -76.0, 20.5}, {2080.0, 3.0, 4.0, 18.0, -76.0, 20.5}, {2080.0, 3.0, 4.0, 23.0, -75.5, 20.5}, {2080.0, 3.0, 4.0, 26.0, -32768.0, 20.5}, {2080.0, 3.0, 4.0, 28.0, -32768.0, 20.5}, {2080.0, 3.0, 4.0, 32.0, -32768.0, 20.5}, {2080.0, 3.0, 4.0, 38.0, -32768.0, 20.5}, {2080.0, 3.0, 5.0, 6.0, -73.5, 23.4}, {2080.0, 3.0, 5.0, 7.0, -73.5, 23.4}, {2080.0, 3.0, 5.0, 8.0, -73.5, 23.4}, {2080.0, 3.0, 5.0, 10.0, -32768.0, 23.4}, {2080.0, 3.0, 5.0, 10.5, -32768.0, 23.4}, {2080.0, 3.0, 5.0, 11.0, -73.0, 23.4}, {2080.0, 3.0, 5.0, 13.0, -73.0, 23.4}, {2080.0, 3.0, 5.0, 15.0, -73.0, 23.4}, {2080.0, 3.0, 5.0, 18.0, -73.0, 23.4}, {2080.0, 3.0, 5.0, 23.0, -72.5, 23.4}, {2080.0, 3.0, 5.0, 26.0, -32768.0, 23.4}, {2080.0, 3.0, 5.0, 28.0, -32768.0, 23.4}, {2080.0, 3.0, 5.0, 32.0, -32768.0, 23.4}, {2080.0, 3.0, 5.0, 38.0, -32768.0, 23.4}, {2080.0, 3.0, 6.0, 6.0, -32768.0, 26.2}, {2080.0, 3.0, 6.0, 7.0, -32768.0, 26.2}, {2080.0, 3.0, 6.0, 8.0, -32768.0, 26.2}, {2080.0, 3.0, 6.0, 10.0, -32768.0, 26.2}, {2080.0, 3.0, 6.0, 10.5, -32768.0, 26.2}, {2080.0, 3.0, 6.0, 11.0, -32768.0, 26.2}, {2080.0, 3.0, 6.0, 13.0, -32768.0, 26.2}, {2080.0, 3.0, 6.0, 15.0, -32768.0, 26.2}, {2080.0, 3.0, 6.0, 18.0, -32768.0, 26.2}, {2080.0, 3.0, 6.0, 23.0, -32768.0, 26.2}, {2080.0, 3.0, 6.0, 26.0, -32768.0, 26.2}, {2080.0, 3.0, 6.0, 28.0, -32768.0, 26.2}, {2080.0, 3.0, 6.0, 32.0, -32768.0, 26.2}, {2080.0, 3.0, 6.0, 38.0, -32768.0, 26.2}};
        this.addSystemParam(extSystemParamsTable);
    }

    private void addSystemParam(double[][] systemParamsTable) {
        TENESystemParamsData data = null;
        int len = systemParamsTable.length;
        for (int datai = 0; datai < len; ++datai) {
            if (datai == systemParamsTable.length - 1) {
                TELogFactory.getNormalLogger().info("datai == systemParamsTable.length - 1");
            }
            double[] boardParam = systemParamsTable[datai];
            data = new TENESystemParamsData((int)boardParam[0], (int)boardParam[1], (int)boardParam[2], boardParam[3], boardParam[4] * 10.0, boardParam[5] * 10.0);
            systemParams.add(data);
        }
    }

    public static TENEPoint[] getValidPointsFromData(String num, String rslmse) {
        String[] rslmseNum;
        TENEPoint[] defaultPoint = new TENEPoint[2];
        ArrayList<TENEPoint> points = new ArrayList<TENEPoint>();
        int pointNum = Integer.valueOf(num);
        if (pointNum == (rslmseNum = rslmse.toLowerCase(Locale.ENGLISH).split(",")).length / 2) {
            TENEPoint point = null;
            int len = rslmseNum.length;
            for (int i = 0; i < len; i += 2) {
                point = new TENEPoint();
                double x_rsl = Double.valueOf(rslmseNum[i]);
                double y_mse = Double.valueOf(rslmseNum[i + 1]);
                point.setCoordinate_x(x_rsl);
                point.setCoordinate_y(y_mse);
                points.add(point);
            }
        }
        Collections.sort(points);
        TENEPoint tempLPoint = (TENEPoint)points.get(0);
        TENEPoint lpoint = new TENEPoint(tempLPoint.getCoordinate_x(), tempLPoint.getCoordinate_y());
        defaultPoint[0] = TENESystemParamsUtils.getHPoint(points);
        defaultPoint[1] = lpoint;
        return defaultPoint;
    }

    private static TENEPoint getHPoint(List<TENEPoint> points) {
        ArrayList<TENEPoint> allPoints = new ArrayList<TENEPoint>();
        TENEPoint defualtHPoint = new TENEPoint();
        TENEPoint lPoint = points.get(0);
        double sMSEL = lPoint.getCoordinate_y();
        Collections.reverse(points);
        allPoints.addAll(points);
        TENEPoint tempHPoint = null;
        HashMap<Double, TENEPoint> deltaMseMap = new HashMap<Double, TENEPoint>();
        int len = allPoints.size();
        for (int i = 0; i < len; ++i) {
            tempHPoint = (TENEPoint)allPoints.get(i);
            if (tempHPoint.getCoordinate_y() - sMSEL < 5.0) continue;
            double deltaMse = 0.0;
            for (int j = i; j < len; ++j) {
                deltaMse += TENESystemParamsUtils.CalculateDeltaMSEValue(lPoint, tempHPoint, (TENEPoint)allPoints.get(j));
            }
            deltaMseMap.put(deltaMse, tempHPoint);
        }
        Iterator iteratot = deltaMseMap.keySet().iterator();
        double key = 65536.0;
        while (iteratot.hasNext()) {
            double tempKey = (Double)iteratot.next();
            if (!(key > tempKey)) continue;
            key = tempKey;
            defualtHPoint = (TENEPoint)deltaMseMap.get(key);
        }
        return defualtHPoint;
    }

    public static double CalculateDeltaRSLValue(TENEPoint lPoint, TENEPoint tempHPoint, double Mset) {
        double deltaValue = 0.0;
        double RSLL = lPoint.getCoordinate_x();
        double MSEL = lPoint.getCoordinate_y();
        double RSLH = tempHPoint.getCoordinate_x();
        double MSEH = tempHPoint.getCoordinate_y();
        double lfMset = Mset;
        RSLL = Math.pow(10.0, RSLL / 100.0);
        MSEL = Math.pow(10.0, MSEL / 100.0);
        RSLH = Math.pow(10.0, RSLH / 100.0);
        MSEH = Math.pow(10.0, MSEH / 100.0);
        lfMset = Math.pow(10.0, lfMset / 100.0);
        double lfTemp1 = 0.0;
        double lfTemp2 = 0.0;
        lfTemp1 = lfMset * RSLH * (RSLL * (MSEH - MSEL));
        lfTemp2 = MSEH * MSEL * (RSLH - RSLL) - lfMset * (RSLH * MSEL - RSLL * MSEH);
        deltaValue = lfTemp1 / lfTemp2;
        deltaValue = 100.0 * Math.log10(deltaValue);
        return deltaValue;
    }

    private static double CalculateDeltaMSEValue(TENEPoint lPoint, TENEPoint tempHPoint, TENEPoint lfPoint) {
        double deltaValue = 0.0;
        double RSLL = lPoint.getCoordinate_x();
        double MSEL = lPoint.getCoordinate_y();
        double RSLH = tempHPoint.getCoordinate_x();
        double MSEH = tempHPoint.getCoordinate_y();
        double lfRslt = lfPoint.getCoordinate_x();
        double lfMset = lfPoint.getCoordinate_y();
        RSLL = Math.pow(10.0, RSLL / 100.0);
        MSEL = Math.pow(10.0, MSEL / 100.0);
        RSLH = Math.pow(10.0, RSLH / 100.0);
        MSEH = Math.pow(10.0, MSEH / 100.0);
        lfRslt = Math.pow(10.0, lfRslt / 100.0);
        double lfTemp1 = 0.0;
        double lfTemp2 = 0.0;
        lfTemp1 = lfRslt * MSEH * (MSEL * (RSLH - RSLL));
        lfTemp2 = (MSEH - MSEL) * RSLH * RSLL + lfRslt * (RSLH * MSEL - RSLL * MSEH);
        deltaValue = lfTemp1 / lfTemp2;
        deltaValue = 100.0 * Math.log10(deltaValue) - lfMset;
        return Math.abs(deltaValue);
    }
}

