/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.ethpfm;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.lpara.TEAlmObjTypeData;
import com.huawei.nglct.nelist.lpara.TEAlmReturnParamParse;
import com.huawei.nglct.nelist.lpara.TELParamMgr;
import com.huawei.nglct.nelist.lpara.TEObjectParam;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.performance.TEPfmMonObjID;
import com.huawei.nglct.nemgr.rtn.ethpfm.TEEthPfmUtils;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.List;

public class TEQueryQueuePfmBean
extends TENEExplorerBean {
    private static final String NSCMD_PM_GET_STATDATA = "NSCMD_PM_GET_STATDATA";
    private static final int FIRST_COS = 1;
    private static final int LAST_COS = 8;
    private static final int NEW_PORT_PRI_OBJ = 107;
    TELParamMgr objTypeMgr = null;
    private List<RowParams> outputRow = null;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.objTypeMgr = new TELParamMgr(neid);
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        RowParams rowparams = inputData.getBussinessParams().getRowParams(0);
        int slotid = Integer.parseInt(rowparams.getParam("slotid").getValue());
        int portid = Integer.parseInt(rowparams.getParam("portid").getValue());
        TEPfmMonObjID monObj = new TEPfmMonObjID();
        monObj.setSlotID(slotid);
        monObj.setPortID(portid);
        Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)NSCMD_PM_GET_STATDATA);
        List<Integer> querypfmevents = TEEthPfmUtils.getQueryQueuePfmEventIDs();
        TEObjectParam objparam = null;
        this.outputRow = new ArrayList<RowParams>();
        for (int i = 1; i <= 8; ++i) {
            monObj.setPathID(i);
            objparam = this.objTypeMgr.getObjectParam(String.valueOf(107), monObj);
            oper.getInput().setPartValue("reserve", "255");
            oper.getInput().setPartValue("objtype", objparam.getObjType());
            oper.getInput().setPartValue("paralen", objparam.getParamLength());
            oper.getInput().setPartValue("objpara", objparam.getObjParam());
            int len = querypfmevents.size();
            for (int j = 0; j < len; ++j) {
                oper.getInput().setPartValue("peid", String.valueOf(querypfmevents.get(j)));
                operationList.add((Operation)oper.clone());
            }
            RowParams row = new RowParams();
            row.addParam("queue", "costype_" + i);
            row.addParam("cos", String.valueOf(i));
            row.addParam("framecount", "/");
            row.addParam("dropframecount", "/");
            this.outputRow.add(row);
        }
        return operationList;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        int i;
        Operation operation = null;
        Output output = null;
        TEAlmObjTypeData almObjTypeObj = null;
        TEPfmMonObjID monObj = null;
        int len = operationList.size();
        for (i = 0; i < len; ++i) {
            operation = (Operation)operationList.get(i);
            for (int j = operation.getOutputCount() - 1; j >= 0; --j) {
                output = operation.getOutput(j);
                if (!output.getFault(0).getCode().equals(String.valueOf(0))) continue;
                String objtype = output.getPartValue("objtype");
                String objparam = output.getPartValue("objpara");
                almObjTypeObj = this.objTypeMgr.getAlmObjTypeData(Integer.valueOf(objtype).intValue());
                monObj = TEAlmReturnParamParse.getInstance().parseObjParam(objparam.getBytes(), almObjTypeObj);
                String eventValue = output.getPartValue("event");
                eventValue = TEEthPfmUtils.convertRmonValue(eventValue);
                int eventID = Integer.parseInt(output.getPartValue("peid"));
                this.setRowParamsValue(monObj.getPathID(), eventID, eventValue);
            }
        }
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        len = this.outputRow.size();
        for (i = 0; i < len; ++i) {
            this.outputData.getBussinessParams().addRowParams(this.outputRow.get(i));
        }
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
    }

    public void setRowParamsValue(int cos, int eventID, String eventValue) {
        RowParams row = null;
        int len = this.outputRow.size();
        for (int i = 0; i < len; ++i) {
            row = this.outputRow.get(i);
            if (!row.getParam("cos").getValue().equals(String.valueOf(cos))) continue;
            if (eventID == 648) {
                row.getParam("framecount").setValue(eventValue);
                continue;
            }
            if (eventID != 510) continue;
            row.getParam("dropframecount").setValue(eventValue);
        }
    }

    public String getDetailStr(RowParams rowparams) {
        String result = "";
        int slotid = Integer.parseInt(rowparams.getParam("slotid").getValue());
        int portid = Integer.parseInt(rowparams.getParam("portid").getValue());
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(this.neid, slotid);
        result = result + slotid + "-" + board.getBoardName() + "-" + portid + "-" + TEConfigurationDataMgr.getInstance().getPortNameForPTN(this.neid, slotid, board.getBoardType(), portid);
        return result;
    }
}

