/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.ethpfm;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.lpara.TEAlmObjTypeData;
import com.huawei.nglct.nelist.lpara.TEAlmReturnParamParse;
import com.huawei.nglct.nelist.lpara.TELParamMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.performance.TEPfmMonObjID;
import com.huawei.nglct.nelist.model.performance.TERMONPfmObjSelect;
import com.huawei.nglct.nemgr.necommon.rmon.TERmonConstant;
import com.huawei.nglct.nemgr.rtn.ethpfm.TEBoardPort;
import com.huawei.nglct.nemgr.rtn.ethpfm.TEEthPfmUtils;
import com.huawei.nglct.nemgr.rtn.ethpfm.TEEvent;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class TEQueryEthPfmBean
extends TENEExplorerBean {
    private static final String NSCMD_PM_GET_STATDATA = "NSCMD_PM_GET_STATDATA";
    private static final String NSCMD_PER_GET_CURDATA_NEW = "NSCMD_PER_GET_CURDATA_NEW";
    private static final String PER_PERIOD = "1";
    TELParamMgr objTypeMgr = null;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.objTypeMgr = new TELParamMgr(neid);
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        HashMap<TEBoardPort, List<TEEvent>> resultMap = new HashMap<TEBoardPort, List<TEEvent>>();
        ArrayList<Integer> errorList = new ArrayList<Integer>();
        this.handleOperationList(operationList, resultMap, errorList);
        this.outputData = this.createOutputData(resultMap, errorList);
    }

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        int i;
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)NSCMD_PM_GET_STATDATA);
        this.setLPOperationFixParam(oper);
        List<Integer> queryPfmIDs = TEEthPfmUtils.getQueryRmonEventIDs();
        int len = queryPfmIDs.size();
        for (i = 0; i < len; ++i) {
            oper.getInput().setPartValue("peid", String.valueOf(queryPfmIDs.get(i)));
            operationList.add((Operation)oper.clone());
        }
        oper = TECreateObjectFactory.getOperation((int)neid, (String)NSCMD_PER_GET_CURDATA_NEW);
        oper.getInput().setPartValue("period", PER_PERIOD);
        this.setLPOperationFixParam(oper);
        queryPfmIDs = TEEthPfmUtils.getQueryPfmEventIDs();
        len = queryPfmIDs.size();
        for (i = 0; i < len; ++i) {
            oper.getInput().setPartValue("peid", String.valueOf(queryPfmIDs.get(i)));
            operationList.add((Operation)oper.clone());
        }
        return operationList;
    }

    private Operation setLPOperationFixParam(Operation oper) {
        oper.getInput().setPartValue("reserve", "255");
        oper.getInput().setPartValue("objtype", "0");
        oper.getInput().setPartValue("paralen", "2");
        oper.getInput().setPartValue("objpara", "0000");
        return oper;
    }

    public void handleOperationList(List<Operation> operationList, Map<TEBoardPort, List<TEEvent>> resultMap, List<Integer> errorList) {
        Operation operation = null;
        Output output = null;
        TEBoardPort boardpfm = null;
        List<Object> eventList = null;
        TEAlmObjTypeData almObjTypeObj = null;
        TEPfmMonObjID monObj = null;
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            operation = operationList.get(i);
            for (int j = operation.getOutputCount() - 1; j >= 0; --j) {
                output = operation.getOutput(j);
                int code = Integer.parseInt(output.getFault(0).getCode());
                if (code != 0) {
                    if (this.getFilterErrorCodeList().contains(code)) continue;
                    errorList.add(code);
                    continue;
                }
                String objtype = output.getPartValue("objtype");
                String objparam = output.getPartValue("objpara");
                almObjTypeObj = this.objTypeMgr.getAlmObjTypeData(Integer.valueOf(objtype).intValue());
                monObj = TEAlmReturnParamParse.getInstance().parseObjParam(objparam.getBytes(), almObjTypeObj);
                String eventValue = "";
                if (operation.getName().equals(NSCMD_PER_GET_CURDATA_NEW)) {
                    eventValue = output.getPartValue("peValue");
                    eventValue = TEEthPfmUtils.convertPfmValue(eventValue);
                } else {
                    eventValue = output.getPartValue("event");
                    eventValue = TEEthPfmUtils.convertRmonValue(eventValue);
                }
                int eventID = Integer.parseInt(output.getPartValue("peid"));
                boardpfm = new TEBoardPort(monObj.getSlotID(), monObj.getPortID());
                if (!resultMap.containsKey(boardpfm)) {
                    eventList = new ArrayList();
                    resultMap.put(boardpfm, eventList);
                } else {
                    eventList = resultMap.get(boardpfm);
                }
                eventList.add(new TEEvent(eventID, eventValue));
            }
        }
    }

    public Datainterface createOutputData(Map<TEBoardPort, List<TEEvent>> resultMap, List<Integer> errorList) {
        TEBoard board = null;
        TEBoardPort boardpfm = null;
        List<TEEvent> eventList = null;
        List list = null;
        TERMONPfmObjSelect rmonpfm = null;
        RowParams row = null;
        Datainterface outputData = new Datainterface();
        outputData.setBussinessParams(new BussinessParams());
        TENE ne = TENEListMgr.getInstance().getNE(this.neid);
        Vector neBoardList = ne.getClonedBoardList();
        Collections.sort(neBoardList);
        ArrayList<TEBoardPort> existList = new ArrayList<TEBoardPort>();
        int len = neBoardList.size();
        for (int i = 0; i < len; ++i) {
            board = (TEBoard)neBoardList.get(i);
            list = TERmonConstant.getInstance().getObjSelectData(this.neid, board.getBoardType());
            int lenj = list.size();
            for (int j = 0; j < lenj; ++j) {
                rmonpfm = (TERMONPfmObjSelect)list.get(j);
                boardpfm = new TEBoardPort(board.getSlotID(), rmonpfm.getPortId());
                if (existList.contains(boardpfm)) continue;
                existList.add(boardpfm);
                eventList = resultMap.get(boardpfm);
                row = this.createRowParams(this.neid, boardpfm, eventList);
                outputData.getBussinessParams().addRowParams(row);
            }
        }
        int totalCode = 0;
        if (!errorList.isEmpty()) {
            totalCode = resultMap.isEmpty() ? 2 : 1;
            RowParams errrowparams = new RowParams();
            int len2 = errorList.size();
            for (int i = 0; i < len2; ++i) {
                RowErrors rowError = new RowErrors();
                ErrorMessage errorMessage = new ErrorMessage();
                errorMessage.setErrorcode(String.valueOf(errorList.get(i)));
                errorMessage.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorList.get(i)));
                rowError.setErrorMessage(errorMessage);
                Param rowObj = new Param();
                rowObj.setName("nename");
                rowObj.setValue(ne.getNEName());
                rowError.addParam(rowObj);
                errrowparams.addRowErrors(rowError);
            }
            outputData.getBussinessParams().addRowParams(errrowparams);
        }
        outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)totalCode));
        return outputData;
    }

    private RowParams createRowParams(int neid, TEBoardPort boardeth, List<TEEvent> eventList) {
        RowParams row = new RowParams();
        row.addParam("slotid", String.valueOf(boardeth.getSlotid()));
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(neid, boardeth.getSlotid());
        row.addParam("boardname", board.getBoardName());
        row.addParam("portid", String.valueOf(boardeth.getPortid()));
        boolean isIFBoard = TEConfigurationDataMgr.getInstance().isIFboard(board.getBoardType());
        String portname = TEConfigurationDataMgr.getInstance().getPortNameForPTN(neid, boardeth.getSlotid(), board.getBoardType(), boardeth.getPortid());
        row.addParam("portname", portname);
        row.addParam("inoutbyte", TEEthPfmUtils.getInOutBytes(eventList));
        row.addParam("inoutpack", TEEthPfmUtils.getInOutPack(eventList));
        row.addParam("inoutrate", TEEthPfmUtils.getInOutRate(eventList));
        row.addParam("inoututil", TEEthPfmUtils.getInOutUtil(eventList));
        if (isIFBoard) {
            row.addParam("frameerror", "-");
            row.addParam("othererror", "-");
            row.addParam("fec", TEEthPfmUtils.getFec(eventList));
        } else {
            row.addParam("frameerror", TEEthPfmUtils.getFrameErrors(eventList));
            row.addParam("othererror", TEEthPfmUtils.getOtherErrors(eventList));
            row.addParam("fec", "-");
        }
        return row;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errorCodeList = new ArrayList<Integer>();
        errorCodeList.add(38748);
        errorCodeList.add(38662);
        errorCodeList.add(42297);
        errorCodeList.add(42310);
        errorCodeList.add(38433);
        errorCodeList.add(42309);
        errorCodeList.add(38671);
        errorCodeList.add(40004);
        errorCodeList.add(38777);
        errorCodeList.add(38722);
        errorCodeList.add(38737);
        errorCodeList.add(46577);
        errorCodeList.add(46587);
        errorCodeList.add(38410);
        errorCodeList.add(46578);
        return errorCodeList;
    }
}

