/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.ethpfm;

import com.huawei.nglct.nemgr.rtn.ethpfm.TEEvent;
import com.huawei.nglct.util.io.IOStreamConvertor;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public final class TEEthPfmUtils {
    public static final int RXOCTETS = 200;
    public static final int TXOCTETS = 199;
    public static final int RXPKTS = 201;
    public static final int TXPKTS = 198;
    public static final int RXGOODFULLFRAMESPEED = 190;
    public static final int TXGOODFULLFRAMESPEED = 191;
    public static final int PORT_RX_BW_UTILIZATION = 567;
    public static final int PORT_TX_BW_UTILIZATION = 568;
    public static final int ETHFCS = 132;
    public static final int ETHUNDER = 122;
    public static final int ETHFRG = 124;
    public static final int ETHJAB = 125;
    public static final int FEC_UNCOR_BLOCK_CNT = 136;
    public static final int PORT_PRI_SNDPKTS = 648;
    public static final int QOS_PRI_DROPPKTS = 510;
    public static final String VALID_VALUE = "/";
    private static final String SPLIT = "/";
    private static final double FLAG = 4.294967296E9;
    private static final int K2MUNIT = 1000;
    private static final int I2PUNIT = 100;

    private static String joinPairValue(String first, String second) {
        first = first == null ? "" : first;
        second = second == null ? "" : second;
        String result = first + "/" + second;
        return result;
    }

    public static List<Integer> getQueryRmonEventIDs() {
        ArrayList<Integer> queryPfmIDs = new ArrayList<Integer>();
        queryPfmIDs.add(200);
        queryPfmIDs.add(199);
        queryPfmIDs.add(201);
        queryPfmIDs.add(198);
        queryPfmIDs.add(190);
        queryPfmIDs.add(191);
        queryPfmIDs.add(567);
        queryPfmIDs.add(568);
        queryPfmIDs.add(132);
        queryPfmIDs.add(122);
        queryPfmIDs.add(124);
        queryPfmIDs.add(125);
        return queryPfmIDs;
    }

    public static List<Integer> getQueryPfmEventIDs() {
        ArrayList<Integer> queryPfmIDs = new ArrayList<Integer>();
        queryPfmIDs.add(136);
        return queryPfmIDs;
    }

    public static List<Integer> getQueryQueuePfmEventIDs() {
        ArrayList<Integer> queryPfmIDs = new ArrayList<Integer>();
        queryPfmIDs.add(648);
        queryPfmIDs.add(510);
        return queryPfmIDs;
    }

    public static String getInOutBytes(List<TEEvent> eventList) {
        String result = "/";
        if (eventList != null) {
            result = TEEthPfmUtils.joinPairValue(TEEthPfmUtils.getEventValueFromList(eventList, 200), TEEthPfmUtils.getEventValueFromList(eventList, 199));
        }
        return result;
    }

    public static String getEventValueFromList(List<TEEvent> eventList, int eventID) {
        String result = null;
        TEEvent event = null;
        int len = eventList.size();
        for (int i = 0; i < len; ++i) {
            event = eventList.get(i);
            if (event.getEventID() != eventID) continue;
            result = event.getValue();
            break;
        }
        return result;
    }

    public static String getEventValueFromListPrecision(List<TEEvent> eventList, int eventID, int precision) {
        String result = TEEthPfmUtils.getEventValueFromList(eventList, eventID);
        if (result != null && !result.equals("") && !result.equals("0")) {
            float fresult = (float)Long.valueOf(result).longValue() / (float)precision;
            DecimalFormat df = new DecimalFormat("0.00");
            result = df.format(fresult);
        }
        return result;
    }

    public static String getInOutPack(List<TEEvent> eventList) {
        String result = "/";
        if (eventList != null) {
            result = TEEthPfmUtils.joinPairValue(TEEthPfmUtils.getEventValueFromList(eventList, 201), TEEthPfmUtils.getEventValueFromList(eventList, 198));
        }
        return result;
    }

    public static String getInOutRate(List<TEEvent> eventList) {
        String result = "/";
        if (eventList != null) {
            result = TEEthPfmUtils.joinPairValue(TEEthPfmUtils.getEventValueFromListPrecision(eventList, 190, 1000), TEEthPfmUtils.getEventValueFromListPrecision(eventList, 191, 1000));
        }
        return result;
    }

    public static String getInOutUtil(List<TEEvent> eventList) {
        String result = "/";
        if (eventList != null) {
            result = TEEthPfmUtils.joinPairValue(TEEthPfmUtils.getEventValueFromListPrecision(eventList, 567, 100), TEEthPfmUtils.getEventValueFromListPrecision(eventList, 568, 100));
        }
        return result;
    }

    public static String getFrameErrors(List<TEEvent> eventList) {
        String result = "/";
        if (eventList != null) {
            result = TEEthPfmUtils.getEventValueFromList(eventList, 132);
            result = result == null ? "/" : result;
        }
        return result;
    }

    public static String getOtherErrors(List<TEEvent> eventList) {
        String result = "/";
        if (eventList != null) {
            String ethjab;
            result = TEEthPfmUtils.getEventValueFromList(eventList, 122);
            String ethunder = result == null ? "/" : result;
            result = TEEthPfmUtils.getEventValueFromList(eventList, 124);
            String ethfrg = result == null ? "/" : result;
            result = TEEthPfmUtils.getEventValueFromList(eventList, 125);
            String string = ethjab = result == null ? "/" : result;
            if (ethunder.equals("/") && ethfrg.equals("/") && ethjab.equals("/")) {
                result = "/";
            } else {
                int count = ethunder.equals("/") ? 0 : Integer.parseInt(ethunder);
                count += ethfrg.equals("/") ? 0 : Integer.parseInt(ethfrg);
                result = String.valueOf(count += ethjab.equals("/") ? 0 : Integer.parseInt(ethjab));
            }
        }
        return result;
    }

    public static String getFec(List<TEEvent> eventList) {
        String result = "/";
        if (eventList != null) {
            result = TEEthPfmUtils.getEventValueFromList(eventList, 136);
            result = result == null ? "/" : result;
        }
        return result;
    }

    public static String convertPfmValue(String pevalue) {
        byte[] t = IOStreamConvertor.getByteArrayFromString((String)pevalue);
        long pValue = IOStreamConvertor.readLong((byte[])t, (int)0);
        return String.valueOf(pValue);
    }

    public static String convertRmonValue(String rmonvalue) {
        byte[] t = IOStreamConvertor.getByteArrayFromString((String)rmonvalue);
        long pValue = IOStreamConvertor.readLong((byte[])t, (int)0);
        return String.valueOf(pValue);
    }
}

