/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.e2e.pla;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.f_interface.asnpla.AsnPTNModifyPhyLinkAggrReq;
import com.huawei.nglct.nemgr.f_interface.asnpla.AsnPTNModifyPhyLinkAggrRsp;
import com.huawei.nglct.nemgr.f_interface.asnpla.AsnPTNPlaMod;
import com.huawei.nglct.nemgr.rtn.e2e.pla.TEE2Util;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEE2EModifyPLAHandler
extends TEWNEMgrHandler {
    protected static final Logger e2elogger = TELogFactory.getE2ELogger();

    protected int handleRequestImpl(FStruct fReq, FStruct fRsp, TaskMgr tm) {
        AsnPTNModifyPhyLinkAggrReq req = (AsnPTNModifyPhyLinkAggrReq)fReq;
        AsnPTNModifyPhyLinkAggrRsp rsp = (AsnPTNModifyPhyLinkAggrRsp)fRsp;
        if (req == null || req.plaModList.isEmpty() || req.neID == null) {
            TEE2Util.fillAsnSingleReturn(0, rsp.result);
            e2elogger.info("TEE2EModifyPLAHandler req is null!");
            return 0;
        }
        int neID = req.neID.intValue();
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (null != ne && 1 != ne.getLogStatus()) {
            TEHandleSbiInfo.getInstance().handleSBIConnectOnInter(neID);
        }
        Datainterface inputData = this.createInputData(req);
        Datainterface outputData = TEE2Util.performSubFunc(neID, 2179789, inputData);
        this.parseOutputData(neID, outputData, req, rsp);
        return 0;
    }

    protected Datainterface createInputData(AsnPTNModifyPhyLinkAggrReq req) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        inputData.setBussinessParams(bussiness);
        RowParams rowparams = null;
        int neID = req.neID.intValue();
        AsnPTNPlaMod plaModObj = null;
        int len = req.plaModList.size();
        for (int i = 0; i < len; ++i) {
            plaModObj = (AsnPTNPlaMod)req.plaModList.get(i);
            rowparams = new RowParams();
            rowparams.addParam("neid", String.valueOf(neID));
            rowparams.addParam("ggroupid", String.valueOf(plaModObj.plaID));
            rowparams.addParam("minUpLinkTH", String.valueOf(plaModObj.minActiveLinks));
            rowparams.addParam("isLogFlag", "0");
            bussiness.addRowParams(rowparams);
        }
        return inputData;
    }

    protected void parseOutputData(int neID, Datainterface outputData, AsnPTNModifyPhyLinkAggrReq req, AsnPTNModifyPhyLinkAggrRsp rsp) {
        if (outputData == null) {
            TEE2Util.fillAsnSingleReturn(1090593060, rsp.result);
            return;
        }
        int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != errorCode && 1 != errorCode && 2 != errorCode) {
            TEE2Util.fillAsnSingleReturn(errorCode, rsp.result);
            return;
        }
        BussinessParams bussiness = outputData.getBussinessParams();
        if (bussiness != null) {
            int len = bussiness.getRowParamsCount();
            for (int i = 0; i < len; ++i) {
                RowParams row = bussiness.getRowParams(i);
                if (row.getRowErrorsCount() == 0) continue;
                int retCode = Integer.parseInt(row.getRowErrors(0).getErrorMessage().getErrorcode());
                int plaID = TEE2Util.getIntParamValue(row.getRowErrors(0).getParam("ggroupid"));
                AsnPTNPlaMod plaObj = this.getAsnPTNPhyLinkAggrMod(req, plaID);
                if (plaObj == null) continue;
                TEE2Util.fillAsnSingleReturn(retCode, plaObj.result);
                rsp.plaModList.add((Object)plaObj);
            }
        }
        if (rsp.plaModList.isEmpty()) {
            TEE2Util.fillAsnSingleReturn(0, rsp.result);
        } else {
            TEE2Util.fillAsnSingleReturn(1090650121, rsp.result);
        }
    }

    private AsnPTNPlaMod getAsnPTNPhyLinkAggrMod(AsnPTNModifyPhyLinkAggrReq req, int plaID) {
        AsnPTNPlaMod plaObj = null;
        int len = req.plaModList.size();
        for (int i = 0; i < len; ++i) {
            plaObj = (AsnPTNPlaMod)req.plaModList.get(i);
            if (plaObj.plaID.intValue() != plaID) continue;
            return plaObj;
        }
        return null;
    }
}

