/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.e2e.pla;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.f_interface.asnpla.AsnPTNGetPhyLinkAggrReq;
import com.huawei.nglct.nemgr.f_interface.asnpla.AsnPTNGetPhyLinkAggrRsp;
import com.huawei.nglct.nemgr.f_interface.asnpla.AsnPTNPhyLinkAggr;
import com.huawei.nglct.nemgr.f_interface.asnpla.AsnPTNPlaMemberInfo;
import com.huawei.nglct.nemgr.rtn.e2e.pla.TEE2Util;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import java.math.BigInteger;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEE2EGetPLAHandler
extends TEWNEMgrHandler {
    protected static final Logger e2elogger = TELogFactory.getE2ELogger();

    protected int handleRequestImpl(FStruct fReq, FStruct fRsp, TaskMgr tm) {
        AsnPTNGetPhyLinkAggrReq req = (AsnPTNGetPhyLinkAggrReq)fReq;
        AsnPTNGetPhyLinkAggrRsp rsp = (AsnPTNGetPhyLinkAggrRsp)fRsp;
        if (req == null || req.neID == null) {
            TEE2Util.fillAsnSingleReturn(0, rsp.result);
            e2elogger.info("TEE2EGetPLAHandler req is null!");
            return 0;
        }
        int neID = req.neID.intValue();
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (null != ne && 1 != ne.getLogStatus()) {
            TEHandleSbiInfo.getInstance().handleSBIConnectOnInter(neID);
        }
        Datainterface inputData = this.createInputData(req);
        Datainterface outputData = TEE2Util.performSubFunc(neID, 2179777, inputData);
        this.parseOutputData(neID, outputData, rsp);
        if (!rsp.plaList.isEmpty()) {
            inputData = this.createSlavePortInputData(neID, rsp);
            outputData = TEE2Util.performSubFunc(neID, 2179788, inputData);
            this.parseSlavePortOutputData(neID, outputData, rsp);
        }
        return 0;
    }

    protected Datainterface createInputData(AsnPTNGetPhyLinkAggrReq req) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        inputData.setBussinessParams(bussiness);
        RowParams rowparams = null;
        int neID = req.neID.intValue();
        int len = req.idList.size();
        for (int i = 0; i < len; ++i) {
            BigInteger plaID = (BigInteger)req.idList.get(i);
            rowparams = new RowParams();
            rowparams.addParam("neid", String.valueOf(neID));
            rowparams.addParam("ggroupid", String.valueOf(plaID));
            rowparams.addParam("isLogFlag", "0");
            bussiness.addRowParams(rowparams);
        }
        return inputData;
    }

    protected Datainterface createSlavePortInputData(int neID, AsnPTNGetPhyLinkAggrRsp rsp) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        inputData.setBussinessParams(bussiness);
        RowParams rowparams = null;
        AsnPTNPhyLinkAggr plaObj = null;
        int len = rsp.plaList.size();
        for (int i = 0; i < len; ++i) {
            plaObj = (AsnPTNPhyLinkAggr)rsp.plaList.get(i);
            rowparams = new RowParams();
            rowparams.addParam("neid", String.valueOf(neID));
            rowparams.addParam("ggroupid", String.valueOf(plaObj.plaID));
            rowparams.addParam("isLogFlag", "0");
            bussiness.addRowParams(rowparams);
        }
        return inputData;
    }

    protected void parseOutputData(int neID, Datainterface outputData, AsnPTNGetPhyLinkAggrRsp rsp) {
        int retcode = TEE2Util.fillAsnSingleReturnResult(outputData, rsp.result);
        if (2 == retcode) {
            return;
        }
        BussinessParams bussiness = outputData.getBussinessParams();
        AsnPTNPhyLinkAggr plaObj = null;
        int len = bussiness.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            RowParams row = bussiness.getRowParams(i);
            if (row.getRowErrorsCount() != 0) continue;
            plaObj = new AsnPTNPhyLinkAggr();
            plaObj.plaType = BigInteger.valueOf(0L);
            plaObj.plaID = BigInteger.valueOf(TEE2Util.getIntParamValue(row.getParam("ggroupid")));
            plaObj.mainPortInfo = new AsnPTNPlaMemberInfo();
            plaObj.mainPortInfo.slotID = BigInteger.valueOf(TEE2Util.getIntParamValue(row.getParam("mainslotid")));
            plaObj.mainPortInfo.portID = BigInteger.valueOf(TEE2Util.getIntParamValue(row.getParam("mainportid")));
            plaObj.mainPortInfo.linkStatus = BigInteger.valueOf(TEE2Util.getIntParamValue(row.getParam("mainportLinkStatus")));
            plaObj.mainPortInfo.workStatus = BigInteger.valueOf(TEE2Util.getIntParamValue(row.getParam("mainportWorkStatus")));
            plaObj.mainPortInfo.hardwareStatus = BigInteger.valueOf(TEE2Util.getIntParamValue(row.getParam("mainportHDStatus")));
            plaObj.minActiveLinks = BigInteger.valueOf(TEE2Util.getIntParamValue(row.getParam("minUpLinkTH")));
            TEE2Util.fillAsnSingleReturn(0, plaObj.result);
            rsp.plaList.add((Object)plaObj);
        }
        if (!rsp.plaList.isEmpty()) {
            TEE2Util.fillAsnSingleReturn(0, rsp.result);
        }
    }

    protected void parseSlavePortOutputData(int neID, Datainterface outputData, AsnPTNGetPhyLinkAggrRsp rsp) {
        int retcode = TEE2Util.fillAsnSingleReturnResult(outputData, rsp.result);
        if (2 == retcode) {
            return;
        }
        BussinessParams bussiness = outputData.getBussinessParams();
        AsnPTNPhyLinkAggr plaObj = null;
        AsnPTNPlaMemberInfo salvePortInfo = null;
        int len = bussiness.getRowParamsCount();
        block0: for (int i = 0; i < len; ++i) {
            RowParams row = bussiness.getRowParams(i);
            if (row.getRowErrorsCount() != 0) continue;
            int plaID = TEE2Util.getIntParamValue(row.getParam("ggroupid"));
            int size = rsp.plaList.size();
            for (int j = 0; j < size; ++j) {
                plaObj = (AsnPTNPhyLinkAggr)rsp.plaList.get(i);
                if (plaObj.plaID.intValue() != plaID) continue;
                salvePortInfo = new AsnPTNPlaMemberInfo();
                salvePortInfo.slotID = BigInteger.valueOf(TEE2Util.getIntParamValue(row.getParam("slavesloid")));
                salvePortInfo.portID = BigInteger.valueOf(TEE2Util.getIntParamValue(row.getParam("slaveportid")));
                salvePortInfo.linkStatus = BigInteger.valueOf(TEE2Util.getIntParamValue(row.getParam("slaveportLinkStatus")));
                salvePortInfo.workStatus = BigInteger.valueOf(TEE2Util.getIntParamValue(row.getParam("slaveportWorkStatus")));
                salvePortInfo.hardwareStatus = BigInteger.valueOf(TEE2Util.getIntParamValue(row.getParam("slaveportHardStatus")));
                plaObj.branchPortInfoList.add((Object)salvePortInfo);
                continue block0;
            }
        }
    }
}

