/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.e2e.pla;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.f_interface.asnpla.AsnPTNCreatePhyLinkAggrReq;
import com.huawei.nglct.nemgr.f_interface.asnpla.AsnPTNCreatePhyLinkAggrRsp;
import com.huawei.nglct.nemgr.f_interface.asnpla.AsnPTNPhyLinkAggr;
import com.huawei.nglct.nemgr.f_interface.asnpla.AsnPTNPlaMemberInfo;
import com.huawei.nglct.nemgr.f_interface.asnpla.AsnPTNPlaMemberInfoList;
import com.huawei.nglct.nemgr.rtn.e2e.pla.TEE2Util;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import java.math.BigInteger;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEE2ECreatePLAHandler
extends TEWNEMgrHandler {
    protected static final Logger e2elogger = TELogFactory.getE2ELogger();
    private static final int FLAG_SLOT = 1;
    private static final int FLAG_PORT = 2;

    protected int handleRequestImpl(FStruct fReq, FStruct fRsp, TaskMgr tm) {
        AsnPTNCreatePhyLinkAggrReq req = (AsnPTNCreatePhyLinkAggrReq)fReq;
        AsnPTNCreatePhyLinkAggrRsp rsp = (AsnPTNCreatePhyLinkAggrRsp)fRsp;
        if (req == null || req.plaList.isEmpty() || req.neID == null) {
            rsp.result.retCode = BigInteger.valueOf(0L);
            e2elogger.info("TEE2ECreatePLAHandler req is null!");
            return 0;
        }
        int neID = req.neID.intValue();
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (null != ne && 1 != ne.getLogStatus()) {
            TEHandleSbiInfo.getInstance().handleSBIConnectOnInter(neID);
        }
        Datainterface inputData = this.createInputData(req);
        Datainterface outputData = TEE2Util.performSubFunc(neID, 2179775, inputData);
        this.parseOutputData(neID, outputData, req, rsp);
        rsp.result.isSuccess = true;
        return 0;
    }

    protected Datainterface createInputData(AsnPTNCreatePhyLinkAggrReq req) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        inputData.setBussinessParams(bussiness);
        RowParams rowparams = null;
        int neID = req.neID.intValue();
        AsnPTNPhyLinkAggr plaObj = null;
        int len = req.plaList.size();
        for (int i = 0; i < len; ++i) {
            plaObj = (AsnPTNPhyLinkAggr)req.plaList.get(i);
            rowparams = new RowParams();
            rowparams.addParam("neid", String.valueOf(neID));
            rowparams.addParam("ggroupid", String.valueOf(plaObj.plaID));
            rowparams.addParam("mainslotid", String.valueOf(plaObj.mainPortInfo.slotID));
            rowparams.addParam("mainportid", String.valueOf(plaObj.mainPortInfo.portID));
            rowparams.addParam("slaveportnum", String.valueOf(plaObj.branchPortInfoList.size()));
            rowparams.addParam("slaveslotids", this.GetSlaveSlotID(plaObj.branchPortInfoList, 1));
            rowparams.addParam("slaveportids", this.GetSlaveSlotID(plaObj.branchPortInfoList, 2));
            rowparams.addParam("isLogFlag", "0");
            bussiness.addRowParams(rowparams);
        }
        return inputData;
    }

    private String GetSlaveSlotID(AsnPTNPlaMemberInfoList salvePortInfoList, int slotPortFlag) {
        StringBuilder builder = new StringBuilder();
        int len = salvePortInfoList.size();
        for (int i = 0; i < len; ++i) {
            AsnPTNPlaMemberInfo salvePort = (AsnPTNPlaMemberInfo)salvePortInfoList.get(i);
            if (i > 0) {
                builder.append(",");
            }
            if (slotPortFlag == 1) {
                builder.append(salvePort.slotID);
                continue;
            }
            builder.append(salvePort.portID);
        }
        return builder.toString();
    }

    protected void parseOutputData(int neID, Datainterface outputData, AsnPTNCreatePhyLinkAggrReq req, AsnPTNCreatePhyLinkAggrRsp rsp) {
        if (outputData == null) {
            TEE2Util.fillAsnSingleReturn(1090593060, rsp.result);
            return;
        }
        int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != errorCode && 1 != errorCode && 2 != errorCode) {
            TEE2Util.fillAsnSingleReturn(errorCode, rsp.result);
            return;
        }
        BussinessParams bussiness = outputData.getBussinessParams();
        if (bussiness != null) {
            int len = bussiness.getRowParamsCount();
            for (int i = 0; i < len; ++i) {
                RowParams row = bussiness.getRowParams(i);
                if (row.getRowErrorsCount() == 0) continue;
                int retCode = Integer.parseInt(row.getRowErrors(0).getErrorMessage().getErrorcode());
                int plaID = TEE2Util.getIntParamValue(row.getRowErrors(0).getParam("ggroupid"));
                AsnPTNPhyLinkAggr plaObj = this.getAsnPTNPhyLinkAggr(req, plaID);
                if (plaObj == null) continue;
                TEE2Util.fillAsnSingleReturn(retCode, plaObj.result);
                rsp.plaList.add((Object)plaObj);
            }
        }
        if (rsp.plaList.isEmpty()) {
            TEE2Util.fillAsnSingleReturn(0, rsp.result);
        } else {
            TEE2Util.fillAsnSingleReturn(1090650121, rsp.result);
        }
    }

    private AsnPTNPhyLinkAggr getAsnPTNPhyLinkAggr(AsnPTNCreatePhyLinkAggrReq req, int plaID) {
        AsnPTNPhyLinkAggr plaObj = null;
        int len = req.plaList.size();
        for (int i = 0; i < len; ++i) {
            plaObj = (AsnPTNPhyLinkAggr)req.plaList.get(i);
            if (plaObj.plaID.intValue() != plaID) continue;
            return plaObj;
        }
        return null;
    }
}

