/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.cpri;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TESetCpriMode
extends TENEExplorerBean {
    private static final String MODE_CPRI = "1";
    private static final String TRASN_START = "NSCMD_CFG_TRANSACTION_BEGIN";
    private static final String TRASN_END = "NSCMD_CFG_TRANSACTION_END";
    private String cpriMode = "0";
    private static List<String> trasactionCmdList = new ArrayList<String>();

    private void addTransaction(ArrayList<Operation> operList) {
        ArrayList<Operation> tmpOpers = new ArrayList<Operation>();
        Iterator<Operation> iter = operList.iterator();
        while (iter.hasNext()) {
            Operation oper = iter.next();
            if (!trasactionCmdList.contains(oper.getName())) continue;
            tmpOpers.add(oper);
            iter.remove();
        }
        if (tmpOpers.isEmpty()) {
            TELogFactory.getNormalLogger().error("Set Cpri Mode: opers is null!");
            return;
        }
        if (tmpOpers.size() > 1) {
            Operation trans_start_oper = TECreateObjectFactory.getOperation((int)this.neid, (String)TRASN_START);
            Operation trans_end_oper = TECreateObjectFactory.getOperation((int)this.neid, (String)TRASN_END);
            tmpOpers.add(0, trans_start_oper);
            tmpOpers.add(trans_end_oper);
            operList.addAll(tmpOpers);
        } else {
            operList.addAll(tmpOpers);
        }
    }

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        Operation oper;
        RowParams[] rows = inputData.getBussinessParams().getRowParams();
        if (rows.length <= 0) {
            TELogFactory.getNormalLogger().error("Set Cpri Mode: Input Params is null!");
            return null;
        }
        Param mode = rows[0].getParam("cprimode");
        if (mode == null || mode.getValue() == null) {
            TELogFactory.getNormalLogger().error("Set Cpri Mode: Cpri Mode Params is null!");
            return null;
        }
        this.cpriMode = mode.getValue();
        ArrayList<Operation> operList = new ArrayList<Operation>();
        if (this.cpriMode.equals(MODE_CPRI)) {
            TELogFactory.getNormalLogger().error("Set Cpri Mode: set cpri mode!");
            oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_CFG_SET_ACM_PARAM");
            this.setInputValue(oper, rows[0], "slotid", "slotid");
            this.setInputValue(oper, rows[0], "subslotid", "subslotid");
            oper.getInput().setPartValue("port", MODE_CPRI);
            this.setInputValue(oper, rows[0], "W32PORT_ATTR_ACMENABLESTATUS", "W32PORT_ATTR_ACMENABLESTATUS");
            this.setInputValue(oper, rows[0], "W32PORT_ATTR_ENSURECALMODE", "W32PORT_ATTR_ENSURECALMODE");
            this.setInputValue(oper, rows[0], "W32PORT_ATTR_ALLCALMODE", "W32PORT_ATTR_ALLCALMODE");
            this.setInputValue(oper, rows[0], "W32PORT_ATTR_MANUALMODE", "W32PORT_ATTR_MANUALMODE");
            operList.add(oper);
            oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_CFG_SET_IF_CHANNELSPACE");
            this.setInputValue(oper, rows[0], "slotid", "slotid");
            this.setInputValue(oper, rows[0], "subslotid", "subslotid");
            oper.getInput().setPartValue("port", MODE_CPRI);
            this.setInputValue(oper, rows[0], "W32PORT_ATTR_CHANNELSPACE", "W32PORT_ATTR_CHANNELSPACE");
            operList.add(oper);
            trasactionCmdList.add("NSCMD_PTN_CFG_SET_ACM_PARAM");
            trasactionCmdList.add("NSCMD_PTN_CFG_SET_IF_CHANNELSPACE");
        } else {
            TELogFactory.getNormalLogger().error("Set Cpri Mode: set normal mode!");
        }
        oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_SET_CPRI_MODE");
        oper.getInput().setPartValue("slotid", rows[0].getParam("slotid").getValue());
        oper.getInput().setPartValue("subslotid", rows[0].getParam("subslotid").getValue());
        oper.getInput().setPartValue("dynport", rows[0].getParam("dynport").getValue());
        operList.add(oper);
        trasactionCmdList.add("NSCMD_CFG_SET_CPRI_MODE");
        this.addTransaction(operList);
        return operList;
    }

    private void setInputValue(Operation oper, RowParams rowParams, String inputParamName, String rowParamName) {
        oper.getInput().setPartValue(inputParamName, rowParams.getParam(rowParamName).getValue());
    }
}

