/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.atpc;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.gencfg.TimeZoneDateBean;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.nglct.util.string.TEStringUtils;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.io.File;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class TEQueryAtpcHistoryBean
extends TENEExplorerBean {
    private static final int ATPC_TIME_OUT = 60;
    private static final String ACTTRANSMITPOWER = "W32PORT_ATTR_ATPCTRPOWER";
    private static final String ACTRECEIVEPOWER = "W32PORT_ATTR_ATPCREPOWER";
    private static final String ATPCADJUSTTIME = "W32PORT_ATTR_ATPCMODIFYTIME";
    private boolean isByteTime = false;
    protected static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String BASE_PATH = "rtn" + File.separator + "res" + File.separator;
    private static final String STRING_SOURCE = BASE_PATH + "atpc" + File.separator + "atpcmodifyhistory_" + LANGUAGE + ".ini";
    TEResourceUtil res = null;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        if (null != inputData.getBussinessParams().getRowParams()[0].getParam("filename") && null != memeryData) {
            TEResourceUtil res = TEGetFilePath.getResource((int)neid, (String)STRING_SOURCE);
            String value = "";
            int len = memeryData.getBussinessParams().getRowParamsCount();
            for (int i = 0; i < len; ++i) {
                RowParams rowParams = memeryData.getBussinessParams().getRowParams(i);
                if (null != rowParams.getParam("slotid") && null != rowParams.getParam("boardname") && null != rowParams.getParam("portname")) {
                    String opticalName = rowParams.getParam("slotid").getValue() + "-" + rowParams.getParam("boardname").getValue() + "-" + rowParams.getParam("portname").getValue();
                    rowParams.addParam("opticalName", opticalName);
                }
                if (null != rowParams.getParam("W32PORT_ATTR_ATPMODIFYDIR") && TEStringUtils.isNumber((String)rowParams.getParam("W32PORT_ATTR_ATPMODIFYDIR").getValue())) {
                    value = rowParams.getParam("W32PORT_ATTR_ATPMODIFYDIR").getValue();
                    rowParams.getParam("W32PORT_ATTR_ATPMODIFYDIR").setValue(res.getString("W32PORT_ATTR_ATPMODIFYDIR_" + value));
                }
                if (null == rowParams.getParam("W32PORT_ATTR_ATPCMODIFYACT") || !TEStringUtils.isNumber((String)rowParams.getParam("W32PORT_ATTR_ATPCMODIFYACT").getValue())) continue;
                value = rowParams.getParam("W32PORT_ATTR_ATPCMODIFYACT").getValue();
                rowParams.getParam("W32PORT_ATTR_ATPCMODIFYACT").setValue(res.getString("W32PORT_ATTR_ATPCMODIFYACT_" + value));
            }
            return memeryData;
        }
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        Output output = null;
        Operation operation = null;
        int m = operationList.size();
        for (int i = 0; i < m; ++i) {
            operation = (Operation)operationList.get(i);
            if (!"NSCMD_CFG_GET_ATPC_HISTORY_WBID".equals(operation.getName())) continue;
            this.isByteTime = true;
            int n = operation.getOutputCount();
            for (int j = 0; j < n; ++j) {
                output = operation.getOutput(j);
                if (!output.getFault(0).getCode().equals("0") || output.getPartValue(ATPCADJUSTTIME) == null || output.getPartValue(ATPCADJUSTTIME).equals("")) continue;
                output.setPartValue(ATPCADJUSTTIME, TEDateUtils.byteStrToDateStr((String)output.getPartValue(ATPCADJUSTTIME)));
            }
        }
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        if (null == this.outputData || null == this.outputData.getBussinessParams()) {
            TELogFactory.getNormalLogger().warn("TEQueryAtpcHistoryBean outputData is null!");
            return;
        }
        if (this.outputData.getBussinessParams().getRowParamsCount() == 0) {
            return;
        }
        RowParams rowparams = null;
        int len = this.outputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            String repower;
            short value;
            int temp;
            String trpower;
            rowparams = this.outputData.getBussinessParams().getRowParams(i);
            if (rowparams.getParamCount() == 0) continue;
            if (null != rowparams.getParam(ACTTRANSMITPOWER) && !(trpower = rowparams.getParam(ACTTRANSMITPOWER).getValue()).equals("-1")) {
                temp = new BigInteger(trpower).intValue();
                value = (short)temp;
                rowparams.getParam(ACTTRANSMITPOWER).setValue(Float.toString((float)value / 10.0f));
            }
            if (null != rowparams.getParam(ACTRECEIVEPOWER) && !(repower = rowparams.getParam(ACTRECEIVEPOWER).getValue()).equals("-1")) {
                temp = new BigInteger(repower).intValue();
                value = (short)temp;
                rowparams.getParam(ACTRECEIVEPOWER).setValue(Float.toString((float)value / 10.0f));
            }
            if (null == rowparams.getParam(ATPCADJUSTTIME)) continue;
            String adjustTime = rowparams.getParam(ATPCADJUSTTIME).getValue();
            String timeFormat = "yyyy-MM-dd HH:mm:ss:SSS";
            if (this.isByteTime) {
                timeFormat = TimeZoneDateBean.getTimeConvertFormat();
            }
            try {
                SimpleDateFormat sf = new SimpleDateFormat(timeFormat);
                GregorianCalendar neTimeCalendar = new GregorianCalendar();
                if (adjustTime.equals("-1")) continue;
                Date date = sf.parse(adjustTime);
                neTimeCalendar.setTime(date);
                rowparams.getParam(ATPCADJUSTTIME).setValue(TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neid).calendarToTime((Calendar)neTimeCalendar));
                continue;
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("Format ATPC adjustment time fail!", (Throwable)e);
            }
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errorList = new ArrayList<Integer>();
        errorList.add(38737);
        errorList.add(38662);
        return errorList;
    }

    public int getTimeOut() {
        return 60;
    }
}

