/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.amgraphic;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nemgr.rtn.amgraphic.AMData;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TEAMDrawing {
    private SimpleDateFormat normal_format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private DateFormat spec_format = new SimpleDateFormat("MM/dd HH:mm:ss");
    private static final String RESOUCE_PATH = "rtn" + File.separator + "res" + File.separator + "graphanalyse" + File.separator + "odugraphres_" + TESysManagerBean.getInstance().getlanguage() + ".ini";
    private static final int MANUALSWT = 1;
    private int imgW;
    private int imgH;
    private String sdate;
    private String edate;
    private int topX;
    private int topY;
    private int scaleY;
    private int scaleX;
    private long startTimeLong;
    private long timeEq;
    private List<AMData> dataList;
    private int neid;

    public void setNeid(int neid) {
        this.neid = neid;
    }

    public void setDataList(List<AMData> dataList) {
        this.dataList = dataList;
    }

    public void setImgW(int imgW) {
        this.imgW = imgW;
    }

    public void setImgH(int imgH) {
        this.imgH = imgH;
    }

    public void setSdate(String sdate) {
        this.sdate = sdate;
    }

    public void setEdate(String edate) {
        this.edate = edate;
    }

    private String getResourceByName(String rname) {
        return TEGetFilePath.getResource((int)this.neid, (String)RESOUCE_PATH).getString(rname);
    }

    public BufferedImage createImg() {
        BufferedImage img = new BufferedImage(this.imgW, this.imgH, 1);
        Graphics2D paintBrush = (Graphics2D)img.getGraphics();
        this.initIMGProperties();
        this.paintBackGroundElement(paintBrush);
        if (this.sdate != null && this.edate != null) {
            this.paintTimeLineStr(paintBrush);
        }
        if (this.dataList != null && !this.dataList.isEmpty()) {
            this.paintTrendLine(paintBrush);
        }
        return img;
    }

    private void paintBackGroundElement(Graphics2D paintBrush) {
        paintBrush.setColor(new Color(239, 239, 239));
        paintBrush.fillRect(0, 0, this.imgW, this.imgH);
        paintBrush.setColor(Color.black);
        paintBrush.fillRect(this.topX - 1, this.topY, 2, this.scaleY * 16);
        int lastY = this.topY;
        for (int i = 0; i < 17; ++i) {
            paintBrush.setColor(Color.gray);
            if (i == 16) {
                paintBrush.setStroke(new BasicStroke(2.0f));
                paintBrush.setColor(Color.black);
            }
            paintBrush.drawLine(this.topX, lastY, this.topX + this.scaleX * 10, lastY);
            this.drawYCoordinateStr(paintBrush, lastY, i);
            lastY += this.scaleY;
        }
        paintBrush.setStroke(new BasicStroke(1.0f));
        paintBrush.setColor(Color.gray);
        int lastX = this.topX + this.scaleX;
        for (int i = 0; i < 10; ++i) {
            paintBrush.drawLine(lastX, this.topY, lastX, this.topY + this.scaleY * 16);
            lastX += this.scaleX;
        }
        this.drawLegend(paintBrush);
    }

    private void drawYCoordinateStr(Graphics2D paintBrush, int lastY, int i) {
        int resMark;
        int fontSize = 14;
        switch (i) {
            case 1: {
                resMark = 15;
                break;
            }
            case 2: {
                resMark = 14;
                break;
            }
            case 3: {
                resMark = 13;
                break;
            }
            case 4: {
                resMark = 12;
                break;
            }
            case 5: {
                resMark = 11;
                break;
            }
            case 6: {
                resMark = 10;
                break;
            }
            case 7: {
                resMark = 9;
                break;
            }
            case 8: {
                resMark = 8;
                break;
            }
            case 9: {
                resMark = 7;
                break;
            }
            case 10: {
                resMark = 6;
                break;
            }
            case 11: {
                resMark = 5;
                break;
            }
            case 12: {
                resMark = 4;
                break;
            }
            case 13: {
                resMark = 3;
                break;
            }
            case 14: {
                resMark = 2;
                break;
            }
            case 15: {
                resMark = 1;
                break;
            }
            default: {
                resMark = 0;
            }
        }
        String strX = this.getResourceByName("acmevt_" + resMark);
        if (!"acmevt_0".equals(strX)) {
            paintBrush.setColor(Color.black);
            paintBrush.setFont(new Font("", 1, fontSize));
            int offSetX = this.topX - (strX.length() + 4) * fontSize / 2;
            paintBrush.drawString(strX, offSetX, lastY + fontSize / 2);
        }
    }

    private void drawLegend(Graphics2D paintBrush) {
        double languageScale = 1.0;
        if ("zh".equals(TESysManagerBean.getInstance().getlanguage())) {
            languageScale = 1.5;
        }
        String legend = this.getResourceByName("Legend");
        String autoSw = this.getResourceByName("amautoswt");
        String manualSw = this.getResourceByName("ammanualswt");
        int offSetY = 5;
        int offSetX = 10;
        int picLength = 20;
        int fontSize = 14;
        paintBrush.setColor(Color.black);
        paintBrush.setFont(new Font("", 1, fontSize));
        paintBrush.drawString(legend, offSetX, offSetY + fontSize);
        int autoSwOffSetX = legend.length() * fontSize;
        paintBrush.drawString(autoSw, (int)(languageScale * (double)autoSwOffSetX), offSetY + fontSize);
        int manualSwOffSetX = autoSwOffSetX + autoSw.length() * fontSize + picLength;
        paintBrush.drawString(manualSw, (int)(languageScale * (double)manualSwOffSetX), offSetY + fontSize);
        int imgOffSetY = offSetY + fontSize / 2;
        paintBrush.setColor(Color.red);
        paintBrush.fillRect((int)((double)(autoSwOffSetX + autoSw.length() * 8 + offSetX) * languageScale), imgOffSetY, picLength, 3);
        paintBrush.setColor(Color.blue);
        paintBrush.fillRect((int)((double)(manualSwOffSetX + manualSw.length() * 8 + offSetX) * languageScale), imgOffSetY, picLength, 3);
    }

    private void paintTimeLineStr(Graphics2D paintBrush) {
        this.getTimeEq();
        int fontSize = 14;
        paintBrush.setColor(Color.black);
        paintBrush.setFont(new Font("", 1, fontSize));
        String startTimeStr = this.spec_format.format(new Date(this.startTimeLong));
        int offSetX = this.topX - startTimeStr.length() * 4;
        int offSetY = this.topY + this.scaleY * 16 + fontSize;
        paintBrush.drawString(startTimeStr, offSetX, offSetY);
        double scaleTime = (double)this.timeEq / 10.0;
        for (int i = 1; i < 11; ++i) {
            paintBrush.drawString(this.spec_format.format(new Date(this.startTimeLong + (long)scaleTime * (long)i)), offSetX + this.scaleX * i, offSetY);
        }
    }

    private void initIMGProperties() {
        this.topX = 140;
        this.topY = 30;
        this.scaleX = (this.imgW - this.topX - 50) / 10;
        this.scaleY = (this.imgH - this.topY - 30) / 16;
    }

    private void paintTrendLine(Graphics2D paintBrush) {
        paintBrush.setStroke(new BasicStroke(2.0f));
        int len = this.dataList.size();
        ArrayList<Integer> temp_X = new ArrayList<Integer>();
        ArrayList<Integer> temp_Y = new ArrayList<Integer>();
        int last_Y = -1;
        for (int i = 0; i < len; ++i) {
            AMData data = this.dataList.get(i);
            int current_X = this.generateX(data.getDate());
            int current_Y = this.generateY(data.getAmMode());
            int currentFuncType = data.getAmEvtType();
            if (i == 0) {
                temp_X.add(current_X);
                temp_Y.add(current_Y);
                last_Y = current_Y;
                continue;
            }
            temp_X.add(current_X);
            temp_Y.add(last_Y);
            if (currentFuncType == 1) {
                int[] xArray = this.toArrayUtil(temp_X);
                int[] yArray = this.toArrayUtil(temp_Y);
                paintBrush.setColor(Color.red);
                paintBrush.drawPolyline(xArray, yArray, temp_X.size());
                temp_X.clear();
                temp_Y.clear();
                int[] xArray_Manual = new int[]{current_X, current_X};
                int[] yArray_Manual = new int[]{last_Y, current_Y};
                paintBrush.setColor(Color.blue);
                paintBrush.drawPolyline(xArray_Manual, yArray_Manual, 2);
                last_Y = current_Y;
                temp_X.add(current_X);
                temp_Y.add(current_Y);
                continue;
            }
            temp_X.add(current_X);
            temp_Y.add(current_Y);
            last_Y = current_Y;
        }
        if (!temp_X.isEmpty()) {
            int[] xArray = this.toArrayUtil(temp_X);
            int[] yArray = this.toArrayUtil(temp_Y);
            paintBrush.setColor(Color.red);
            paintBrush.drawPolyline(xArray, yArray, temp_X.size());
        }
    }

    private int[] toArrayUtil(List<Integer> intList) {
        int len = intList.size();
        int[] array = new int[len];
        for (int n = 0; n < len; ++n) {
            array[n] = intList.get(n);
        }
        return array;
    }

    private int generateX(Date timePoint) {
        long currentDateTime = timePoint.getTime();
        double currentPartPercent = (double)(currentDateTime - this.startTimeLong) / ((double)this.timeEq * 1.0);
        return (int)((double)(this.scaleX * 10) * currentPartPercent) + this.topX;
    }

    private void getTimeEq() {
        try {
            long startTime;
            this.startTimeLong = startTime = this.normal_format.parse(this.sdate).getTime();
            long endTime = this.normal_format.parse(this.edate).getTime();
            this.timeEq = endTime - startTime;
        }
        catch (ParseException e) {
            TELogFactory.getNormalLogger().error("TELctDrawing.getTimeEq() fail,time format error!", (Throwable)e);
        }
    }

    private int generateY(int funcMode) {
        int realVal = 0;
        switch (funcMode) {
            case 1: {
                realVal = 4;
                break;
            }
            case 2: {
                realVal = 6;
                break;
            }
            case 3: {
                realVal = 7;
                break;
            }
            case 4: {
                realVal = 8;
                break;
            }
            case 5: {
                realVal = 9;
                break;
            }
            case 6: {
                realVal = 10;
                break;
            }
            case 7: {
                realVal = 11;
                break;
            }
            case 8: {
                realVal = 13;
                break;
            }
            case 9: {
                realVal = 3;
                break;
            }
            case 10: {
                realVal = 5;
                break;
            }
            case 11: {
                realVal = 12;
                break;
            }
            case 12: {
                realVal = 14;
                break;
            }
            case 13: {
                realVal = 15;
                break;
            }
            case 14: {
                realVal = 1;
                break;
            }
            case 15: {
                realVal = 2;
                break;
            }
            default: {
                realVal = 0;
            }
        }
        return this.topY + this.scaleY * (1 + (15 - realVal));
    }
}

