var st = null;
var countObj = null;

var IPTYPE_USERSET = 1;
var IPTYPE_UNSET = 0xFF;

var mplsEN = new Array();
mplsEN[0] = "disabled";
mplsEN[1] = "enabled";

var ipSpecify = new Array();
ipSpecify[1] = "ipspecify1";
ipSpecify[255] = "ipspecify255";

var btnRightArr = new Object();

var winobj = getNeProperty(top);
var neid = winobj.neid;
var nmUser = winobj.nmUser;

function init()
{
    initTable();
    initButton();
    
    var countArea = document.createElement("div");
    $("countdiv").appendChild(countArea);
    countObj = new TableDataCount();
    countArea.appendChild(countObj.getCountArea());
    initRight();
    
    $("querybtn").disabled = !btnRightArr.querybtn.right;
}

function initTable()
{
	if(!SpecialAttrMgr.isNESupport(neid,"TE_FUNC_PTN_CFG_ETHVOIDPORT","ETHVOIDPORT_ATTR_SUPPORT_L3MTU"))
	{
		window.tableconf[0].getColFromColId("PTNIF_PORT_ATTR_L3_MTU").setWidth("0");
	}
    st = new SortTable();
    st.setImage("../../../../../images/");
    st.setOnRowSelectHandler(rowSelectHandler);
    st.setOnCellEditHandler(cellEditHandler);
    createTableHead(st, window.tableconf[0]);
    $("tbdiv").appendChild(st.getTable());
    
    st.setBodyHeight(getTableHeight($("tbdiv"), st) + "px");
    
    $("tbdiv").oncontextmenu = popupMenuHandler;
}

function initButton()
{
    $("querybtn").value = RESOURCE["querybutton"];
    $("applybtn").value = RESOURCE["applybutton"];
}

function initRight()
{
    btnRightArr.querybtn = new BtnRightObj("querybtn", TECMDCODE_PTN_ETHVOIDPORT_QUERY);
    btnRightArr.applybtn = new BtnRightObj("applybtn", TECMDCODE_PTN_ETHVOIDPORT_MODIFY);
    
    getRightInfo(winobj, btnRightArr);
}

function tabSelectHandler()
{
    if (btnRightArr.querybtn.right) 
    {
        doQuery();
    }
}

function rowSelectHandler()
{
    countObj.setSelectedCount(st.getSelectedRowCount());
}

function cellEditHandler()
{
    $("applybtn").disabled = !btnRightArr.applybtn.right;
}

function createQueryXml()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doQuery()
{
    $("querybtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xml = createQueryXml();
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_PTN_ETHVOIDPORT_QUERY + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, queryCallBack, null, "inputdata=" + xml);
}

function queryCallBack(doc)
{
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    
    var data = EncapsulateData(doc);
    
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        st.clearTableData();
        createTableBody(st, window.tableconf[0], data, RESOURCE);
        addCellListener();
        
        countObj.setTotalCount(st.getDataRowLength());
        
        var ce = st.getHeadCell("port").element;
        st.sortRows(ce, 1);
        /*
        if (st.getDataRowLength() > 0) 
        {
            st.setRowSelect(0);
            rowSelectHandler();
        }
        */
    }
}

function addCellListener()
{
    for (var i = 0, m = st.getDataRowLength(); i < m; i++) 
    {
        var ipSpecify = st.getCellCurrentValue(i, "PTNIF_PORT_ATTR_IPPARATYPE", "PTNIF_PORT_ATTR_IPPARATYPE");
        if (IPTYPE_UNSET == ipSpecify) 
        {
            var cell = st.getCell(i, "PTNIF_PORT_ATTR_IPPARA");
            st.setCellIsEdit(cell, 0);
            st.getCellShow(i, "PTNIF_PORT_ATTR_IPPARA").element.innerHTML = "-";
            
            cell = st.getCell(i, "PTNIF_PORT_ATTR_IPPARAT");
            st.setCellIsEdit(cell, 0);
            st.getCellShow(i, "PTNIF_PORT_ATTR_IPPARAT").element.innerHTML = "-";
        }
        
        var cell = st.getCellEdit(i, "PTNIF_PORT_ATTR_IPPARATYPE");
        cell.element.onchange = function()
        {
			var rowIndex = this.parentNode.parentNode.rowIndex;
            var ipSpecify = parseInt(this.value);
            if (IPTYPE_UNSET == ipSpecify) 
            {
                cell = st.getCell(rowIndex, "PTNIF_PORT_ATTR_IPPARA");
                st.setCellIsEdit(cell, 0);
				st.setCellValue(cell, "PTNIF_PORT_ATTR_IPPARA", "255.255.255.255");
                st.getCellShow(rowIndex, "PTNIF_PORT_ATTR_IPPARA").element.innerHTML = "-";
                
                cell = st.getCell(rowIndex, "PTNIF_PORT_ATTR_IPPARAT");
                st.setCellIsEdit(cell, 0);
				st.setCellValue(cell, "PTNIF_PORT_ATTR_IPPARAT", "255.255.255.255");
                st.getCellShow(rowIndex, "PTNIF_PORT_ATTR_IPPARAT").element.innerHTML = "-";
            }
            else 
            {
                cell = st.getCell(rowIndex, "PTNIF_PORT_ATTR_IPPARA");
                st.setCellIsEdit(cell, 1);
				st.setCellValue(cell, "PTNIF_PORT_ATTR_IPPARA", "0.0.0.0");
                st.getCellShow(rowIndex, "PTNIF_PORT_ATTR_IPPARA").element.innerHTML = "0.0.0.0";
                
                cell = st.getCell(rowIndex, "PTNIF_PORT_ATTR_IPPARAT");
                st.setCellIsEdit(cell, 1);
				st.setCellValue(cell, "PTNIF_PORT_ATTR_IPPARAT", "255.255.255.252");
                st.getCellShow(rowIndex, "PTNIF_PORT_ATTR_IPPARAT").element.innerHTML = "255.255.255.252";
            }
        }
        
        validateIp(st.getCellEdit(i, "PTNIF_PORT_ATTR_IPPARA").element, true);
        validateIp(st.getCellEdit(i, "PTNIF_PORT_ATTR_IPPARAT").element, true);
    }
}

function createApplyXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        if (!st.getModify(i)) 
        {
            continue;
        }
        
        var row = new tagElement("row-params");
		row.appendChild(createTagElement("neid", neid));        
        row.appendChild(createTagElement("slotid", 0xFFFF));
        row.appendChild(createTagElement("subslotid", 0xFF));
        row.appendChild(createTagElement("port", st.getCellCurrentValue(i, "port", "port")));
        row.appendChild(createTagElement("interfaceid", st.getCellShow(i, "port").element.innerHTML));		
        
        if (st.getCellModify(i, "PTNIF_PORT_ATTR_MPLSEN")) 
        {
            row.appendChild(createTagElement("PTNIF_PORT_ATTR_MPLSEN", st.getCellCurrentValue(i, "PTNIF_PORT_ATTR_MPLSEN", "PTNIF_PORT_ATTR_MPLSEN")));
        }
        
        if (st.getCellModify(i, "PTNIF_PORT_ATTR_IPPARATYPE") || st.getCellModify(i, "PTNIF_PORT_ATTR_IPPARA") || st.getCellModify(i, "PTNIF_PORT_ATTR_IPPARAT")) 
        {
			var ipType = parseInt(st.getCellCurrentValue(i, "PTNIF_PORT_ATTR_IPPARATYPE", "PTNIF_PORT_ATTR_IPPARATYPE"));
			row.appendChild(createTagElement("iptype", ipType));
			row.appendChild(createTagElement("PTNIF_PORT_ATTR_IPPARATYPE", ipType == IPTYPE_UNSET ? IPTYPE_USERSET : ipType));
            var ipAddress = st.getCellCurrentValue(i, "PTNIF_PORT_ATTR_IPPARA", "PTNIF_PORT_ATTR_IPPARA");
			var ipMask = st.getCellCurrentValue(i, "PTNIF_PORT_ATTR_IPPARAT", "PTNIF_PORT_ATTR_IPPARAT");
			row.appendChild(createTagElement("ipaddress", ipAddress));
			row.appendChild(createTagElement("PTNIF_PORT_ATTR_IPPARA", parseInt("0x" + convertIpaddrToHexcode(ipAddress))));
			row.appendChild(createTagElement("ipmask", ipMask));
            row.appendChild(createTagElement("PTNIF_PORT_ATTR_IPPARAT", parseInt("0x" + convertIpaddrToHexcode(ipMask))));
            row.appendChild(createTagElement("PTNIF_PORT_ATTR_IPPARABORD", 0xFFFF));
			row.appendChild(createTagElement("PTNIF_PORT_ATTR_IPPARAPORT", 0xFFFF));
        }
        
		if(st.getCell(i,"PTNIF_PORT_ATTR_L3_MTU") != null
			&& st.getCellModify(i, "PTNIF_PORT_ATTR_L3_MTU"))
		{
			row.appendChild(createTagElement("PTNIF_PORT_ATTR_L3_MTU", st.getCellCurrentValue(i, "PTNIF_PORT_ATTR_L3_MTU", "PTNIF_PORT_ATTR_L3_MTU")));
		}
		
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doApply()
{
    $("querybtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xml = createApplyXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_PTN_ETHVOIDPORT_MODIFY + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, applyCallBack, null, "inputdata=" + xml);
}

function applyCallBack(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    refreshTableState(st, window.tableconf[0], data);
    
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    if (data.getSErrorCode() != 0) 
    {
        $("applybtn").disabled = !btnRightArr.applybtn.right;
    }
}

window.onresize = function()
{
	st.setBodyHeight(getTableHeight($("tbdiv"), st) + "px");
};
