var st = null;
var countObj = null;

var btnRightArr = new Object();

var winobj = getNeProperty(top);
var neid = winobj.neid;
var nmUser = winobj.nmUser;

var portMode = new Array();
portMode[2] = "layer2";
portMode[3] = "layer3";

var portType = new Array();
portType[1] = "eoavirif";
portType[2] = "vlansubif";

var aal5Type = new Array();
aal5Type[1] = "llcb";
aal5Type[2] = "llcr";
aal5Type[3] = "vcmuxb";
aal5Type[4] = "vcmuxr";

function init()
{
    initTable();
    initButton();
    
    var countArea = document.createElement("div");
    $("countdiv").appendChild(countArea);
    countObj = new TableDataCount();
    countArea.appendChild(countObj.getCountArea());
    initRight();
    
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("newbtn").disabled = !btnRightArr.newbtn.right;
    
    tabSelectHandler();
}

function initTable()
{
    st = new SortTable();
    st.setImage("../../../../../images/");
    st.setOnRowSelectHandler(rowSelectHandler);
    st.setOnCellEditHandler(cellEditHandler);
    createTableHead(st, window.tableconf[0]);
    $("tbdiv").appendChild(st.getTable());
    
    st.setBodyHeight(getTableHeight($("tbdiv"), st) + "px");
    
    $("tbdiv").oncontextmenu = popupMenuHandler;
}

function initButton()
{
    $("querybtn").value = RESOURCE["querybutton"];
    $("newbtn").value = RESOURCE["newbutton"];
    $("deletebtn").value = RESOURCE["deletebutton"];
    $("applybtn").value = RESOURCE["applybutton"];
}

function initRight()
{
    btnRightArr.querybtn = new BtnRightObj("querybtn", TECMDCODE_PTN_ETHVOIDPORT_QUERY);
    btnRightArr.newbtn = new BtnRightObj("newbtn", TECMDCODE_PTN_ETHVOIDPORT_CREATE);
    btnRightArr.deletebtn = new BtnRightObj("deletebtn", TECMDCODE_PTN_ETHVOIDPORT_DELETE);
    btnRightArr.applybtn = new BtnRightObj("applybtn", TECMDCODE_PTN_ETHVOIDPORT_MODIFY);
    
    getRightInfo(winobj, btnRightArr);
}

function tabSelectHandler()
{
    if (btnRightArr.querybtn.right) 
    {
        doQuery();
    }
}

function rowSelectHandler()
{
    var selectedRowCount = st.getSelectedRowCount();
    countObj.setSelectedCount(selectedRowCount);
    
    if (selectedRowCount > 0) 
    {
        $("deletebtn").disabled = !btnRightArr.deletebtn.right;
    }
    else 
    {
        $("deletebtn").disabled = true;
    }
}

function cellEditHandler()
{
    $("applybtn").disabled = !btnRightArr.applybtn.right;
}

function createQueryXml()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doQuery()
{
    $("querybtn").disabled = true;
    $("newbtn").disabled = true;
    $("deletebtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xml = createQueryXml();
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_PTN_ETHVOIDPORT_QUERY + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, queryCallBack, null, "inputdata=" + xml);
}

function queryCallBack(doc)
{
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("newbtn").disabled = !btnRightArr.newbtn.right;
    
    var data = EncapsulateData(doc);
    
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        st.clearTableData();
        createTableBody(st, window.tableconf[0], data, RESOURCE);
        for (var i = 0, m = st.getDataRowLength(); i < m; i++) 
        {
            var cell = st.getCellElement(i, "PTNIF_PORT_ATTR_PORTNAME");
            cell.editElement.element.maxLength = 64;
            cell.editElement.element.onkeyup = function()
            {
                calStrSinoLen(this, 64);
            }
            
            if (st.getCellCurrentValue(i, "vpi", "vpi") == null) 
            {
                st.getCellShow(i, "vpi").element.innerHTML = "-";
            }
            
            if (st.getCellCurrentValue(i, "vci", "vci") == null) 
            {
                st.getCellShow(i, "vci").element.innerHTML = "-";
            }
            
            if (st.getCellCurrentValue(i, "aal5type", "aal5type") == null) 
            {
                st.getCellShow(i, "aal5type").element.innerHTML = "-";
            }
            
            if (st.getCellCurrentValue(i, "vlan", "vlan") == null) 
            {
                st.getCellShow(i, "vlan").element.innerHTML = "-";
            }
            
            if (st.getCellCurrentValue(i, "PTNIF_ETHPORT_ATTR_MAC", "PTNIF_ETHPORT_ATTR_MAC") == null) 
            {
                st.getCellShow(i, "PTNIF_ETHPORT_ATTR_MAC").element.innerHTML = "-";
            }
        }
        
        countObj.setTotalCount(st.getDataRowLength());
        
        var ce = st.getHeadCell("port").element;
        st.sortRows(ce, 1);
        /*
        if (st.getDataRowLength() > 0) 
        {
            st.setRowSelect(0);
        }
        rowSelectHandler();
        */
    }
}

function doCreate()
{
    xshowModalDialog("createvirtualinterface.html", RESOURCE["createvirif"], 480, 460, "../../../../../images/");
}

function createDeleteXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var indexes = st.getSelectedRows();
    for (var i = 0, m = indexes.length; i < m; i++) 
    {
        var rowparams = new tagElement("row-params");
        
        rowparams.appendChild(createTagElement("neid", neid));
        rowparams.appendChild(createTagElement("port", st.getCellCurrentValue(indexes[i], "port", "port")));
        rowparams.appendChild(createTagElement("interfaceid", st.getCellShow(indexes[i], "port").element.innerHTML));
        
        bussiness.appendChild(rowparams);
    }
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doDelete()
{
    if (!confirm(RESOURCE["SERVICE_BREAK_WARN"])) 
    {
        return;
    }
    
    $("querybtn").disabled = true;
    $("newbtn").disabled = true;
    $("deletebtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xml = createDeleteXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_PTN_ETHVOIDPORT_DELETE + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, deleteCallBack, null, "inputdata=" + xml);
}

function deleteCallBack(doc)
{
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("newbtn").disabled = !btnRightArr.newbtn.right;
    
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    var indexes = st.getSelectedRows();
    for (var i = 0, m = data.getBErrLength(); i < m; i++) 
    {
        var port = data.getBErrParam(i, "port");
        for (var j = indexes.length - 1; j >= 0; j--) 
        {
            var portid = st.getCellCurrentValue(indexes[j], "port", "port");
            if (port == portid) 
            {
                indexes.splice(j, 1);
                break;
            }
        }
    }
    for (var k = indexes.length - 1; k >= 0; k--) 
    {
        st.deleteRow(indexes[k]);
    }
    st.adjustDataRows();
    
    countObj.setTotalCount(st.getDataRowLength());
    if (st.getDataRowLength() > 0) 
    {
        for (var i = 0, m = data.getBErrLength(); i < m; i++) 
        {
            if (st.getModify(i)) 
            {
                $("applybtn").disabled = !btnRightArr.applybtn.right;
                break;
            }
        }
        if (st.getSelectedRowCount() <= 0) 
        {
            st.setRowSelect(0);
        }
    }
    rowSelectHandler();
}

function createApplyXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        if (!st.getModify(i)) 
        {
            continue;
        }
        
        var row = new tagElement("row-params");
        row.appendChild(createTagElement("neid", neid));
        row.appendChild(createTagElement("slotid", 0xFFFF));
        row.appendChild(createTagElement("subslotid", 0xFF));
        row.appendChild(createTagElement("port", st.getCellCurrentValue(i, "port", "port")));
        row.appendChild(createTagElement("interfaceid", st.getCellShow(i, "port").element.innerHTML));
        row.appendChild(createTagElement("PTNIF_PORT_ATTR_PORTNAME", st.getCellCurrentValue(i, "PTNIF_PORT_ATTR_PORTNAME", "PTNIF_PORT_ATTR_PORTNAME")));
        
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doApply()
{
    $("querybtn").disabled = true;
    $("newbtn").disabled = true;
    $("deletebtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xml = createApplyXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_PTN_ETHVOIDPORT_MODIFY + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, applyCallBack, null, "inputdata=" + xml);
}

function applyCallBack(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    refreshTableState(st, window.tableconf[0], data);
    
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("newbtn").disabled = !btnRightArr.newbtn.right;
    if (st.getSelectedRowCount() > 0) 
    {
        $("deletebtn").disabled = !btnRightArr.deletebtn.right;
    }
    if (data.getSErrorCode() != 0) 
    {
        $("applybtn").disabled = !btnRightArr.applybtn.right;
    }
}

window.onresize = function()
{
    st.setBodyHeight(getTableHeight($("tbdiv"), st) + "px");
};
