var ct = null;
var portRes = null;
var win = getParentWindow();

var EVP_EOA = 1;
var EVP_VLAN = 2;

var LAYER_2 = 2;
var LAYER_3 = 3;

var IPTYPE_USERSET = 1;
var IPTYPE_UNSET = 0xFF;

function init()
{
    initTable();
    initButton();
    
    getResources(ct.getAtom("porttype").getValue());
    changeBoard(ct.getAtom("board").getValue());
}

function initTable()
{
    ct = new CTable();
    ct.addHead(RESOURCE["attribute"], RESOURCE["getvalue"]);
    
    var atom = new Atom("text");
    checkText(atom.element, "1", "2047");
    ct.addAttrRow("port", RESOURCE["port"], atom);
    
    atom = new Atom("text");
    checkTextData(atom.element, 64);
    ct.addAttrRow("name", RESOURCE["name"], atom);
    
    atom = new Atom("select");
    atom.element.style.width = "100%"; 
  
    atom.element.options[atom.element.options.length] = new Option(RESOURCE["eoavirif"], "1");
    atom.element.options[atom.element.options.length] = new Option(RESOURCE["vlansubif"], "2");  
    atom.element.onchange = function()
    {
    	changePortType(this.value);
    }   
    ct.addAttrRow("porttype", RESOURCE["porttype"], atom);
    
    atom = new Atom("select");
    atom.element.options[atom.element.options.length] = new Option(RESOURCE["layer2"], "2");
    atom.element.options[atom.element.options.length] = new Option(RESOURCE["layer3"], "3");
    atom.element.options.selectedIndex = 1;
    atom.element.onchange = changePortMode;
    ct.addAttrRow("portmode", RESOURCE["portmode"], atom);
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    atom.element.onchange = function()
    {
        changeBoard(this.value);
    }
    ct.addAttrRow("board", RESOURCE["board"], atom);
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    ct.addAttrRow("portid", RESOURCE["portid"], atom);
    
    atom = new Atom("checkbox");
    ct.addAttrRow("vp", "", atom);
    atom.element.onclick = clickVP;
    var span = document.createElement("span");
    span.innerHTML = RESOURCE["vp"];
    atom.element.parentNode.appendChild(span);
    
    atom = new Atom("text");
    checkText(atom.element, "0", "4095");
    ct.addAttrRow("vpi", RESOURCE["vpi"], atom);
    
    atom = new Atom("text");
    checkText(atom.element, "0", "65535");
    ct.addAttrRow("vci", RESOURCE["vci"], atom);
    
    atom = new Atom("select");
    atom.element.options[atom.element.options.length] = new Option(RESOURCE["llcb"], "1");
    atom.element.options[atom.element.options.length] = new Option(RESOURCE["llcr"], "2");
    atom.element.options[atom.element.options.length] = new Option(RESOURCE["vcmuxb"], "3");
    atom.element.options[atom.element.options.length] = new Option(RESOURCE["vcmuxr"], "4");
    ct.addAttrRow("aal5type", RESOURCE["aal5type"], atom);
    
    atom = new Atom("text");
    checkText(atom.element, "1", "4094");
    atom.element.disabled = true;
    atom.setValue("-");
    ct.addAttrRow("vlan", RESOURCE["vlan"], atom);
    
    atom = new Atom("select");
    atom.element.options[atom.element.options.length] = new Option(RESOURCE["ipspecify1"], "1");
    atom.element.options[atom.element.options.length] = new Option(RESOURCE["ipspecify255"], "255");
    atom.element.onchange = changeIPSpecify;
    ct.addAttrRow("ipspecify", RESOURCE["ipspecify"], atom);
    
    atom = new Atom("text");
    validateIp(atom.element);
    atom.setValue("0.0.0.0");
    ct.addAttrRow("ipaddress", RESOURCE["ipaddress"], atom);
    
    atom = new Atom("text");
    validateIp(atom.element);
    atom.setValue("255.255.255.252");
    ct.addAttrRow("ipmask", RESOURCE["ipmask"], atom);
    
    atom = new Atom("select");
    atom.element.options[atom.element.options.length] = new Option(RESOURCE["enabled"], "1");
    atom.element.options[atom.element.options.length] = new Option(RESOURCE["disabled"], "0");
    atom.element.options.selectedIndex = 1;
    ct.addAttrRow("mplsen", RESOURCE["mplsen"], atom);
    
    /**
     *     : DTS2012122806190 
     * 
     */ 
    if(!isSupportCreateEoa())
    {       
    	var portTypeAtom = ct.getAtom("porttype");
    	portTypeAtom.element.options.selectedIndex = 1;
  	    changePortType(portTypeAtom.element.options.value);
  	    portTypeAtom.element.disabled = true;
    }
    
    $("tbdiv").appendChild(ct.getTable());
}


/**
 *     : DTS2012122806190 
 *  U2000     :
 * server\cbb\trans\core\conf\xml\model\ipptn\ptnne_support_attrib.xml
 *   :PTNIF_ETHVP_ATTR_TYPE_EOA PTNIF_ETHVP_ATTR_TYPE_VLAN
 * RTN910,RTN950, RTN980 [05760310-05769999]       EOA       
 * RTn905,RTN950A, RTN910NA  RTN980NA     EOA       
 * @return
 */
function isSupportCreateEoa()
{
	var versions = win.winobj.neversion.split(".");
	var neType = win.winobj.neType
	
	if(neType== '89' || neType == '90' || neType== '95' || neType == '114')
	{
		return false;
	}
	if((neType == "76" || neType == "77" || neType == "83")
			&& (versions[2] + versions[3]) >= "0310")
	{
		return false;
	}	
	return true;
}

function initButton()
{
    $("okbtn").value = RESOURCE["okbutton"];
    $("cancelbtn").value = RESOURCE["cancelbutton"];
    $("applybtn").value = RESOURCE["applybutton"];
}

function changePortType(portTypeValue)
{
    var portModeAtom = ct.getAtom("portmode");
    var vpAtom = ct.getAtom("vp");
    var vpiAtom = ct.getAtom("vpi");
    var vciAtom = ct.getAtom("vci");
    var aal5TypeAtom = ct.getAtom("aal5type");
    var vlanAtom = ct.getAtom("vlan");
    var ipSpecifyAtom = ct.getAtom("ipspecify");
    var ipAddrAtom = ct.getAtom("ipaddress");
    var ipMaskAtom = ct.getAtom("ipmask");
	var mplsENAtom = ct.getAtom("mplsen");
    
    var portType = parseInt(portTypeValue);
    switch (portType)
    {
        case EVP_EOA:
            portModeAtom.element.disabled = false;
            vpAtom.element.disabled = false;
            vpiAtom.element.disabled = false;
            vpiAtom.setValue("");
            vciAtom.element.disabled = false;
            vciAtom.setValue("");
            aal5TypeAtom.element.disabled = false;
            aal5TypeAtom.element.options.length = aal5TypeAtom.element.options.length - 1;
            aal5TypeAtom.element.options.selectedIndex = 0;
            vlanAtom.element.disabled = true;
            vlanAtom.setValue("-");			
            
            ipSpecifyAtom.element.options.selectedIndex = 0;
            ipSpecifyAtom.element.disabled = false;
			ipAddrAtom.setValue("0.0.0.0");
			ipAddrAtom.element.disabled = false;
			ipMaskAtom.setValue("255.255.255.252");
			ipMaskAtom.element.disabled = false;			
            mplsENAtom.element.options.selectedIndex = 1;
			mplsENAtom.element.disabled = false;
            break;
        case EVP_VLAN:
            portModeAtom.element.selectedIndex = 1;
            portModeAtom.element.disabled = true;
            vpAtom.element.checked = false;
            vpAtom.element.disabled = true;
            vpiAtom.element.disabled = true;
            vpiAtom.setValue("-");
            vciAtom.element.disabled = true;
            vciAtom.setValue("-");
            aal5TypeAtom.element.disabled = true;
            aal5TypeAtom.element.options[aal5TypeAtom.element.options.length] = new Option("-", "-");
            aal5TypeAtom.element.options.selectedIndex = aal5TypeAtom.element.options.length - 1;
            vlanAtom.element.disabled = false;
            vlanAtom.setValue("");
            
            if (ipSpecifyAtom.element.disabled) 
            {
                ipSpecifyAtom.element.options.length = ipSpecifyAtom.element.options.length - 1;
            }
            ipSpecifyAtom.element.options.selectedIndex = 0;
            ipSpecifyAtom.element.disabled = false;
			ipAddrAtom.setValue("0.0.0.0");
			ipAddrAtom.element.disabled = false;
			ipMaskAtom.setValue("255.255.255.252");
			ipMaskAtom.element.disabled = false;
			if (mplsENAtom.element.disabled)
			{
				mplsENAtom.element.options.length = mplsENAtom.element.options.length - 1;
			}
            mplsENAtom.element.options.selectedIndex = 1;
			mplsENAtom.element.disabled = false;
            break;
        default:
            break;
    }
    
    getResources(portType);
    changeBoard(ct.getAtom("board").getValue());
}

function changePortMode()
{
    var ipSpecifyAtom = ct.getAtom("ipspecify");
    var ipAddressAtom = ct.getAtom("ipaddress");
    var ipMaskAtom = ct.getAtom("ipmask");
    var mplsENAtom = ct.getAtom("mplsen");
    
    var layer = parseInt(this.value);
    switch (layer)
    {
        case LAYER_2:
            ipSpecifyAtom.element.disabled = true;
            ipSpecifyAtom.element.options[ipSpecifyAtom.element.options.length] = new Option("-", "-");
            ipSpecifyAtom.element.options.selectedIndex = ipSpecifyAtom.element.options.length - 1;
            ipAddressAtom.element.disabled = true;
            ipAddressAtom.setValue("-");
            ipMaskAtom.element.disabled = true;
            ipMaskAtom.setValue("-");
            mplsENAtom.element.disabled = true;
            mplsENAtom.element.options[mplsENAtom.element.options.length] = new Option("-", "-");
            mplsENAtom.element.options.selectedIndex = mplsENAtom.element.options.length - 1;
            break;
        case LAYER_3:
            ipSpecifyAtom.element.disabled = false;
            ipSpecifyAtom.element.options.length -= 1;
            ipSpecifyAtom.element.options.selectedIndex = 0;
            ipAddressAtom.element.disabled = false;
            ipAddressAtom.setValue("0.0.0.0");
            ipMaskAtom.element.disabled = false;
            ipMaskAtom.setValue("255.255.255.252");
            mplsENAtom.element.disabled = false;
            mplsENAtom.element.options.length -= 1;
            mplsENAtom.element.options.selectedIndex = 1;
            break;
        default:
            break;
    }
}

function changeIPSpecify()
{
    var ipAddressAtom = ct.getAtom("ipaddress");
    var ipMaskAtom = ct.getAtom("ipmask");
    
    var specify = parseInt(this.value);
    switch (specify)
    {
        case IPTYPE_USERSET:
            ipAddressAtom.element.disabled = false;
            ipAddressAtom.setValue("0.0.0.0");
            ipMaskAtom.element.disabled = false;
            ipMaskAtom.setValue("255.255.255.252");
            break;
        case IPTYPE_UNSET:
            ipAddressAtom.element.disabled = true;
            ipAddressAtom.setValue("-");
            ipMaskAtom.element.disabled = true;
            ipMaskAtom.setValue("-");
            break;
        default:
            break;
    }
}

function clickVP()
{
    var vciAtom = ct.getAtom("vci");
    if (this.checked) 
    {
        vciAtom.element.disabled = true;
        vciAtom.setValue("-");
    }
    else 
    {
        vciAtom.element.disabled = false;
        vciAtom.setValue("");
    }
}

function changeBoard(slotId)
{
    var portOptions = ct.getAtom("portid").element.options;
    portOptions.length = 0;
    for (var i = 0, m = portRes.length; i < m; i++) 
    {
        var port = portRes[i];
        if (slotId == port.slotId) 
        {
            portOptions[portOptions.length] = new Option(port.slotId + "-" + port.boardName + "-" + port.portName, port.portId);
        }
    }
}

function createGetResourcesXML(portType)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", win.neid));
    rowparams.appendChild(createTagElement("porttype", portType));
    
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function getResources(portType)
{
    var xml = createGetResourcesXML(portType);
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_PTN_ETHVOIDPORT_RESOURCE_GET + "&nmUser=" + win.nmUser;
    loadXMLdoc(url, "POST", false, handleBackGetResources, null, "inputdata=" + xml);
}

function handleBackGetResources(doc)
{
    portRes = new Array();
    var tmpSlot = new Array();
    
    var boardOptions = ct.getAtom("board").element.options;
    boardOptions.length = 0;
    var data = EncapsulateData(doc);
    for (var i = 0, m = data.getDataRowLength(); i < m; i++) 
    {
        var port = new Object();
        port.slotId = data.getDataRowParam(i, "slotid");
        port.boardName = data.getDataRowParam(i, "boardname");
        port.portId = data.getDataRowParam(i, "portid");
        port.portName = data.getDataRowParam(i, "portname");
        
        portRes[portRes.length] = port;
        if (!tmpSlot.contains(port.slotId)) 
        {
            boardOptions[boardOptions.length] = new Option(port.slotId + "-" + port.boardName, port.slotId);
            tmpSlot[tmpSlot.length] = port.slotId;
        }
    }
    
    tmpSlot.clear();
}

function validate()
{
    var msgArr = new Array();
    if (ct.getAtom("port").getValue() == "") 
    {
        msgArr[msgArr.length] = RESOURCE["port"] + RESOURCE["rangemsg"] + "1~2047";
        isValid = false;
    }
    if (ct.getAtom("name").getValue().trim() == "") 
    {
        msgArr[msgArr.length] = RESOURCE["name"];
    }
    var vci = ct.getAtom("vci").getValue();
    if (vci != "-" && vci == "") 
    {
        msgArr[msgArr.length] = RESOURCE["vci"] + RESOURCE["rangemsg"] + "0~65535";
    }
    var vpi = ct.getAtom("vpi").getValue();
    if (vpi != "-" && vpi == "") 
    {
        msgArr[msgArr.length] = RESOURCE["vpi"] + RESOURCE["rangemsg"] + "0~4095";
    }
    var vlan = ct.getAtom("vlan").getValue();
    if (vlan != "-" && vlan == "") 
    {
        msgArr[msgArr.length] = RESOURCE["vlan"] + RESOURCE["rangemsg"] + "1~4094";
    }
    if (ct.getAtom("portid").getValue() == "") 
    {
        msgArr[msgArr.length] = RESOURCE["portid"];
    }
    var ip = ct.getAtom("ipaddress").getValue();
    if (ip != "-" && (ip == "" || ip == "0.0.0.0")) 
    {
        msgArr[msgArr.length] = RESOURCE["ipaddress"] + RESOURCE["inputmsg"] + "'255.255.255.255','0.0.0.0'";
    }
    if (ct.getAtom("ipmask").getValue() == "0.0.0.0") 
    {
        msgArr[msgArr.length] = RESOURCE["ipmask"] + RESOURCE["inputmsg"] + "'0.0.0.0'";
    }
    
    if (msgArr.length > 0) 
    {
        var msg = RESOURCE["errormsg"];
        for (var i = 0, m = msgArr.length; i < m; i++) 
        {
            msg += "\n(" + (i + 1) + ")" + msgArr[i];
        }
        alert(msg);
        return false;
    }
    else 
    {
        return true;
    }
}

function createVirtualInterfaceXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", win.neid));
    rowparams.appendChild(createTagElement("slotid", "65535"));
    rowparams.appendChild(createTagElement("subslotid", "255"));
    var interfaceId = parseInt(ct.getAtom("port").getValue());
    rowparams.appendChild(createTagElement("interfaceid", interfaceId));
    rowparams.appendChild(createTagElement("port", interfaceId + 0x2800));
    rowparams.appendChild(createTagElement("PTNIF_PORT_ATTR_PORTNAME", ct.getAtom("name").getValue()));
    var portType = parseInt(ct.getAtom("porttype").getValue());
    rowparams.appendChild(createTagElement("porttype", portType));
    var portMode = parseInt(ct.getAtom("portmode").getValue());
    rowparams.appendChild(createTagElement("PTNIF_PORT_ATTR_MODE", portMode));
    rowparams.appendChild(createTagElement("slot", ct.getAtom("board").getValue()));
    rowparams.appendChild(createTagElement("portid", ct.getAtom("portid").getValue()));
    rowparams.appendChild(createTagElement("assport", ct.getAtom("portid").element.options[ct.getAtom("portid").element.options.selectedIndex].text));
    switch (portType)
    {
        case EVP_EOA:
            rowparams.appendChild(createTagElement("vpi", ct.getAtom("vpi").getValue()));
            var vci = ct.getAtom("vci").getValue();
            var atom = ct.getAtom("vp");
            if (atom.element.checked) 
            {
                vci = "65535";
            }
            rowparams.appendChild(createTagElement("vci", vci));
            rowparams.appendChild(createTagElement("aal5type", ct.getAtom("aal5type").getValue()));
            break;
        case EVP_VLAN:
            rowparams.appendChild(createTagElement("vlan", ct.getAtom("vlan").getValue()));
            break;
        default:
            break;
    }
    
    if (LAYER_3 == portMode) 
    {
        var ipSpecify = parseInt(ct.getAtom("ipspecify").getValue());
        rowparams.appendChild(createTagElement("iptype", ipSpecify));
        
        var ipAddress = "255.255.255.255";
        var ipMask = "255.255.255.255";
        if (IPTYPE_USERSET == ipSpecify) 
        {
            ipAddress = ct.getAtom("ipaddress").getValue();
            ipMask = ct.getAtom("ipmask").getValue();
        }
        else if (IPTYPE_UNSET == ipSpecify) 
        {
            ipSpecify = IPTYPE_USERSET;
        }
        rowparams.appendChild(createTagElement("PTNIF_PORT_ATTR_IPPARATYPE", ipSpecify));
        rowparams.appendChild(createTagElement("ipaddress", ipAddress));
        rowparams.appendChild(createTagElement("PTNIF_PORT_ATTR_IPPARA", parseInt("0x" + convertIpaddrToHexcode(ipAddress))));
        rowparams.appendChild(createTagElement("ipmask", ipMask));
        rowparams.appendChild(createTagElement("PTNIF_PORT_ATTR_IPPARAT", parseInt("0x" + convertIpaddrToHexcode(ipMask))));
        rowparams.appendChild(createTagElement("PTNIF_PORT_ATTR_IPPARABORD", 0xFFFF));
        rowparams.appendChild(createTagElement("PTNIF_PORT_ATTR_IPPARAPORT", 0xFFFF));
        rowparams.appendChild(createTagElement("PTNIF_PORT_ATTR_MPLSEN", ct.getAtom("mplsen").getValue()));
    }
    
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doCreate(isOK)
{
    if (!validate()) 
    {
        return;
    }
    
    var xml = createVirtualInterfaceXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_PTN_ETHVOIDPORT_CREATE + "&nmUser=" + win.nmUser;
    loadXMLdoc(url, "POST", false, handleBackCreate, isOK, "inputdata=" + xml);
}

function handleBackCreate(doc, param)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        win.doQuery();
        
        if (!param || data.getSErrorCode == 1) 
        {
            ct.getAtom("port").setValue("");
            ct.getAtom("name").setValue("");
            ct.getAtom("porttype").element.options.selectedIndex = 0;
            
            var atom = ct.getAtom("portmode");
            atom.element.options.selectedIndex = 1;
            atom.element.disabled = false;
            
            atom = ct.getAtom("vp");
            atom.element.checked = false;
            atom.element.disabled = false;
            
            atom = ct.getAtom("vpi");
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("vci");
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("aal5type");
            if (atom.element.disabled) 
            {
                atom.element.options.length -= 1;
            }
            atom.element.options.selectedIndex = 0;
            atom.element.disabled = false;
            
            atom = ct.getAtom("vlan");
            atom.setValue("-");
            atom.element.disabled = true;
            
            atom = ct.getAtom("ipspecify");
            if (atom.element.disabled) 
            {
                atom.element.options.length -= 1;
            }
            atom.element.options.selectedIndex = 0;
            atom.element.disabled = false;
            
            atom = ct.getAtom("ipaddress");
            atom.setValue("0.0.0.0");
            atom.element.disabled = false;
            
            atom = ct.getAtom("ipmask");
            atom.setValue("255.255.255.252");
            atom.element.disabled = false;
            
            atom = ct.getAtom("mplsen");
            if (atom.element.disabled) 
            {
                atom.element.options.length -= 1;
            }
            atom.element.options.selectedIndex = 0;
            atom.element.disabled = false;
            
            getResources(ct.getAtom("porttype").getValue());
            changeBoard(ct.getAtom("board").getValue());
        }
        else 
        {
            xcloseDialog();
        }
    }
}
