function createTagElement(name, value)
{
	var elem = new tagElement("param");
	elem.setAttribute("name", name);
	elem.setAttribute("value", value);
	return elem;
}


function showErrorDialog(data)
{
	var errArr = [];
	errArr[0] = "errObjStr";
	var oError = data.getError();
	if(data.getBErrLength() > 0)
    {
        for(var i = 0, m = data.getBErrLength(); i < m ; i++)
        {
            var tempErrObjStr =  oError.getRowKey(i, "nename");
            if(null != oError.getRowKey(i, "port") && "" != oError.getRowKey(i, "port"))
            {
                tempErrObjStr += "-" + (parseInt(oError.getRowKey(i, "port")) - 6144);
            }
            oError.rowErrors[i].errorObj["errObjStr"] = tempErrObjStr;
        }
        
    	for (var i = data.getBErrLength() - 1; i >= 0; i--)
    	{
    		var code = data.getBErrorCode(i);
    		for (var j = i - 1; j >= 0; j--)
    		{
    			if (data.getBErrorCode(j) == code)
    			{
    				oError.rowErrors.removeAt(i);
    				break;
    			}
    		}
    	}
    }
    openErrPage("../../../../../page/", data.getError(), errArr);
}

function limitPathInput(pathobj, minValue, maxValue)
{
    var minvalue = minValue ;
    var maxvalue = maxValue ;
    
    pathobj.value = "";
    pathobj.style.imeMode = "disabled";
    pathobj.onkeypress = function()
    {
        var Evt = window.event;
        return restrictPath2(pathobj, Evt, minvalue, maxvalue);
    };
    pathobj.onpaste = function()
    {
        return false;
    };
    pathobj.onpaste = function()
    {
        var pasteText = window.clipboardData.getData("Text");
        pasteText = pathobj.value + pasteText;
        return pathTextCheck(pasteText, minvalue, maxvalue);
        
    };
}


function restrictPath2(field, event, minvalue,maxvalue)
{
    var key, keychar;
    
    key = ((event.keyCode != 0) ? (event.keyCode) : (event.charCode));
    
    keychar = String.fromCharCode(key);
    
    if (event.ctrlKey) 
    {
        if (keychar == 'X' || keychar == 'C' || keychar == 'A' || keychar == 'V') 
        {
            return true;
        }
    }
    if (event.shiftKey) 
    {
        return false;
    }
    if ((key == 8) || (key == 9)) 
    {
        return true;
    }
    
    if ((keychar == '\'') && (key == 39)) 
    {
        return true;
    }
    if ((keychar == '%') && (key == 37)) 
    {
        return true;
    }
    if ((keychar == '&') && (key == 38)) 
    {
        return true;
    }
    if ((keychar == '(') && (key == 40)) 
    {
        return true;
    }
    
    if (keychar == '.' || keychar == '/' || keychar == ';' || keychar == '\'' 
    	|| keychar == '[' || keychar == ']' || keychar == '\\' || keychar == '=') 
    {
        return false;
    }
    
    if (key > 36 && key < 41) 
    {
        return true;
    }
    
    if ((field.value.length == 0) && ((keychar == ',') || (keychar == '-'))) 
    {
        return false;
    }
    
    if ((field.value.length == 0) && ((keychar >= '0') && (keychar <= '9'))) 
    {
        var tempvalue = 0;
        if ((keychar >= '0') && (keychar <= '9')) 
        {
            tempvalue = key - 48;
        }
        if (tempvalue > maxvalue || tempvalue < minvalue) 
        {
            alert(RESOURCE["wrong1"] + minvalue + RESOURCE["wrong2"] + maxvalue + RESOURCE["wrong3"]);
            return false;
        }
        else 
        {
            return true;
        }
    }
    
    if ((field.value.length != 0) && ((keychar >= '0') && (keychar <= '9') || (keychar == '-') || (keychar == ','))) 
    {
        var tmp = field.value;
        var txtlist = field.value.split(",");
        
        if ((keychar >= '0') && (keychar <= '9')) 
        {
            var pos = digitalTag_getPos(field);
            if (keychar == '0') 
            {
                var val = tmp.substring(0, pos);
                var vArray = val.split(",");
                var value = vArray[vArray.length - 1].split("-");
                if (parseInt(value[value.length - 1]) == 0) 
                {
                    return false;
                }
            }
            var newVal = tmp.substring(0, pos) + keychar + tmp.substring(pos + selectionLen(field));
            var vArr = newVal.split(",");
            for (var i = 0; i < vArr.length; i++) 
            {
                var va = vArr[i].split("-");
                for (var j = 0; j < va.length; j++) 
                {
                    if (parseInt(va[j]) < minvalue || parseInt(va[j]) > maxvalue) 
                    {
                        alert(RESOURCE["wrong1"] + minvalue + RESOURCE["wrong2"] + maxvalue + RESOURCE["wrong3"]);
                        return false;
                    }
                }
            }
        }
        if ((keychar == '-') || (keychar == ',')) 
        {
            var currText = txtlist[txtlist.length - 1];
            if (currText == "") 
            {
                return false;
            }
            if ((String.fromCharCode(currText.charCodeAt(currText.length - 1)) == '-') 
            		|| (String.fromCharCode(currText.charCodeAt(currText.length - 1)) == ',')) 
            {
                return false;
            }
            else 
            {
                if ((currText.indexOf("-") != -1) && (keychar != ',')) 
                {
                    return false;
                }
                else 
                {
                    return true;
                }
            }
        }
        
    }
    else 
    {
        if (event.ctrlKey) 
        {
            if (keychar == 'X' || keychar == 'C' || keychar == 'A' || keychar == 'V') 
            {
                return true;
            }
        }
        else 
        {
            return false;
        }
    }
}



function pathTextCheck(inputText, limitLow, limitHigh)
{
    for (var i = 0, isize = inputText.length; i < isize; i++) 
    {
        var ch = inputText.charCodeAt(i);
        if (ch < 48 || ch > 57) 
        {
            if ((String.fromCharCode(ch) == "-" || String.fromCharCode(ch) == ",")) 
            {
                continue;
            }
            else 
            {
                return false;
            }
        }
    }    
    
    var str = inputText.split(",");
    if (inputText.length == 0) 
    {
        return true;
    }
    
    for (var i = 0; i < str.length; i++) 
    {
        var b = str[i].indexOf("-") != -1;
        if (b) 
        {
            var range = str[i].split("-");
            var rangeStart = parseInt(range[0]);
            var rangeEnd = parseInt(range[1]);
            
            if ((rangeStart > limitHigh) || (rangeEnd > limitHigh) || (rangeStart < limitLow) || (rangeEnd < limitLow)) 
            {
                alert(RESOURCE["wrong1"] + minvalue + RESOURCE["wrong2"] + maxvalue + RESOURCE["wrong3"]);
                inputText.value = 1;
                return false;
            }
        }
        else 
        {
            if (parseInt(str[i]) > limitHigh || parseInt(str[i]) < limitLow) 
            {
                alert(RESOURCE["wrong1"] + minvalue + RESOURCE["wrong2"] + maxvalue + RESOURCE["wrong3"]);
                inputText.value = 1;
                return false;
            }
        }
    }
    return true;
}

function getListFromString(valueString)
{
    var listTemp = [];
    var listTemp2 = [];
    listTemp.length = 0;
    listTemp2.length = 0;
    var listID = new Array();
    if (valueString.indexOf(",") != -1) 
    {
        listTemp = valueString.split(",");
        for (var i = 0, isize = listTemp.length; i < isize; i++) 
        {
            if (listTemp[i].indexOf("-") != -1) 
            {
                listTemp2 = listTemp[i].split("-");
                
                var starti = parseInt(listTemp2[0]);
                var endi = parseInt(listTemp2[1]);
                
                if ((!isNaN(starti)) && (!isNaN(endi))) 
                {
                    if (starti >= endi) 
                    {
                        var temp = starti;
                        starti = endi;
                        endi = starti;
                    }
                    for (var j = starti; j <= endi; j++) 
                    {
                        if (!listID.contains(j)) 
                        {
                            listID.push(j);
                        }
                    }
                }
            }
            else 
            {
                if (listTemp[i].trim() != "") 
                {
                    if (!listID.contains(parseInt(listTemp[i]))) 
                    {
                        listID.push(parseInt(listTemp[i]));
                    }
                }
            }
            
        }
    }
    else if (valueString.indexOf("-") != -1) 
    {
        listTemp = valueString.split("-");
        
        var starti = parseInt(listTemp[0]);
        var endi = parseInt(listTemp[1]);
        if ((!isNaN(starti)) && (!isNaN(endi))) 
        {
            if (starti >= endi) 
            {
                var temp = starti;
                starti = endi;
                endi = starti;
            }
            for (var j = starti; j <= endi; j++) 
            {
                if (!listID.contains(j)) 
                {
                    listID.push(j);
                }
                
            }
        }
    }else
    {
    	if (!listID.contains(parseInt(valueString))) 
        {
            listID.push(parseInt(valueString));
        }
    }
	return listID;
}

function tenToHex(param)
{
	var hexChars = "0123456789ABCDEF";
	var respart = param % 16;
	var intpart = (param - respart) / 16;
	var result = hexChars.charAt(respart);
	while((intpart >= 16) || (intpart % 16 != 0))
	{
		respart = intpart % 16;
		intpart = (intpart - respart) / 16;
		result = hexChars.charAt(respart) + result;
	}

	if(0 != (result.length % 2))
	{
		result = "0" + result;
	}
	
	return result;
}

function tenToPrototype(param)
{
	var paramvalue ="";
	for(var i =0;i<param.length;i++)
	{
		paramvalue+=tenToHex(param[i]);
	}
	return paramvalue;
}
