var ct = null;
var portRes = null;

var win = getParentWindow();
var neid = win.neid;
var nmUser = win.nmUser;

var borrowedPorts = null;
var memberInterfaces = null;
var sdh_interfacelevel = 1798;//
var pdh_interfacelevel = 1797;//

var LEVEL_VC12 = 0;
var LEVEL_64K = 1;
var getavailableboard = 0;
var getavailableport = 1;
var obj = getNeProperty(win.parent);

function init()
{
    initTable();
    initButton();
    getResources(getavailableport);
    fillAvailablePorts();
    

}
function isSupportVC12()
{
	if(isRTN900NEtype(obj.neType))
	{
		var args = obj.neversion.split(".");
		if(parseInt(args[2])<=1 || parseInt(args[2])>=5)
		{
			return true;
		}
	}
	return false;
}
function initTable()
{
    ct = new CTable();
    ct.addHead(RESOURCE["attribute"], RESOURCE["getvalue"]);
    
    var atom = new Atom("text");
    ct.addAttrRow("port", RESOURCE["serialport"], atom);
    limitPathInput(atom.element,0,2047);
    
    atom = new Atom("text");
    checkTextData(atom.element, 64);
    ct.addAttrRow("name", RESOURCE["serialportname"], atom);
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    /**
     *      DTS2011052003444 
     *        
     *      VC12 RTN900 V1R1       V1R3     
     */
    if(isSupportVC12())
    {
    	atom.element.options[atom.element.options.length] = new Option(RESOURCE["vc12"], "0");
    }
    
    	atom.element.options[atom.element.options.length] = new Option(RESOURCE["ktimeslot"], "1");    	
    
    atom.element.options.selectedIndex = 0;
    atom.element.onchange = changeLevel;
    ct.addAttrRow("level", RESOURCE["serialportlevel"], atom);
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    atom.element.onchange = changeBoard;
    ct.addAttrRow("usedboard", RESOURCE["usedboard"], atom);
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    ct.addAttrRow("usedport", RESOURCE["usedport"], atom);
    
    atom = new Atom("text");
    ct.addAttrRow("highpath", RESOURCE["highpath"], atom);
    atom.element.disabled = true;
    atom.setValue("VC4-1");
    
    atom = new Atom("text");
    ct.addAttrRow("lowpath", RESOURCE["lowpath"], atom);
    limitPathInput(atom.element,1,63);
    
    atom = new Atom("text");
    ct.addAttrRow("timeslot", RESOURCE["timeslot"], atom);
    limitPathInput(atom.element,1,31);
    
    var btnElem = document.createElement("button");
    btnElem.setAttribute("id", "htmlButton_timeslotbutton");
    btnElem.style.width = "20%";
    btnElem.style.height =  "3%";
    btnElem.className = "autowidthbutton";
    btnElem.value = RESOURCE["timeslotselect"];
    btnElem.onclick = handleTimeslotSelect;
    ct.getAtom("timeslot").element.value ="";
    ct.getAtom("timeslot").element.disabled = true;
    ct.getAtom("timeslot").element.style.width = "79%";
    ct.getAtom("timeslot").element.parentNode.appendChild(btnElem);
            
    $("tbdiv").appendChild(ct.getTable());
}

function initButton()
{
    $("okbtn").value = RESOURCE["okbutton"];
    $("cancelbtn").value = RESOURCE["cancelbutton"];
    $("applybtn").value = RESOURCE["applybutton"];
}

function handleTimeslotSelect()
{
	var slotid = parseInt(ct.getAtom("usedboard").getValue());
	var usedport = parseInt(ct.getAtom("usedport").getValue());
	var lowpath = parseInt(ct.getAtom("lowpath").getValue());
	if(isNaN(slotid) || isNaN(usedport))
	{
		return;
	}
	
	if(true == ct.getAtom("lowpath").element.disabled)
	{
		if(isNaN(lowpath))
		{
			lowpath = -1;
		}
	}
	else
	{
		if(isNaN(lowpath))
		{
			lowpath = 0;
		}
	}
	
	xshowModalDialog("timeslotselect.html?slotid="+slotid+"&port="+usedport+"&lowpath="+lowpath, RESOURCE["confgmember"], 720, 400, "../../../../../images/");	
}

function doCreate(isOK)
{
    if (!validate()) 
    {
        return;
    }
    
    var xml = createSerialInterfaceXML();
    if(null == xml)
    {
    	return;
    }
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_PTN_SP_CREATE + "&nmUser=" + win.nmUser;
    loadXMLdoc(url, "POST", false, handleBackCreate, isOK, "inputdata=" + xml);
}
function createSerialInterfaceXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = null;
    
    var level = parseInt(ct.getAtom("level").getValue());
    var interfaceId = null;
    var serialports = ct.getAtom("port").getValue();
    var serialportslist = getListFromString(serialports);
    	
    var seriallowpath = ct.getAtom("lowpath").getValue();
    var seriallowpathlist = getListFromString(seriallowpath);
    
    var lowpathenable = ct.getAtom("lowpath").element.disabled==false?true:false;
    if(lowpathenable)
    {
    	if(serialportslist.length != seriallowpathlist.length)
    	{
	    	var msg = RESOURCE["errormsg"];
	    	msg += "\n(1)" + RESOURCE["portNumerror"];;
	        alert(msg);
    		return null;
    	}
    }

	var slotid = parseInt(ct.getAtom("usedboard").getValue());
	var usedport = parseInt(ct.getAtom("usedport").getValue());
	
    if(LEVEL_VC12 == level)
    {
    	for (var path = 0, pathsize = serialportslist.length; path < pathsize; path++)
    	{
    		rowparams = new tagElement("row-params");
		    rowparams.appendChild(createTagElement("neid", win.neid));
		    rowparams.appendChild(createTagElement("slotid", slotid));
		    rowparams.appendChild(createTagElement("subslotid", "255"));
		    interfaceId = parseInt(serialportslist[path]);
		    rowparams.appendChild(createTagElement("port", interfaceId + 0x1800));
		    rowparams.appendChild(createTagElement("phyportid", usedport));
		    if("" != ct.getAtom("name").getValue())
		    {
		    	rowparams.appendChild(createTagElement("PTNIF_PORT_ATTR_PORTNAME", ct.getAtom("name").getValue()));
		    }
		    rowparams.appendChild(createTagElement("phypathnum", 1));
	    	rowparams.appendChild(createTagElement("phypathlist", tenToHex(seriallowpathlist[path])));
	    	bussiness.appendChild(rowparams);
    	}
    }
    else if(LEVEL_64K == level)
    {
	    var ktimeslot = ct.getAtom("timeslot").getValue();
	    var ktimeslotlist = getListFromString(ktimeslot);
	    var ktimeslotvalue = tenToPrototype(ktimeslotlist);
	    
        for (var path = 0, pathsize = serialportslist.length; path < pathsize; path++)
    	{
	    	rowparams = new tagElement("row-params");
			rowparams.appendChild(createTagElement("neid", win.neid));
			rowparams.appendChild(createTagElement("slotid", slotid));
			rowparams.appendChild(createTagElement("subslotid", "255"));
			interfaceId = parseInt(serialportslist[path]);
			rowparams.appendChild(createTagElement("port", interfaceId + 0x1800));
			rowparams.appendChild(createTagElement("phyportid", usedport));
			if("" != ct.getAtom("name").getValue())
			{
			    rowparams.appendChild(createTagElement("PTNIF_PORT_ATTR_PORTNAME", ct.getAtom("name").getValue()));
			}
	    
	    	if(lowpathenable)
	    	{
		    	rowparams.appendChild(createTagElement("highchannel", 1));//     
		    	rowparams.appendChild(createTagElement("phypathlist", seriallowpathlist[path]));
		    	rowparams.appendChild(createTagElement("ktimeslotnum", ktimeslotlist.length));
		    	rowparams.appendChild(createTagElement("ktimeslot", ktimeslotvalue));
	    	}
	    	else
	    	{
		    	rowparams.appendChild(createTagElement("phypathnum", ktimeslotlist.length));//     
		    	rowparams.appendChild(createTagElement("phypathlist", ktimeslotvalue));
	    	}
	    	bussiness.appendChild(rowparams);
    	}
    }
    else
    {
    	return null;
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackCreate(doc, param)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        win.querySerialInterface();
        
        if (!param || data.getSErrorCode == 1) 
        {
            var level = parseInt(ct.getAtom("level").getValue());

            ct.getAtom("port").setValue("");
            ct.getAtom("name").setValue("");
            
            var tmpAtom = ct.getAtom("highpath");
    
            if(tmpAtom.element.disabled == false)
            {
            	 tmpAtom.setValue("");
            }
            tmpAtom = ct.getAtom("lowpath");
            if(tmpAtom.element.disabled == false)
            {
                 tmpAtom.setValue("");
            }
            tmpAtom = ct.getAtom("timeslot");
            if(tmpAtom.element.disabled == false)
            {
                 tmpAtom.setValue("");
            }
        }
        else 
        {
        	clearRes();
            xcloseDialog();
        }
    }
}

function closeDialog()
{
     clearRes();
     xcloseDialog();
}

function validate()
{
    var msgArr = new Array();
	var tmpAtom = null;

	var useslot = ct.getAtom("usedboard").getValue();
	var usename = "";
	for( var i = 0; i < ct.getAtom("usedboard").element.options.length; i++ )
	{
		var usedbdOption = ct.getAtom("usedboard").element.options[i];
		if( usedbdOption.value == useslot )
		{
			usename = usedbdOption.text;
		}
	}
	if (ct.getAtom("level").getValue().trim() == LEVEL_64K &&
		usename.indexOf("CQ1") >= 0 )
	{
		msgArr[msgArr.length] = RESOURCE["_64K_NOT_SUPPORT_CQ1"];
	}
	if (ct.getAtom("level").getValue().trim() == LEVEL_64K &&
		usename.indexOf("VS2") >= 0 )
	{
		msgArr[msgArr.length] = RESOURCE["_64K_NOT_SUPPORT_VS2"];
	}
	if (ct.getAtom("level").getValue().trim() == LEVEL_64K &&
		usename.indexOf("CD1") >= 0 )
	{
		msgArr[msgArr.length] = RESOURCE["_64K_NOT_SUPPORT_CD1"];
	}
    if (ct.getAtom("port").getValue().trim() == "") 
    {
        msgArr[msgArr.length] = RESOURCE["serialport"];
    }

    if (ct.getAtom("name").getValue().trim() == "") 
    {
        msgArr[msgArr.length] = RESOURCE["serialportname"];
    }
    
    tmpAtom = ct.getAtom("highpath");
    if(tmpAtom.element.disabled == false && "" == tmpAtom.getValue().trim())
    {
    	msgArr[msgArr.length] = RESOURCE["highpath"];
    }
    
    tmpAtom = ct.getAtom("highpath");
    if(tmpAtom.element.disabled == false && "" == tmpAtom.getValue().trim())
    {
    	msgArr[msgArr.length] = RESOURCE["highpath"];
    }
    
    tmpAtom = ct.getAtom("lowpath");
    if (tmpAtom.getValue().trim() == "") 
    {
        msgArr[msgArr.length] = RESOURCE["lowpath"];
    }
    
    tmpAtom = ct.getAtom("timeslot");
    if(tmpAtom.element.disabled == false && "" == tmpAtom.getValue().trim())
    {
    	msgArr[msgArr.length] = RESOURCE["timeslot"];
    }
    
    if (msgArr.length > 0) 
    {
        var msg = RESOURCE["errormsg"];
        for (var i = 0, m = msgArr.length; i < m; i++) 
        {
            msg += "\n(" + (i + 1) + ")" + msgArr[i];
        }
        alert(msg);
        return false;
    }
    else 
    {
        return true;
    }
}


function createGetResourcesXML(restype)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", win.neid));
    rowparams.appendChild(createTagElement("restype", restype));
    
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function getResources(resType)
{
    var xml = createGetResourcesXML(resType);
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_PTN_SP_RESOURCE_GET + "&nmUser=" + win.nmUser;
    loadXMLdoc(url, "POST", false, handleGetResources,resType, "inputdata=" + xml);
}

function handleGetResources(doc,param)
{
	borrowedPorts = new Array();
	memberInterfaces = new Array();
	
    var param = null;
    var options = null;
	
    var data = EncapsulateData(doc);
    for (var i = 0, m = data.getDataRowLength(); i < m; i++) 
    {
        param = data.getDataRowParam(i, "borrowedports");
        if (null != param) 
        {
            options = data.getDataRowOptions(i, "borrowedports");
            for (var j = 0, n = options.length; j < n; j++) 
            {
                borrowedPorts[borrowedPorts.length] = options[j];
            }
        }
        
        param = data.getDataRowParam(i, "memberinterfaces");
        if (null != param) 
        {
            options = data.getDataRowOptions(i, "memberinterfaces");
            for (var j = 0, n = options.length; j < n; j++) 
            {
                memberInterfaces[memberInterfaces.length] = options[j];
            }
        }
    }
}

function fillAvailablePorts()
{
    var boardOptions = ct.getAtom("usedboard").element.options;
    boardOptions.length = 0;
    portRes = new Array();
    
	var lastIndex = -1;
    var tmpbd = new Array();
    for (var i = 0, m = memberInterfaces.length; i < m; i++) 
    {
    	var port = new Object();
		lastIndex = memberInterfaces[i].lastIndexOf("#");
    	var members = new Array();
		var tmpMember = memberInterfaces[i].substring(0, lastIndex);
		members[0] = tmpMember.substring(0, tmpMember.lastIndexOf("#"));
		members[1] = tmpMember.substring(tmpMember.lastIndexOf("#") + 1, tmpMember.length);
		members[2] = memberInterfaces[i].substring(lastIndex + 1, memberInterfaces[i].length);
        var mif = members[0].split("-");
        port.slotId = mif[0];
        port.boardName = mif[1];
        port.portName = members[0];
        port.portId = members[1];
        port.interfacelevel = members[2];
        portRes[portRes.length] = port;
        if (!tmpbd.contains(mif[0])) 
        {
            boardOptions[boardOptions.length] = new Option(mif[0] + "-" + mif[1], mif[0]);
            tmpbd[tmpbd.length] = mif[0];
        }
    }
    tmpbd.clear();
    changeLevel(ct.getAtom("level").getValue());//     
}

function changeLevel(defaultlevel)
{
    var timeAtom = ct.getAtom("timeslot");
    var highpathAtom = ct.getAtom("highpath");
    var lowpathAtom = ct.getAtom("lowpath");
    var level = parseInt(this.value);
	if(0 != level && 1 != level)
	{
		level = parseInt(defaultlevel);
	}

    switch (level)
    {
        case LEVEL_VC12:
            timeAtom.element.disabled = true;
            $("htmlButton_timeslotbutton").disabled = true;
            timeAtom.setValue("-");
            highpathAtom.element.disabled = true;
            highpathAtom.setValue("VC4-1");
            lowpathAtom.element.disabled = false;
            lowpathAtom.setValue("");
            break;
        case LEVEL_64K:
            timeAtom.element.disabled = false;
            $("htmlButton_timeslotbutton").disabled = false;
            timeAtom.setValue("");
            highpathAtom.element.disabled = true;
            highpathAtom.setValue("-");
            lowpathAtom.element.disabled = true;
            lowpathAtom.setValue("-");
            break;
        default:
            break;
    }
    reInitBoard(level);
    changeBoard(ct.getAtom("usedboard").getValue());
}

function reInitBoard(level)
{
    var boardOptions = ct.getAtom("usedboard").element.options;
    boardOptions.length = 0;
    var tmpbd = new Array();
    var tempport = null;
    for (var i = 0, m = portRes.length; i < m; i++) 
    {
    	tempport = portRes[i];
    	if (!tmpbd.contains(tempport.slotId)) 
	    {
		    if(LEVEL_VC12 == level)
	    	{
		        if(sdh_interfacelevel == tempport.interfacelevel)
		        {
		        	boardOptions[boardOptions.length] = new Option(tempport.slotId + "-" + tempport.boardName, tempport.slotId);
		        }
	    	}
	    	else if(LEVEL_64K == level)
	    	{
	    		boardOptions[boardOptions.length] = new Option(tempport.slotId + "-" + tempport.boardName, tempport.slotId);
	    	}
	        tmpbd[tmpbd.length] = tempport.slotId;
	    }
    }
    tmpbd.clear();
}

function changeBoard(slotId)
{
    var slotid = parseInt(this.value);
    var isVC12 = false;
    if(isNaN(slotid) && slotId)
    {
    	slotid = slotId;
    }
    
    var portOptions = ct.getAtom("usedport").element.options;
    portOptions.length = 0;
    for (var i = 0, m = portRes.length; i < m; i++) 
    {
        var port = portRes[i];

        if (slotid == port.slotId) 
        {
	        if(sdh_interfacelevel == port.interfacelevel)
	        {
	        	isVC12 = true;
	        }
            portOptions[portOptions.length] = new Option(port.portName, port.portId);
        }
    }
    if(true == isVC12)
    {
    	ct.getAtom("highpath").element.disabled = true;
        ct.getAtom("highpath").setValue("VC4-1");
    	ct.getAtom("lowpath").element.disabled = false;
        ct.getAtom("lowpath").setValue("");
    }else
    {
        ct.getAtom("highpath").element.disabled = true;
        ct.getAtom("highpath").setValue("-");
    	ct.getAtom("lowpath").element.disabled = true;
        ct.getAtom("lowpath").setValue("-");
    }
}


function clearRes()
{
	portRes.clear();
}

function isRTN900Below05760510()
{
	var result = false;
	var args = obj.neversion.split(".");
	if( args[2] < "05" )
	{
		result = true;
	}
}
