
var obj = getNeProperty(self);

mincir = 64;
maxcir = 1048576;
var dm;
var portTable = null;
var isQueryFromNE = "1";
var btnRightArr = new Array();

var selectedIndex = 0;

var enableStatus = new Object;
enableStatus["0"] = "disabled";
enableStatus["1"] = "enabled";

var neType = obj.neType;
var nevr = obj.neversion.split('.');

var CIR_RANGE = ["0","1000000","64"];
var PIR_RANGE = ["0","1000000","64"];
var CBS_RANGE = ["0","512000","0"];
var PBS_RANGE = ["0","512000","0"];

var CIR_DEFAULT = 4294967295;
var PIR_DEFAULT = 4294967295;
var CBS_DEFAULT = 4294967295;
var PBS_DEFAULT = 4294967295;

function init()
{
	initAdpater();
	
	portTable = new SortTable();
	portTable.setImage("../../../../../images/");
	
	
	createTableHead(portTable, window.tableconf[0]);
	var hc = portTable.getHeadCell("port");
	$("tableDiv").appendChild(portTable.getTable());

	portTable.setBodyHeight(getComponetHeight($("tableDiv"),120) + "px");
	portTable.setOnRowSelectHandler(rowSelectHandler);  
	portTable.setOnCellEditHandler(cellEditHandler);  

	$("querybtn").value = RESOURCE["query"];
	$("createbtn").value = RESOURCE["newbutton"];
	$("applybtn").value = RESOURCE["applybutton"];
	$("delbtn").value = RESOURCE["deletebutton"];
	$("applybtn").disabled = true;
	$("delbtn").disabled = true;

	btnRightArr.querybtn = new BtnRightObj("querybtn", TECMDCODE_PTN_QUERY_PORTSHAPING);
	btnRightArr.applybtn = new BtnRightObj("applybtn", TECMDCODE_PTN_CREATE_PORTSHAPING);
	btnRightArr.createbtn = new BtnRightObj("createbtn", TECMDCODE_PTN_CREATE_PORTSHAPING);
	btnRightArr.delbtn = new BtnRightObj("delbtn", TECMDCODE_PTN_CREATE_PORTSHAPING);

	sendRightInfo(btnRightArr);
	$("querybtn").disabled = !btnRightArr["querybtn"].right;
	$("createbtn").disabled = !btnRightArr["createbtn"].right;
	if (!$("querybtn").disabled)
	{
		query();
	}
}


function cellEditHandler()
{
	document.getElementById("applybtn").disabled = !btnRightArr["applybtn"].right;
}

/*******************************************************************************
 *        XML  
 ******************************************************************************/
function createRightXML()
{
	var root = new inputxml("datainterface"); //     datainterface    
	var firstlevel = new tagElement("bussiness-params"); //          
	var secondlevel, thirdlevel;
	for ( var btnrightobj in btnRightArr) //              btnRightArr
	{
		if (btnRightArr[btnrightobj].btnId == null)
		{
			continue;
		}
		secondlevel = new tagElement("row-params"); //          

		thirdlevel = new tagElement("param"); //           ID          thirdlevel
		thirdlevel.setAttribute("name", "btnID");
		thirdlevel.setAttribute("value", btnRightArr[btnrightobj].btnId);
		secondlevel.appendChild(thirdlevel); //         

		thirdlevel = new tagElement("param"); //           ID          thirdlevel
		thirdlevel.setAttribute("name", "sfid");
		thirdlevel.setAttribute("value", btnRightArr[btnrightobj].sfid);
		secondlevel.appendChild(thirdlevel); //         

		firstlevel.appendChild(secondlevel); //                
	}
	root.getRoot().appendChild(firstlevel);//                
	return root.toString(); //     
}

/*******************************************************************************
 *           
 ******************************************************************************/
function sendRightInfo()
{
	var xmldata = createRightXML();//        XML  
	var url = "../../../../../securityServlet?neID=" + obj["neid"]
			+ "&nmUser=" + obj["nmUser"];// url    securityServlet       
	loadXMLdoc(url, "POST", false, rightHandleBack, null, "inputdata="
			+ xmldata);//       
}

/*******************************************************************************
 *                
 ******************************************************************************/
function rightHandleBack(doc)
{
	var data = EncapsulateData(doc); //           
	for ( var i = 0, datalen = data.getDataRowLength(); i < datalen; i++)//   data      
	{
		var right = data.getDataRowParam(i, "right"); //   data      
		if (1 == right)// right 1     
		{
			btnRightArr[data.getDataRowParam(i, "btnID")].right = true; // btnRightArr   right   true
		}
		else
		{
			btnRightArr[data.getDataRowParam(i, "btnID")].right = false;// btnRightArr   right   false
		}
	}
}



/**
 *        
 * 
 * @param params
 *                
 */
function rowSelectHandler(params)
{
	if (portTable.getSelectedRowCount() > 0) 
	{
		$("delbtn").disabled = !btnRightArr["delbtn"].right;;
	}
	else
	{
		$("delbtn").disabled = true;
	}
}

/**
 *           xml  
 * 
 * @return    xml  
 */
function createQueryXML()
{
	var root = new inputxml("datainterface");
	var firstlevel = new tagElement("bussiness-params");
	var secondlevel = new tagElement("row-params");

	var thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name", "neid");
	thirdlevel.setAttribute("value", obj["neid"]);
	secondlevel.appendChild(thirdlevel);

	
	firstlevel.appendChild(secondlevel);
	root.getRoot().appendChild(firstlevel);
	return root.toString();
}

/**
 *        
 * 
 * @param isNeedWriteLog        
 */
function query()
{
	$("querybtn").disabled = true;
	$("applybtn").disabled = true;
	$("createbtn").disabled = true;
	$("delbtn").disabled = true;
	var xml = createQueryXML();//   xml  
	
	var queryUrl = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_PTN_QUERY_PORTSHAPING + "&nmUser=" + obj["nmUser"];
	loadXMLdoc(queryUrl, "POST", true, queryHandleBack, null, "inputdata="+ xml);//     
}

/**
 *   shaping     
 * 
 * @param doc
 *                   
 */
function queryHandleBack(doc)
{
	var queryResult = EncapsulateData(doc);// deal with the data
	
	var errorCode = queryResult.getSErrorCode();
	if (errorCode != 0 && errorCode != 1 && errorCode != 2)//      
	{
		showQueryErrDlg(queryResult);
	}

	if(errorCode != 2)//     
    {
		portTable.clearTableData();
		createTableBody(portTable,window.tableconf[0],queryResult,RESOURCE);//put data to table	
		for(var rowindex = 0, stlen = portTable.getDataRowLength(); rowindex < stlen; rowindex++)
        {
    	    var circell = portTable.getCellEdit(rowindex, "cir").element;
    	    circell.onchange = function ()
            {
        	     document.getElementById("applybtn").disabled = !btnRightArr["applybtn"].right;
            }
            var cbscell = portTable.getCellEdit(rowindex, "cbs").element;
    	    cbscell.onchange = function ()
            {
        	     document.getElementById("applybtn").disabled = !btnRightArr["applybtn"].right;
            }
            var pircell = portTable.getCellEdit(rowindex, "pir").element;
    	    pircell.onchange = function ()
            {
        	     document.getElementById("applybtn").disabled = !btnRightArr["applybtn"].right;
            }
            var pbscell = portTable.getCellEdit(rowindex, "pbs").element;
    	    pbscell.onchange = function ()
            {
        	     document.getElementById("applybtn").disabled = !btnRightArr["applybtn"].right;
            }
			textCheckWithStepLen(portTable.getCellEdit(i, "cir").element,CIR_RANGE[0],CIR_RANGE[1],64);
			textCheckWithStepLen(portTable.getCellEdit(i, "pir").element,PIR_RANGE[0],PIR_RANGE[1],64);
		    textCheck(portTable.getCellEdit(i, "cbs").element,CBS_RANGE[0],CBS_RANGE[1]);
		    textCheck(portTable.getCellEdit(i, "pbs").element,PBS_RANGE[0],PBS_RANGE[1]);
        }		
    }

	$("querybtn").disabled = !btnRightArr["querybtn"].right;
	$("createbtn").disabled = !btnRightArr["createbtn"].right;
}

/**
 *        ,    
 *          calidate.js      
 */
/**
 * DTS2012042507898
 * 1                    
 * 2                               
 *   shaping           se                5000-10000000     64               64   5056 5120...
 *                      
 *                           64                                        5064            
 */

if(isOSNNEtype(neType) || SpecialAttrMgr.isNESupport(obj.neid, "TE_FUNC_CFG_ETH_SHAPING", "SHAPING_ATTR_TITLE64STEP"))
{
	alertDialogWithStepLen = function(min, max, stepLen,othervalue)
	{
		var alertStr = RESOURCE["wrong1"];
		if(typeof(othervalue) != "undefined" && othervalue != null)
		{
			alertStr = RESOURCE["wrong7"];
			alertStr += othervalue + RESOURCE["wrong6"];
		}
		alertStr += min + RESOURCE["wrong2"] + max + RESOURCE["wrong3"];
		if( stepLen != null )
		{
			alertStr += RESOURCE["steplen"] + stepLen;
		}
		alertStr += "\n" + RESOURCE["notice1"];
		alert(alertStr);
		return false;
	};
}

/**
 *          
 */
function addTableCellListener()
{
	var dcbsCellEdit = portTable.getCellEdit(0, "dcbs");
	if (dcbsCellEdit != null)
	{
		checkDataCellEvent(dcbsCellEdit.element, 0, 512, 0);
	}
}

function createModifyXML()
{
	var root = new inputxml("datainterface");
	
    var bussiness = new tagElement("bussiness-params");
    var row = null;
    var param = null;
    var isModify = false;
    for(var rowindex = 0,rowlen = portTable.getDataRowLength();rowindex<rowlen;rowindex++)
    {
    	if(!portTable.getModify(rowindex))
    	{
    		continue;
    	}
    	isModify = true;
    	row = new tagElement("row-params");
    	
    	param = new tagElement("param");
		param.setAttribute("name","neid");
		param.setAttribute("value",obj["neid"]); 
		row.appendChild(param);	
			
		param = new tagElement("param");
		param.setAttribute("name","slotid");
		param.setAttribute("value",portTable.getCellStoreValue(rowindex,"slotid","slotid")); 
		row.appendChild(param);	
		
		var subslotid = portTable.getCellStoreValue(rowindex,"portqueid","subcard");
		if(subslotid != null && subslotid != "")
		{
			param = new tagElement("param");
		    param.setAttribute("name","subcard");
			param.setAttribute("value",subslotid);
		    row.appendChild(param);
		}
		
		param = new tagElement("param");
		param.setAttribute("name","port");
		param.setAttribute("value",portTable.getCellStoreValue(rowindex,"port","port")); 
		row.appendChild(param);	
						
		param = new tagElement("param");
		param.setAttribute("name","cir");
		param.setAttribute("value",	portTable.getCellStoreValue(rowindex,"cir","cir")); 
		row.appendChild(param);	
			
		param = new tagElement("param");
		param.setAttribute("name","cbs");
		param.setAttribute("value",	portTable.getCellStoreValue(rowindex,"cbs","cbs")); 
		row.appendChild(param);	
			
		param = new tagElement("param");
		param.setAttribute("name","pir");
		param.setAttribute("value",	portTable.getCellStoreValue(rowindex,"pir","pir")); 
		row.appendChild(param);	

		param = new tagElement("param");
		param.setAttribute("name","pbs");
		param.setAttribute("value",	portTable.getCellStoreValue(rowindex,"pbs","pbs")); 
		row.appendChild(param);	
    
    	bussiness.appendChild(row);
    }    
    if(!isModify)
    {
    	return null;
    }
    root.getRoot().appendChild(bussiness);
    return root.toString();
}

function modify()
{
	var modifyXML = createModifyXML();
	if (modifyXML == null)
	{
		return;
	}

	document.getElementById("querybtn").disabled = true;
	document.getElementById("applybtn").disabled = true;
	var modifyUrl = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_PTN_SET_PORTSHAPING + "&nmUser=" + obj["nmUser"];
	loadXMLdoc(modifyUrl, "POST", true, modifyHandleBack, null, "inputdata=" + modifyXML);//     
}

function modifyHandleBack(doc)
{
	var modifyResult = EncapsulateData(doc);
	showQueryErrDlg(modifyResult);
	if (modifyResult.getSErrorCode() != 0)
	{
		document.getElementById("applybtn").disabled = !btnRightArr["applybtn"].right;
	}
	document.getElementById("querybtn").disabled = !btnRightArr["querybtn"].right;
	refreshTableState(portTable, window.tableconf[0], modifyResult);
}

/**
 *      
 */
window.onresize = function()
{
	portTable.setBodyHeight(getComponetHeight($("tableDiv"),120) + "px");
}

/**
 *            
 */
function showQueryErrDlg(result)
{
	var errArr = [];
	errArr[0] = "nename";
	errArr[1] = "slotid";
	errArr[2] = "boardname";
	errArr[3] = "subcardname";
	errArr[4] = "portname";
	openErrPage("../../../../../page/", result.getError(), errArr);
}

function setOptionValue(param)
{
	var showtext = param[0];
	var txtvalue = param[1];
	var elem = param[2];
	var colid = elem.colid;

	var rows = elem.parent.getSelectedRows();
	for ( var i = 0; i < rows.length; i++)
	{
		var cell = elem.parent.getCell(rows[i], colid);
		if (cell.element.isEdit == 0)
		{
			continue;
		}
		elem.parent.setCellValue(cell, colid, txtvalue);
		var showElement = cell.element.showElement;
		cell.element.modify = true;
		cell.element.parentNode.modify = true;
		cell.element.style.backgroundColor = "#d0f946";
		handleCellEdit(cell.element, TABLE_CONSTANT.AFTEREDIT);
		if (showElement.type == 'span' || showElement.type == 'text')
		{
			if (colid == "enable")
			{
				showElement.element.innerText = showtext;
			}
			else
			{
				showElement.element.innerText = txtvalue;
			}
		}
		else if (showElement.type == 'select')
		{
			var options = showElement.element.options;
			for ( var j = 0; j < options.length; j++)
			{
				if (options[j].value == txtvalue)
				{
					showElement.element.selectedIndex = j;
					break;
				}
			}
		}
		if (cell.element.editElement.element.onchange)
		{
			cell.element.editElement.element.value = txtvalue;
			cell.element.editElement.element.onchange();
		}
	}
}

function onblurHandler(event)
{

	if (!event)
	{
		event = window.event;
	}
	var numobj = event.target ? event.target : event.srcElement;
	if (numobj.value == "")
	{
		numobj.value = 0;
		return;
	}

	if ((Number(numobj.value) != 0) && (Number(numobj.value) % 64 != 0))
	{
		numobj.value = 64;
		alert(RESOURCE["wrong"]);
		return;
	}
}

function keyupHandler(event)
{
	if (!event)
	{
		event = window.event;
	}
	var numobj = event.target ? event.target : event.srcElement;

	if (numobj.value > 1048576)
	{
		alert(RESOURCE["wrong"]);
		numobj.value = 1048576;
		return;
	}
}

function keypressHandler(event)
{
	var key, keychar;
	if (!event)
	{
		event = window.event;
		key = window.event.keyCode;
	}
	var numobj = event.target ? event.target : event.srcElement;
	var code = (event.keyCode != 0 ? event.keyCode : event.charCode);

	if (event.keyCode == 13)
	{
		if (numobj.value == "")
		{
			alert(RESOURCE["wrong"]);
			return false;
		}
		event.srcElement.blur();
		return true;
	}

	if (code == 8 || code == 46 || code == 37 || code == 39)
	{
		return true;
	}

	if (code < 48 || code > 57)
	{
		return false;
	}
	window.status = "code:" + code + "; value:" + numobj.value;
	var position = digitalTag_getPos(numobj);
	if (position == 0 && numobj.value.length > 0 && (code == 48 || code == 96))
	{
		return false;
	}

	if (numobj.value == '0' && position > 0)
	{
		return false;
	}

	keychar = String.fromCharCode(key);
	if (numobj.value + keychar > 1048576)
	{
		numobj.value = 1048576;
		alert(RESOURCE["wrong"]);
		return false;
	}
}

function getDataArr()
{
	var opsary = new Array();
	opsary[0] = new Option("0Kbit/s", 0);
	opsary[1] = new Option("512Kbit/s", 512);
	opsary[2] = new Option("1Mbit/s", 1024);
	opsary[3] = new Option("2Mbit/s", 2048);
	opsary[4] = new Option("3Mbit/s", 3072);
	opsary[5] = new Option("4Mbit/s", 4096);
	opsary[6] = new Option("5Mbit/s", 5120);
	opsary[7] = new Option("6Mbit/s", 6144);
	opsary[8] = new Option("7Mbit/s", 7168);
	opsary[9] = new Option("8Mbit/s", 8192);
	opsary[10] = new Option("9Mbit/s", 9216);
	opsary[11] = new Option("10Mbit/s", 10240);
	opsary[12] = new Option("20Mbit/s", 20480);
	opsary[13] = new Option("30Mbit/s", 30720);
	opsary[14] = new Option("40Mbit/s", 40960);
	opsary[15] = new Option("50Mbit/s", 51200);
	opsary[16] = new Option("100Mbit/s", 102400);
	opsary[17] = new Option("1000Mbit/s", 1024000);
	return opsary;
}

function doCreate()
{
	xshowModalDialog("newshaping.html",RESOURCE["newbutton"],400,260,"../../../../../images/");
}



function doDel()
{
	$("querybtn").disabled = true;
	$("delbtn").disabled = true;
	$("createbtn").disabled = true;
	var url = "../../../../../neExlorerServlet?sfid="+TECMDCODE_PTN_DEL_PORTSHAPING+"&nmUser="+obj["nmUser"];	
  loadXMLdoc(url,"POST",true,callbackDoDel,null,"inputdata="+createDel());
	 
}


function createDel()
{
	  var root = new inputxml("datainterface");
	
    var bussiness = new tagElement("bussiness-params");
    var row = null;
    var param = null;    
   
    var selectedRow = portTable.getSelectedRows();
    for(var i = 0; i < selectedRow.length; i++)
    {
    	row = new tagElement("row-params");
	    param = new tagElement("param");
	    param.setAttribute("name","neid");
	    param.setAttribute("value",obj["neid"]);
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name","slotid");
	    param.setAttribute("value",portTable.getCellStoreValue(selectedRow[i],"slotid","slotid"));
	    row.appendChild(param);
		
		var subslotid = portTable.getCellStoreValue(selectedRow[i],"portqueid","subcard");
		if(subslotid != null && subslotid != "")
		{
			param = new tagElement("param");
		    param.setAttribute("name","subcard");
			param.setAttribute("value",subslotid);
		    row.appendChild(param);
		}
	    
		param = new tagElement("param");
	    param.setAttribute("name","port");
	    param.setAttribute("value",portTable.getCellStoreValue(selectedRow[i],"port","port"));
	    row.appendChild(param);    
	    bussiness.appendChild(row);
	    
	   
	   }
    
    root.getRoot().appendChild(bussiness);
    return root.toString();
}


function callbackDoDel(doc)
{
    var data = EncapsulateData(doc);
    if (data.getSErrorCode() != "0") 
    {
        var errArr = [];
        errArr[0] = "slotid";
        errArr[1] = "port";
        openErrPage("../../../../../page/", data.getError(), errArr);
    }
    query();
    $("querybtn").disabled = !btnRightArr["querybtn"].right;
    $("delbtn").disabled = true;
}

function initAdpater()
{
	SpecialAttrMgr.getNEFunInfo(obj.neid,"TE_FUNC_CFG_ETH_SHAPING");

	if(isNotSupportCBS()) 
	{
		window.tableconf[0].getColFromColId("cbs").width = "0%";
	}
	if(isNotSupportPBS())
	{
		window.tableconf[0].getColFromColId("pbs").width = "0%";
	}
	if(isNotSupportCIR())
	{
		window.tableconf[0].getColFromColId("cir").width = "0%";
	}
	if(isNotSupportPIR())
	{
		window.tableconf[0].getColFromColId("pir").width = "0%";
	}
	if(( isOSN5X0NEtype(neType) &&  (nevr[2] + nevr[3]) >= '0510') || neType == '67')
    {
		CIR_RANGE = ["0","10000000","64"];
		PIR_RANGE = ["0","10000000","64"];
		CBS_RANGE = ["0","4294967295","0"];
		PBS_RANGE = ["0","4294967295","0"];
	}
	else if(( isRTN900NEtype(neType) &&  (nevr[2] + nevr[3]) >= '0310'))
	{
		CIR_RANGE = ["0","1000000","64"];
		PIR_RANGE = ["0","1000000","64"];
		CBS_RANGE = ["0","4294967295","0"];
		PBS_RANGE = ["0","4294967295","0"];
	}
	else if(isMSOTN(neType))
	{
		CIR_RANGE = ["64","10000000","64"];
		PIR_RANGE = ["64","10000000","64"];
	}
	else if(isOSNNEtype(neType))
	{
		PIR_RANGE = ["5000","10000000","5000"];
	}
	else if(neType == '121')
	{
		CIR_RANGE = ["0","10000000","64"];
		PIR_RANGE = ["0","10000000","64"];
	}

	var cirRg = SpecialAttrMgr.getNEAttrListValue(obj.neid, "TE_FUNC_CFG_ETH_SHAPING", "SHAPING_ATTR_CIR_RANGE");
	if(cirRg != null && cirRg.length >= 2)
	{
		CIR_RANGE = cirRg;
	}
	var pirRg = SpecialAttrMgr.getNEAttrListValue(obj.neid, "TE_FUNC_CFG_ETH_SHAPING", "SHAPING_ATTR_PIR_RANGE");
	if(pirRg != null && pirRg.length >= 2)
	{
		PIR_RANGE = pirRg;
	}
	var cbsRg = SpecialAttrMgr.getNEAttrListValue(obj.neid, "TE_FUNC_CFG_ETH_SHAPING", "SHAPING_ATTR_CBS_RANGE");
	if(cbsRg != null && cbsRg.length >= 2)
	{
		CBS_RANGE = cbsRg;
	}
	var pbsRg = SpecialAttrMgr.getNEAttrListValue(obj.neid, "TE_FUNC_CFG_ETH_SHAPING", "SHAPING_ATTR_PBS_RANGE");
	if(pbsRg != null && pbsRg.length >= 2)
	{
		PBS_RANGE = pbsRg;
	}
	
	if((isRTN900NEtype(neType) &&  (nevr[2] + nevr[3]) >= '0330')
		|| ( neType == '81' &&  (nevr[2] + nevr[3]) >= '0520')
		|| (neType == '62' &&  (nevr[2] + nevr[3]) >= '0530') || neType == '67')
	{
		if(isRTN900NEtype(neType) &&  (nevr[2] + nevr[3]) >= '0510'
			|| ( neType == '81' &&  (nevr[2] + nevr[3]) >= '0610')
			|| (neType == '62' &&  (nevr[2] + nevr[3]) >= '0610') || neType == '67')
		{
			CIR_DEFAULT = 4294967295;
			CBS_DEFAULT = 4294967295;
		}
		else
		{
			CIR_DEFAULT = 0;
			CBS_DEFAULT = 0;
		}
	}
	
	var cirDefault = SpecialAttrMgr.getNEAttrValue(obj.neid, "TE_FUNC_CFG_ETH_SHAPING", "SHAPING_ATTR_NOSTUPPORT_CIR");
	if(cirDefault != null)
	{
		CIR_DEFAULT = cirDefault;
	}
	var pirDefault = SpecialAttrMgr.getNEAttrValue(obj.neid, "TE_FUNC_CFG_ETH_SHAPING", "SHAPING_ATTR_NOSTUPPORT_PIR");
	if(pirDefault != null)
	{
		PIR_DEFAULT = pirDefault;
	}
	
	var cbsDefault = SpecialAttrMgr.getNEAttrValue(obj.neid, "TE_FUNC_CFG_ETH_SHAPING", "SHAPING_ATTR_NOSTUPPORT_CBS");
	if(cbsDefault != null)
	{
		CBS_DEFAULT = cbsDefault;
	}
	var pbsDefault = SpecialAttrMgr.getNEAttrValue(obj.neid, "TE_FUNC_CFG_ETH_SHAPING", "SHAPING_ATTR_NOSTUPPORT_PBS");
	if(pbsDefault != null)
	{
		PBS_DEFAULT = pbsDefault;
	}
}

function isNotSupportCBS()
{
    if ((isRTN900NEtype(neType) && (nevr[2] + nevr[3]) >= '0330') ||
    (neType == '81' && (nevr[2] + nevr[3]) >= '0520') ||
    (neType == '62' && (nevr[2] + nevr[3]) >= '0530') ||
    (neType == '29') ||
    (neType == '41') ||
    (neType == '82') ||
    (neType == '67') ||
    isMSOTN(neType) ||
    isOSNNEtype(neType) ||
    SpecialAttrMgr.isNESupport(obj.neid, "TE_FUNC_CFG_ETH_SHAPING", "SHAPING_ATTR_NOSTUPPORT_CBS")) 
    {
        return true;
    }
    return false;
}

function isNotSupportPBS()
{
    if (isMSOTN(neType) ||
    isOSNNEtype(neType) ||
    SpecialAttrMgr.isNESupport(obj.neid, "TE_FUNC_CFG_ETH_SHAPING", "SHAPING_ATTR_NOSTUPPORT_PBS")) 
    {
        return true;
    }
    return false;
}

function isNotSupportCIR()
{
	if ((isRTN900NEtype(neType) && (nevr[2] + nevr[3]) >= '0330') ||
    (neType == '81' && (nevr[2] + nevr[3]) >= '0520') ||
    (neType == '62' && (nevr[2] + nevr[3]) >= '0530') ||
    (neType == '29') ||
    (neType == '41') ||
    (neType == '82') ||
    (neType == '67') ||
    SpecialAttrMgr.isNESupport(obj.neid, "TE_FUNC_CFG_ETH_SHAPING", "SHAPING_ATTR_NOSTUPPORT_CIR")) 
    {
        return true;
    }
    else 
    {
        return false;
    }
}

function isNotSupportPIR()
{
	if(SpecialAttrMgr.isNESupport(obj.neid, "TE_FUNC_CFG_ETH_SHAPING", "SHAPING_ATTR_NOSTUPPORT_PIR"))
	{
		return true;
	}
	return false;
}
