/**
 * 2011-11-14 U2KR7      MSOTN           
 * 1                       
 * 
 * "phyport",         0, 
	"vuni",            1, 
	"vnni",            2, 
	"flow",            3
	
	"local",           0
	"remote",          1
    "observe",         2
 */
language = SYSTEMCONF.getLanguage();

document.title = RESOURCE["portmirrormgr"];

var win = getParentWindow();

var winurlobj = getNeProperty(win.document);

var obj = getNeProperty(self);

var portList = new Array();
var tmpValue = "";

var ct = null;

function initPage() 
{
	getSupportPort();
	createButton();
	createTable();
}

function getSupportPort() 
{
	var xml = createXML();
	var URL = "../../../../../neExlorerServlet?sfid="
			+ TECMDCODE_PTN_PORTMIRROR_GETPORT + "&nmUser="
			+ winurlobj["nmUser"];
	loadXMLdoc(URL, "POST", false, getPortCallBack, null, "inputdata=" + xml);
}

function createXML() 
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = new tagElement("param");

	var neid = winurlobj["neid"];
	param.setAttribute("name", "neid");
	param.setAttribute("value", neid);
	row.appendChild(param);

	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);

	return di.toString();
}

function getPortCallBack(doc) 
{
	var data = EncapsulateData(doc);

	for ( var i = 0, len = data.getDataRowLength(); i < len; i++) {
		var portInfo = new Object;
		portInfo.portName = data.getDataRowParam(i, "port");
		portInfo.slotId = data.getDataRowParam(i, "slotId");
		portInfo.portId = data.getDataRowParam(i, "portId");
		portList[i]=portInfo;
	}
}

function createButton() 
{
	$("submitbtn").value = RESOURCE["okbutton"];
	$("cancel").value = RESOURCE["cancelbutton"];
	$("apply").value = RESOURCE["applybutton"];
}

function createTable() 
{
	ct = new CTable();
	ct.addHead(RESOURCE["attribute"], RESOURCE["value"]);
	
	/**
	 * start:mirror_ID mirroID        checkbox   ID      1~0xFFFFFFFF
	 */
	var atom = new Atom("span");
	ct.addAttrRow("mirrorIndex", RESOURCE["mirrorIndex"], atom);
	
	var elem = document.createElement("input");
    elem.type = "text";
    elem.id = "mirrorIndex";
    checkText(elem, "1", "4294967295");
    elem.style.width = "44%";
    elem.disabled = true;
    elem.value = "-";
    atom.element.parentNode.appendChild(elem);
    elem.onpaste = function() 
	{
    	return digitalTag_checkPaste(this);
	}
    
    var elem = document.createElement("input");
    elem.type = "checkbox";
    elem.id = "isAuto";
    elem.style.width = "10%";
    elem.onclick = function()
    {
        if ($("isAuto").checked) 
        {
            $("mirrorIndex").disabled = true;
            $("mirrorIndex").value = "-";
        }
        else 
        {
            $("mirrorIndex").disabled = false;
            $("mirrorIndex").value = "";
        }
    };
    atom.element.parentNode.appendChild(elem);    
    
    elem = document.createElement("span");
    elem.innerHTML = RESOURCE["autoassign"];
    elem.style.width = "45%";
    atom.element.parentNode.appendChild(elem);   
	/**
	 * end:mirror_ID
	 */
	
    /**
	 * mirrorname:                  64                     
	 */
	var atom = new Atom("text");
	checkTextData(atom.element, 64);
	ct.addAttrRow("mirrorname", RESOURCE["mirrorname"], atom);
	

	var atom = new Atom("select");
	atom.addOption("INGRESS", 1);
	if (winurlobj.neType != 82 && winurlobj.neType != 41 && winurlobj.neType != 29
		&& !SpecialAttrMgr.isNENotSupport(winurlobj.neid,"TE_FUN_PTN_PORTMIRROR", "PORTMIRROR_ATTR_SUPPORT_EGRESS"))
	{
		atom.addOption("EGRESS", 2);
	}
	if(SpecialAttrMgr.isNESupport(winurlobj.neid,"TE_FUN_PTN_PORTMIRROR", "PORTMIRROR_ATTR_SUPPORT_BIDIRECTIONAL"))
	{
		atom.addOption("BIDIRECTIONAL", 3);
	}
	
	ct.addAttrRow("srcdirection", RESOURCE["direction"], atom);

	atom = new Atom("select");
	atom.id = "mirrorport";
	var portList = getPortList();
	for ( var i = 0, len = portList.length; i < len; i++) {
		atom.addOption(portList[i].portName, JSON.stringify(portList[i]));
	}
	ct.addAttrRow("mirrorport", RESOURCE["mirrorport"], atom);

	atom = new Atom("select");
	atom.id = "mirroredport";
	for ( var i = 0, len = portList.length; i < len; i++) {
		atom.addOption(portList[i].portName, JSON.stringify(portList[i]));
	}
	ct.addAttrRow("mirroredport", RESOURCE["mirroredport"], atom);

	document.body.insertBefore(ct.getTable(), document.body.firstChild);
	/**
	 *       
	 */
	$("isAuto").checked=true;
}

function getPortList() 
{
	return portList;
}

function createXMLData() 
{

	var neid = winurlobj["neid"];

	var servicename = ct.getAttrValue("mirrorname");
	var mirrorport = JSON.parse(ct.getAttrValue("mirrorport"));
	var mirroredport = JSON.parse(ct.getAttrValue("mirroredport"));
	var direction = ct.getAttrValue("srcdirection");
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = new tagElement("param");

	param.setAttribute("name", "neid");
	param.setAttribute("value", neid);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "isAuto");

	var autoIndexparam = new tagElement("param");
	autoIndexparam.setAttribute("name", "isAutoIndex");
	
	var indexParam=new tagElement("param");
	indexParam.setAttribute("name", "mirrorServiceIndex");
	if($("isAuto").checked)
	{
		param.setAttribute("value", 1);//     ID   1
		autoIndexparam.setAttribute("value", 2);//          2
		indexParam.setAttribute("value", 1);//     ID index    
	}
	else
	{
		param.setAttribute("value", 0);
		autoIndexparam.setAttribute("value", 0);
		indexParam.setAttribute("value", $("mirrorIndex").value);
	}
	row.appendChild(autoIndexparam);
	row.appendChild(indexParam);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "mirrorName");
	param.setAttribute("value", servicename);
	row.appendChild(param);
	
	/**
	 *       NSCMD_ETHN_ADD_MIRROR local      remote      observe     
	 */
	param = new tagElement("param");
	param.setAttribute("name", "mirrorType");
	param.setAttribute("value", obj.mirrortype);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "srcPointType");
	param.setAttribute("value", obj.srcPointType);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "srcPointDirection");
	param.setAttribute("value", direction);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "slotID");
	param.setAttribute("value", mirrorport.slotId);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "srcparam1");
	param.setAttribute("value", mirrorport.slotId);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "srcparam2");
	param.setAttribute("value", "255");
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "srcparam3");
	param.setAttribute("value", mirrorport.portId);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "obsPointSlotID");
	param.setAttribute("value", mirroredport.slotId);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "obsPointSubSlotID");
	param.setAttribute("value", "255");
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "obsPointPortID");
	param.setAttribute("value", mirroredport.portId);
	row.appendChild(param);

	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);

	return di.toString();
}

function sendCreateInfo(flag) 
{   
	
	var mirrorport = JSON.parse(ct.getAttrValue("mirrorport"));
	var mirroredport = JSON.parse(ct.getAttrValue("mirroredport"));
	if (mirrorport.portName == mirroredport.portName) {
		alert(RESOURCE["cantEqual"]);
		return;
	}

	$("submitbtn").disabled = true;
	$("cancel").disabled = true;
	$("apply").disabled = true;

	var xml = createXMLData();

	var URL = "../../../../../neExlorerServlet?sfid="
			+ TECMDCODE_PTN_PORTMIRRORING_CREATE + "&nmUser="
			+ winurlobj["nmUser"];
	loadXMLdoc(URL, "POST", true, PostCallBackHandler, flag, "inputdata=" + xml);
}

function PostCallBackHandler(doc, flag) 
{
	$("submitbtn").disabled = false;
	$("cancel").disabled = false;
	$("apply").disabled = false;

	var data = EncapsulateData(doc);

	if (data.getSErrorCode() != OPERATION_SUCCESS) {
		showErrorDialog(data);
		return;
	}

	win.sendQueryInfo();

	if (flag) {
		xcloseDialog();
	}
}

function showErrorDialog(data) 
{

	var errArr = [];
	errArr[0] = "nename";
	errArr[1] = "slotid";
	errArr[2] = "boardname";
	openErrPage("../../../../../page/", data.getError(), errArr);
}
